%==================================================================
%
%	Cursor.m
%
%	Markus Junghoefer	[1996]
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
%
%
%	Function definition
%
	
	function[hCursorVec,hCursorTimeVec,hCursorValVec,CursorPoint,ch_UseCursorFunc,hSpecCursorPoint]=...
	Cursor(x,DataMat,hAxesVec,hCursorVec,hCursorTimeVec,hCursorValVec,Action,CursorStatus,...
	CursorPoint,CursorPointDef,CursorColor,CursorTimeColor,CursorValColor,...
	CursorTimeFontSize,CursorValFontSize,CursorTimeVisible,CursorValVisible,...
	CursorYDataDef,CursorValPos2Def,ch_UseCursorFunc,SpecLastChan,...
	SpecCursorYDataDef, SpecCursorTimePos2, SpecCursorTimeFontSize, SpecCursorTimeColor, SpecCursorTimeVisible,...
	MinDataVec,MaxDataVec,hSpecCursorPoint,SpecCursorPointPos2,SpecCursorPointColor);


%
%
%=================================================================
if nargin<31; SpecCursorPointColor=[]; end
if nargin<30; SpecCursorPointPos2=[]; end
if nargin<29; hSpecCursorPoint=[]; end
if nargin<28; MaxDataVec=[]; end
if nargin<27; MinDataVec=[]; end
if nargin<26; SpecCursorTimeVisible=[]; end
if nargin<25; SpecCursorTimeColor=[]; end
if nargin<24; SpecCursorTimeFontSize=[]; end
if nargin<23; SpecCursorTimePos2=[]; end
if nargin<22; SpecCursorYDataDef=[]; end
if nargin<21; SpecLastChan=[]; end
if nargin<20; ch_UseCursorFunc=[]; end
if nargin<19; CursorValPos2Def=[]; end
if nargin<18; CursorYDataDef=[]; end
if nargin<17; CursorValVisible=[]; end
if nargin<16; CursorTimeVisible=[]; end
if nargin<15; CursorValFontSize=[]; end
if nargin<14; CursorTimeFontSize=[]; end
if nargin<13; CursorValColor=[]; end
if nargin<12; CursorTimeColor=[]; end
if nargin<11; CursorColor=[]; end
if nargin<10; CursorPointDef=[]; end
if nargin<9; CursorPoint=[]; end
if nargin<8; CursorStatus=[]; end
if nargin<7; Action='SetCursorToPoint'; end
if nargin<6; hCursorValVec=[]; end
if nargin<5; hCursorTimeVec=[]; end
if nargin<4; hCursorVec=[]; end
if nargin<3; hCursorVec=[];hCursorTimeVec=[];hCursorValVec=[];CursorPoint=[]; return; end

[ch_UseCursorFunc]=IfEmptyInputBo(['Do you want to use the cursor function ?'],[],ch_UseCursorFunc,1,1);

if ~ch_UseCursorFunc; hCursorVec=[];hCursorTimeVec=[];hCursorValVec=[];CursorPoint=[]; return; end

if isempty(CursorPoint); CursorPoint=1; end
if isempty(CursorPointDef); CursorPointDef=1; end
if isempty(CursorColor); CursorColor='green'; end
if isempty(CursorTimeColor); CursorTimeColor='green'; end
if isempty(CursorValColor); CursorTimeColor='green'; end
if isempty(CursorTimeFontSize); CursorTimeFontSize=14; end
if isempty(CursorValFontSize); CursorValFontSize=14; end
if isempty(CursorTimeVisible); CursorTimeVisible='on'; end
if isempty(CursorValVisible); CursorValVisible='on'; end
if isempty(SpecLastChan); SpecLastChan=0; end
if isempty(SpecCursorTimeFontSize); SpecCursorTimeFontSize=12; end
if isempty(SpecCursorTimeColor); SpecCursorTimeColor='green'; end
if isempty(SpecCursorTimeVisible); SpecCursorTimeVisible='on'; end


NPoints=length(x);
NChan=length(hAxesVec);
if isempty(MinDataVec)
	MinDataVec=min(DataMat');
end
if isempty(MaxDataVec)
	MaxDataVec=max(DataMat');
end
YIntVec=MaxDataVec-MinDataVec;
CursorTimePos2Vec=0.05.*YIntVec+MinDataVec;

if strcmp(Action,'SetCursorToPoint')
	if  CursorPoint>=1 & CursorPoint<=length(x)
		CursorTime=x(CursorPoint);
		if SpecLastChan
			MaxChanInd=NChan-1;
		else
			MaxChanInd=NChan;
		end

		for i=1:MaxChanInd
			axes(hAxesVec(i));
			if isempty(CursorYDataDef)
				CursorYData=[MinDataVec(i) MaxDataVec(i)];
			else
				CursorYData=CursorYDataDef;
			end
			hCursorVec(i)=line('XData',[CursorTime CursorTime],'YData',CursorYData,'Color',CursorColor);
			CursorTime=(round(CursorTime.*10))./10;
			CursorTimeString=[num2str(CursorTime)];
			hCursorTimeVec(i)=text('Position',[CursorTime,CursorTimePos2Vec(i)],'String',CursorTimeString,...
			'FontSize',CursorTimeFontSize,'Color',CursorTimeColor,'HorizontalAlignment','left','Visible',CursorTimeVisible);
			DataVal=DataMat(i,CursorPoint);
			DataVal=(round(DataVal.*10))./10;
			CursorValString=[num2str(DataVal)];
			
			if isempty(CursorValPos2Def)
				CursorValPos2=max(DataVal+0.05.*YIntVec(i),CursorTimePos2Vec(i)+0.05.*YIntVec(i));
				CursorValPos2=min(CursorValPos2,MaxDataVec(i)-0.05.*YIntVec(i));
				hCursorValVec(i)=text('Position',[CursorTime,CursorValPos2],'String',CursorValString,...
				'FontSize',CursorValFontSize,'Color',CursorValColor,'HorizontalAlignment','left','Visible',CursorValVisible);
			else
				CursorValPos2=CursorValPos2Def;
				hCursorValVec(i)=text('Position',[CursorTime,CursorValPos2],'String',CursorValString,...
				'FontSize',CursorValFontSize,'Color',CursorValColor,'HorizontalAlignment','center','Visible',CursorValVisible);
			end
		end
		if SpecLastChan
			axes(hAxesVec(NChan));
			hCursorVec(NChan)=line('XData',[CursorTime CursorTime],'YData',SpecCursorYDataDef,'Color',CursorColor);
			CursorTime=(round(CursorTime.*10))./10;
			CursorTimeString=[num2str(CursorTime)];
			hCursorTimeVec(NChan)=text('Position',[CursorTime,SpecCursorTimePos2],'String',CursorTimeString,...
			'FontSize',SpecCursorTimeFontSize,'Color',SpecCursorTimeColor,'HorizontalAlignment','left','Visible',SpecCursorTimeVisible);
			CursorPointString=[num2str(CursorPoint)];
			hSpecCursorPoint=text('Position',[CursorTime,SpecCursorPointPos2],'String',CursorPointString,...
			'FontSize',SpecCursorTimeFontSize,'Color',SpecCursorPointColor,'HorizontalAlignment','left','Visible',SpecCursorTimeVisible);
		end
	end
end
if strcmp(Action,'ChangeCursorPos')
	fprintf('\n\n');clc;
	fprintf('Use <<z <x c v> b>> to move the cursor !\n\n');
	fprintf('or insert the new cursor time !\n\n');
	fprintf('(insert s to stop the cursor)\n\n');
	Key='c';
	CursorTimeNew=[];
	while ~strcmp(Key,'s')
		if ~isempty(CursorTimeNew)
			[MinVal,CursorPoint]=min((x-CursorTimeNew).^2);
		else				
			if strcmp(Key,'c')
				CursorPoint=CursorPointDef;
			elseif strcmp(Key,'b') & CursorPoint < NPoints
				CursorPoint=CursorPoint+1;
			elseif strcmp(Key,'v') & CursorPoint < NPoints-10
				CursorPoint=CursorPoint+10;
			elseif strcmp(Key,'z')  & CursorPoint > 1
				CursorPoint=CursorPoint-1;
			elseif strcmp(Key,'x')  & CursorPoint > 10
				CursorPoint=CursorPoint-10;
			end
		end
		CursorTime=x(CursorPoint);
		if SpecLastChan
			MaxChanInd=NChan-1;
		else
			MaxChanInd=NChan;
		end
		for i=1:MaxChanInd
			if isempty(CursorYDataDef)
				CursorYData=[MinDataVec(i) MaxDataVec(i)];
			else
				CursorYData=CursorYDataDef;
			end
			set(hCursorVec(i),'XData',[CursorTime,CursorTime],'YData',CursorYData);
			CursorTime=(round(CursorTime.*10))./10;
			CursorTimeString=[num2str(CursorTime)];
			set(hCursorTimeVec(i),'Position',[CursorTime,CursorTimePos2Vec(i)],'String',CursorTimeString);
			DataVal=DataMat(i,CursorPoint);
			DataVal=(round(DataVal.*10))./10;
			CursorValString=[num2str(DataVal)];
			if isempty(CursorValPos2Def)
				CursorValPos2=max(DataVal+0.05.*YIntVec(i),CursorTimePos2Vec(i)+0.05.*YIntVec(i));
				CursorValPos2=min(CursorValPos2,MaxDataVec(i)-0.05.*YIntVec(i));
			else
				CursorValPos2=CursorValPos2Def;
			end
			set(hCursorValVec(i),'Position',[CursorTime,CursorValPos2],'String',CursorValString);
		end
		if SpecLastChan
			CursorTime=(round(CursorTime.*10))./10;
			CursorTimeString=[num2str(CursorTime)];
			set(hCursorTimeVec(NChan),'Position',[CursorTime,SpecCursorTimePos2],'String',CursorTimeString);
			CursorPointString=[num2str(CursorPoint)];
			set(hSpecCursorPoint,'Position',[CursorTime,SpecCursorPointPos2],'String',CursorPointString);
			set(hCursorVec(NChan),'XData',[CursorTime,CursorTime],'YData',SpecCursorYDataDef);
		end
		KeyIsOk=0;
		while ~KeyIsOk;
			[Key]=IfEmptyInputString([],[],[],'s');
			if length(Key)==1
				if strcmp(Key,'z') | strcmp(Key,'x') | strcmp(Key,'c') | strcmp(Key,'v') | strcmp(Key,'b') | strcmp(Key,'s')
					KeyIsOk=1; CursorTimeNew=[];
				elseif Key-48<=9 & Key-48>=0
					KeyIsOk=1; CursorTimeNew=Key-48;
				else
					KeyIsOk=0;
				end
			else
				Key=Key-48;
				if Key(1)==-3
					CursorTimeNew=0;
					for i=2:length(Key)
						CursorTimeNew=CursorTimeNew+Key(i).*10.^(length(Key)-i);
					end
					CursorTimeNew=-1.*CursorTimeNew;
					if CursorTimeNew> x(1) & CursorTimeNew< x(length(x))
						KeyIsOk=1;
					else
						KeyIsOk=0;
					end
				elseif all(Key>=0) & all(Key<=9)
					CursorTimeNew=0
					for i=1:length(Key)
						CursorTimeNew=CursorTimeNew+Key(i).*10.^(length(Key)-i);
					end
					if CursorTimeNew> x(1) & CursorTimeNew< x(length(x))
						KeyIsOk=1;
					else
						KeyIsOk=0;
					end
				else
					KeyIsOk=0;
				end
			end
			if ~KeyIsOk;
				fprintf('Sorry, this input is not permitted !\n\n');
			end
		end		
	end
end
return;
