function [DataMat,SaveFilePath,SizeDataMat,NDim,Version,SampRate,AvgRef,StartF0,EndF0,DeltaF0,NTap,SigmaM,EegMegStatus,NChanExtra,AmpPhaseStatus,NTrials]=DiffWaveletData(FileMat,SaveFilePath)
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
%=========================================================================
%
%	DiffWaveletData
%
%	Markus Junghoefer	[2000]
%
%
%	
%	Function definition
% 
% 
%================================================================================
if nargin<2;SaveFilePath=[];end;
if nargin<1;FileMat=[];end;

if isempty(FileMat)	
    FileExt='*.*wa*'; 
    String='Choose a wavelet file (*.*wa*):';
    DefFilePath=SetDefPath(1,FileExt);
    [NFiles,FileMat,VersionString,BatchFilePath]=ReadFileNames(FileMat,DefFilePath,String,[],[],[],[],2);
else
    NFiles=size(FileMat,1);
end
if NFiles<2; return; end
if NFiles>2 & mod(NFiles,2)~=0
    uiwait(errordlg('Uneven number of files while calculating wavelet-differences!'));
    return;
end
NPairs = NFiles/2;
counter = 0;
while counter<NFiles
    counter = counter+1;
	[File,Path,FilePath]=GetFileNameOfMat(FileMat,counter);
	[DataMat,FilePath,SizeDataMat,NDim,Version,SampRate,AvgRef,StartF0,EndF0,DeltaF0,NTap,SigmaM, ...
            EegMegStatus,NChanExtra,AmpPhaseStatus,NTrials]=ReadWaveletData(FilePath);

    counter = counter+1;
	[FileNew,PathNew,FilePathNew]=GetFileNameOfMat(FileMat,counter);
	[DataMatNew,FilePathNew,SizeDataMatNew,NDimNew,Version,SampRateNew,AvgRefNew,StartF0New,EndF0New,DeltaF0New,NTapNew,SigmaMNew, ...
            EegMegStatusNew,NChanExtraNew,AmpPhaseStatusNew,NTrialsNew]=ReadWaveletData(FilePathNew);
    
   	if isempty(SaveFilePath)
        [File,Path]=SepFilePath(FilePath);
        [FileNew,PathNew]=SepFilePath(FilePathNew);
        initFile='Diff.';
        Tmp1=findstr(File,'.awa');
        Tmp2=findstr(File,'.pwa');
        
        Tmp3=findstr(FileNew,'.awa');
        Tmp4=findstr(FileNew,'.pwa');
        if ~isempty(Tmp1)
            if length(File)>Tmp1+3 & length(FileNew)>Tmp3+3
                initFile=['Diff.awa',File(Tmp1+4:end),'-',FileNew(Tmp3+4:end)];
            else
                initFile='Diff.awa';
            end
        elseif ~isempty(Tmp2)
            if length(File)>Tmp2+3 & length(FileNew)>Tmp4+3
                initFile=['Diff.pwa',File(Tmp2+4:end),'-',FileNew(Tmp1+4:end)];
            else
                initFile='Diff.pwa';  
            end
        end    
        if NFiles==2
            [SaveFile,SavePath,SaveFilePath]=WriteFilePath([Path,filesep,initFile],'Choose diff. file name:');
        else
            SaveFilePath = [Path,File(1:Tmp1+3),File(Tmp1+4:end),'-',FileNew(Tmp3+4:end)];
        end
	end
    
    
	DataMat=DataMat-DataMatNew;
	NTrials=(NTrials+NTrialsNew)./2;
	SaveWaveletData(DataMat,SaveFilePath,[],[],[],SampRate,AvgRef,StartF0,EndF0,DeltaF0,NTap,SigmaM,EegMegStatus,NChanExtra,AmpPhaseStatus,NTrials);
	if nargout==0; DataMat=[]; end
    SaveFilePath = [];
end
return;
