%==================================================================
%
%	ExistCalcPhiMat.m
%
%	Markus Junghoefer	[1995]
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
%
%
%	
%	Function definition

	function [CosPhiMat] = ExistCalcPhiMat(status,A, B, PathCoeff, EcfgFile)

	
%=================================================================

SizeA=size(A);
SizeB=size(B);

%=============Searching for CosPhiMatFile===========================
if status==-1
	InvCosPhiFilePath=[PathCoeff,filesep,'InvCosPhi_',EcfgFile];
	[InvCosPhiFile,InvCosPhiPath]=SepFilePath(InvCosPhiFilePath);
	fid=fopen(InvCosPhiFilePath,'r','b');
	clc;
	if fid<0 
		fprintf('\n\n')
		fprintf('Can not find a file with name:\n')	
		PrintFilePath(InvCosPhiFilePath)
		fprintf('\n\n')
		fprintf('Start calculation of inverse cosinus(phi) matrix:\n')
		Message=char('Can not find a file with name:');
		Message=char(Message,InvCosPhiFilePath);
		Message=char(Message,'');
		Message=char(Message,'Start calculation of inverse cosinus(phi) matrix.');
		Message=char(Message,'This calculation might take a minute.');
		Message=char(Message,'');
		hmsgbox=msgbox(Message,'Info:','help');
		hChildMsgbox=get(hmsgbox,'Children');
		set(hChildMsgbox(length(hChildMsgbox)),'Visible','off');
		pause(.001)
		[CosPhiMat]=CalcCosPhiMat(A,[]);
		close(hmsgbox);
		[fid,Msg]=fopen(InvCosPhiFilePath,'w','b');
		if fid~=-1
			fwrite(fid,CosPhiMat,'float32');
		else
			Message=char('Can not write file:');			
			Message=char(Message,InvCosPhiFilePath);
			if length(InvCosPhiFile)>31; 
				Message=char(Message,'File name must not contain more than 31 characters!');	
			else
				Message=char(Message,Msg);
			end
			Message=char(Message,'');
			hmsgbox=msgbox(Message,'Info:','help');
			pause(.001)
		end
	else
		fprintf('\n\n')
		fprintf('Read file:\n')	
      	PrintFilePath(InvCosPhiFilePath)
     	fprintf('\n\n')
		[CosPhiMat,count] =fread(fid,[SizeA(1),SizeA(1)],'float32');
	end
elseif status==1
	ForCosPhiFilePath=[PathCoeff,filesep,'ForCosPhi_',EcfgFile,'_',num2str(SizeB(1))];
	[ForCosPhiFile,ForCosPhiPath]=SepFilePath(ForCosPhiFilePath);
	fid=fopen(ForCosPhiFilePath,'r','b');
	clc;
	if fid<0 
		fprintf('\n\n')
		fprintf('Can not find a file with name:\n')	
		PrintFilePath(ForCosPhiFilePath)
		fprintf('\n\n')
		fprintf('Start calculation of forward cosinus(phi) matrix:\n')
		Message=char('Can not find a file with name:');
		Message=char(Message,ForCosPhiFilePath);
		Message=char(Message,'');
		Message=char(Message,'Start calculation of forward cosinus(phi) matrix.');
		Message=char(Message,'This calculation might take a minute.');
		Message=char(Message,'');
		hmsgbox=msgbox(Message,'Info:','help');
		hChildMsgbox=get(hmsgbox,'Children');
		set(hChildMsgbox(length(hChildMsgbox)),'Visible','off');
		pause(.001)
		[CosPhiMat]=CalcCosPhiMat(A,B);
		close(hmsgbox);
		[fid,Message]=fopen(ForCosPhiFilePath,'w','b');
		if fid~=-1
			fwrite(fid,CosPhiMat,'float32');
		else
			Message=char('Can not write file:');			
			Message=char(Message,ForCosPhiFilePath);
			if length(ForCosPhiFile)>31; 
				Message=char(Message,'File name must not contain more than 31 characters!');	
			else
				Message=char(Message,Msg);
			end
			Message=char(Message,'');
			hmsgbox=msgbox(Message,'Info:','help');
			pause(.001)
		end
	else
		fprintf('\n\n')
		fprintf('Read file:\n')	
      	PrintFilePath(ForCosPhiFilePath)
      	fprintf('\n\n')
		[CosPhiMat,count] =fread(fid,[SizeA(1),SizeB(1)],'float32');
	end
end
if fid~=-1; fclose(fid); end

return;
