function OutFileMat=FilterAvgFiles(FileMat,SampRateTmp,ChLowPassFilt,ChHighPassFilt)
%==================================================================
%==================================================================
%
%	FilterAvgFiles.m
%
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
%	Markus Junghoefer	[1999]
%
%
%	Function definition
%	
%
%
%
%
%=================================================================

%==================================================================
if nargin<4; ChHighPassFilt=1; end
if nargin<3; ChLowPassFilt=1; end
if nargin<2; SampRateTmp=250; end
if nargin<1; FileMat=[]; end

DefFilePath=SetDefPath('r','*.at*');
[NFiles,FileMat,NonUse,BatchFilePath]=ReadFileNames(FileMat,DefFilePath,'Choose *.at* file(s):');
if NFiles==0; return; end
[BatchFile,BatchPath]=SepFilePath(BatchFilePath);
SetDefPath('w',BatchPath);

FullFilePath=which('20HzPass25HzStopButter250.lf');
if ~isempty(FullFilePath);
    [FullFile,FullPath]=SepFilePath(FullFilePath);
    if FullPath(end)==filesep
        FullPath=FullPath(1:length(FullPath)-1);
    end
    OldPath=pwd;
    eval(['cd ',FullPath]); 
    Return2OldPathStatus=1;
end

%===============FilterFile====================================
if ChLowPassFilt
    [LowFiltFile,LowFiltPath,LowFiltFilePath]=ReadFilePath([],['*',int2str(SampRateTmp),'.lf'],'Open lowpass file: (Cancel => no filtering)');
    if LowFiltFile==0; 
        ChLowPassFilt=0; 
    else
        LowFiltCoeff=ReadBem(LowFiltFilePath,1,'Matrix','Ascii')
        SizeLowFiltCoeff=size(LowFiltCoeff);
        if SizeLowFiltCoeff(1)~=2 & SizeLowFiltCoeff(2)==2; LowFiltCoeff=LowFiltCoeff'; end
    end 
end
if ChHighPassFilt
    [HighFiltFile,HighFiltPath,HighFiltFilePath]=ReadFilePath([],['*',int2str(SampRateTmp),'.hf'],'Open highpass file: (Cancel => no filtering)');
    if HighFiltFile==0; 
        ChHighPassFilt=0; 
    else
        HighFiltCoeff=ReadBem(HighFiltFilePath,1,'Matrix','Ascii')
        SizeHighFiltCoeff=size(HighFiltCoeff);
        if SizeHighFiltCoeff(1)~=2 & SizeHighFiltCoeff(2)==2; HighFiltCoeff=HighFiltCoeff'; end
    end   
end
if ChLowPassFilt | ChHighPassFilt
    for FileInd=1:NFiles
        [NoUse,NoUse,FilePath]=GetFileNameOfMat(FileMat,FileInd);
        [AvgMat,File,Path,FilePath,NTrialAvgVec,StdChanTimeMat,...
                SampRate,AvgRef,Version,MedMedRawVec,MedMedAvgVec,EegMegStatus,NChanExtra]=ReadAvgFile(FilePath);
        [NChan,NPoints]=size(AvgMat);
        if SampRate==SampRateTmp;
            if ChLowPassFilt
                for i=1:NChan
                    AvgMat(i,:)=(filtfilt(LowFiltCoeff(1,:),LowFiltCoeff(2,:),AvgMat(i,:)'))';
                end
            end
            if ChHighPassFilt
                for i=1:NChan
                    AvgMat(i,:)=(filtfilt(HighFiltCoeff(1,:),HighFiltCoeff(2,:),AvgMat(i,:)'))';
                end
            end
            if ChLowPassFilt & ChHighPassFilt
                SaveFilePath=[FilePath '.lhf'];
            elseif  ChLowPassFilt
                SaveFilePath=[FilePath '.lf'];
            elseif  ChHighPassFilt
                SaveFilePath=[FilePath '.hf'];
            end
            SaveAvgFile(SaveFilePath,AvgMat,NTrialAvgVec,StdChanTimeMat,SampRate,MedMedRawVec,MedMedAvgVec,EegMegStatus,NChanExtra);
            if FileInd==1
                OutFileMat=char(SaveFilePath);
            else
                OutFileMat=char(OutFileMat,SaveFilePath);
            end
        end	
    end
end
if Return2OldPathStatus
    eval(['cd ',OldPath]); 
end
return