function[]=Main128(action);
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      

%==================================================================
%
%	Main128
%
%	Markus Junghoefer	[1998]
%
%
%	Function definition

%

%==================================================================
%==================================================================
if nargin<1; action='InitializeMenu'; end

%================= global variables =============================================
global hMain128Fig

if strcmp(action,'InitializeMenu'),

	%============================================================================
	%=========== INITIALIZE MENU ================================================
	%============================================================================
	
			
	%============== figure with graphs =========================		
   	if strcmp(computer,'MAC2')	
      	ChanFigPosVec=[0 0 0.6 1];	
      	MenuFigPosVec=[0 0 .2 1];
		AvgInfoFigPosVec=[0 .55 MenuFigPosVec(1) .45];
		AvgMessageFigPosVec=[0 0 MenuFigPosVec(1) .45];
   	elseif strcmp(computer,'PCWIN') 
      	ChanFigPosVec=[0.005 0.01 .60 0.95];  
      	MenuFigPosVec=[0.61 0.01 0.2 0.935];
		AvgInfoFigPosVec=[0 .5 MenuFigPosVec(1) .5];
		AvgMessageFigPosVec=[0 0 MenuFigPosVec(1) .5];
    elseif strcmp(computer,'SOL2')
      	ChanFigPosVec=[0.01 0.01 .601 0.935];  
      	MenuFigPosVec=[0.6224 0.01 0.2 0.91];
		AvgInfoFigPosVec=[0 .5 MenuFigPosVec(1) .5];
		AvgMessageFigPosVec=[0 0 MenuFigPosVec(1) .5];		
   	end;
   
	%============== figure with menu ===========================		
	Main128FigString=['Main Menu:'];
   	hMain128Fig=figure('Units','normal','Position',MenuFigPosVec, ...
        'Name',Main128FigString,'Color',[1 1 1], ...
        'NumberTitle','off');
		
		
    % Information for all buttons (and menus)
    labelColor=[0.8 0.8 0.8];
    yInitPos=0.90;
    menutop=0.955;
    btnTop = 0.6;
    top=0.75;
    left=0.125;
    btnWid=0.8;
    btnHt=0.08;
	btnHt_edit=0.050;
    textHeight = 0.05;			% not used !!!!!!!!!!!
    textWidth = 0.06;
    % Spacing between the button and the next command's label
    spacing=0.015;

    %====================================
    % The CONSOLE frame
	
    frmBorder=0.05; 
	frmLeft=left-frmBorder;
	frmBottom=0.010; 
    frmHeight = 1-3.*frmBottom; 
	frmWidth = btnWid+2*frmBorder;
    yPos=frmBottom-frmBorder;
    frmPos=[frmLeft frmBottom frmWidth frmHeight];
	ConsoleRGBColor=[0.3 0 0];
    hConsolFrame=uicontrol( ...
        'Style','frame', ...
        'Units','normalized', ...
        'Position',frmPos, ...
		'BackgroundColor',ConsoleRGBColor);
		
	%propedit(hConsolFrame)
	%====================================
    
	% The ChannelPlot frame
    	%frmBorder=0.019; frmBottom=0.019; 
    %frmHeight = 1-(3.*frmBorder); frmWidth = 0.725;
    %yPos=frmBottom-frmBorder;
    %frmPos=[frmBorder yPos frmWidth frmHeight+2*frmBorder];
    %hChannelPlot=uicontrol( ...
    %   'Style','frame', ...
    %    'Units','normalized', ...
    %     'Position',frmPos, ...
	%	'BackgroundColor',[0 0 0.3]);
	%propedit(hChannelPlot)

	
 	%==============================================================
    % FirstBatch===================================================
	%==============================================================
	
	btnNumber=1;
    yPos=menutop-(btnNumber-1)*(btnHt+spacing);
    btnPos=[left yPos-btnHt btnWid btnHt];
	callbackStr = 'FirstBatch';
	hFirstBatchMenu=uicontrol( ...
        'Style','pushbutton', ...
        'Units','normalized', ...
        'Position',btnPos, ...
        'String','First Batch', ...
		'Userdata','0', ...
        'Callback',callbackStr,...
		'FontSize',20,...
		'ForegroundColor',[.3 .3 0],...
		'Enable','off');
	
	%==============================================================
    % EditAEM
	%==============================================================
	
	btnNumber=2;
    yPos=menutop-(btnNumber-1)*(btnHt+spacing);
    btnPos=[left yPos-btnHt btnWid btnHt];
	callbackStr = 'EditAEM';
	hEditAEMMenu=uicontrol( ...
        'Style','pushbutton', ...
        'Units','normalized', ...
        'Position',btnPos, ...
        'String','Edit AEM', ...
		'Userdata','0', ...
        'Callback',callbackStr,...
		'FontSize',20,...
		'ForegroundColor',[.3 0 0.3],...
		'Enable','on');
	
	%==============================================================
    % AvgApprox
	%==============================================================
	
	btnNumber=3;
    yPos=menutop-(btnNumber-1)*(btnHt+spacing);
    btnPos=[left yPos-btnHt btnWid btnHt];
	callbackStr = 'AvgApprox';
	hAvgApproxMenu=uicontrol( ...
        'Style','pushbutton', ...
        'Units','normalized', ...
        'Position',btnPos, ...
        'String','Average', ...
		'Userdata','0', ...
        'Callback',callbackStr,...
		'FontSize',20,...
		'ForegroundColor',[0 0.3 0.3],...
		'Enable','on');
		
	%==============================================================
    % Plot2d
	%==============================================================
	
	btnNumber=4;
    yPos=menutop-(btnNumber-1)*(btnHt+spacing);
    btnPos=[left yPos-btnHt btnWid btnHt];
	callbackStr = 'Plot2d';
	hPlot2dMenu=uicontrol( ...
        'Style','pushbutton', ...
        'Units','normalized', ...
        'Position',btnPos, ...
        'String','Plot 2D', ...
		'Userdata','0', ...
        'Callback',callbackStr,...
		'FontSize',20,...
		'ForegroundColor',[0 0 0.3],...
		'Enable','on');
	
	%==============================================================
    % Plot3d
	%==============================================================
	
	btnNumber=5;
    yPos=menutop-(btnNumber-1)*(btnHt+spacing);
    btnPos=[left yPos-btnHt btnWid btnHt];
	callbackStr = 'Plot3d';
	hPlot3dMenu=uicontrol( ...
        'Style','pushbutton', ...
        'Units','normalized', ...
        'Position',btnPos, ...
        'String','Plot 3d', ...
		'Userdata','0', ...
        'Callback',callbackStr,...
		'FontSize',20,...
		'ForegroundColor',[0 0.3 0],...
		'Enable','off');
end
