function [StimTypeVec,UseTrialIndVec,NonUseTrialIndVec] = NeuroScan2Con(FileMat)
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
%==================================================================
%
%	NeuroScan2Con
%
%
%	Markus Junghoefer	[2002]
%
%
%	Function definition
%
%	function NsStruct=NeuroScan2Con(NsFilePath)
% 
% 	if nargin<1; FilePath=[]; end
%

%=================================================================
if nargin<1;FileMat=[]; end

DefFilePath=SetDefPath('r','*.cnt');
[NFiles,FileMat,VersionString,BatchFilePath]=ReadFileNames(FileMat,DefFilePath,'Choose cnt file(s) or a batch file:');
if NFiles==0; return; end
[BatchFile,BatchPath]=SepFilePath(BatchFilePath)
SetDefPath('w',BatchPath);

for FileInd=1:NFiles
	[NsFile,NsPath,NsFilePath]=GetFileNameOfMat(FileMat,FileInd);
	f=ReadNeuroScanStruct(NsFilePath);
	%==========================================
	NTotTrials=f.header.numevents
	CellVec=[1 2 3 4];
	NBadStimtype=0;
	NOKStimtype=0;
	TrialStatusVec=zeros(NTotTrials,1);
	for i=1:NTotTrials
		StimtypeTmp=f.events(i).stimtype;
		if StimtypeTmp>0 & StimtypeTmp<6
			TrialStatusVec(i)=1;
		end
		StimTypeVec(i)=f.events(i).stimtype;
	end
	UseTrialIndVec=find(TrialStatusVec);
	NonUseTrialIndVec=find(~TrialStatusVec);
	NTotTrials=length(UseTrialIndVec);
 	ConFilePath=[NsPath,NsFile(1:end-3),'con'];
 	SaveAscii(StimTypeVec(UseTrialIndVec),ConFilePath);
end
return;
