%==================================================================
%
%	PlotECPositions.m
%
%	Markus Junghoefer	[1995]
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
%
%
%	This will plot the cartesian Electrode positions in an 2 or 3 dimensional plot
%	Status==1 => Scalp
%	Status==2 => Cortex

%	Function definition

	function []=PlotECPositions(status,dim,TextStatus,ForeGroundColor,chPlotECPositions,...
	EPosSpher,Radius,SensorCircleStatus,SensorAsteriskStatus,SensorNameStatus,SensorNames)

%==================================================================
if nargin<11; SensorNames=[]; end;
if nargin<10; SensorNameStatus=0; end;
if nargin<9; SensorAsteriskStatus=0; end;
if nargin<8; SensorCircleStatus=1; end;
if nargin<7; return; end;
if ~chPlotECPositions; return; end;

[ECPosCart] = change_sphere_cart(EPosSpher,Radius,1);
NChan=length(ECPosCart);
if isempty(SensorNames); SensorNames=int2str([1:NChan]); end
RoFaktor1=1.01;
RoFaktor2=1.05;


if dim==2
	for j=1:NChan
		if SensorCircleStatus
			text(ECPosCart(j,1),ECPosCart(j,2), 'o','HorizontalAlignment','center','FontSize',[10],'Color',ForeGroundColor);
		end
		if SensorAsteriskStatus
			text(ECPosCart(j,1),ECPosCart(j,2), '*','HorizontalAlignment','center','FontSize',[10],'Color',ForeGroundColor);
		end
		if SensorNameStatus
			text(ECPosCart(j,1),ECPosCart(j,2), SensorNames(j,:),'HorizontalAlignment','center','FontSize',[16],'Color',ForeGroundColor);
		end	
	end
elseif dim==3
	for j=1:NChan
		if SensorCircleStatus
			text(RoFaktor1.*ECPosCart(j,1),RoFaktor1.*ECPosCart(j,2), RoFaktor1.*ECPosCart(j,3), 'o',...
			'HorizontalAlignment','center','FontSize',[10],'Color',ForeGroundColor);
		end
		if SensorAsteriskStatus
			text(RoFaktor1.*ECPosCart(j,1),RoFaktor1.*ECPosCart(j,2), RoFaktor1.*ECPosCart(j,3), '*',...
			'HorizontalAlignment','center','FontSize',[10],'Color',ForeGroundColor);
		end
		if SensorNameStatus
			if SensorCircleStatus | SensorAsteriskStatus
				text(RoFaktor2.*ECPosCart(j,1),RoFaktor2.*ECPosCart(j,2), RoFaktor2.*ECPosCart(j,3), ['  '  SensorNames(j,:)],...
				'HorizontalAlignment','left','FontSize',[10],'Color',ForeGroundColor);
			else
				text(RoFaktor2.*ECPosCart(j,1),RoFaktor2.*ECPosCart(j,2), RoFaktor2.*ECPosCart(j,3),SensorNames(j,:),...
				'HorizontalAlignment','center','FontSize',[10],'Color',ForeGroundColor);
			end
		end
	end	
else
	error('Bad dimension')
end
return;
