%==================================================================
%
%	PlotSingleFrequVec.m
%
%
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
%	Markus Junghoefer	[1996]
%
%	Function definition

	function[]=PlotSingleFrequVec(Data,IndexVec,ElNo,frequ_resol);

%=================================================================
global data_file ch_run e_config e_status samp_rate;

ch_Intervall=1;
LengthData=length(Data);

while ch_Intervall
	if ElNo==0
		fprintf('Plot the frequency course of global power: \n\n');
	else
		fprintf(1,'Plot the frequency course of electrode number: \n\n',ElNo);
	end
	[min_f]=IfEmptyInputValInt(['Please insert the minimum Frequency [in Hz]:'],[],[],0,0,samp_rate./2);
	StartPoint=floor(min_f/frequ_resol)+1;
	[max_f]=IfEmptyInputValInt(['Please insert the maximum Frequency [in Hz]:'],[],[],samp_rate./2,0,samp_rate./2);
	EndPoint=floor(max_f/frequ_resol)+1;
	f=linspace(min_f,max_f,EndPoint-StartPoint+1);
	MinData=min(Data(StartPoint:EndPoint));
	MaxData=max(Data(StartPoint:EndPoint));
	fprintf(1,'The values of all data lay between %g and %g !\n\n',MinData,MaxData);
	[MinData]=IfEmptyInputVal(['Insert the new minima:'],[],[],MinData);
	[MaxData]=IfEmptyInputVal(['Insert the new maxima:'],[],[],MaxData);
	figure('Units','normal','NumberTitle','off','Position',[0.66,0.5,0.33,0.5],'Name','Potential Time Course')
	axes('Units','normal','Position',[0.15 0.2 0.8 0.725])
	plot(f,Data(StartPoint:EndPoint));

	if ElNo==0
		TitleString=['Frequency Course of Gobal Power:'];
	else
		TitleString=['Frequency Course of Electrode No:',ElNo];
	end
	title(TitleString);
	axis([f(1) f(length(f))  MinData MaxData]);
	xlabel('Frequency [Hz]');
	
	if ~isempty(data_file) & ~isempty(ch_run)
		hold on
		axes('Units','normal','Position',[0 0 1 0.2])
		text('Units','normal','Position',[.15,.05],'String','Data from file:  ','FontSize',[10])
		text('Units','normal','Position',[.5,.05],'String',num2str(data_file),'FontSize',[10])
		text('Units','normal','Position',[.15,.2],'String','Electrode config.:','FontSize',[10])
		text('Units','normal','Position',[.5,.2],'String',['ec_',e_config,'_',e_status],'FontSize',[10])
		text('Units','normal','Position',[.15,.35],'String','Run Number:  ','FontSize',[10])
		text('Units','normal','Position',[.5,.35],'String',num2str(ch_run),'FontSize',[10])
		axis('off')
		hold off
	end
	[ch_Intervall]=IfEmptyInputBo(['Do you want to choose a different frequency intervall ?'],[],[],1);
end 
return;
