function [NFiles,FileMat,NonUse,BatchFilePath]=ReadBatchFileNames(BatchFilePath)
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
%==================================================================
%
%	ReadBatchFileNames.m
%
%	Harald Schupp & Markus Junghofer
%
%
%	
%	Function definition
%==================================================================
if nargin<1; BatchFilePath=[]; end
NonUse=[];
if isempty(BatchFilePath)
	[BatchFile,BatchPath]=uigetfile('*','Open file: ',0,0);
	if BatchFile==0; NFiles=0; FileMat=[]; return; end
	BatchFilePath=[BatchPath,BatchFile];
end

[fid]=fopen(BatchFilePath,'r','b');
NFiles=0;
while feof(fid) == 0;
	NFiles=NFiles+1;
	FilePath=fgetl(fid);
	if NFiles==1
		FileMat=char(FilePath);
	else
		FileMat=char(FileMat,FilePath);
	end
end		
disp(FileMat)		
