%==================================================================
%
%	ReadEGISHeader.m
%
%	Markus Junghoefer	[1996]
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
%
%
%	Function definition
%
%
	function[Header,File,Path,FilePath,SampRate,NCells,NTrials,NPoints,...
	NChan,LHeader,LCellHdr,BrdGain,ChanZero,ChanGain,HdrVer,Bits,Range,...
	LData,LSpecCellMat,BytOrd,ExptNam,RunDate,RunTime,SubjID,Handed,Sex,...
    Age,ExperID,EdVer,CalFlag,LText,LComment,LPad,CellID,CellName,LSpec]=ReadEGISHeader(...
	FilePath,HeaderIn,filterSpec,LSpecCellVal,PrintStatus,BitsRangeStatus)
%
%==================================================================
if nargin<6; BitsRangeStatus=0; end;
if nargin<5; PrintStatus=1; end;
if nargin<4; LSpecCellVal=[]; end;
if nargin<3; filterSpec='*'; end;
if nargin<2; HeaderIn=[]; end;
if nargin<1; FilePath=[]; end;
if ~isempty(HeaderIn); File=[]; Path=[];FilePath=[]; return; end;

DefPath=SetDefPath('r','*.E*');
[File,Path,FilePath]=ReadFilePath(FilePath,DefPath,'Open Egis file:');
if File==0; 
	Header=[]; File=0; Path=0; FilePath=0; SampRate=[]; NCells=[]; NTrials=[]; NPoints=[]; 
	NChan=[]; LHeader=[]; LCellHdr=[]; BrdGain=[]; ChanZero=[]; ChanGain =[];HdrVer=[]; Bits=[]; Range=[];
	LData=[]; LSpecCellMat=[]; 
	return;
end
SetDefPath('w',Path);
global BytOrd
global HdrVer
global LHeader
global LData
global ExptNam
global RunDate
global RunTime
global SubjID
global Handed
global Sex
global Age
global ExperID
global EdVer
global CalFlag
global NCells
global NChan
global LText
global LComment
global LPad
global BrdGain
global LCellHdr
global ChanZero
global ChanGain
global CellID
global CellName
global NTrials
global NPoints
global SampRate
global LSpec
if PrintStatus
	fprintf('\n')
	clc;
	fprintf('Start reading data file...\n\n');
	disp(FilePath);
	fprintf('\n\n');
end
fid=fopen(FilePath,'r','b');
BytOrd(1:4)=fread(fid,4,'uint8');
HdrVer=fread(fid,1,'int16');
LHeader=fread(fid,1,'int16');
LData=fread(fid,1,'int32');
[ExptNam]=fread(fid,80,'uchar');
RunDate=fread(fid,3,'int16');
RunTime=fread(fid,3,'int16');
SubjID=fread(fid,1,'int16');
Handed=fread(fid,1,'int16');
Sex=fread(fid,1,'int16');
Age=fread(fid,1,'int16');
ExperID=fread(fid,1,'int16');
EdVer=fread(fid,1,'int16');
CalFlag=fread(fid,1,'int16');
NCells=fread(fid,1,'int16');
NChan=fread(fid,1,'int16');
LComment=fread(fid,1,'int16');
LText=fread(fid,1,'int16');
LPad=fread(fid,1,'int16');   
BitsRangeStatus
if BitsRangeStatus==1
	Bits=LText; %Achtung
	Range=LPad; %Achtung
    fprintf('Bits = LText\n');
    fprintf('Range = LPad\n');
else
	Bits=10;
	Range=366;
end
fprintf('Bits = %g\n',Bits);
fprintf('Range = %g\n',Range);
BrdGain=fread(fid,1,'int16');
for i=1:NCells
	LCellHdr(i)=fread(fid,1,'int16');
end
[ChanZero]=fread(fid,NChan,'int16');
[ChanGain]=fread(fid,NChan,'int16');
Tell1=ftell(fid);
CellName=zeros(80,NCells);
index=0;
Offset=0;
CellID=[];CellName=[];NTrials=[];NPoints=[];SampRate=[];LSpec=[];LSpecCell=[];
for CellInd=1:NCells
	if CellInd>1
		Offset=Tell1+sum(LCellHdr(1:CellInd-1));
		SeekStatus=fseek(fid,Offset,'bof');
		if SeekStatus==-1; error('FSeekError in ReadEgisHeader'); end
	end
	CellID(CellInd)=fread(fid,1,'int16');
	CellName(:,CellInd)=fread(fid,80,'char');
	NTrials(CellInd)=fread(fid,1,'int16');
	NPoints(CellInd)=fread(fid,1,'int16');
	SampRate(CellInd)=fread(fid,1,'int16');
	LSpec(CellInd)=fread(fid,1,'int16');	%Bytes => TmpVec=fread(fid,LSpec(CellInd)./2,'int16')
	eval(['global LSpecCell',int2str(CellInd)])
	eval(['LSpecCell',int2str(CellInd),'= zeros(NTrials(CellInd),LSpec(CellInd)./2);'])
	for TrialInd=1:NTrials(CellInd)
		TmpVec=fread(fid,LSpec(CellInd)./2,'int16')';
		eval(['LSpecCell',int2str(CellInd),'(',int2str(TrialInd),',:) = TmpVec;']);
	end
end
LSpecCellMat=[];
if ~isempty(LSpecCellVal)
	if LSpecCellVal>0 & LSpecCellVal<=NCells
		eval(['LSpecCellMat=LSpecCell' int2str(LSpecCellVal) ';']);
	end
end
CalcLengthData=NChan*sum(NTrials.*NPoints).*2;
NoPointsInCell=NPoints.*NTrials.*NChan;
NoPointsInAllCells=sum(NoPointsInCell);
NoPointsInFile=NoPointsInAllCells+LHeader;
tell1=ftell(fid);
fseek(fid,0,-1);
Header=fread(fid,LHeader,'int8');
if PrintStatus; fprintf('End reading data file...\n'); end
fclose(fid);
return;
