function[EStatusVec,EStFile,EStPath,EStFilePath,EStFileFound]=ReadEStatus(EStFilePath,NChan)
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
%==================================================================
%
%	ReadECfgStatus.m
%
%	Markus Junghoefer	[1996]
%
%
%	
%	Function definition

	
	
%=================================================================
if nargin<2; NChan=[]; end
if nargin<1; EStFilePath=[]; end
if isempty(EStFilePath)
	[NChan]=IfEmptyInputValInt('Please insert the number of channels to read:',[],NChan,128,1,129,1);
end
filterSpec=['*.' int2str(NChan) 'ESt'];
[EStFile,EStPath,EStFilePath]=ReadFilePath(EStFilePath,filterSpec,'Choose electrode status file:');
if EStFile==0
	EStFileFound=0;
else
	fid=fopen(EStFilePath,'r','b');
	if fid>2; EStFileFound=1; else; EStFileFound=0; end
end
if EStFileFound
	fprintf('Start reading of file...\n\n');
	fprintf(EStFilePath); fprintf('\n\n');
	EStatusVec= fread(fid,inf,'int16');
	fprintf('End reading file...');
	fclose(fid);
	pause(1)
else
	EStatusVec=[]; EStFile=[]; EStPath=[]; EStFilePath=[];
end

return;
