function	[File,Path,FilePath]=ReadFilePath(FilePath,filterSpec,dialogTitle,X,Y,string1,string2,string3)
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
%==================================================================
%
%	ReadFilePath.m
%
%	Markus Junghoefer	[1996]
%
%
%	Function definition
% 
% 	function[File,Path,FilePath]=ReadFilePath(FilePath,filterSpec,dialogTitle,X,Y,string1,string2,string3)
% 
%=================================================================
if nargin<8; string3=[]; end
if nargin<7; string2=[]; end
if nargin<6; string1=[]; end
if nargin<5; Y=[]; end
if nargin<4; X=[]; end
if nargin<3; dialogTitle=[]; end
if nargin<2; filterSpec=[]; end
if nargin<1; FilePath=[]; end
if ~isempty(FilePath)
   [File,Path]=SepFilePath(FilePath);
	return;
else
	if isempty(X); X=[.5]; end
	if isempty(Y); Y=[.5]; end
	if isempty(filterSpec); filterSpec=['*']; end
	if isempty(dialogTitle); dialogTitle=['Choose file to analyse:']; end
	if ~isempty(string1); fprintf(string1); end
	if ~isempty(string2); fprintf(string2); end
	if ~isempty(string3); fprintf(string3); end
	[File,Path]=uigetfile(filterSpec,dialogTitle,X,Y);
   	FilePath=[Path,File];
   	if isempty(find(FilePath)); return; end;
end
return;
