%==================================================================
%
%	ReadKNPolFile.m
%
%	Markus Junghoefer	[1995]
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
%
%
%	Function definition
%
	
	function[pol_data,NrOfPolFiles,TotNrOfEl]=ReadKNPolFile(a);

%
%
%=================================================================
if nargin<1; a=[]; end
clc;
[NrOfPolFiles]=IfEmptyInputVal(['Please insert the number of'],['Polhemus files to read in:'],[],3);
[TotNrOfEl]=IfEmptyInputVal(['Please insert the total number of electrodes:'],[],TotNrOfEl,130);
pol_data=zeros(NrOfPolFiles*TotNrOfEl,3);

for i=1:NrOfPolFiles

	%+++++Open file to read Polhemus Data
	fprintf(1,'Please insert the %g file name of the original Polhemus-data:',i);
	pause(1)
	[pol_data_file,data_path]=uigetfile('*','Get File: Polhemus Data');
	pol_data_file=[data_path,pol_data_file];
	fprintf('\n')
	[nr_pol_rows]=IfEmptyInputVal(['Please insert the number of rows of this file:'],[],[],7);
	fprintf('Start to read in file with name:\n\n');
	fprintf(pol_data_file)

	fid=fopen(pol_data_file,'r');

	%+++++Read data in nr_pol_rows rows given in Polhemus format (?,x,y,z,theta,phi,?)

	[pol_data_tmp,count]=fscanf(fid,'%g',[nr_pol_rows,TotNrOfEl]);
	pol_data((i-1)*TotNrOfEl+1:i*TotNrOfEl,:)=pol_data_tmp(2:4,:)';
	pol_data_tmp=[];
	fprintf('\n\n')
	fprintf('End reading file.\n\n\n');

end

return;
