%==================================================================
%
%	ReadOrCalcCoeff.m
%
%	Markus Junghoefer	[1995]
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
%
%
%	
%	Function definition

	function [Coeff] = ReadOrCalcCoeff(status,A,B,PathLeg,...
					   PathCoeff, ECFGFILE,...
					   n_scalp, l_iter, m_iter, LengthLegVec)

	
%=================================================================

size_A=size(A);
size_B=size(B);

if ECFGFILE(length(ECFGFILE)-4:length(ECFGFILE))=='.ecfg'
	Ecfg=ECFGFILE(1:length(ECFGFILE)-5);
else
	Ecfg=ECFGFILE;
end
if status==1
	[CosPhiMat]=ExistCalcPhiMat(-1,A, B, PathCoeff, Ecfg);
else
	[CosPhiMat]=ExistCalcPhiMat(1,A, B, PathCoeff, Ecfg);
end
if status==1
	CoeffFilePath = [PathCoeff,filesep,'Inv_',Ecfg,'_',num2str(n_scalp),'_',num2str(l_iter)];
elseif status==2
	CoeffFilePath = [PathCoeff,filesep,'Scalp_',Ecfg,'_',num2str(n_scalp),'_',num2str(l_iter)];
elseif status==3
	CoeffFilePath = [PathCoeff,filesep,'CsdScalp_',Ecfg,'_',num2str(n_scalp),'_',num2str(l_iter)];
elseif status==4
	CoeffFilePath = [PathCoeff,filesep,'Cort_',Ecfg,'_',num2str(n_scalp),'_',num2str(l_iter)];
elseif status==5
	CoeffFilePath = [PathCoeff,filesep,'CsdCort_',Ecfg,'_',num2str(n_scalp),'_',num2str(l_iter)];
end
[CoeffFile,CoeffPath]=SepFilePath(CoeffFilePath);
[CoeffFid,Msg]=fopen(CoeffFilePath,'r','b');
clc;
if CoeffFid<0 
	fprintf('\n\n')
	fprintf('Calculate:\n')	
	PrintFilePath(CoeffFilePath)
	fprintf('\n')
	if length(CoeffFile)>31; 
		fprintf('Can not save file since file name must not contain more than 31 characters!\n\n')
	end
	Message=char('');
	Message=char(Message,'Calculate leadfield coefficients');
	Message=char(Message,CoeffFilePath);
	Message=char(Message,'');
	Message=char(Message,'This calculation might take a minute');
	Message=char(Message,'');
	hmsgbox=msgbox(Message,'Info:','help');
	hChildMsgbox=get(hmsgbox,'Children');
	set(hChildMsgbox(length(hChildMsgbox)),'Visible','off');
	pause(.1);
	if status==1 | status==2
		ScalpLegFile = [PathLeg,filesep,'ScalpLeg_',num2str(l_iter),'_',num2str(m_iter),'_',num2str(LengthLegVec)];
		ScalpLegFid=fopen(ScalpLegFile,'r','b');	
		[ScalpLegVec] =fread(ScalpLegFid,inf,'float64');
		fclose(ScalpLegFid);
		[Coeff] = CalcCoeff(CosPhiMat,ScalpLegVec,LengthLegVec);
	elseif status==3
		CsdScalpLegFile = [PathLeg,filesep,'CsdScalpLeg_',num2str(l_iter),'_',num2str(m_iter),'_',num2str(LengthLegVec)];
		CsdScalpLegFid=fopen(CsdScalpLegFile,'r','b');
		[CsdScalpLegVec] =fread(CsdScalpLegFid,inf,'float64');	
		fclose(CsdScalpLegFid);
		[Coeff] = CalcCoeff(CosPhiMat,CsdScalpLegVec,LengthLegVec);
	elseif status==4
		CortLegFile = [PathLeg,filesep,'CortLeg_',num2str(l_iter),'_',num2str(m_iter),'_',num2str(LengthLegVec)];
		CortLegFid=fopen(CortLegFile,'r','b');
		[CortLegVec] =fread(CortLegFid,inf,'float64');
		fclose(CortLegFid);
		[Coeff] = CalcCoeff(CosPhiMat,CortLegVec,LengthLegVec);
	elseif status==5
		CsdCortLegFile = [PathLeg,filesep,'CsdCortLeg_',num2str(l_iter),'_',num2str(m_iter),'_',num2str(LengthLegVec)];
		CsdCortLegFid=fopen(CsdCortLegFile,'r','b');
		[CsdCortLegVec] =fread(CsdCortLegFid,inf,'float64');
		fclose(CsdCortLegFid);
		[Coeff] = CalcCoeff(CosPhiMat,CsdCortLegVec,LengthLegVec);	
	end
	close(hmsgbox);
	[CoeffFid,Msg]=fopen(CoeffFilePath,'w','b');
	if CoeffFid~=-1
		fwrite(CoeffFid,Coeff,'float32');
		fclose(CoeffFid);
	else
		Message=char('Can not write file:');			
		Message=char(Message,CoeffFilePath);
		if length(CoeffFile)>31; 
			Message=char(Message,'File name must not contain more than 31 characters!');	
		else
			Message=char(Message,Msg);
		end
		Message=char(Message,'');
		hmsgbox=msgbox(Message,'Info:','help');
		pause(.001)
	end
	return;
else
	fprintf('Read file:\n');
	PrintFilePath(CoeffFilePath);
	fprintf('\n');
	Message=char('');
	Message=char(Message,'Read leadfield coefficients from file:');
	Message=char(Message,CoeffFilePath);
	Message=char(Message,' ');
	hmsgbox=msgbox(Message,'Info:','help'); 
	hChildMsgbox=get(hmsgbox,'Children');
	set(hChildMsgbox(length(hChildMsgbox)),'Visible','off');
	pause(1);
	if status==1
		[Coeff,count] =fread(CoeffFid,[size_A(1),size_A(1)],'float32');
	else
		[Coeff,count] =fread(CoeffFid,[size_A(1),size_B(1)],'float32');
	end
end
close(hmsgbox);
return;
	
