function [SensorPosNormMat,SensorNames,SensorNChan,Cot,FiduMat,SfpMat]=ReadPmgCotSfpFiles(PmgFilePath,CloseMsgBoxStatus,ReadCotStatus,ReadSfpStatus)
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      

if nargin<4; ReadSfpStatus=1; end
if nargin<3; ReadCotStatus=1; end
if nargin<2; CloseMsgBoxStatus=0; end
if nargin<1; PmgFilePath=[]; end

[DefFilePath] = SetDefPath('r','*.pmg')
[PmgFile,PmgPath,PmgFilePath]=ReadFilePath(PmgFilePath,DefFilePath,'Please choose a pmg file:');
if PmgFile==0; return; end
SetDefPath('w',PmgPath);
[PmgFid,ErrorMessage]=fopen(PmgFilePath,'r','b');
if PmgFid==-1; 
	Message=char('');
    Message=char(Message,'Can not read sensor configuration from file:');
    Message=char(Message,PmgFilePath);
    Message=char(Message,'');
    Message=char(Message,'Error message:');
    Message=char(Message,ErrorMessage);
    Message=char(Message,'');
    Message=char(Message,'');
    SensorPosNormMat=[];
    CloseMsgBoxStatus=0;
else
	Message=char('');
    Message=char(Message,'Read sensor configuration from file:');
    Message=char(Message,PmgFilePath);
    Message=char(Message,'');
    Message=char(Message,'');
    Count1=1; SensorNChan=0;	
    while Count1~=0
		TellTmp=ftell(PmgFid);
	    [TmpStr,Count1]=fscanf(PmgFid,'%s',1);
	    if Count1==0; 
			break 
		else 
			SensorNChan=SensorNChan+1; 
		end
	    TmpTmp=findstr(TmpStr,'Channel');
		%exp2besa pmg format
	    if ~isempty(TmpTmp)
		    [ChanName,Count1]=fscanf(PmgFid,'%s',1);
			TmpTmp=findstr(ChanName,'''');
		    ChanName=ChanName(TmpTmp(1)+2:TmpTmp(2)-1);
		elseif strcmp(TmpStr(1),'A')
		    ChanName=TmpStr(2:length(TmpStr));
		else
		    ChanName=[int2str(SensorNChan)];
			fseek(PmgFid,TellTmp,'bof');
		end
	    if SensorNChan==1
		    SensorNames=ChanName;
		else
		    SensorNames=char(SensorNames,ChanName);
		end
	    [Tmp((SensorNChan-1).*6+1:SensorNChan.*6),Count1]=fscanf(PmgFid,'%g',6);
	end
    fclose(PmgFid);
    SensorPosNormMat=reshape(Tmp,6,SensorNChan)';
end
Cot=[0 0 0];
if ReadCotStatus
	CotFilePath=[PmgFilePath(1:length(PmgFilePath)-3),'cot'];
	ExCotFilePath=exist(CotFilePath);
	if ExCotFilePath~=2	% file not found
		Message=char(Message,'Sorry, but the ".cot" default file:');
		Message=char(Message,CotFilePath);
		Message=char(Message,'does not exist !');
		Message=char(Message,'');
		Message=char(Message,'Thus,  it is not possible to subtract the center');
		Message=char(Message,'of the modelled sphere from the sensor positions !');
		Message=char(Message,'');
		Message=char(Message,'Use [0 0 0] as center of sphere !');
    	Message=char(Message,'');
	else
		Message=char(Message,'Read center of sphere from file:');
		Message=char(Message,CotFilePath);
		Message=char(Message,'');
		CotFid=fopen(CotFilePath,'r','b');
		CotString=fscanf(CotFid,'%s');
		CotTmpVec=findstr(CotString,',');
		if length(CotTmpVec)~=2; 
       	 	frewind(CotFid);
        	Cot=fscanf(CotFid,'%g',3);
        	fclose(CotFid);
        	if length(Cot)~=3
            	BadCotFormatStatus=1; 
			else
				Cot=Cot';
			end
		else 
			Cot(1)=str2num(CotString(1:CotTmpVec(1)-1));
			Cot(2)=str2num(CotString(CotTmpVec(1)+1:CotTmpVec(2)-1));
			Cot(3)=str2num(CotString(CotTmpVec(2)+1:length(CotString)));
			fclose(CotFid);
			if length(Cot)~=3; 
				BadCotFormatStatus=1; 
			end
		end
		Message=char(Message,'Use:');
		Message=char(Message,[num2str(Cot.*1000),' [mm]']);
		Message=char(Message,'as center of sphere !');
		Message=char(Message,'');
		Message=char(Message,'');
	end
end
FiduMat=zeros(7,3);
SfpMat=[];
if ReadSfpStatus
	%======================Read Sfp file========================
	SfpFilePath=[PmgFilePath(1:length(PmgFilePath)-3),'sfp'];
	ExSfpFilePath=exist(SfpFilePath);
	if ExSfpFilePath~=2	% file not found
		Message=char(Message,'Sorry, but the ".sfp" default file:');
		Message=char(Message,SfpFilePath);
		Message=char(Message,'does not exist !');
		Message=char(Message,'');
		Message=char(Message,'Set FiduMat=zeros(7,3)');
		Message=char(Message,''); 
	else
		Message=char(Message,'Read fids and surface points from file:');
		Message=char(Message,SfpFilePath);
		Message=char(Message,''); 
		Message=char(Message,'FiduMat [mm]:');
		Message=char(Message,''); 
		SfpFid=fopen(SfpFilePath,'r','b');
		LineInd=0;
		FiduInd=0;
		SfpInd=0;
		while 1
			LineInd=LineInd+1;
			tline=fgetl(SfpFid);
			if ~ischar(tline); break; end
			if isempty(findstr(tline,'urf'))
				FiduInd=FiduInd+1; 
				disp(tline);  
				if FiduInd==1
					FiduMat=zeros(1,3);
				else
					FiduMatNew=zeros(FiduInd,3);
					FiduMatNew(1:FiduInd-1,:)=FiduMat;
					FiduMat=FiduMatNew;
				end
				StrInd=0; 
				[Chopped,Remainder]=strtok(tline); 
				if ~isempty(str2num(Chopped))       %New version: names first ; old version: names last
					Remainder=tline;
				end
				while 1  
					StrInd=StrInd+1; 
					[Chopped,Remainder]=strtok(Remainder);       
					if ~ischar(Remainder) | StrInd>3; 
                        break; 
                    end 
					if ~isempty(str2num(Chopped))
						FiduMat(FiduInd,StrInd)=str2num(Chopped);
					end
				end
			else
				SfpInd=SfpInd+1;
				if SfpInd==1
					SfpMat=zeros(1,3);
				else
					SfpMatNew=zeros(SfpInd,3);
					SfpMatNew(1:SfpInd-1,:)=SfpMat;
					SfpMat=SfpMatNew;
				end
				StrInd=0; 
				[Chopped,Remainder]=strtok(tline);
				while 1  
					StrInd=StrInd+1;
					[Chopped,Remainder]=strtok(Remainder); 
					if ~ischar(Remainder) | StrInd>3; 
                        break; 
                    end 
					if ~isempty(str2num(Chopped))
						SfpMat(SfpInd,StrInd)=str2num(Chopped);
					end
				end
			end
		end
		fclose(SfpFid);
		Message=char(Message,num2str(FiduMat.*1000)); 
		Message=char(Message,''); 
		Message=char(Message,''); 
		Message=char(Message,['Number of surface points: ',int2str(SfpInd)])
		Message=char(Message,''); 
		Message=char(Message,''); 
	end
end
hmsgbox=msgbox(Message,'Info','help'); 
if CloseMsgBoxStatus
	hChildMsgbox=get(hmsgbox,'Children');
	set(hChildMsgbox(length(hChildMsgbox)),'Visible','off');
	pause(2)
	close(hmsgbox)
else
	pause(.001);	
end
return;
