function [SensorPosMat,SensorNames,FidPosMat,FidNames]=ReadSfpFile(FilePath,CloseMsgBoxStatus)
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      

if nargin<2; CloseMsgBoxStatus=0; end
if nargin<1; FilePath=[]; end

[DefFilePath] = SetDefPath('r','*.sfp')
[File,Path,FilePath]=ReadFilePath(FilePath,DefFilePath,'Please choose a sfp file:');
if File==0; return; end
SetDefPath('w',Path);
[Fid,ErrorMessage]=fopen(FilePath,'r','b');
EtIndVec=[]; FidIndVec=[];SensorIndVec=[];FidPosMat=[];SensorPosMat=[];
if Fid==-1; 
	Message=char('');
    Message=char(Message,'Can not read sensor configuration from file:');
    Message=char(Message,FilePath);
    Message=char(Message,'');
    Message=char(Message,'Error message:');
    Message=char(Message,ErrorMessage);
    Message=char(Message,'');
    Message=char(Message,'');
    SensorPosNormMat=[];
else
	Message=char('');
    Message=char(Message,'Read sensor configuration from file:');
    Message=char(Message,FilePath);
    Message=char(Message,'');
    Message=char(Message,'');
    Count1=1; SensorNChan=0;	
	LineInd=0;Ind=0;
	while 1
		LineInd=LineInd+1;
		tline=fgetl(Fid);
		if ~ischar(tline); 
			break;
		end
		disp(tline)
		Ind=Ind+1;
		StrInd=0; 
		[Chopped,Remainder]=strtok(tline); 
		Chopped=deblank(Chopped)
		if ~isempty(findstr(lower(Chopped),'fid')) | ...
			~isempty(findstr(lower(Chopped),'nas')) | ...
			~isempty(findstr(lower(Chopped),'ini')) | ...
			strcmp(lower(Chopped),'cz')| ...
			~isempty(findstr(lower(Chopped),'ear')),
			FidIndVec=[FidIndVec,Ind];
		elseif ~isempty(findstr(lower(Chopped),'eth')) | ...
			~isempty(findstr(lower(Chopped),'etv')) 
			EtIndVec=[EtIndVec,Ind];
		else
			SensorIndVec=[SensorIndVec,Ind];
		end
		if Ind==1
			SensorPosMat=zeros(1,3);
			SensorNames=char(Chopped);
		else
			SensorPosMatNew=zeros(Ind,3);
			SensorPosMatNew(1:Ind-1,:)=SensorPosMat;
			SensorPosMat=SensorPosMatNew;
			SensorNames=char(SensorNames,Chopped);
		end
		while 1  
			StrInd=StrInd+1;
			[Chopped,Remainder]=strtok(Remainder);     
			if ~ischar(Remainder) | StrInd>3
				break; 
			end 
			if ~isempty(str2num(Chopped))
				SensorPosMat(Ind,StrInd)=str2num(Chopped);
			end
		end
	end
    fclose(Fid);
	if ~isempty(FidIndVec)	
		FidPosMat=SensorPosMat(FidIndVec,:);
		FidNames=SensorNames(FidIndVec,:);
	end
	if ~isempty(SensorIndVec)
		SensorPosMat=SensorPosMat(SensorIndVec,:);
		SensorNames=SensorNames(SensorIndVec,:);
	end
end
return
