function [Tmp1,Str1,Str2] = ReadVPM(FilePath)
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
%==================================================================
%
%	ReadVPM.m
%
%	Markus Junghoefer, 2000
%
%
%	
%	Function definition
%==================================================================
if nargin<1; FilePath=[]; end

[File,Path]=uigetfile('*.*','Open VPM file: ');
FilePath=[Path,File];
[FidIn]=fopen(FilePath,'r','b');
[FidOut]=fopen([FilePath,'.impjmp'],'w','b');

if FidIn==-1 | FidOut==-1; error('Bad file identifier in ReadVPM.m'); end
NSess=2;
NKind=1;
Tmp1=zeros(NSess,NKind,24);
Tmp2=zeros(NSess,NKind,2000);
Tmp3=zeros(NSess,NKind,2000);
% 
% %Write data
% TmpString=          ['Val01; Val02;  Val03;  Val04; Val05; Val06; Val07; Val08; Val09; Val10; '];
% TmpString=[TmpString,'Val11; Val12;  Val13;  Val14; Val15; Val16; Val17; Val18; Val19; Val20; '];
% TmpString=[TmpString,'Val21; Val22;  Val23;  Val24; '];
% TmpString=[TmpString,'Str1; Str2;'];
% fprintf(FidOut,TmpString);
% fprintf(FidOut,'%g\t',Tmp1(SessInd,KindInd));
% fprintf(FidOut,'\t');
% fprintf(FidOut,TmpStr1);
% fprintf(FidOut,'\t');
% fprintf(FidOut,TmpStr2);
% fprintf(FidOut,'\t');

for SessInd=1:NSess
	for KindInd=1:NKind
		Tmp1(SessInd,KindInd,1)=fscanf(FidIn,'%g',1);
		TmpStr1=fscanf(FidIn,'%s',1);
		if SessInd==1 & KindInd==1
			Str1=char(TmpStr1);
		else
			Str1=char(Str1,TmpStr1);
		end
		Tmp1(SessInd,KindInd,2:13)=fscanf(FidIn,'%g',12);
		TmpStr2=fscanf(FidIn,'%s',1);
		if SessInd==1 & KindInd==1
			Str2=char(TmpStr2);
		else
			Str2=char(Str2,TmpStr2);
		end
		if KindInd==1
			Tmp1(SessInd,KindInd,14:18)=fscanf(FidIn,'%g',5);
		else
			Tmp1(SessInd,KindInd,14:19)=fscanf(FidIn,'%g',6);
		end
		Tmp1(SessInd,KindInd,20:24)=fscanf(FidIn,'%g',5);
		NTrials=Tmp1(SessInd,KindInd,16);
		Tmp=fscanf(FidIn,'%g',NTrials*2);
		Tmp=reshape(Tmp,2,NTrials)';
		Tmp2(SessInd,KindInd,1:NTrials)=Tmp(:,1);
		Tmp3(SessInd,KindInd,1:NTrials)=Tmp(:,2);	
	end
end
fclose(FidIn);
for SessInd=1:NSess
	for KindInd=1:NKind
		for TrialInd=1:NTrials
			fprintf(FidOut,'%g\t',Tmp2(SessInd,KindInd,TrialInd));
% 			fprintf(FidOut,'%g\t',Tmp3(SessInd,KindInd,TrialInd));
		end
		fprintf(FidOut,'\n');
	end
end
fclose(FidOut);
return;
