function [DataMat,FilePath,SizeDataMat,NDim,Version,SampRate,AvgRef,StartF0,EndF0,DeltaF0,NTap,SigmaM,EegMegStatus,NChanExtra,AmpPhaseStatus,NTrials]=
ReadWaveletData(FilePath,Format,DefDataFilePath,DialogTitle)
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
%=========================================================================
%
%	ReadWaveletData.m
%
%	Markus Junghoefer	[2000]
%
%
%	
%	Function definition
% 
% 
%================================================================================
if nargin<4;DialogTitle=[];end;
if nargin<3;DefDataFilePath=[];end;
if nargin<2;Format='float32';end;
if nargin<1;FilePath=[];end;

if isempty(DialogTitle)
	DialogTitle='Read Wavelet data from file:';
end
if isempty(Format)
	Format='float32';
end
[File,Path,FilePath]=ReadFilePath(FilePath,DefDataFilePath,DialogTitle);
if File==0; DataMat=[]; FilePath=[]; SizeDataMat=0; NDim=0; Version=[]; return; end
DefDataFilePath=SetDefPath(2,Path);
fprintf('Read Wavelet data from file...\n\n');
disp(FilePath)
fid=fopen(FilePath,'r','b');
Version=fread(fid,1,Format);
SampRate=fread(fid,1,Format);
AvgRef=fread(fid,1,Format);
StartF0=fread(fid,1,Format);
EndF0=fread(fid,1,Format);
DeltaF0=fread(fid,1,Format);
NTap=fread(fid,1,Format);
SigmaM=fread(fid,1,Format);
NDim=fread(fid,1,Format);
OldFormat=1;
if Version==1
	EegMegStatus=0
	NChanExtra=0
	AmpPhaseStatus=0
elseif Version>1
	EegMegStatus=fread(fid,1,Format);
	NChanExtra=fread(fid,1,Format);
	AmpPhaseStatus=fread(fid,1,Format);
end
if Version>2
   	NTrials=fread(fid,1,Format);
else
    NTrials=1;
end
SizeDataMat=fread(fid,NDim,Format);
if size(SizeDataMat,1)~=1
	SizeDataMat=SizeDataMat'
end
[Data,Count]=fread(fid,Format);
if prod(SizeDataMat)~=Count
	SizeDataMat=SizeDataMat
	Count=Count
	error('prod(SizeDataMat)~=Count in ReadWaveletData')
end
DataMat=reshape(Data,SizeDataMat);
fclose(fid);	
fprintf(1,'\n\n')
fprintf('End reading data from file...\n\n');	
fprintf(1,'\n\n')
fprintf(1,'Data size:  '); 
for i=1:NDim-1
	fprintf(1,'%g x ',SizeDataMat(i)); 
end
fprintf(1,'%g \n\n',SizeDataMat(NDim)); 
return;
