%==================================================================
%
%	Save2Bem.m
%
%	Markus Junghoefer	[1996]
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
%
%
%	
%	Function definition

	function [SaveFilePath]=Save2Bem(DataMat,TriMat,SaveFilePath,chSaveDataMat,...
	BemKind,DataFormat,String,Precision,InfoDataMatSize,InfoDataMatFile,DefFileName)
	
%=================================================================
if nargin<11;DefFileName='Untitled';end;
if nargin<10;InfoDataMatFile=1;end;
if nargin<9;InfoDataMatSize=1;end;
if nargin<8;Precision=[];end;
if nargin<7;String=[];end;
if nargin<6;DataFormat='Ascii';end;
if nargin<5;BemKind='Matrix';end;
if nargin<4;chSaveDataMat=[];end;
if nargin<3;SaveFilePath=[];end;
if nargin<2;TriMat=[];end;
if nargin<1;DataMat=[];end;

if ~chSaveDataMat; return; end;
if isempty(DataFormat); DataFormat=['Ascii']; end
if isempty(InfoDataMatFile); InfoDataMatFile=1; end
if isempty(InfoDataMatSize); InfoDataMatSize=1; end
if isempty(Precision); Precision=5; end
if strcmp(DataFormat,'ascii'); DataFormat=['Ascii']; end
if strcmp(DataFormat,'asci');  DataFormat=['Ascii']; end
if strcmp(DataFormat,'Asci');  DataFormat=['Ascii']; end 
if strcmp(BemKind,'point');   BemKind=['Point']; end
if strcmp(BemKind,'matrix');  BemKind=['Matrix']; end
if strcmp(BemKind,'triangle');BemKind=['Triangle']; end
if strcmp(BemKind,'aelectrode');BemKind=['AElectrode']; end
if strcmp(BemKind,'belectrode');BemKind=['BElectrode']; end

fprintf('\n');
clc;
if isempty(String)
	[chSaveDataMat]=IfEmptyInputBo(['Do you want to save the DataMat Y/N ?'],[],chSaveDataMat,1);
else
	[chSaveDataMat]=IfEmptyInputBo(String,['Do you want to save this DataMat Y/N ?'],chSaveDataMat,1);
end
if ~chSaveDataMat
	return;
end

if isempty(SaveFilePath)
	[SaveFile,SavePath,SaveFilePath]=WriteFilePath(DefFileName,'Choose a file name:');
	if SaveFile==0; SaveFilePath=[]; return; end
end

[m,n]=size(DataMat);
if ~isempty(TriMat); 
	[p,q]=size(TriMat); 
else
	if strcmp(BemKind,'Triangle'); error('No triangle bem data'); end
end

if strcmp(BemKind,'AElectrode')	
	if m==1; DataMat=DataMat'; m=n; n=1; end
	if m==2; DataMat=DataMat'; m=n; n=2; end
	if n==1
		DataMatTmp=zeros(m,2);
		DataMatTmp(:,1)=[1:m]';
		DataMatTmp(:,2)=DataMat;
		DataMat=[]; DataMat=DataMatTmp; DataMatTmp=[]; n=2;
	elseif n==2
		if DataMat(:,1)~=[1:m]; error('Bad bem electrode format !!!'); end
	else
		error('Bad bem a type electrode format !!!')
	end
	if InfoDataMatSize; 
		fprintf(1,'The bem a type electrode matrix to save contains %g electrodes.\n\n',m); pause(.5); 
	end
elseif strcmp(BemKind,'BElectrode')	
	if m==3; DataMat=DataMat'; m=n; n=3; end
	if n~=3
		error('Bad bem b type electrode format !!!')
	end
	if InfoDataMatSize; 
		fprintf(1,'The bem b type electrode matrix to save contains %g electrodes.\n\n',m); pause(.5); 
	end
elseif strcmp(BemKind,'Point') 
	if n==3
		DataMatTmp=zeros(m,4); 
		DataMatTmp(:,2:4)=DataMat;
		DataMatTmp(:,1)=[1:m]';
		DataMat=[]; DataMat=DataMatTmp; DataMatTmp=[]; n=4;
	end
	if n~=4
		error('Bad bem point format !!!')
	end	
	if InfoDataMatSize; 
		fprintf(1,'The bem point matrix to save contains %g points.\n\n',m); pause(.5); 
	end
elseif strcmp(BemKind,'Triangle') 
	if n==3
		DataMatTmp=zeros(m,4); 
		DataMatTmp(:,2:4)=DataMat;
		DataMatTmp(:,1)=[1:m]';
		DataMat=[]; DataMat=DataMatTmp; DataMatTmp=[]; n=4;
	end
	if n~=4
		error('Bad bem point format !!!')
	end	
	if InfoDataMatSize; 
		fprintf(1,'The bem point matrix to save contains %g points.\n\n',m); pause(.5); 
	end
	if q==3
		TriMatTmp=zeros(p,4); 
		TriMatTmp(:,2:4)=TriMat;
		TriMatTmp(:,1)=[1:p]';
		TriMat=[]; TriMat=TriMatTmp; TriMatTmp=[]; q=4;
	end
	if q~=4
		error('Bad triangle format !!!')
	end
	if InfoDataMatSize; 
		fprintf(1,'The triangle matrix to save contains %g triangles.\n\n',p); pause(.5); 
	end
elseif strcmp(BemKind,'Matrix') 
	if InfoDataMatSize; 
		fprintf(1,'The matrix to save contains %g rows and %g columns.\n\n',m,n); pause(.5); 
	end
else
	error('Unknown bem format !!!')
end

fid=fopen(SaveFilePath,'w','b');

if InfoDataMatFile
	
	fprintf('\n');
	if ~InfoDataMatSize & ~InfoDataMatFile; clc; end
	fprintf('Start writing DataMat to file...\n\n');
	disp(SaveFilePath);
    fprintf('\n\n');
end

if strcmp(DataFormat,'Ascii')	
	if ~strcmp(BemKind,'BElectrode') 
		MaxMaxAbs=max(max(abs(DataMat)));
		Acc1=floor(log10(m))+1;
		Acc2=floor(log10(MaxMaxAbs))+1;
	else
		MaxMaxAbs1=max(abs(DataMat(:,1)));
		MaxMaxAbs2=max(max(abs(DataMat(:,2:3))));
		Acc1=floor(log10(MaxMaxAbs1))+1;
		Acc2=floor(log10(MaxMaxAbs2))+1;
	end
	if isempty(Precision)
		[Precision]=IfEmptyInputValInt(['Please insert the decimal places:'],[],[],3,1,10,1);
	end
	if strcmp(BemKind,'AElectrode') | strcmp(BemKind,'BElectrode')| strcmp(BemKind,'Point') | strcmp(BemKind,'Triangle')
		fprintf(fid,'%g\n',m);
	elseif strcmp(BemKind,'Matrix')
		fprintf(fid,'%g\t',m); fprintf(fid,'%g\n',n);
	else
		error('Unknown bem format');
	end
else
	if strcmp(BemKind,'AElectrode') | strcmp(BemKind,'BElectrode')  | strcmp(BemKind,'Point') | strcmp(BemKind,'Triangle')
		fwrite(fid,n,DataFormat);
	elseif strcmp(BemKind,'Matrix')
		fwrite(fid,[m n],DataFormat);
	else
		error('Unknown bem format');
	end
end
if strcmp(DataFormat,'Ascii')	
	if strcmp(BemKind,'Matrix') 
		for MInd=1:m
			if n>1
				for NInd=1:n-1
					fprintf(fid,['%' num2str(Acc2) '.' num2str(Precision) 'f\t'],DataMat(MInd,NInd));
				end
			end
			fprintf(fid,['%' num2str(Acc2) '.' num2str(Precision) 'f\n'],DataMat(MInd,n));
		end	
	else
		for MInd=1:m
			fprintf(fid,['%' num2str(Acc1) '.0f\t'],DataMat(MInd,1));
			if n>1
				for NInd=2:n-1
					fprintf(fid,['%' num2str(Acc2) '.' num2str(Precision) 'f\t'],DataMat(MInd,NInd));
				end
			end
			fprintf(fid,['%' num2str(Acc2) '.' num2str(Precision) 'f\n'],DataMat(MInd,n));
		end
	end
else
	fwrite(fid,DataMat,DataFormat);
end

	
if strcmp(BemKind,'Triangle')	
	if strcmp(DataFormat,'Ascii')	
		fprintf(fid,'%g\n',p);
		for PInd=1:p
			fprintf(fid,['%' num2str(Acc1) '.0f\t'],TriMat(PInd,1));
			for QInd=2:q-1
				fprintf(fid,['%' num2str(Acc2) '.' num2str(Precision) 'f\t'],TriMat(PInd,QInd));
			end
			fprintf(fid,['%' num2str(Acc2) '.' num2str(Precision) 'f\n'],TriMat(PInd,q));
		end
	else
		fwrite(fid,p,DataFormat);
		fwrite(fid,DataMat,DataFormat);
	end
end
fprintf('End writing DataMat to file...\n\n');	
fclose(fid);	
	
return;
