%==================================================================
%
%	SaveAsciiBesa
%
%	Markus Junghoefer	[1998]
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
%
%
%	Function definition
%
	
	function[FilePath]=SaveAsciiBesa(DataMat,TSB,DI,SB,SC,FilePath);

%
%
%=================================================================
if nargin<6; FilePath=[]; end
if nargin<5; return; end

if isempty(FilePath)
	[File,Path]=uiputfile('*.avr*','Choose Besa Ascii file:');
	FilePath=[Path,File];
end
[NChan,NPoints]=size(DataMat);
fid=fopen(FilePath,'w','b');
clc;
fprintf(fid,'Npts= %d  TSB= %f  DI= %f  SB= %f  SC= %f \n',NPoints,TSB,DI,SB,SC);
for ChanInd=1:NChan
	fprintf(fid,'%g\t',DataMat(ChanInd,1:NPoints-1));
	fprintf(fid,'%g\n',DataMat(ChanInd,NPoints));
end
fclose(fid);
return;
