%==================================================================
%
%	SaveEGISAvgFile.m
%
%	Markus Junghoefer	[1996]
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
%
%
%	Function definition
%
%
	function[SaveFile,SavePath,SaveFilePath]=SaveEGISAvgFile(SaveFilePath,OrigFilePath,...
	AvgMat, AvgCell, AvgLCellHdr, AvgCellID, AvgCellName, AvgNTrials, AvgNPoints, AvgSampRate, AvgNChan, ChanWeightVec)
%
%==================================================================
if nargin<12; ChanWeightVec=[]; end;
if nargin<11; AvgNChan=[]; end;
if nargin<10; AvgSampRate=[]; end;
if nargin<9; AvgNPoints=[]; end;
if nargin<8; AvgNTrials=[]; end;
if nargin<7; AvgCellName=[]; end;
if nargin<6; AvgCellID=[]; end;
if nargin<5; AvgLCellHdr=[]; end;
if nargin<4; AvgCell=[]; fprintf('Missing AvgCell in SaveEGISAvgFile !!'); return; end;


if isempty(AvgLCellHdr); 
	global LCellHdr; 
	if ~isempty(LCellHdr)
		AvgLCellHdr=LCellHdr(AvgCell);
	else
		fprintf('Missing AvgLCellHdr and  LCellHdr in SaveEGISAvgFile !!'); return;
	end
end

if isempty(AvgCellID); 
	global CellID; 
	if ~isempty(CellID)
		AvgCellID=CellID(AvgCell);
	else
		fprintf('Missing AvgCellID and  CellID in SaveEGISAvgFile !!'); return;
	end
end

if isempty(AvgCellName); 
	global CellName; 
	if ~isempty(CellName)
		AvgCellName=CellName(:,AvgCell);
	else
		fprintf('Missing AvgCellName and  CellName in SaveEGISAvgFile !!'); return;
	end
end

if isempty(AvgNTrials); 
	global NTrials; 
	if ~isempty(NTrials)
		AvgNTrials=NTrials(AvgCell);
	else
		fprintf('Missing AvgNTrials and  NTrials in SaveEGISAvgFile !!'); return;
	end
end

if isempty(AvgNPoints); 
	global NPoints; 
	if ~isempty(NPoints)
		AvgNPoints=NPoints(AvgCell);
	else
		fprintf('Missing AvgNPoints and  NPoints in SaveEGISAvgFile !!'); return;
	end
end

if isempty(AvgSampRate); 
	global SampRate; 
	if ~isempty(SampRate)
		AvgSampRate=SampRate(AvgCell);
	else
		fprintf('Missing AvgSampRate and  SampRate in SaveEGISAvgFile !!'); return;
	end
end

if isempty(AvgNChan); 
	global NChan; 
	if ~isempty(NChan)
		AvgNChan=NChan+1;
	else
		fprintf('Missing AvgNChan and  NChan in SaveEGISAvgFile !!'); return;
	end
end
%=========================================================================================


if isempty(OrigFilePath)
	[OrigFile,OrigPath,OrigFilePath]=ReadFilePath([],['Please insert the original data file:']);
else
	[OrigFile,OrigPath]=SepFilePath(OrigFilePath);
end
	
if isempty(SaveFilePath)
	[SaveFile,SavePath,SaveFilePath]=WriteFilePath(['Save data to file:']);
else
	[SaveFile,SavePath]=SepFilePath(SaveFilePath);
end



global BytOrd
global HdrVer
global AvgLData
global ExptNam
global RunDate
global RunTime
global SubjID
global Handed
global Sex
global Age
global ExperID
global EdVer
global CalFlag
global LText
global LComment
global LPad
global BrdGain
global LCellHdr
global ChanZero
global ChanGain

if isempty(AvgMat)
	[AvgMat,Header,ReadFile,ReadPath,ReadFilePath,ChanWeightVec] = ...
	ReadEGISAvgFile(OrigFilePath);
	[AvgNChan,AvgNPoints]=size(AvgMat);
end


LengthOrigFilePath=length(OrigFilePath);
AvgLData=AvgNPoints*AvgNChan;

fprintf('\n')
clc;
fprintf('Start writing averaged data to file...\n\n');
fprintf(SaveFilePath);
fprintf('\n\n');
fid=fopen(SaveFilePath,'w');

fwrite(fid,BytOrd,'uint8');
fwrite(fid,HdrVer,'int16');
tell=ftell(fid);
AvgLHeader=1;
fwrite(fid,AvgLHeader,'int16');
fwrite(fid,AvgLData,'int32');
fwrite(fid,LengthOrigFilePath,'int16');
fwrite(fid,OrigFilePath,'uchar');
fwrite(fid,ExptNam,'uchar');
fwrite(fid,RunDate,'int16');
fwrite(fid,RunTime,'int16');
fwrite(fid,SubjID,'int16');
fwrite(fid,Handed,'int16');
fwrite(fid,Sex,'int16');
fwrite(fid,Age,'int16');
fwrite(fid,ExperID,'int16');
fwrite(fid,EdVer,'int16');
fwrite(fid,CalFlag,'int16');
fwrite(fid,AvgCell,'int16');
fwrite(fid,AvgNChan,'int16');
fwrite(fid,LText,'int16');
fwrite(fid,LComment,'int16');
fwrite(fid,LPad,'int16');
fwrite(fid,BrdGain,'int16');
fwrite(fid,AvgLCellHdr,'int16');

fwrite(fid,ChanZero,'int16');
fwrite(fid,ChanGain,'int16');

fwrite(fid,AvgCellID,'int16');
fwrite(fid,AvgCellName,'char');
fwrite(fid,AvgNTrials,'int16');
fwrite(fid,AvgNPoints,'int16');
fwrite(fid,AvgSampRate,'int16');
AvgLHeader=ftell(fid);
fseek(fid,tell,-1);
fwrite(fid,AvgLHeader,'int16');
fseek(fid,AvgLHeader,-1);

fwrite(fid,AvgMat,'float32');
if ~isempty(ChanWeightVec)
	fwrite(fid,length(ChanWeightVec),'int16');
	fwrite(fid,ChanWeightVec,'float32');
else
	fwrite(fid,0,'int16');
end

fprintf('End writing EGIS averaged data to file...\n');
pause(1);

fclose(fid);
return;
