function [DefFilePath,DefPath] = SetDefPath(RWStatus,PathOrFileExt,FileStr);
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
%==================================================================
%
%	SetDefPath.m
%
%	Markus Junghoefer	[1999]
%
%
%	
% 	Function definition
% 
% 	function [DefFilePath] = SetDefPath(RWStatus,PathOrFileExt,FileStr);
% 			  
% 	RWStatus==0  | Clear  | clear;	RWStatus==1  | R  | r  => Read; 	RWStatus==2  | W  | w => Write	;
%
%=================================================================
if nargin<3;FileStr=[];end
if nargin<2;PathOrFileExt=[];end
if nargin<1;RWStatus='r'; end
if isempty(RWStatus); return; end

if strcmp(RWStatus,'r') | strcmp(RWStatus,'R') | strcmp(RWStatus,'read') | strcmp(RWStatus,'Read')
	RWStatus=1;
elseif strcmp(RWStatus,'w') | strcmp(RWStatus,'W') | strcmp(RWStatus,'write') | strcmp(RWStatus,'Write')
	RWStatus=2;
elseif strcmp(RWStatus,'Clear') | strcmp(RWStatus,'clear')
	RWStatus=0;
end
DefPath=0;
DefFile=['DefaultPath.' computer];
%=================================================================
[nouse1,Plot2dFolder]=SepFilePath(which('Plot2d.m'));
DefFilePath = [Plot2dFolder,'Plot2dUtil',filesep,'ViewDefault',filesep,DefFile];
fid = fopen(DefFilePath,'r','b');
if fid==-1
    fid = fopen(DefFilePath,'wt');
    fprintf(fid,pwd);     
end
fclose(fid);  
%===========================================================
if RWStatus==0	 %Clear;
   	if ~strcmp(DefFilePath,'..') & ~strcmp(DefFilePath,'');
		DefFilePathFid=fopen(DefFilePath,'w','b');
		if DefFilePathFid~=-1
			clc;
			fprintf(DefFilePathFid,'%s','');
			fclose(DefFilePathFid);
			fprintf(1,'Clear default path:\n\n');
			disp(DefFilePath); 
			fprintf('\n\n');
			return;
		else
			fprintf(1,'Can not clear:\n\n')
			fprintf(1,['DefaultPath.' computer]); fprintf('\n\n');
			fprintf(1,'File can not be opened.\n\n')
			DefFilePath=[];
			return;
		end
	else
		clc;
		fprintf(1,'Can not clear:\n\n')
		fprintf(1,['DefaultPath.' computer]); fprintf('\n\n');
		fprintf(1,'Can not find this file in Matlab search path.')
		DefFilePath=[];
		return;
	end
end
%===========================================================
if RWStatus==2; %Write;
   	if ~strcmp(DefFilePath,'..') & ~strcmp(DefFilePath,'');
		DefFilePathFid=fopen(DefFilePath,'w','b');
		if DefFilePathFid~=-1
			clc;
			if ~isempty(PathOrFileExt)
				fprintf(DefFilePathFid,'%s',PathOrFileExt);
				fclose(DefFilePathFid);
				fprintf(1,'Write default path:\n\n')
				disp(PathOrFileExt); fprintf('\n\n');
				fprintf(1,'to "path default file":\n\n')
				disp(DefFilePath); 
				fprintf('\n\n');
				return;
			end
		else
			clc;
			fprintf(1,'Can not write:\n\n')
			fprintf(1,PathOrFileExt); fprintf(1,'\n\n');
			fprintf(1,'to "path default file" since the file:\n\n')
			fprintf(1,['DefaultPath.' computer]); fprintf('\n\n');
			fprintf(1,'can not be opened.')
			DefFilePath=[];
			return;
		end
	end
	clc;
	fprintf(1,'Can not write:\n\n')
	disp(PathOrFileExt); fprintf('\n\n');
	fprintf(1,'to "path default file" since the file:\n\n')
	fprintf(1,['DefaultPath.' computer]); fprintf('\n\n');
	fprintf(1,'does not exist.')
	DefFilePath=[];
	return;
end
%===========================================================
if ~isempty(PathOrFileExt) & strcmp(computer,'PCWIN')
 	PathOrFileExt=[filesep,PathOrFileExt];
end
if ~strcmp(DefFilePath,'..') & ~strcmp(DefFilePath,'');
       	DefFilePathFid=fopen(DefFilePath,'r','b');
       	if DefFilePathFid~=-1
        	DefPath=fscanf(DefFilePathFid,'%s',1);
           	fclose(DefFilePathFid);
           	IndSepPathStr=findstr(DefPath,filesep);
		if strcmp(computer,'MAC2')
			NSepStr=length(IndSepPathStr)-1;
		else 
			NSepStr=length(IndSepPathStr);
           	end;
           	ExistDefPath=0;
            	while ExistDefPath~=7 & NSepStr>0  
            		ExistDefPath=exist(DefPath);
            		if ExistDefPath==7 %Dir
				DefFilePath=[DefPath,PathOrFileExt];
              		else
				DefPath=DefPath(1:IndSepPathStr(NSepStr));
				NSepStr=NSepStr-1;
			end
		end
		if ExistDefPath~=7 & ~isempty(FileStr)
			DefFilePath=which(FileStr);
			if ~strcmp(DefFilePath,'..');
				[DefFile,DefPath]=SepFilePath(DefFilePath);
			end
		end
	end
end
if ~isempty(PathOrFileExt)
	if isempty(DefPath) | DefPath==0
		DefFilePath=which(PathOrFileExt);		
		if strcmp(DefFilePath,'..'); 
			DefFilePath=PathOrFileExt;
		else
			[DefFile,DefPath]=SepFilePath(DefFilePath);
			DefFilePath=[DefPath,PathOrFileExt];
		end         
	else
		if strcmp(DefPath(end),filesep)
            if strcmp(PathOrFileExt(1),filesep)
  			    DefFilePath=[DefPath,PathOrFileExt(2:end)];
            else
                DefFilePath=[DefPath,PathOrFileExt];
            end
		else
            if strcmp(PathOrFileExt(1),filesep)
			    DefFilePath=[DefPath,PathOrFileExt];
            else
                DefFilePath=[DefPath,filesep,PathOrFileExt];
            end
		end
	end
else
	if DefPath==0
		DefFilePath=[pwd,'*'];
	else
		DefFilePath=[DefPath,'*'];
	end
end

%==========================
return;
