function SurfPmgCotSfp(PmgMat,FidMat,SfpMat,RotDegVal,FigName)
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      

if nargin<5; FigName=[]; end
if nargin<4; RotDegVal=0; end
if nargin<3; return; end

hPmgCotFig=figure('Units','normal','NumberTitle','off','Position',[0 0 .8 .92],'Name',['Pmg, Cot, Sfp; ',FigName]);    
for i=1:4
    subplot(2,2,i)
    plot3(PmgMat(:,1),PmgMat(:,2),PmgMat(:,3),'bo')
    hold on
    if size(PmgMat,1)>70
        plot3(PmgMat(71,1),PmgMat(71,2),PmgMat(71,3),'g*')
    end
    plot3(0,0,0,'r*')  %Center of Sphere      
    quiver3(PmgMat(:,1),PmgMat(:,2),PmgMat(:,3),PmgMat(:,4),PmgMat(:,5),PmgMat(:,6),'k');
    if ~isempty(SfpMat)
        plot3(FidMat(1:3,1),FidMat(1:3,2),FidMat(1:3,3),'m*')
    end
    if ~isempty(SfpMat)
        plot3(SfpMat(:,1),SfpMat(:,2),SfpMat(:,3),'k.')
    else
        LSensorPosCart=sqrt(PmgMat(:,1).^2+PmgMat(:,2).^2+PmgMat(:,3).^2)
        HeadRadius=0.09;
        plot3(HeadRadius.*PmgMat(:,1)./LSensorPosCart,HeadRadius.*PmgMat(:,2)./LSensorPosCart,HeadRadius.*PmgMat(:,3)./LSensorPosCart,'bx')
    end
    axis([-.2 .2 -.2 .2 -.1 .2])
    hold off
    xlabel('x- axis')
    ylabel('y- axis')
    zlabel('z- axis')
    if i==1
        view(-90,0)
        title(['Besa System (Add. x-rot.(deg.): ',num2str(RotDegVal),'); Left View'])
    elseif i==2
        view(90,0)
        title(['Besa System (Add. x-rot.(deg.): ',num2str(RotDegVal),'); Right View'])
    elseif i==3
        view(180,0)
        title(['Besa System (Add. x-rot.(deg.): ',num2str(RotDegVal),'); Front View'])
    elseif i==4
        view(0,0)
        title(['Besa System (Add. x-rot.(deg.): ',num2str(RotDegVal),'); Back View'])
    end
end
pause(1)
return;
