%==================================================================
%
%	SwitchGrandBatch
%
%	Markus Junghoefer	[2004]
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
%
%
%	Function definition
%
%   if actual directory is '*Grand*' and directory SubDir('Grand*),filesep,*Batch* exists
%   switch Grand and Batch 
%
%	
function[DefFilePath]=SwitchGrandBatch(DefFilePath,GrandBatchStr,SetDefPathStatus);
%
%
%
%=================================================================
if nargin<2; SetDefPathStatus=1; end
if nargin<2; GrandBatchStr='Grand2Batch'; end
if nargin<1; DefFilePath=[]; return; end

[DefFile,DefPath]=SepFilePath(DefFilePath)
if strcmp(GrandBatchStr,'Grand2Batch')
    GrandBatchStr1='Grand'; GrandBatchStr2='Batch';
elseif strcmp(GrandBatchStr,'Batch2Grand')  
    GrandBatchStr1='Batch'; GrandBatchStr2='Grand';
end
if strcmp(DefPath(end),filesep)
    Tmp=findstr(DefPath(1:end-1),filesep);
else
    Tmp=findstr(DefPath,filesep);
end
if ~isempty(Tmp)
    if ~isempty(findstr(DefPath(Tmp(end)+1:end),GrandBatchStr1))
        D=dir(DefPath(1:Tmp(end)-1));
        i=0;
        while i<length(D)
            i=i+1;
            if ~isempty(findstr(D(i).name,GrandBatchStr2))
                DefPath=[DefPath(1:Tmp(end)-1),filesep,D(i).name];
                if SetDefPathStatus; SetDefPath(1,DefPath); end
                DefFilePath=[DefPath,filesep,DefFile];
                break;
            end
        end 
    end
end
return;