%==================================================================
%
%	XRotation.m
%
%	Markus Junghoefer	[1996]
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
%
%
%	Function definition
%
	function[DataOutCart]=XRotation(DataInCart,Phi,RadStatus);
%
%=================================================================
if nargin<3; RadStatus=0, end
[m,n]=size(DataInCart);
if n==3
	DataInCart=DataInCart';
end
if ~RadStatus
	Phi=Phi./180.*pi;
end
PhiMat=[1 0 0; 0 cos(Phi) -sin(Phi); 0 sin(Phi) cos(Phi)];
DataOutCart=PhiMat*DataInCart;
if n==3
	DataOutCart=DataOutCart';
end
return;
