%==================================================================
%
%	calc_pol_no_base.m
%
%	Markus Junghoefer	[1995]
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
%
%
%
%	Function definition

function [data_out_sphere,e_names_out] = calc_pol_no_base(data_out_sphere,e_names_out)


%=================================================================
[m,n]=size(e_names_out);

clc;
fprintf('Start to insert which positions are really measured electrodes:\n\n\n')
[ch_AllOrSpec]=IfEmptyInputBo(['Do you want to choose special no electrode positions ?'],[],[],1);
if ch_AllOrSpec
	[ch_file]=IfEmptyInputBo(['Do you want to use an existing take_vec file ?'],[],[],1);
	if ch_file	
		data_file=[];
		[data_file,data_path]=uigetfile('*','Get File: TakeVecFile');
		data_file=[data_path,data_file];
		fid=fopen(data_file,'r','b');
		fprintf('Start reading of file:\n');
		fprintf(data_file);
		fprintf('\n\n');
		[take_vec,count]= fread(fid,inf,'float64');
		if length(take_vec)~=m
			error('length(take_vec)~=m in calc_pol_take_vec');
		end
		take_vec=take_vec';
		fprintf('The read in take_vec is:\n\n')
		disp(take_vec)
		pause
	else 
		take_vec=ones(m,1);
		clc;
		for i=1:m
			clc;
			fprintf('\n');
			fprintf(1,'Please insert whether the %g position named:  \n\n',i)
			fprintf(1,e_names_out(i,:))
			fprintf('\n\n')
			[take_vec(i)]=IfEmptyInputVal(['is a measured electrode position  [1]'],['or a base position                [0]:  '],[],1);
		end 
		[ch_SaveInFile]=IfEmptyInputBo(['Do you want to save this take_vec in file ? Y/N'],[],[],1);
		if ch_SaveInFile
			clc;
			data_file=[];
			[data_file,data_path]=uiputfile('*','Put File: TakeVecFile');
			data_file=[data_path,data_file];
			fid=fopen(data_file,'r','b');
			fprintf('Start writing take_vec to file:\n');
			fprintf(data_file);
			fprintf('\n');	
			fid=fopen(data_file,'a','b');
			count = fwrite(fid,take_vec,'float64');
			fclose(fid);
		end
	end
	
	v=find(take_vec);
	data_out_sphere_tmp=data_out_sphere(v,:);
	data_out_sphere=[];
	data_out_sphere=data_out_sphere_tmp;
	clear data_out_sphere_tmp;

	e_names_out_tmp=e_names_out(v,:);
	e_names_out=[];
	e_names_out=e_names_out_tmp;
	clear e_names_out_tmp;
	
	clc;
	fprintf('This are the electrode positions without base positions:\n\n');
	disp(e_names_out);
	pause
end

return;
