%==================================================================
%
%	calc_view_course.m
%
%	Markus Junghoefer	[1995]
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
%
%
%	Function definition
%
	
	function[v_view,ch_view_general,ch_view_special]=calc_view_course(status,v_time);

%
%
%=================================================================


gen_view=[0 0; 180 0; 0 90; 0 -90; -90 0; 90 0; 45 70]; 
v_view=ones(length(v_time),2);
if status==1	
	clc;
	fprintf('Do you want to use for all course pictures the same view    [1]\n');
	fprintf('or do you want to insert special views for special times ?  [2]\n');
	
	ch_view_general=input('Please insert your choice:   [1]');
	if isempty(ch_view_general)
		ch_view_general=1;
	end
	if ch_view_general==1
		clc;
		fprintf('Do you want to look from\n\n')
		fprintf('back    [0, 0]                                              [1]\n')
		fprintf('front   [180, 0]                                            [2]\n')
		fprintf('top     [0, 90]                                             [3]\n')
		fprintf('bottom  [0, -90]                                            [4]\n')
		fprintf('left    [-90, 0]                                            [5]\n')
		fprintf('right   [90, 0]                                             [6]\n')
		fprintf('default [45, 70]                                            [7]\n\n')
		fprintf('or do you want to insert theta and phi by your own?         [8]\n\n')
		ch_view_special_tmp=[];
		ch_view_special_tmp=input('Please insert your choice of view:  [3]');
		if isempty(ch_view_special_tmp)
			ch_view_special_tmp=3;
		end
		if ch_view_special_tmp == 8 
			clc;
			v_view(:,1)=input('Please insert theta of the wished view:  ');
			v_view(:,2)=input('Please insert phi of the wished view:  ');
		else
			v_view(:,1)=gen_view(ch_view_special_tmp,1).*v_view(:,1);
			v_view(:,2)=gen_view(ch_view_special_tmp,2).*v_view(:,2);
		end
		ch_view_special=ch_view_special_tmp.*ones(1,length(v_time));
	else
	v_time
		for i=1:length(v_time)
			clc;
			fprintf(1,'Do you want to look at time point %g from\n\n',v_time(i))
			fprintf('back    [0, 0]                                              [1]\n')
			fprintf('front   [180, 0]                                            [2]\n')
			fprintf('top     [0, 90]                                             [3]\n')
			fprintf('bottom  [0, -90]                                            [4]\n')
			fprintf('left    [-90, 0]                                            [5]\n')
			fprintf('right   [90, 0]                                             [6]\n')
			fprintf('default [45, 70]                                            [7]\n\n')
			fprintf('or do you want to insert theta and phi by your own?         [8]\n\n')
			ch_view_special_tmp=[];
			ch_view_special_tmp=input('Please insert your choice of view:  [3]');
			if isempty(ch_view_special_tmp)
				ch_view_special_tmp=3;
			end
			ch_view_special(i)=ch_view_special_tmp;
			if ch_view_special_tmp == 8 
				clc;
				v_view(i,1)=input('Please insert theta of the wished view:  ');
				v_view(i,2)=input('Please insert phi of the wished view:  ');
			else
				v_view(i,:)=gen_view(ch_view_special_tmp,:);
			end
		end
	end
end
return;
