function [neighbours]=findchanneighbours(EPosSpher,SpherRadius,neighbourspherdist)
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      

global hPlot3dMenuFig hPlot2dMenuFig hGlobalMsgbox ForSensorMat SensorMat View2d3d CutRealBotVal...
    matlabversion calpLeadLocCart ScalpLeadLocSpher ROIIndMat ScalpLeadLocSpherGrad
Tau = neighbourspherdist/180*pi;
debug = 0;
    
hPlot3dList = get(hPlot3dMenuFig,'UserData');
ROIMatSpherRad=[EPosSpher,ones(length(EPosSpher),1)*SpherRadius,ones(length(EPosSpher),1)*Tau];
NROI=size(ROIMatSpherRad,1);
OIStr='ROI';


ROIMatCart=ROIMatSpherRad;
ROIMatCart(:,1:3)=change_sphere_cart([ROIMatSpherRad(:,1),ROIMatSpherRad(:,2)],SpherRadius,1);
ScalpLocCart=ROIMatCart(:,1:3);
ScalpLocSpher=ROIMatSpherRad; 
neighbours = cell(1);
ScalpLeadLocCart=ScalpLocCart;
ScalpLeadLocSpher=ScalpLocSpher;
DiffLoc=ScalpLeadLocCart;
ScalpLeadLocSpherGrad=ScalpLeadLocSpher;
ScalpLeadLocSpherGrad(:,[1,2])=(ScalpLeadLocSpher(:,[1,2])./pi).*180;
MaxNROIIndVec=0;
message={'Finding channelneighbours... '};
infdlg1 = infdlg('T-test restrictions:',message,[],[],[]);

infdlgtext1 = findobj('tag','infdlgtext1');
infdlgtext2 = findobj('tag','infdlgtext2');

for ROIInd=1:NROI
    set(infdlgtext1,'String',[num2str(ROIInd),' of ']);
    set(infdlgtext2,'String',num2str(NROI));
    pause(0.0000001);
    CenterROILoc=ROIMatCart(ROIInd,1:3);
    Tau=ROIMatCart(ROIInd,4);
    MaxDist=sqrt((SpherRadius.*sin(Tau)).^2+(SpherRadius.*(cos(Tau)-1)).^2);
    for Ind=1:length(DiffLoc);
        DiffLoc(Ind,:)=ScalpLeadLocCart(Ind,:)-CenterROILoc;
    end
    ROIIndVec=find(sqrt(sum(DiffLoc'.^2))<MaxDist)
   
   

    NROIIndVec=length(ROIIndVec);
    fprintf('Region of interest # %g ;\n',ROIInd);
    fprintf('Center of region: %g , %g ; (theta, phi);\n',ROIMatSpherRad(ROIInd,1:2));
    fprintf('Extention of region: %g ;\n',ROIMatSpherRad(ROIInd,4));
    fprintf('Number of locations within given region: %g ;\n\n',NROIIndVec);
    fprintf('Cartesian locations:\n\n')
    disp(ScalpLeadLocCart(ROIIndVec,:));
    fprintf('Spherical locations:\n\n')
    disp(180.*ScalpLeadLocSpher(ROIIndVec,1:2)./pi);
    fprintf('\n\n\n\n')
    MaxNROIIndVec=max([MaxNROIIndVec NROIIndVec]);
    neighbours{ROIInd}=ROIIndVec;  
    
    if debug
        if isempty(findobj('tag','ROIfigure'))
            roifigure = figure('name','press return to step through channels:','tag','ROIfigure')
        end
        plot3(ROIMatCart(:,1),ROIMatCart(:,2),ROIMatCart(:,3),'bo')
        hold on
        plot3(ROIMatCart(ROIIndVec,1),ROIMatCart(ROIIndVec,2),ROIMatCart(ROIIndVec,3),'ro');
        hold off
        view(90,0)
        pause
     end
        
        
end

infdlg1 = findobj('tag','infdlg');
close (infdlg1);

if debug
    close (roifigure);
end

return