%==================================================================
%
%	model_nose.m
%
%	Markus Junghoefer	[1995]
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
%
%
%	Function definition
%
	
	function[X_nose,Y_nose,Z_nose]=model_nose(radius);

%
%
%=================================================================

nose_radius=0.5*radius;

[X_nose, Y_nose, Z_nose]=sphere(4);
X_nose=X_nose.*nose_radius;	
Z_nose=Z_nose.*nose_radius;


for i=1:5
	for j=1:5
		if Y_nose(i,j)<0
			Y_nose(i,j)=NaN;
		else
			Y_nose(i,j)=Y_nose(i,j).*nose_radius+radius-nose_radius/2;
		end
		if Z_nose(i,j)<0
			Z_nose(i,j)=NaN;
		else
			Z_nose(i,j)=Z_nose(i,j)-nose_radius;
		end
	end
end
