% Plot the residual variance against regularistation parameter
% for given leadfield and data
% The interval for regularisation parameters must be given in a
% 3*1-vector, e.g. [0.0 0.01 0.1], where the 2nd element is the step size

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      

function regularisation_curve(lfdmat, reg_interval, data, nr_timepoints);  

if nargin==0,
   disp(' regularisation_curve(lfdmat, reg_interval, data); ');
   return;
end;


reg_begin = reg_interval(1);
reg_end = reg_interval(3);
reg_step = reg_interval(2);

[max_rows,max_cols,nr_sets] = size(data);

if nr_sets==1 | nargin==3,
   nr_timepoints(1:nr_sets) = max_cols;
end;


cnt=0;
for regpar = reg_begin:reg_step:reg_end,
   cnt = cnt+1;
   G = pinv_tikh(lfdmat, regpar);
   for i=1:nr_sets,
	   inv = G*data(:,1:nr_timepoints(i),i);
   	variances(i) = mean(res_var(lfdmat, inv, data(:,1:nr_timepoints(i),i)));
   end;
   mean_var(cnt) = mean(variances);
end;


plot(reg_begin:reg_step:reg_end, mean_var);
axis([reg_begin reg_end min(mean_var) max(mean_var)]);
