function [x, r] = when_changes_radius(xyz, tol);
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      

if nargin==1,
	tol = 0;
end;

cnt = 1;
for i=1:length(xyz)-1,
	radius = norm(xyz(:,i));
	if abs(radius-norm(xyz(:,i+1)))>tol,
      		x(cnt) = i;
      		r(cnt) = radius;
		cnt = cnt+1;
		outtxt = sprintf('%f   %d', radius, i);
		disp(outtxt);
	end;
end;

x(cnt) = length(xyz);
r(cnt) = norm(xyz(:,i+1));

outtxt = sprintf('%f   %d', norm(xyz(:,i+1)), i+1);
disp(outtxt);
