global SubInd SubIndStr Base BaseStr MaskStr

%---------------------------------------------------------------
% model(1) Low-Off vs High Off
%---------------------------------------------------------------
clear F1 F2 
Mask=[MaskStr,'*.img']
FolderName=['E:\fMRIData\fMRIDataGiessen\',SubIndStr,'\ValAro09\']
F1=spm_get('Files',FolderName,Mask);
ValAro09RealignFile=spm_get('Files',FolderName,['realignment*.*'])
ValAro09RealignMat=ReadTxtMat(ValAro09RealignFile,[6 406]);
ValAro09RealignMat=ValAro09RealignMat';
if size(ValAro09RealignMat)~=[406,6]
   error('size(ValAro09RealignMat)~=[406,6]')
end
FolderName=['E:\fMRIData\fMRIDataGiessen\',SubIndStr,'\ValAro36\'];
F2=spm_get('Files',FolderName,Mask);
ValAro36RealignFile=spm_get('Files',FolderName,['realignment*.*'])
ValAro36RealignMat=ReadTxtMat(ValAro36RealignFile,[6 406]);
ValAro36RealignMat=ValAro36RealignMat';
if size(ValAro36RealignMat)~=[406,6]
   error('size(ValAro36RealignMat)~=[406,6]')
end
F1
F2
if SubInd==21 | SubInd==23 | SubInd==24  
   F1Tmp=F2;
   F2=F1;
   F1=F1Tmp;
   ValAro36RealignMatTmp=ValAro36RealignMat;
   ValAro09RealignMat=ValAro36RealignMat;
   ValAro36RealignMat=ValAro36RealignMatTmp;
   clear F1Tmp ValAro36RealignMatTmp
   F1
   F2
end

%---------------------------------------------------------------
% batch variables defined here for analysis 'model'
%---------------------------------------------------------------

model(1) = struct( ...
 'types',          4, ...
 'global_effects', {'Scaling'}, ...
 'burst_mode',     0, ...
 'HF_fil',         'specify',  ...
 'HF_cut',         [48 48], ...
 'LF_fil',         'Gaussian', ...
 'LF_cut',         [4], ...
 'int_corr',       'none', ... 
 'now_later',      1, ...
 'stop_writing',   0, ...
 'trial_fcon',     0, ...
 'RT',             3, ...
 'replicated',     0, ...
 'same_time_param',0, ...
 'nsess',          2, ...
 'nscans',         [406 406], ...
 'files',          {{F1 F2}}, ...
 'conditions_nb',  [5 5], ...     
 'conditions',     [1 1], ...
 'regressors_nb',  [6 6], ...
 'regressors',     [1 2], ...
 'parametrics_type', {{'none','none'}}, ...
 'parametrics',    [], ...
 'stochastics_flag',[0 0], ...
 'stochastics',    []);
 
NScanPerBlock=4;

NegHigh=[2 9  13 20 23 30 33 39 42 49 52 59 63 70 72 80 83 89 92 98 ]*NScanPerBlock+Base
NegLow =[4 8  12 19 22 28 34 40 43 50 53 60 65 67 74 79 82 87 95 100]*NScanPerBlock+Base
Neutral=[1 6  11 16 21 26 31 36 41 46 51 56 61 66 71 76 81 86 91 96 ]*NScanPerBlock+Base
PosLow =[5 7  14 17 25 27 35 37 44 47 55 58 64 68 75 78 85 88 94 99 ]*NScanPerBlock+Base
PosHigh=[3 10 15 18 24 29 32 38 45 48 54 57 62 69 73 77 84 90 93 97 ]*NScanPerBlock+Base
%-------------------------------------------

conditions(1) = struct( ...
 'names',   {{'NegHigh','NegLow','Neutral','PosLow','PosHigh'}}, ...
 'onsets',{{NegHigh,NegLow,Neutral,PosLow,PosHigh}}, ...   
 'types',    {{'epochs','epochs','epochs','epochs','epochs'}}, ...  %'types',    {{'events','events','events','events','events'}}, ... 
 'bf_ep',   [1 1 1 1 1], ...                                        %'bf_ev',   [1 1 1 1 1], ...
 'volterra',  0, ...
 'variable_dur',0);
%-------------------------------------------

bf_ep(1) = struct( ...
  'ep_type',4, ...
  'length',NScanPerBlock, ...
  'conv',  1, ...  
  'deriv', 0);

%bf_ev(1) = struct( ...
%  'ev_type',1, ...
%  'length',4);

regressors(1) = struct( ...
 	'names', {{'xValAro09','yValAro09','zValAro09','PitchValAro09','RollValAro09','YawValAro09'}}, ...
    'values',ValAro09RealignMat);
 
regressors(2) = struct( ...
'names', {{'xValAro36','yValAro36','zValAro36','PitchValAro36','RollValAro36','YawValAro36'}}, ...
'values',ValAro36RealignMat);



%-------------------------------------------

%-------------All---------------------------

%-------------------------------------------



%-----------Arousal All---------------------

CPosHiGTNeutAll=[0 0 -1 0 1 0 0 0 0 0 0 0 0 -1 0 1 0 0 0 0 0 0 0 0]

CPosHiLTNeutAll=-CPosHiGTNeutAll

CNegHiGTNeutAll=[1 0 -1 0 0 0 0 0 0 0 0 1 0 -1 0 0 0 0 0 0 0 0 0 0]

CNegHiLTNeutAll=-CNegHiGTNeutAll

CPosLoGTNeutAll=[0 0 -1 1 0 0 0 0 0 0 0 0 0 -1 1 0 0 0 0 0 0 0 0 0]

CPosLoLTNeutAll=-CPosLoGTNeutAll

CNegLoGTNeutAll=[0 1 -1 0 0 0 0 0 0 0 0 0 1 -1 0 0 0 0 0 0 0 0 0 0]

CNegLoLTNeutAll=-CNegLoGTNeutAll

%-----------Valence All----------------------

CPosHiGTNegHiAll=[-1 0 0 0 1 0 0 0 0 0 0 -1 0 0 0 1 0 0 0 0 0 0 0 0]

CPosHiLTNegHiAll=-CPosHiGTNegHiAll

CPosLoGTNegLoAll=[0 -1 0 1 0 0 0 0 0 0 0 0 -1 0 1 0 0 0 0 0 0 0 0 0]

CPosLoLTNegLoAll=-CPosLoGTNegLoAll

%-------------------------------------------

%-----------Arousal Complex---------------------

CAroHiGTLoAll=[3 -2 -2 -2 3 0 0 0 0 0 0 3 -2 -2 -2 3 0 0 0 0 0 0 0 0];

CAroHiLTLoAll=-CAroHiGTLoAll;

CAroLinHiGTLoAll=[4 -1 -6 -1 4 0 0 0 0 0 0 4 -1 -6 -1 4 0 0 0 0 0 0 0 0];

CAroLinHiLTLoAll=-CAroLinHiGTLoAll;

CAroExp1HiGTLoAll=[2 -1 -2 -1 2 0 0 0 0 0 0 2 -1 -2 -1 2 0 0 0 0 0 0 0 0];

CAroExp1HiLTLoAll=-CAroExp1HiGTLoAll;

CAroExp2HiGTLoAll=[7 -3 -8 -3 7 0 0 0 0 0 0 7 -3 -8 -3 7 0 0 0 0 0 0 0 0];

CAroExp2HiLTLoAll=-CAroExp2HiGTLoAll;

%-------------------------------------------

%-----------Valence Complex---------------------

CValPosGTNegAll=[-1 -1 0 1 1 0 0 0 0 0 0 -1 -1 0 1 1 0 0 0 0 0 0 0 0];

CValPosLTNegAll=-CValPosGTNegAll;



%-------------------------------------------

%-----------Slow--------------------------

%-------------------------------------------

%-----------Arousal Slow---------------------

CPosHiGTNeutSlow=[0 0 -1 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0]

CPosHiLTNeutSlow=-CPosHiGTNeutSlow

CNegHiGTNeutSlow=[1 0 -1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0]

CNegHiLTNeutSlow=-CNegHiGTNeutSlow

CPosLoGTNeutSlow=[0 0 -1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0]

CPosLoLTNeutSlow=-CPosLoGTNeutSlow

CNegLoGTNeutSlow=[0 1 -1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0]

CNegLoLTNeutSlow=-CNegLoGTNeutSlow

%-----------Valence Slow----------------------

CPosHiGTNegHiSlow=[-1 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0]

CPosHiLTNegHiSlow=-CPosHiGTNegHiSlow

CPosLoGTNegLoSlow=[0 -1 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0]

CPosLoLTNegLoSlow=-CPosLoGTNegLoSlow

%-------------------------------------------

%-----------Arousal Slow Complex---------------------

CAroHiGTLoSlow=[3 -2 -2 -2 3 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0];

CAroHiLTLoSlow=-CAroHiGTLoSlow;

CAroLinHiGTLoSlow=[4 -1 -6 -1 4 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0];

CAroLinHiLTLoSlow=-CAroLinHiGTLoSlow;

CAroExp1HiGTLoSlow=[2 -1 -2 -1 2 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0];

CAroExp1HiLTLoSlow=-CAroExp1HiGTLoSlow;

CAroExp2HiGTLoSlow=[7 -3 -8 -3 7 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0];

CAroExp2HiLTLoSlow=-CAroExp2HiGTLoSlow;

%-------------------------------------------

%-----------Valence Slow Complex---------------------
CValPosGTNegSlow=[-1 -1 0 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0];
CValPosLTNegSlow=-CValPosGTNegSlow;
%-------------------------------------------
%-----------Fast--------------------------
%-------------------------------------------
%-----------Arousal Fast---------------------
CPosHiGTNeutFast=[0 0 0 0 0 0 0 0 0 0 0 0 0 -1 0 1 0 0 0 0 0 0 0 0]
CPosHiLTNeutFast=-CPosHiGTNeutFast
CNegHiGTNeutFast=[0 0 0 0 0 0 0 0 0 0 0 1 0 -1 0 0 0 0 0 0 0 0 0 0]
CNegHiLTNeutFast=-CNegHiGTNeutFast
CPosLoGTNeutFast=[0 0 0 0 0 0 0 0 0 0 0 0 0 -1 1 0 0 0 0 0 0 0 0 0]
CPosLoLTNeutFast=-CPosLoGTNeutFast
CNegLoGTNeutFast=[0 0 0 0 0 0 0 0 0 0 0 0 1 -1 0 0 0 0 0 0 0 0 0 0]
CNegLoLTNeutFast=-CNegLoGTNeutFast
%-----------Valence Fast----------------------
CPosHiGTNegHiFast=[0 0 0 0 0 0 0 0 0 0 0 -1 0 0 0 1 0 0 0 0 0 0 0 0]
CPosHiLTNegHiFast=-CPosHiGTNegHiFast
CPosLoGTNegLoFast=[0 0 0 0 0 0 0 0 0 0 0 0 -1 0 1 0 0 0 0 0 0 0 0 0]
CPosLoLTNegLoFast=-CPosLoGTNegLoFast
%-------------------------------------------
%-----------Arousal Fast Complex---------------------
CAroHiGTLoFast=[0 0 0 0 0 0 0 0 0 0 0 3 -2 -2 -2 3 0 0 0 0 0 0 0 0];
CAroHiLTLoFast=-CAroHiGTLoFast;
CAroLinHiGTLoFast=[0 0 0 0 0 0 0 0 0 0 0 4 -1 -6 -1 4 0 0 0 0 0 0 0 0];
CAroLinHiLTLoFast=-CAroLinHiGTLoFast;
CAroExp1HiGTLoFast=[0 0 0 0 0 0 0 0 0 0 0 2 -1 -2 -1 2 0 0 0 0 0 0 0 0];
CAroExp1HiLTLoFast=-CAroExp1HiGTLoFast;
CAroExp2HiGTLoFast=[0 0 0 0 0 0 0 0 0 0 0 7 -3 -8 -3 7 0 0 0 0 0 0 0 0];
CAroExp2HiLTLoFast=-CAroExp2HiGTLoFast;
%-------------------------------------------
%-----------Valence Fast Complex---------------------
CValPosGTNegFast=[0 0 0 0 0 0 0 0 0 0 0 -1 -1 0 1 1 0 0 0 0 0 0 0 0];
CValPosLTNegFast=-CValPosGTNegFast;%-------------------------------------------
%-----------Fast Vs Slow--------------------
%-------------------------------------------
%-----------All Fast Vs Slow------------
CFastGTSlowAll=[-1 -1 -1 -1 -1 0 0 0 0 0 0 1 1 1 1 1 0 0 0 0 0 0 0 0];
CFastLTSlowAll=-CFastGTSlowAll;
CFastGTSlowNegHiAll=[-1 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0];
CFastLTSlowNegHiAll=-CFastGTSlowNegHiAll;
CFastGTSlowNegLoAll=[0 -1 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0];
CFastLTSlowNegLoAll=-CFastGTSlowNegLoAll;
CFastGTSlowNeutAll=[0 0 -1 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0];
CFastLTSlowNeutAll=-CFastGTSlowNeutAll;
CFastGTSlowPosLoAll=[0 0 0 -1 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0];
CFastLTSlowPosLoAll=-CFastGTSlowPosLoAll;
CFastGTSlowPosHiAll=[0 0 0 0 -1 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0];
CFastLTSlowPosHiAll=-CFastGTSlowPosHiAll;
%-------------------------------------------
%-----------Arousal Fast Vs Slow------------
CFastGTSlowHiAroAll=[-1 0 0 0 -1 0 0 0 0 0 0 1 0 0 0 1 0 0 0 0 0 0 0 0];
CFastLTSlowHiAroAll=-CFastGTSlowHiAroAll;
CFastGTSlowLoAroAll=[0 -1 0 -1 0 0 0 0 0 0 0 0 1 0 1 0 0 0 0 0 0 0 0 0];
CFastLTSlowLoAroAll=-CFastGTSlowLoAroAll;
%-------------------------------------------
%-----------Valence Fast Vs Slow------------
CFastGTSlowNegValAll=[-1 -1 0 0 0 0 0 0 0 0 0 1 1 0 0 0 0 0 0 0 0 0 0 0];
CFastLTSlowNegValAll=-CFastGTSlowNegValAll;
CFastGTSlowPosValAll=[0 0 0 -1 -1 0 0 0 0 0 0 0 0 0 1 1 0 0 0 0 0 0 0 0];
CFastLTSlowPosValAll=-CFastGTSlowPosValAll;

contrasts(1) = struct( ...
  'names',  {{...
            'CPosHiGTNeutAll','CPosHiLTNeutAll','CNegHiGTNeutAll','CNegHiLTNeutAll','CPosLoGTNeutAll',...
            'CPosLoLTNeutAll','CNegLoGTNeutAll','CNegLoLTNeutAll','CPosHiGTNegHiAll','CPosHiLTNegHiAll',...                 %10
            'CPosLoGTNegLoAll','CPosLoLTNegLoAll','CAroHiGTLoAll','CAroHiLTLoAll','CAroLinHiGTLoAll',...
            'CAroLinHiLTLoAll','CAroExp1HiGTLoAll','CAroExp1HiLTLoAll','CAroExp2HiGTLoAll','CAroExp2HiLTLoAll',...           %20
            'CValPosGTNegAll','CValPosLTNegAll','CPosHiGTNeutSlow','CPosHiLTNeutSlow','CNegHiGTNeutSlow',...
            'CNegHiLTNeutSlow','CPosLoGTNeutSlow','CPosLoLTNeutSlow','CNegLoGTNeutSlow','CNegLoLTNeutSlow',...               %30
            'CPosHiGTNegHiSlow','CPosHiLTNegHiSlow','CPosLoGTNegLoSlow','CPosLoLTNegLoSlow','CAroHiGTLoSlow',...
            'CAroHiLTLoSlow','CAroLinHiGTLoSlow','CAroLinHiLTLoSlow','CAroExp1HiGTLoSlow','CAroExp1HiLTLoSlow',...           %40
            'CAroExp2HiGTLoSlow','CAroExp2HiLTLoSlow','CValPosGTNegSlow','CValPosLTNegSlow','CPosHiGTNeutFast',...
            'CPosHiLTNeutFast','CNegHiGTNeutFast','CNegHiLTNeutFast','CPosLoGTNeutFast','CPosLoLTNeutFast',...               %50
            'CNegLoGTNeutFast','CNegLoLTNeutFast','CPosHiGTNegHiFast','CPosHiLTNegHiFast','CPosLoGTNegLoFast',...             
            'CPosLoLTNegLoFast','CAroHiGTLoFast','CAroHiLTLoFast','CAroLinHiGTLoFast','CAroLinHiLTLoFast',...                 %60
            'CAroExp1HiGTLoFast','CAroExp1HiLTLoFast','CAroExp2HiGTLoFast','CAroExp2HiLTLoFast','CValPosGTNegFast',...
            'CValPosLTNegFast','CFastGTSlow','CFastLTSlow','CFastGTSlowNegHi','CFastLTSlowNegHi',...               %70
            'CFastGTSlowNegLo','CFastLTSlowNegLo','CFastGTSlowNeut','CFastLTSlowNeut','CFastGTSlowPosLo',...
            'CFastLTSlowPosLo','CFastGTSlowPosHi','CFastLTSlowPosHi','CFastGTSlowHiAro','CFastLTSlowHiAro',...   %80
            'CFastGTSlowLoAro','CFastLTSlowLoAro','CFastGTSlowNegVal','CFastLTSlowNegVal','CFastGTSlowPosVal',...
            'CFastLTSlowPosVal',...
            }}, ...
  'types',   {{'T','T','T','T','T','T','T','T','T','T','T','T','T','T','T','T','T','T','T','T',...
               'T','T','T','T','T','T','T','T','T','T','T','T','T','T','T','T','T','T','T','T',...
               'T','T','T','T','T','T','T','T','T','T','T','T','T','T','T','T','T','T','T','T',...
               'T','T','T','T','T','T','T','T','T','T','T','T','T','T','T','T','T','T','T','T',...
               'T','T','T','T','T','T',...
            }}, ...
  'values',  {{...
            CPosHiGTNeutAll,CPosHiLTNeutAll,CNegHiGTNeutAll,CNegHiLTNeutAll,CPosLoGTNeutAll,...
            CPosLoLTNeutAll,CNegLoGTNeutAll,CNegLoLTNeutAll,CPosHiGTNegHiAll,CPosHiLTNegHiAll,...                                   %10
            CPosLoGTNegLoAll,CPosLoLTNegLoAll,CAroHiGTLoAll,CAroHiLTLoAll,CAroLinHiGTLoAll,...
            CAroLinHiLTLoAll,CAroExp1HiGTLoAll,CAroExp1HiLTLoAll,CAroExp2HiGTLoAll,CAroExp2HiLTLoAll,...                            %20
            CValPosGTNegAll,CValPosLTNegAll,CPosHiGTNeutSlow,CPosHiLTNeutSlow,CNegHiGTNeutSlow,...
            CNegHiLTNeutSlow,CPosLoGTNeutSlow,CPosLoLTNeutSlow,CNegLoGTNeutSlow,CNegLoLTNeutSlow,...                                %30
            CPosHiGTNegHiSlow,CPosHiLTNegHiSlow,CPosLoGTNegLoSlow,CPosLoLTNegLoSlow,CAroHiGTLoSlow,...
            CAroHiLTLoSlow,CAroLinHiGTLoSlow,CAroLinHiLTLoSlow,CAroExp1HiGTLoSlow,CAroExp1HiLTLoSlow,...                            %40
            CAroExp2HiGTLoSlow,CAroExp2HiLTLoSlow,CValPosGTNegSlow,CValPosLTNegSlow,CPosHiGTNeutFast,...
            CPosHiLTNeutFast,CNegHiGTNeutFast,CNegHiLTNeutFast,CPosLoGTNeutFast,CPosLoLTNeutFast,...                                %50
            CNegLoGTNeutFast,CNegLoLTNeutFast,CPosHiGTNegHiFast,CPosHiLTNegHiFast,CPosLoGTNegLoFast,...
            CPosLoLTNegLoFast,CAroHiGTLoFast,CAroHiLTLoFast,CAroLinHiGTLoFast,CAroLinHiLTLoFast,...                                 %60
            CAroExp1HiGTLoFast,CAroExp1HiLTLoFast,CAroExp2HiGTLoFast,CAroExp2HiLTLoFast,CValPosGTNegFast,...
            CValPosLTNegFast,CFastGTSlowAll,CFastLTSlowAll,CFastGTSlowNegHiAll,CFastLTSlowNegHiAll,...                              %70
            CFastGTSlowNegLoAll,CFastLTSlowNegLoAll,CFastGTSlowNeutAll,CFastLTSlowNeutAll,CFastGTSlowPosLoAll,...
            CFastLTSlowPosLoAll,CFastGTSlowPosHiAll,CFastLTSlowPosHiAll,CFastGTSlowHiAroAll,CFastLTSlowHiAroAll,...                 %80
            CFastGTSlowLoAroAll,CFastLTSlowLoAroAll,CFastGTSlowNegValAll,CFastLTSlowNegValAll,CFastGTSlowPosValAll,...
            CFastLTSlowPosValAll,
             }} ...
);