global SubInd SubIndStr Base BaseStr MaskStr

%---------------------------------------------------------------
% model(1) Low-Off vs High Off
%---------------------------------------------------------------
clear F1 F2 
Mask=[MaskStr,'*.img']
FolderName=['K:\ValAro\',SubIndStr,'\09\']
F1=spm_get('Files',FolderName,Mask);
ValAro09RealignFile=spm_get('Files',FolderName,['realignment*.*'])
ValAro09RealignMat=ReadTxtMat(ValAro09RealignFile,[6 96]);
ValAro09RealignMat=ValAro09RealignMat';
if size(ValAro09RealignMat)~=[96,6]
   error('size(ValAro09RealignMat)~=[96,6]')
end
FolderName=['K:\ValAro\',SubIndStr,'\36\'];
F2=spm_get('Files',FolderName,Mask);
ValAro36RealignFile=spm_get('Files',FolderName,['realignment*.*'])
ValAro36RealignMat=ReadTxtMat(ValAro36RealignFile,[6 96]);
ValAro36RealignMat=ValAro36RealignMat';
if size(ValAro36RealignMat)~=[96,6]
   error('size(ValAro36RealignMat)~=[96,6]')
end
F1
F2

%---------------------------------------------------------------
% batch variables defined here for analysis 'model'
%---------------------------------------------------------------

model(1) = struct( ...
 'types',          4, ...
 'global_effects', {'None'}, ...
 'burst_mode',     0, ...
 'HF_fil',         'None',  ...
 'HF_cut',         [], ...
 'LF_fil',         'Gaussian', ...
 'LF_cut',         [4], ...
 'int_corr',       'none', ... 
 'now_later',      1, ...
 'stop_writing',   0, ...
 'trial_fcon',     0, ...
 'RT',             4.5, ...
 'replicated',     0, ...
 'same_time_param',0, ...
 'nsess',          5, ...
 'nscans',         [96 96 96 96 96], ...
 'files',          {{F1 F2 F3 F4 F5}}, ...
 'conditions_nb',  [1 1 1 1 1], ...     
 'conditions',     [1 1 1 1 1], ...
 'regressors_nb',  [6 6 6 6 6], ...
 'regressors',     [1 2 3 4 5], ...
 'parametrics_type',{{'none','none','none','none','none'}}, ...
 'parametrics',     [], ...
 'stochastics_flag',[0 0 0 0 0], ...
 'stochastics',    []);
 
% NScanPerBlock=4;
% 
% NegHigh=[2 9  13 20 23 30 33 39 42 49 52 59 63 70 72 80 83 89 92 98 ]*NScanPerBlock+Base
% NegLow =[4 8  12 19 22 28 34 40 43 50 53 60 65 67 74 79 82 87 95 100]*NScanPerBlock+Base
% Neutral=[1 6  11 16 21 26 31 36 41 46 51 56 61 66 71 76 81 86 91 96 ]*NScanPerBlock+Base
% PosLow =[5 7  14 17 25 27 35 37 44 47 55 58 64 68 75 78 85 88 94 99 ]*NScanPerBlock+Base
% PosHigh=[3 10 15 18 24 29 32 38 45 48 54 57 62 69 73 77 84 90 93 97 ]*NScanPerBlock+Base
%-------------------------------------------

% conditions(1) = struct( ...
%  'names',   {{'NegHigh','NegLow','Neutral','PosLow','PosHigh'}}, ...
%  'onsets',{{NegHigh,NegLow,Neutral,PosLow,PosHigh}}, ...   
%  'types',    {{'epochs','epochs','epochs','epochs','epochs'}}, ...  %'types',    {{'events','events','events','events','events'}}, ... 
%  'bf_ep',   [1 1 1 1 1], ...                                        %'bf_ev',   [1 1 1 1 1], ...
%  'volterra',  0, ...
%  'variable_dur',0);
%-------------------------------------------
conditions(1) = struct( ...
 'names',   {{'back','front','high','mid','noise'}}, ...
 'onsets',{{[1 1 1 1 1]}}, ...   
 'types',    {{'epochs','epochs','epochs','epochs','epochs'}}, ...  
 'bf_ep',   [1 1 1 1 1], ...                                      
 'volterra',  0, ...
 'variable_dur',0);

bf_ep(1) = struct( ...
  'ep_type',4, ...
  'length',96, ...
  'conv',0, ...  
  'deriv',0);

regressors(1) = struct( ...
 	'names', {{'xValAro09','yValAro09','zValAro09','PitchValAro09','RollValAro09','YawValAro09'}}, ...
    'values',ValAro09RealignMat);
 
regressors(2) = struct( ...
'names', {{'xValAro36','yValAro36','zValAro36','PitchValAro36','RollValAro36','YawValAro36'}}, ...
'values',ValAro36RealignMat);



%-------------------------------------------
%-------------------------------------------
%-------------------------------------------

Tmp1=[1 0 0 0 0 0 0 -1 0 0 0 0 0 0 0 0 0 0 0 0 0]

contrasts(1) = struct( ...
  'names',  {{...
            'bcvsdb'}}, ...
  'types',   {{'T'...
            }}, ...
  'values',  {{...
            Tmp}} ...
);