global SubInd SubIndStr MaskStr SmoothStr

%---------------------------------------------------------------
% model(1) Low-Off vs High Off
%---------------------------------------------------------------
clear F0 F1 
Mask=[MaskStr,'*.img']

Folder0='D:\MEG\FPP43\Run1\FPP43.1.0'
Folder1='D:\MEG\FPP43\Run1\FPP43.1.1'

F10=spm_get('Files',Folder0,Mask);
NFiles10=size(F10,1)
F11=spm_get('Files',Folder1,Mask);
NFiles11=size(F11,1)
F1=[F10;F11]

Folder0='D:\MEG\FPP43\Run2\FPP43.2.0'
Folder1='D:\MEG\FPP43\Run2\FPP43.2.1'

F20=spm_get('Files',Folder0,Mask);
NFiles20=size(F20,1)
F21=spm_get('Files',Folder1,Mask);
NFiles21=size(F21,1)
F2=[F20;F21]

%---------------------------------------------------------------
% batch variables defined here for analysis 'model'
%---------------------------------------------------------------

model(1) = struct( ...
 'types',          4, ...
 'global_effects', {'None'}, ...
 'burst_mode',     0, ...
 'HF_fil',         'none',  ...
 'HF_cut',         [], ...
 'LF_fil',         'none', ...
 'LF_cut',         [], ...
 'int_corr',       'none', ... 
 'now_later',      1, ...
 'stop_writing',   0, ...
 'trial_fcon',     0, ...
 'RT',             1, ...
 'replicated',     0, ...
 'same_time_param',0, ...
 'nsess',          2, ...
 'nscans',         [NFiles10+NFiles11,NFiles20+NFiles21], ...
 'files',          {{F1,F2}}, ...
 'conditions_nb',  [2 2], ...     
 'conditions',     [1 2], ...
 'regressors_nb',  [0 0], ...
 'regressors',     [], ...
 'parametrics_type',{{'none','none'}}, ...
 'parametrics',    [], ...
 'stochastics_flag',[0 0], ...
 'stochastics',    []);
 
%-------------------------------------------
conditions(1) = struct( ...
 'names',   {{'Low','High'}}, ...
 'onsets',{{0,NFiles10}}, ...   
 'types',    {{'epochs','epochs'}}, ...  
 'bf_ep',   [1 2], ...                  
 'volterra',  0, ...
 'variable_dur',0);

%-------------------------------------------

bf_ep(1) = struct( ...
  'ep_type',4, ...
  'length',NFiles10, ...
  'conv',0, ...  
  'deriv',0);

bf_ep(2) = struct( ...
  'ep_type',4, ...
  'length',NFiles11, ...
  'conv',0, ...  
  'deriv',0);

%-------------------------------------------

conditions(2) = struct( ...
 'names',   {{'Low','High'}}, ...
 'onsets',{{0,NFiles20}}, ...   
 'types',    {{'epochs','epochs'}}, ...  
 'bf_ep',   [3 4], ...                  
 'volterra',  0, ...
 'variable_dur',0);

%-------------------------------------------

bf_ep(3) = struct( ...
  'ep_type',4, ...
  'length',NFiles20, ...
  'conv',0, ...  
  'deriv',0);

bf_ep(4) = struct( ...
  'ep_type',4, ...
  'length',NFiles21, ...
  'conv',0, ...  
  'deriv',0);

contrasts(1) = struct('names',{{'CHighGTLow','CLowGTHigh'}},'types', {{'T','T'}},'values',{{[-1 1 -1 1 0 0],[1 -1 1 -1 0 0]}});