function [MiCs,IndVec1,IndVec2,LastShot]=fMriTStat(FuncMat,StatStatus,Lag,NShotPerCycle)
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
%==================================================================
%
%	fMriTStat.m
%
%
%	Qun Zhao & Markus Junghoefer	[2000]
%
%
%
%	Function definition
%
%
% This program is designed to calculate the independent and dependent t-
% statistics of fMRI signal 
%=================================================================
 if nargin<4; NShotPerCycle=4; end
 if nargin<3; Lag=2; end
 if nargin<2; StatStatus='CalcIndT21'; end
 if nargin<1; FuncMat=[]; end

 [XSizeFunc,YSizeFunc,NSlice,NShot]=size(FuncMat);


if strcmp(StatStatus,'CalcIndT12') | strcmp(StatStatus,'CalcIndT21')
	 FigTitle='Independent t-Test Shot Order';
	[IndVec1,IndVec2,Num,LastShot]=CalcInd12Vec(NShot,NShotPerCycle,Lag,FigTitle);
	Mean1=mean(FuncMat(:,:,:,IndVec1),4);
	Mean2=mean(FuncMat(:,:,:,IndVec2),4);
	Std1=std(FuncMat(:,:,:,IndVec1),0,4);
	Std2=std(FuncMat(:,:,:,IndVec2),0,4);
	Vari=sqrt((Std1.^2+Std2.^2)./Num);
	if strcmp(StatStatus,'CalcIndT12') 
		MiCs=(Mean1-Mean2)./Vari;
	elseif strcmp(StatStatus,'CalcIndT21') 
		MiCs=(Mean2-Mean1)./Vari;
	end
elseif strcmp(StatStatus,'CalcDepT12') | strcmp(StatStatus,'CalcDepT21')
	 FigTitle='Dependent t-Test Shot Order';
	[IndVec1,IndVec2,Num,LastShot]=CalcInd12Vec(NShot,NShotPerCycle,Lag,FigTitle);
	if strcmp(StatStatus,'CalcDepT12')
		Diff=FuncMat(:,:,:,IndVec1)-FuncMat(:,:,:,IndVec2);
	elseif strcmp(StatStatus,'CalcDepT21')
		Diff=FuncMat(:,:,:,IndVec2)-FuncMat(:,:,:,IndVec1);
	end
	MiCs=mean(Diff,4)./(std(Diff,0,4)./sqrt(Num));
else
  	disp(sprintf('fMriTStat: action string ''%s'' not recognized, no action taken.',StatStatus))
	return
end
return;
