function [NIndVec]=FindTD(CoorMat,CoorFilePath,TDStrFilePath,TDCoorFilePath,TdFilePath)
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      

if nargin<5; TdFilePath=[]; end
if nargin<4; TDCoorFilePath=[]; end
if nargin<3; TDStrFilePath=[]; end
if nargin<2; CoorFilePath=[]; end
if nargin<1; CoorMat=[]; end

%global TDStrSort LLineVec TDCoorSortMat
TDStrSort=[];
LLineVec=[];
TDCoorSortMat=[];

if isempty(CoorMat) 
    if isempty(CoorFilePath)
        DefFolder=['H:\fMRIGV\AllStats']
        Mask=['*BTal*.txt'];
        CoorFilePath=spm_get(1,Mask,'Choose a BTal*.txt file',DefFolder);
    end
    fid=fopen(CoorFilePath,'r','ieee-le');
    i=0;
    while 1
        tline = fgetl(fid);
        if ~ischar(tline), break, end
        i=i+1;
        CoorMat(i,:)=str2num(tline);
    end
    fclose(fid);
end

FindStatus=1; %Single Point
NTDCoor=222956;
if isempty(TDStrSort);
    TDStrSort=char(zeros(NTDCoor,120));
    fid1=fopen(TDStrFilePath,'r','ieee-le');
    LLineVec=zeros(NTDCoor,1);
    for i=1:NTDCoor
        tline=fgets(fid1);
        LLineVec(i)=length(tline);
        TDStrSort(i,1:length(tline))=tline;
    end
    fclose(fid1);
end
if isempty(TDCoorSortMat);
    fid2=fopen(TDCoorFilePath,'r','ieee-le');
    TDCoorSortMat=fread(fid2,[NTDCoor 3],'float32');
    fclose(fid2)
end
TDCoorSortSumVec=sum(abs(TDCoorSortMat),2);
NCoor=size(CoorMat,1);
if FindStatus==1 %Single Point
    c=[1 1 1];
    for i=1:NCoor
        %j=0;
        j=min(find(TDCoorSortSumVec>=sum(abs(CoorMat(i,:)))));
        fprintf(1,'%g of %g done ...\n',i,NCoor)
        a=1;
        while sum(abs(a))>0 & j<NTDCoor
            j=j+1;
            a=TDCoorSortMat(j,:)-CoorMat(i,:);
        end
        NIndVec(i)=j;
    end
    LNIndVec=length(NIndVec);
elseif FindStatus==2 %Single Point
    c=[1 1 1];
    Radius=6
    for i=1:NCoor
        MinJ=min(find(TDCoorSortSumVec>=sum(abs(CoorMat(i,:)))-Radius));
        fprintf(1,'%g of %g done ...\n',i,NCoor)
        a=1;
        while sum(abs(a))>0 & j<NTDCoor
            j=j+1;
            a=TDCoorSortMat(j,:)-CoorMat(i,:);
        end
        NIndVec(i)=j;
    end
    LNIndVec=length(NIndVec)
end
fid3=fopen(TdFilePath,'w','ieee-le');
for i=1:LNIndVec
    fprintf(fid3,'%g, ',i);
    fprintf(fid3,TDStrSort(NIndVec(i),1:LLineVec(NIndVec(i))),'float32');
end
fclose(fid3)
return