function [BMat,MMat]=Mni2TalSingle(MniMat)
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      

if nargin<1; return; end


MMat(1)=0.88.*MniMat(1)-0.8;	%Meyer-Lindenberg
MMat(2)=0.97.*MniMat(2)-3.32;
MMat(3)=0.05.*MniMat(2)+0.88.*MniMat(3)-0.44;
	
BMat(1)=0.99.*MniMat(1);	%Brett
if MniMat(3)>=0
	BMat(2)=0.9688.*MniMat(2)+0.046.*MniMat(3);
	BMat(3)=-0.0485.*MniMat(2)+0.9189.*MniMat(3);
else
	BMat(2)=0.9688.*MniMat(2)+0.042.*MniMat(3);
	BMat(3)=-0.0485.*MniMat(2)+0.839.*MniMat(3);
end
return
