function [DataMat,FilePath,SizeDataMat,NDim,Version]=ReformatAB(FilePath,Orient);
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
%=========================================================================
%
%	ReformatAB
%
%	Markus Junghoefer	[2000]
%

%	
%	Function definition
% 
% 
%================================================================================
if nargin<2;Orient='Coronal';end
if nargin<1;FilePath=[];end
global FunMat

if strcmp(Orient,'Coronal') | strcmp(Orient,'coronal') | strcmp(Orient,'cor') | strcmp(Orient,'Cor')
	Orient='Coronal';
elseif strcmp(Orient,'Sagital') | strcmp(Orient,'sagital') | strcmp(Orient,'sag') | strcmp(Orient,'Sag')
	Orient='Sagital';
elseif  strcmp(Orient,'transversal') | strcmp(Orient,'transversal') | strcmp(Orient,'tra') | strcmp(Orient,'Tra') | ...
	strcmp(Orient,'Axial') | strcmp(Orient,'axial') | strcmp(Orient,'axi') | strcmp(Orient,'Axi')
	Orient='Axial';
end
NDyn=128;
NSlice=6;
XSizeFun=64;
YSizeFun=64;
if strcmp(Orient,'Coronal')
	DimFile=[XSizeFun NSlice YSizeFun];
elseif strcmp(Orient,'Sagital')
	DimFile=[NSlice XSizeFun YSizeFun];
elseif strcmp(Orient,'Axial')
	DimFile=[XSizeFun YSizeFun NSlice];
end
FunMat=zeros([XSizeFun YSizeFun NSlice NDyn]);
NCountFile=XSizeFun.*YSizeFun.*NSlice;
[DefFilePath]=SetDefPath('r','*.img');
[File,Path,FilePath]=ReadFilePath(FilePath,DefFilePath,'Read first MRI data from file:');
if File==0; 
	DataMat=[]; 
	FilePath=[]; 
	return; 
end
SetDefPath('w',Path);
fprintf('Read data from file...\n\n');
File=File(1:length(File)-7);
for DynInd=1:NDyn
	if DynInd<10
		NDynStr=['00',int2str(DynInd)];
	elseif  DynInd>9 & DynInd<100
		NDynStr=['0',int2str(DynInd)];
	elseif  DynInd>99 & DynInd<1000
		NDynStr=[int2str(DynInd)];
	end
	FilePath=[Path,File,NDynStr,'.img'];
	fprintf(1,[FilePath,'\n'])
	fid=fopen(FilePath,'r','ieee-be');
	[Data,Count]=fread(fid,'int16');
	if Count~=NCountFile
		error('Count~=NCountFile in ReformatAB')
	end
	Tmp=reshape(Data,DimFile);
	for SliceInd=1:NSlice
		if strcmp(Orient,'Coronal')
			TmpTmp=rot90(squeeze(Tmp(:,SliceInd,:)));
		elseif strcmp(Orient,'Sagital')
			TmpTmp=rot90(squeeze(Tmp(:,SliceInd,:)));
		elseif strcmp(Orient,'Axial')
			TmpTmp=rot90(squeeze(Tmp(:,:,SliceInd)));
		end
		FunMat(:,:,SliceInd,DynInd)=TmpTmp;
	end
	fclose(fid);
end
FilePath=['Paul:',File,'fun']
SaveNDimData(FunMat,FilePath,'int16');
MeanFun=squeeze(mean(FunMat,4));
XSizeStruc=256
YSizeStruc=256
StrucMat=zeros(XSizeStruc,YSizeStruc,NSlice);
Interp2Str='cubic';
for SliceInd=1:NSlice
	StrucMat(:,:,SliceInd)=interp2(MeanFun(:,:,SliceInd),linspace(1,XSizeFun,XSizeStruc),linspace(1,YSizeFun,YSizeStruc)',Interp2Str);
end
AbsMinStrucMat=min(min(min(StrucMat)));
StrucMat=StrucMat-AbsMinStrucMat;	
StrucMat=StrucMat./max(max(max(StrucMat)));
StrucMat=StrucMat.*(2^16./2-1);
FilePath=['Paul:',File,'str'];
SaveNDimData(StrucMat,FilePath,'int16');
return
