function [] = fMRIMenu(action)
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      

%================= global variables =============================================

global hfMRIMenu

% 	Possible actions and button callbacks:

%================================================================================	

if nargin<1; action='InitializeMenue'; end

if strcmp(action,'InitializeMenue')

	%============================================================================
   	%=========== INITIALIZE MENU ================================================
	%============================================================================
			
	if strcmp(computer,'MAC2')	
      		MenuFigPosVec=[0.6 0 0.4 1];
   	elseif strcmp(computer,'PCWIN') 
      		MenuFigPosVec=[0.61 0.05 0.4 0.82];
      	elseif strcmp(computer,'SOL2')
      		MenuFigPosVec=[0.6224 0.01 0.4 0.91];	
	elseif strcmp(computer,'LNX86')
      		MenuFigPosVec=[0.6224 0.01 0.4 0.91];	
	else
      		MenuFigPosVec=[0.6 0 0.3 1];
   	end
   
   	%============== figure with menu ===========================		
	hfMRIMenuMenuFigString=['fMRI Menu:'];
   	hfMRIMenu=figure('Units','normal','Position',MenuFigPosVec, ...
    'Name',hfMRIMenuMenuFigString,'Color',[.99 .99 .99],...
    'NumberTitle','off');
		
    % Information for all buttons (and menus)
    labelColor=[0.8 0.8 0.8];
    yInitPos=0.90;
   	menutop=0.955;
   	btnTop = 0.6;
    top=0.75;
    left=0.125;
    btnWid=0.8;
   	btnHt=0.0325;
    btnHtEdit=0.05;
    textWidth = 0.06;
	textHeight = 0.05;
   	% Spacing between the button and the next command's label
   	spacing=0.015;
    delta = 0.005;
	fontsize = 8;
	%====================================
    % The CONSOLE frame
	%==============================================================

    frmBorder=0.05; 
	frmLeft=left-frmBorder;
	frmBottom=0.010; 
   	frmHeight = 1-3.*frmBottom; 
	frmWidth = btnWid+2*frmBorder;
    	frmPos=[frmLeft frmBottom frmWidth frmHeight];
	ConsoleRGBColor=[0 0.4 0];
   	hConsolFrame=uicontrol( ...
        'Style','frame', ...
        'Units','normalized', ...
        'Position',frmPos, ...
	 'BackgroundColor',ConsoleRGBColor);
	
	%=====================
	%Read Structural 
	%=====================
	btnNumber = 1;
	yPos = menutop-(btnNumber-1)*(btnHt+spacing);
	btnPos = [left yPos-btnHt-delta btnWid/4 btnHt];
	callbackStr = 'fMRIMenu(''ReadStruc'')';
	hReadStruc = uicontrol(...
       	'Style','pushbutton',...
		'Units','Normalized',...
		'Position',btnPos,...
		'String','Read Structural',...
		'Callback',callbackStr,...
		'Enable','on');	 
	
	%=====================
	%Reformat & Save Structural 
	%=====================
	yPos = menutop-(btnNumber-1)*(btnHt+spacing);
	btnPos = [left+btnWid/4 yPos-btnHt-delta btnWid/4 btnHt];
	callbackStr = 'fMRIMenu(''ReformSaveStruc'')';
	hReformSaveStruc = uicontrol(...
         	'Style','pushbutton',...
		 'Units','Normalized',...
		 'Position',btnPos,...
		 'String','Reformat & Save',...
		 'Callback',callbackStr,...
		 'Enable','on');	 
	
	%=====================
	%Reformat & Save Structural 
	%=====================
	yPos = menutop-(btnNumber-1)*(btnHt+spacing);
	btnPos = [left+btnWid/2 yPos-btnHt-delta btnWid/4 btnHt];
	callbackStr = 'fMRIMenu(''ReformStruc'')';
	hReformStruc = uicontrol(...
         	'Style','pushbutton',...
		 'Units','Normalized',...
		 'Position',btnPos,...
		 'String','Reformat',...
		 'Callback',callbackStr,...
		 'Enable','on');	  
		 
	%=====================
	%Save Structural 
	%=====================
	yPos = menutop-(btnNumber-1)*(btnHt+spacing);
	btnPos = [left+3.*btnWid/4 yPos-btnHt-delta btnWid/4 btnHt];
	callbackStr = 'fMRIMenu(''SaveStruc'')';
	hSaveStruc = uicontrol(...
        	'Style','pushbutton',...
		 'Units','Normalized',...
		 'Position',btnPos,...
		 'String','Save',...
		 'Callback',callbackStr,...
		 'Enable','on');
	
	%=====================
	%Read Functional 
	%=====================
	btnNumber = 2;
	yPos = menutop-(btnNumber-1)*(btnHt+spacing);
	btnPos = [left yPos-btnHt-delta btnWid/4 btnHt];
	callbackStr = 'fMRIMenu(''ReadFunc'')';
	hReadFunc = uicontrol(...
         'Style','pushbutton',...
		 'Units','Normalized',...
		 'Position',btnPos,...
		 'String','Read Functional',...
		 'Callback',callbackStr,...
		 'Enable','on');	 
	
	%=====================
	%Reformat & Save Functional 
	%=====================
	yPos = menutop-(btnNumber-1)*(btnHt+spacing);
	btnPos = [left+btnWid/4 yPos-btnHt-delta btnWid/4 btnHt];
	callbackStr = 'fMRIMenu(''ReformSaveFunc'')';
	hReformSaveFunc = uicontrol(...
         'Style','pushbutton',...
		 'Units','Normalized',...
		 'Position',btnPos,...
		 'String','Reformat & Save',...
		 'Callback',callbackStr,...
		 'Enable','on');	 
 
	%=====================
	%Reformat Functional 
	%=====================
	yPos = menutop-(btnNumber-1)*(btnHt+spacing);
	btnPos = [left+btnWid/2 yPos-btnHt-delta btnWid/4 btnHt];
	callbackStr = 'fMRIMenu(''ReformFunc'')';
	hReformFunc = uicontrol(...
         'Style','pushbutton',...
		 'Units','Normalized',...
		 'Position',btnPos,...
		 'String','Reformat',...
		 'Callback',callbackStr,...
		 'Enable','on');	 

	%=====================
	%Save Functional 
	%=====================
	yPos = menutop-(btnNumber-1)*(btnHt+spacing);
	btnPos = [left+3.*btnWid/4 yPos-btnHt-delta btnWid/4 btnHt];
	callbackStr = 'fMRIMenu(''SaveFunc'')';
	hSaveFunc = uicontrol(...
         'Style','pushbutton',...
		 'Units','Normalized',...
		 'Position',btnPos,...
		 'String','Save',...
		 'Callback',callbackStr,...
		 'Enable','on');
		 
	%=====================
	%Read Functional & Structural
	%=====================
	btnNumber = 3;
	yPos = menutop-(btnNumber-1)*(btnHt+spacing);
	btnPos = [left yPos-btnHt-delta btnWid/4 btnHt];
	callbackStr = 'fMRIMenu(''ReadFuncStruc'')';
	hReadFuncStruc = uicontrol(...
         'Style','pushbutton',...
		 'Units','Normalized',...
		 'Position',btnPos,...
		 'String','Read Func. & Struc.',...
		 'Callback',callbackStr,...
		 'Enable','on');	 
	 
	%=====================
	%Calculate All
	%=====================
	btnNumber = 3;
	yPos = menutop-(btnNumber-1)*(btnHt+spacing);
	btnPos = [left+btnWid/4 yPos-btnHt-delta btnWid/4 btnHt];
	callbackStr = 'fMRIMenu(''CalcAll'')';
	hCalcAll = uicontrol(...
         'Style','pushbutton',...
		 'Units','Normalized',...
		 'Position',btnPos,...
		 'String','Calculate All',...
		 'Callback',callbackStr,...
		 'Enable','on');	 
		
	%=====================
	%Batch Calculate All
	%=====================
	btnNumber = 3;
	yPos = menutop-(btnNumber-1)*(btnHt+spacing);
	btnPos = [left+btnWid/2 yPos-btnHt-delta btnWid/4 btnHt];
	callbackStr = 'fMRIMenu(''BatchCalcAll'')';
	hBatchCalcAll = uicontrol(...
         'Style','pushbutton',...
		 'Units','Normalized',...
		 'Position',btnPos,...
		 'String','Batch All',...
		 'Callback',callbackStr,...
		 'Enable','on');	 
		 
	%=====================
	%Save All
	%=====================
	btnNumber = 3;
	yPos = menutop-(btnNumber-1)*(btnHt+spacing);
	btnPos = [left+3.*btnWid/4 yPos-btnHt-delta btnWid/4 btnHt];
	callbackStr = 'fMRIMenu(''SaveAll'')';
	hSaveAll = uicontrol(...
         'Style','pushbutton',...
		 'Units','Normalized',...
		 'Position',btnPos,...
		 'String','Save All',...
		 'Callback',callbackStr,...
		 'Enable','on');	 
		 
	%=====================
	%Plot Structural
	%=====================
	btnNumber = 4;
	yPos = menutop-(btnNumber-1)*(btnHt+spacing);
	btnPos = [left yPos-btnHt-delta btnWid/4 btnHt];
	callbackStr = 'fMRIMenu(''PlotStruc'')';
	hPlotStruc = uicontrol(...
        	 'Style','popupmenu', ...
		 'Units','Normalized',...
		 'Position',btnPos,...
		 'String','Plot Struc.',...
		 'Callback',callbackStr,...
		 'Value',1,...
		 'Enable','off');
		 
	%=====================
	%Plot Functional Shot
	%=====================
	yPos = menutop-(btnNumber-1)*(btnHt+spacing);
	btnPos = [left+btnWid/4 yPos-btnHt-delta btnWid/4 btnHt];
	callbackStr = 'fMRIMenu(''PlotFuncShot'')';
	hPlotFuncShot = uicontrol(...
         	'Style','popupmenu', ...
		 'Units','Normalized',...
		 'Position',btnPos,...
		 'String','Func. Shot.',...
		 'Callback',callbackStr,...
		  'Value',1,...
		 'Enable','off');
		
	%=====================
	%Plot Functional Slice
	%=====================
	yPos = menutop-(btnNumber-1)*(btnHt+spacing);
	btnPos = [left+btnWid/2 yPos-btnHt-delta btnWid/4 btnHt];
	callbackStr = 'fMRIMenu(''PlotFuncSlice'')';
	hPlotFuncSlice = uicontrol(...
         	'Style','popupmenu', ...
		 'Units','Normalized',...
		 'Position',btnPos,...
		 'String','Func. Slice.',...
		 'Callback',callbackStr,...
		  'Value',1,...
		 'Enable','off');
		
	%=====================
	%Plot Functional Slice & Shot
	%=====================
	yPos = menutop-(btnNumber-1)*(btnHt+spacing);
	btnPos = [left+3.*btnWid/4 yPos-btnHt-delta btnWid/4 btnHt];
	callbackStr = 'fMRIMenu(''PlotFuncShotSlice'')';
	hPlotFuncShotSlice = uicontrol(...
         	'Style','popupmenu', ...
		 'Units','Normalized',...
		 'Position',btnPos,...
		 'String','Slice & Shot.',...
		 'Callback',callbackStr,...
		  'Value',1,...
		 'Enable','off');
	
	%===================================
    	% TR
    	%===================================
	btnNumber=5;     
	yPos=menutop-(btnNumber-1)*(btnHt+spacing);
    	btnPos=[left yPos-btnHtEdit./2 2.*btnWid./6 btnHtEdit./2];
    
	hTRText = uicontrol( ...
        'Style','text', ...
        'Units','normalized', ...
	'Position',btnPos, ...
        'Horiz','left', ...
        'Foreground','black', ...
        'String','  TR [ms]',...
	'Enable','on');

	btnPos=[left+2.*btnWid./6 yPos-btnHtEdit./2 btnWid./6 1.*btnHtEdit./2];
	callbackStr = 'fMRIMenu(''setTR'')';
    
	hTR = uicontrol( ...
        'Style','edit', ...
        'Units','normalized', ...
	'Position',btnPos, ...
        'Horiz','center', ...
        'Background','white', ...
        'Foreground','black', ...
        'String','3000',...
	'Value',3000,...
        'callback',callbackStr,...
	'Enable','on');

	%===================================
    	% Number of Shots per Cycle
    	%===================================
	yPos=menutop-(btnNumber-1)*(btnHt+spacing);
    	btnPos=[left yPos-btnHtEdit 2.*btnWid./6 btnHtEdit./2];
    
	hNShotPerCycleText = uicontrol( ...
        'Style','text', ...
        'Units','normalized', ...
	'Position',btnPos, ...
        'Horiz','left', ...
        'Foreground','black', ...
        'String','  Shots per Cycle',...
	'Enable','on');

	btnPos=[left+btnWid./3 yPos-btnHtEdit btnWid./6 btnHtEdit./2];
	callbackStr = 'fMRIMenu(''setNShotPerCycle'')';
    
	hNShotPerCycle = uicontrol( ...
        'Style','edit', ...
        'Units','normalized', ...
	'Position',btnPos, ...
        'Horiz','center', ...
        'Background','white', ...
        'Foreground','black', ...
        'String','4',...
	'Value',4,...
        'callback',callbackStr,...
	'Enable','on');

	%===================================
    	% Sampling
    	%===================================
	yPos=menutop-(btnNumber-1)*(btnHt+spacing);
    	btnPos=[left+btnWid./2 yPos-btnHtEdit./2 2.*btnWid./6 btnHtEdit./2];
    
	hSamplingText = uicontrol( ...
        'Style','text', ...
        'Units','normalized', ...
	'Position',btnPos, ...
        'Horiz','left', ...
        'Foreground','black', ...
        'String','  Sampling',...
	'Enable','on');

	btnPos=[left+btnWid./2+2.*btnWid./6 yPos-btnHtEdit./2 btnWid./6 1.*btnHtEdit./2];
	callbackStr = 'fMRIMenu(''setSampling'')';
    
	hSampling = uicontrol( ...
        'Style','edit', ...
        'Units','normalized', ...
	'Position',btnPos, ...
        'Horiz','center', ...
        'Background','white', ...
        'Foreground','black', ...
        'String','1',...
	'Value',1,...
	'Userdata',1,...
        'callback',callbackStr,...
	'Enable','off');
	
	%===================================
    	% Batch Sampling
    	%===================================
	yPos=menutop-(btnNumber-1)*(btnHt+spacing);
    	btnPos=[left+btnWid./2 yPos-btnHtEdit 2.*btnWid./6 btnHtEdit./2];
    
	hBatchSamplingText = uicontrol( ...
        'Style','text', ...
        'Units','normalized', ...
	'Position',btnPos, ...
        'Horiz','left', ...
        'Foreground','black', ...
        'String','Batch Sampling',...
	'Enable','on');

	btnPos=[left+btnWid./2+2.*btnWid./6 yPos-btnHtEdit btnWid./6 1.*btnHtEdit./2];
	callbackStr = 'fMRIMenu(''setBatchSampling'')';
    
	hBatchSampling = uicontrol( ...
        'Style','edit', ...
        'Units','normalized', ...
	'Position',btnPos, ...
        'Horiz','center', ...
        'Background','white', ...
        'Foreground','black', ...
        'String','1',...
	'Value',1,...
	'Userdata',1,...
        'callback',callbackStr,...
	'Enable','on');
	
	%=====================
	%Independent Students T-Test 2-1
	%=====================
	btnNumber = 6;
	yPos = menutop-(btnNumber-1)*(btnHt+spacing);
	btnPos = [left yPos-btnHt./2-delta btnWid/4 btnHt./2];
	callbackStr = 'fMRIMenu(''CalcIndT21'')';
	hCalcIndT21=uicontrol(...
         'Style','pushbutton',...
		 'Units','Normalized',...
		 'Position',btnPos,...
		 'String','  Ind. T-Test 2-1',...
		 'Callback',callbackStr,...
		 'Enable','off');	 
		 
	%=====================
	%Independent Students T-Test 1-2
	%=====================
	btnNumber = 6;
	yPos = menutop-(btnNumber-1)*(btnHt+spacing);
	btnPos = [left yPos-btnHt-delta btnWid/4 btnHt./2];
	callbackStr = 'fMRIMenu(''CalcIndT12'')';
	hCalcIndT12=uicontrol(...
         'Style','pushbutton',...
		 'Units','Normalized',...
		 'Position',btnPos,...
		 'String','  Ind. T-Test 1-2',...
		 'Callback',callbackStr,...
		 'Enable','off');	 
		 
	%=====================
	%PlotIndTPosVal
	%=====================
	yPos = menutop-(btnNumber-1)*(btnHt+spacing);
	btnPos = [left+btnWid/4 yPos-btnHt./2-delta btnWid/4 btnHt./2];
	callbackStr = 'fMRIMenu(''PlotIndTPosVal'')';
	hPlotIndTPosVal= uicontrol(...
        	 'Style','pushbutton',...
		 'Units','Normalized',...
		 'Position',btnPos,...
		 'String','Plot Pos. t.',...
		 'Callback',callbackStr,...
		 'Enable','off');
	
	%=====================
	%PlotIndTNegVal
	%=====================
	yPos = menutop-(btnNumber-1)*(btnHt+spacing);
	btnPos = [left+btnWid/4 yPos-btnHt-delta btnWid/4 btnHt./2];
	callbackStr = 'fMRIMenu(''PlotIndTNegVal'')';
	hPlotIndTNegVal= uicontrol(...
        	 'Style','pushbutton',...
		 'Units','Normalized',...
		 'Position',btnPos,...
		 'String','Plot Neg. t.',...
		 'Callback',callbackStr,...
		 'Enable','off');
		 
	%=====================
	%PlotIndTPosLag
	%=====================
	yPos = menutop-(btnNumber-1)*(btnHt+spacing);
	btnPos = [left+btnWid/2 yPos-btnHt./2-delta btnWid/4 btnHt./2];
	callbackStr = 'fMRIMenu(''PlotIndTPosLag'')';
	hPlotIndTPosLag= uicontrol(...
        	 'Style','pushbutton',...
		 'Units','Normalized',...
		 'Position',btnPos,...
		 'String','Plot Pos. Lag',...
		 'Callback',callbackStr,...
		 'Enable','off');
	
	%=====================
	%PlotIndTNegLag
	%=====================
	yPos = menutop-(btnNumber-1)*(btnHt+spacing);
	btnPos = [left+btnWid/2 yPos-btnHt-delta btnWid/4 btnHt./2];
	callbackStr = 'fMRIMenu(''PlotIndTNegLag'')';
	hPlotIndTNegLag= uicontrol(...
        	 'Style','pushbutton',...
		 'Units','Normalized',...
		 'Position',btnPos,...
		 'String','Plot Neg. Lag',...
		 'Callback',callbackStr,...
		 'Enable','off');
		 
	%=====================
	%Plot  Ind. t-Test Single Slice 
	%=====================
	yPos = menutop-(btnNumber-1)*(btnHt+spacing);
	btnPos = [left+3.*btnWid/4 yPos-btnHt-delta btnWid/4 btnHt];
	callbackStr = 'fMRIMenu(''PlotIndTSlice'')';
	hPlotIndTSlice = uicontrol(...
         	'Style','popupmenu', ...
		 'Units','Normalized',...
		 'Position',btnPos,...
		 'String','Plot Slice.',...
		 'Callback',callbackStr,...
		  'Value',1,...
		 'Enable','off');
		 
	%=====================
	%Plot  Ind. t-Test Set Actual
	%=====================
	yPos = menutop-(btnNumber-1)*(btnHt+spacing);
	btnPos = [left+3.*btnWid/4 yPos-btnHt-delta btnWid/4 btnHt./2];
	callbackStr = 'fMRIMenu(''SetIndTActual'')';
	hSetIndTActual= uicontrol(...
        	 'Style','pushbutton',...
		 'Units','Normalized',...
		 'Position',btnPos,...
		 'String','Not Actual',...
		 'Callback',callbackStr,...
		 'Value',1,...
		 'Enable','off');
		 
	%===================================
    	% IndTBase
    	%===================================
	btnNumber=7;     
	yPos=menutop-(btnNumber-1)*(btnHt+spacing);
    	btnPos=[left yPos-btnHtEdit./2 2.*btnWid./6 btnHtEdit./2];
    
	hIndTBaseText = uicontrol( ...
        'Style','text', ...
        'Units','normalized', ...
	'Position',btnPos, ...
        'Horiz','left', ...
        'Foreground','black', ...
        'String','  Ind T-Test Base',...
	'Enable','on');

	btnPos=[left+2.*btnWid./6 yPos-btnHtEdit./2 btnWid./6 1.*btnHtEdit./2];
	callbackStr = 'fMRIMenu(''setIndTBase'')';
    
	hIndTBase = uicontrol( ...
        'Style','edit', ...
        'Units','normalized', ...
	'Position',btnPos, ...
        'Horiz','center', ...
        'Background','white', ...
        'Foreground','black', ...
        'String','4',...
	'Value',4,...
        'callback',callbackStr,...
	'Enable','on');
	
	%===================================
    	% IndTMinLag
    	%===================================
	btnNumber=7;     
	yPos=menutop-(btnNumber-1)*(btnHt+spacing);
    	btnPos=[left+btnWid./2 yPos-btnHtEdit./2 2.*btnWid./6 btnHtEdit./2];
    
	hIndTMinLagText = uicontrol( ...
        'Style','text', ...
        'Units','normalized', ...
	'Position',btnPos, ...
        'Horiz','left', ...
        'Foreground','black', ...
        'String','  Ind T-Test Min. Lag',...
	'Enable','on');

	btnPos=[left+5.*btnWid./6 yPos-btnHtEdit./2 btnWid./6 1.*btnHtEdit./2];
	callbackStr = 'fMRIMenu(''setIndTMinLag'')';
    
	hIndTMinLag = uicontrol( ...
        'Style','edit', ...
        'Units','normalized', ...
	'Position',btnPos, ...
        'Horiz','center', ...
        'Background','white', ...
        'Foreground','black', ...
        'String','0',...
	'Value',0,...
        'callback',callbackStr,...
	'Enable','on');

	%===================================
    	% IndTMaxLag
    	%===================================
	btnNumber=7;     
	yPos=menutop-(btnNumber-1)*(btnHt+spacing);
    	btnPos=[left+btnWid./2 yPos-btnHtEdit 2.*btnWid./6 btnHtEdit./2];
    
	hIndTMaxLagText = uicontrol( ...
        'Style','text', ...
        'Units','normalized', ...
	'Position',btnPos, ...
        'Horiz','left', ...
        'Foreground','black', ...
        'String','  Ind T-Test Max. Lag',...
	'Enable','on');

	btnPos=[left+5.*btnWid./6 yPos-btnHtEdit btnWid./6 1.*btnHtEdit./2];
	callbackStr = 'fMRIMenu(''setIndTMaxLag'')';
    
	hIndTMaxLag = uicontrol( ...
        'Style','edit', ...
        'Units','normalized', ...
	'Position',btnPos, ...
        'Horiz','center', ...
        'Background','white', ...
        'Foreground','black', ...
        'String','3',...
	'Value',3,...
        'callback',callbackStr,...
	'Enable','on');

	%===================================
    	% IndTPosMin
    	%===================================
	btnNumber=8;     
	yPos=menutop-(btnNumber-1)*(btnHt+spacing);
    	btnPos=[left yPos-btnHtEdit./2 2.*btnWid./6 btnHtEdit./2];
    
	hIndTPosMinText = uicontrol( ...
        'Style','text', ...
        'Units','normalized', ...
	'Position',btnPos, ...
        'Horiz','left', ...
        'Foreground','black', ...
        'String','  Ind T-Test Pos. Min.',...
	'Enable','on');

	btnPos=[left+2.*btnWid./6 yPos-btnHtEdit./2 btnWid./6 1.*btnHtEdit./2];
	callbackStr = 'fMRIMenu(''setIndTPosMin'')';
    
	hIndTPosMin = uicontrol( ...
        'Style','edit', ...
        'Units','normalized', ...
	'Position',btnPos, ...
        'Horiz','center', ...
        'Background','white', ...
        'Foreground','black', ...
        'String','2.4',...
	'Value',2.4,...
        'callback',callbackStr,...
	'Enable','on');

	%===================================
    	% IndTPosMax
    	%===================================
	yPos=menutop-(btnNumber-1)*(btnHt+spacing);
    	btnPos=[left yPos-btnHtEdit 2.*btnWid./6 btnHtEdit./2];
    
	hIndTPosMaxText = uicontrol( ...
        'Style','text', ...
        'Units','normalized', ...
	'Position',btnPos, ...
        'Horiz','left', ...
        'Foreground','black', ...
        'String','  Ind T-Test Pos. Max.',...
	'Enable','on');

	btnPos=[left+2.*btnWid./6 yPos-btnHtEdit btnWid./6 1.*btnHtEdit./2];
	callbackStr = 'fMRIMenu(''setIndTPosMax'')';
    
	hIndTPosMax = uicontrol( ...
        'Style','edit', ...
        'Units','normalized', ...
	'Position',btnPos, ...
        'Horiz','center', ...
        'Background','white', ...
        'Foreground','black', ...
        'String','100',...
	'Value',100,...
        'callback',callbackStr,...
	'Enable','on');
	
	%===================================
    	% IndTNegMin
    	%===================================
	btnNumber=8;     
	yPos=menutop-(btnNumber-1)*(btnHt+spacing);
    	btnPos=[left+btnWid./2 yPos-btnHtEdit./2 btnWid./3 btnHtEdit./2];
    
	hIndTNegMinText = uicontrol( ...
        'Style','text', ...
        'Units','normalized', ...
	'Position',btnPos, ...
        'Horiz','left', ...
        'Foreground','black', ...
        'String','  Ind T-Test Neg. Min.',...
	'Enable','on');

	btnPos=[left+5.*btnWid./6 yPos-btnHtEdit./2 btnWid./6 1.*btnHtEdit./2];
	callbackStr = 'fMRIMenu(''setIndTNegMin'')';
    
	hIndTNegMin = uicontrol( ...
        'Style','edit', ...
        'Units','normalized', ...
	'Position',btnPos, ...
        'Horiz','center', ...
        'Background','white', ...
        'Foreground','black', ...
        'String','-2.4',...
	'Value',-2.4,...
        'callback',callbackStr,...
	'Enable','on');

	%===================================
    	% IndTNegMax
    	%===================================
	yPos=menutop-(btnNumber-1)*(btnHt+spacing);
    	btnPos=[left+btnWid./2 yPos-btnHtEdit 2.*btnWid./6 btnHtEdit./2];
    
	hIndTNegMaxText = uicontrol( ...
        'Style','text', ...
        'Units','normalized', ...
	'Position',btnPos, ...
        'Horiz','left', ...
        'Foreground','black', ...
        'String','  Ind T-Test Neg. Max.',...
	'Enable','on');

	btnPos=[left+5.*btnWid./6 yPos-btnHtEdit btnWid./6 1.*btnHtEdit./2];
	callbackStr = 'fMRIMenu(''setIndTNegMax'')';
    
	hIndTNegMax = uicontrol( ...
        'Style','edit', ...
        'Units','normalized', ...
	'Position',btnPos, ...
        'Horiz','center', ...
        'Background','white', ...
        'Foreground','black', ...
        'String','-100',...
	'Value',-100,...
        'callback',callbackStr,...
	'Enable','on');
	
	%=====================
	%Dependent Students T-Test 2-1
	%=====================
	btnNumber = 9;
	yPos = menutop-(btnNumber-1)*(btnHt+spacing);
	btnPos = [left yPos-btnHt./2-delta btnWid/4 btnHt./2];
	callbackStr = 'fMRIMenu(''CalcDepT21'')';
	hCalcDepT21=uicontrol(...
         'Style','pushbutton',...
		 'Units','Normalized',...
		 'Position',btnPos,...
		 'String','  Dep. T-Test 2-1 ',...
		 'Callback',callbackStr,...
		 'Enable','off');	 
		 
	%=====================
	%Dependent Students T-Test 1-2
	%=====================
	btnNumber = 9;
	yPos = menutop-(btnNumber-1)*(btnHt+spacing);
	btnPos = [left yPos-btnHt-delta btnWid/4 btnHt./2];
	callbackStr = 'fMRIMenu(''CalcDepT12'')';
	hCalcDepT12=uicontrol(...
         'Style','pushbutton',...
		 'Units','Normalized',...
		 'Position',btnPos,...
		 'String','  Dep. T-Test 1-2 ',...
		 'Callback',callbackStr,...
		 'Enable','off');	 
		 
	%=====================
	%PlotDepTPosVal
	%=====================
	yPos = menutop-(btnNumber-1)*(btnHt+spacing);
	btnPos = [left+btnWid/4 yPos-btnHt./2-delta btnWid/4 btnHt./2];
	callbackStr = 'fMRIMenu(''PlotDepTPosVal'')';
	hPlotDepTPosVal= uicontrol(...
        	 'Style','pushbutton',...
		 'Units','Normalized',...
		 'Position',btnPos,...
		 'String','Plot Pos. Dep.',...
		 'Callback',callbackStr,...
		 'Enable','off');
	
	%=====================
	%PlotDepTNegVal
	%=====================
	yPos = menutop-(btnNumber-1)*(btnHt+spacing);
	btnPos = [left+btnWid/4 yPos-btnHt-delta btnWid/4 btnHt./2];
	callbackStr = 'fMRIMenu(''PlotDepTNegVal'')';
	hPlotDepTNegVal= uicontrol(...
        	 'Style','pushbutton',...
		 'Units','Normalized',...
		 'Position',btnPos,...
		 'String','Plot Neg. Dep.',...
		 'Callback',callbackStr,...
		 'Enable','off');
	
	%=====================
	%PlotDepTPosLag
	%=====================
	yPos = menutop-(btnNumber-1)*(btnHt+spacing);
	btnPos = [left+btnWid/2 yPos-btnHt./2-delta btnWid/4 btnHt./2];
	callbackStr = 'fMRIMenu(''PlotDepTPosLag'')';
	hPlotDepTPosLag= uicontrol(...
        	 'Style','pushbutton',...
		 'Units','Normalized',...
		 'Position',btnPos,...
		 'String','Plot Pos. Lag',...
		 'Callback',callbackStr,...
		 'Enable','off');
	
	%=====================
	%PlotDepTNegLag
	%=====================
	yPos = menutop-(btnNumber-1)*(btnHt+spacing);
	btnPos = [left+btnWid/2 yPos-btnHt-delta btnWid/4 btnHt./2];
	callbackStr = 'fMRIMenu(''PlotDepTNegLag'')';
	hPlotDepTNegLag= uicontrol(...
        	 'Style','pushbutton',...
		 'Units','Normalized',...
		 'Position',btnPos,...
		 'String','Plot Neg. Lag',...
		 'Callback',callbackStr,...
		 'Enable','off');
		 
	%=====================
	%Plot  Dep. t-Test Single Slice 
	%=====================
	yPos = menutop-(btnNumber-1)*(btnHt+spacing);
	btnPos = [left+3.*btnWid/4 yPos-btnHt-delta btnWid/4 btnHt];
	callbackStr = 'fMRIMenu(''PlotDepTSlice'')';
	hPlotDepTSlice = uicontrol(...
         	'Style','popupmenu', ...
		 'Units','Normalized',...
		 'Position',btnPos,...
		 'String','Plot Slice.',...
		 'Callback',callbackStr,...
		  'Value',1,...
		 'Enable','off');
	
	%=====================
	%Plot  Dep. t-Test Set Actual
	%=====================
	yPos = menutop-(btnNumber-1)*(btnHt+spacing);
	btnPos = [left+3.*btnWid/4 yPos-btnHt-delta btnWid/4 btnHt./2];
	callbackStr = 'fMRIMenu(''SetDepTActual'')';
	hSetDepTActual= uicontrol(...
        	 'Style','pushbutton',...
		 'Units','Normalized',...
		 'Position',btnPos,...
		 'String','Not Actual',...
		 'Callback',callbackStr,...
		 'Value',1,...
		 'Enable','off');
		 
	%===================================
    	% DepTBase
    	%===================================
	btnNumber=10;     
	yPos=menutop-(btnNumber-1)*(btnHt+spacing);
    	btnPos=[left yPos-btnHtEdit./2 2.*btnWid./6 btnHtEdit./2];
	hDepTBaseText = uicontrol( ...
        'Style','text', ...
        'Units','normalized', ...
	'Position',btnPos, ...
        'Horiz','left', ...
        'Foreground','black', ...
        'String','  Dep. T-Test Base',...
	'Enable','on');

	btnPos=[left+2.*btnWid./6 yPos-btnHtEdit./2 btnWid./6 1.*btnHtEdit./2];
	callbackStr = 'fMRIMenu(''setDepTBase'')';
	hDepTBase = uicontrol( ...
        'Style','edit', ...
        'Units','normalized', ...
	'Position',btnPos, ...
        'Horiz','center', ...
        'Background','white', ...
        'Foreground','black', ...
        'String','4',...
	'Value',4,...
        'callback',callbackStr,...
	'Enable','on');

	%===================================
    	% DepTMinLag
    	%===================================
	btnNumber=10;     
	yPos=menutop-(btnNumber-1)*(btnHt+spacing);
    	btnPos=[left+btnWid./2 yPos-btnHtEdit./2 2.*btnWid./6 btnHtEdit./2];
    
	hDepTMinLagText = uicontrol( ...
        'Style','text', ...
        'Units','normalized', ...
	'Position',btnPos, ...
        'Horiz','left', ...
        'Foreground','black', ...
        'String','  Dep. T-Test Min. Lag',...
	'Enable','on');

	btnPos=[left+5.*btnWid./6 yPos-btnHtEdit./2 btnWid./6 1.*btnHtEdit./2];
	callbackStr = 'fMRIMenu(''setDepTMinLag'')';
    
	hDepTMinLag = uicontrol( ...
        'Style','edit', ...
        'Units','normalized', ...
	'Position',btnPos, ...
        'Horiz','center', ...
        'Background','white', ...
        'Foreground','black', ...
        'String','0',...
	'Value',0,...
        'Callback',callbackStr,...
	'Enable','on');

	%===================================
    	% DepTMaxLag
    	%===================================
	btnNumber=10;     
	yPos=menutop-(btnNumber-1)*(btnHt+spacing);
    	btnPos=[left+btnWid./2 yPos-btnHtEdit 2.*btnWid./6 btnHtEdit./2];
    
	hDepTMaxLagText = uicontrol( ...
        'Style','text', ...
        'Units','normalized', ...
	'Position',btnPos, ...
        'Horiz','left', ...
        'Foreground','black', ...
        'String','  Dep T-Test Max. Lag',...
	'Enable','on');

	btnPos=[left+5.*btnWid./6 yPos-btnHtEdit btnWid./6 1.*btnHtEdit./2];
	callbackStr = 'fMRIMenu(''setDepTMaxLag'')';
    
	hDepTMaxLag = uicontrol( ...
        'Style','edit', ...
        'Units','normalized', ...
	'Position',btnPos, ...
        'Horiz','center', ...
        'Background','white', ...
        'Foreground','black', ...
        'String','3',...
	'Value',3,...
        'Callback',callbackStr,...
	'Enable','on');

	%===================================
    	% DepTPosMin
    	%===================================
	btnNumber=11;     
	yPos=menutop-(btnNumber-1)*(btnHt+spacing);
    	btnPos=[left yPos-btnHtEdit./2 2.*btnWid./6 btnHtEdit./2];
	hDepTPosMinText = uicontrol( ...
        'Style','text', ...
        'Units','normalized', ...
	'Position',btnPos, ...
        'Horiz','left', ...
        'Foreground','black', ...
        'String','  Dep. T-Test Min.',...
	'Enable','on');

	btnPos=[left+2.*btnWid./6 yPos-btnHtEdit./2 btnWid./6 btnHtEdit./2];
	callbackStr = 'fMRIMenu(''setDepTPosMin'')';
	hDepTPosMin = uicontrol( ...
        'Style','edit', ...
        'Units','normalized', ...
	'Position',btnPos, ...
        'Horiz','center', ...
        'Background','white', ...
        'Foreground','black', ...
        'String','2.4',...
	'Value',2.4,...
        'callback',callbackStr,...
	'Enable','on');

	%===================================
    	% DepTPosMax
    	%===================================
	yPos=menutop-(btnNumber-1)*(btnHt+spacing);
    	btnPos=[left yPos-btnHtEdit 2.*btnWid./6 btnHtEdit./2];
	hDepTPosMaxText = uicontrol( ...
        'Style','text', ...
        'Units','normalized', ...
	'Position',btnPos, ...
        'Horiz','left', ...
        'Foreground','black', ...
        'String','  Dep. T-Test Max.',...
	'Enable','on');

	btnPos=[left+2.*btnWid./6 yPos-btnHtEdit btnWid./6 btnHtEdit./2];
	callbackStr = 'fMRIMenu(''setDepTPosMax'')';
    
	hDepTPosMax = uicontrol( ...
        'Style','edit', ...
        'Units','normalized', ...
	'Position',btnPos, ...
        'Horiz','center', ...
        'Background','white', ...
        'Foreground','black', ...
        'String','100',...
	'Value',100,...
        'callback',callbackStr,...
	'Enable','on');
	
	%===================================
    	% DepTNegMin
    	%===================================
	yPos=menutop-(btnNumber-1)*(btnHt+spacing);
    	btnPos=[left+btnWid./2 yPos-btnHtEdit./2 btnWid./3 btnHtEdit./2];
    
	hDepTNegMinText = uicontrol( ...
        'Style','text', ...
        'Units','normalized', ...
	'Position',btnPos, ...
        'Horiz','left', ...
        'Foreground','black', ...
        'String','  Dep T-Test Neg. Min.',...
	'Enable','on');

	btnPos=[left+5.*btnWid./6 yPos-btnHtEdit./2 btnWid./6 1.*btnHtEdit./2];
	callbackStr = 'fMRIMenu(''setDepTNegMin'')';
    
	hDepTNegMin = uicontrol( ...
        'Style','edit', ...
        'Units','normalized', ...
	'Position',btnPos, ...
        'Horiz','center', ...
        'Background','white', ...
        'Foreground','black', ...
        'String','-2.4',...
	'Value',-2.4,...
        'callback',callbackStr,...
	'Enable','on');

	%===================================
    	% DepTNegMax
    	%===================================
	yPos=menutop-(btnNumber-1)*(btnHt+spacing);
    	btnPos=[left+btnWid./2 yPos-btnHtEdit 2.*btnWid./6 btnHtEdit./2];
    
	hDepTNegMaxText = uicontrol( ...
        'Style','text', ...
        'Units','normalized', ...
	'Position',btnPos, ...
        'Horiz','left', ...
        'Foreground','black', ...
        'String','  Dep T-Test Neg. Max.',...
	'Enable','on');

	btnPos=[left+5.*btnWid./6 yPos-btnHtEdit btnWid./6 1.*btnHtEdit./2];
	callbackStr = 'fMRIMenu(''setDepTNegMax'')';
    
	hDepTNegMax = uicontrol( ...
        'Style','edit', ...
        'Units','normalized', ...
	'Position',btnPos, ...
        'Horiz','center', ...
        'Background','white', ...
        'Foreground','black', ...
        'String','-100',...
	'Value',-100,...
        'callback',callbackStr,...
	'Enable','on');
	
	%=====================
	%CalcXCorr
	%=====================
	btnNumber = 12;
	yPos = menutop-(btnNumber-1)*(btnHt+spacing);
	btnPos = [left yPos-btnHt-delta btnWid/4 btnHt];
	callbackStr = 'fMRIMenu(''CalcXCorr'')';
	hCalcXCorr = uicontrol(...
         'Style','pushbutton',...
		 'Units','Normalized',...
		 'Position',btnPos,...
		 'String','X-Corr Function',...
		 'Callback',callbackStr,...
		 'Enable','off');	 
		 
	%=====================
	%PlotXCorrVal
	%=====================
	yPos = menutop-(btnNumber-1)*(btnHt+spacing);
	btnPos = [left+btnWid/4 yPos-btnHt-delta btnWid/4 btnHt];
	callbackStr = 'fMRIMenu(''PlotXCorrVal'')';
	hPlotXCorrVal= uicontrol(...
        	 'Style','pushbutton',...
		 'Units','Normalized',...
		 'Position',btnPos,...
		 'String','Plot Max. Value',...
		 'Callback',callbackStr,...
		 'Enable','off');
	%=====================
	%PlotXCorrLag
	%=====================
	yPos = menutop-(btnNumber-1)*(btnHt+spacing);
	btnPos = [left+btnWid/2 yPos-btnHt-delta btnWid/4 btnHt];
	callbackStr = 'fMRIMenu(''PlotXCorrLag'')';
	hPlotXCorrLag= uicontrol(...
        	 'Style','pushbutton',...
		 'Units','Normalized',...
		 'Position',btnPos,...
		 'String','Plot Max. Lag',...
		 'Callback',callbackStr,...
		 'Enable','off');
		 
	%=====================
	%Plot  X-Corr Single Slice 
	%=====================
	yPos = menutop-(btnNumber-1)*(btnHt+spacing);
	btnPos = [left+3.*btnWid/4 yPos-btnHt-delta btnWid/4 btnHt];
	callbackStr = 'fMRIMenu(''PlotXCorrSlice'')';
	hPlotXCorrSlice = uicontrol(...
         	'Style','popupmenu', ...
		 'Units','Normalized',...
		 'Position',btnPos,...
		 'String','Plot Slice.',...
		 'Callback',callbackStr,...
		  'Value',1,...
		 'Enable','off');
	
	%=====================
	%  X-Corr Set Actual
	%=====================
	yPos = menutop-(btnNumber-1)*(btnHt+spacing);
	btnPos = [left+3.*btnWid/4 yPos-btnHt-delta btnWid/4 btnHt./2];
	callbackStr = 'fMRIMenu(''SetXCorrActual'')';
	hSetXCorrActual= uicontrol(...
        	 'Style','pushbutton',...
		 'Units','Normalized',...
		 'Position',btnPos,...
		 'String','Not Actual',...
		 'Callback',callbackStr,...
		 'Value',1,...
		 'Enable','off');
		 
	%===================================
    	% XCorrBase
    	%===================================
	btnNumber=13;     
	yPos=menutop-(btnNumber-1)*(btnHt+spacing);
    	btnPos=[left yPos-btnHtEdit./2 2.*btnWid./6 btnHtEdit./2];
	hXCorrBaseText = uicontrol( ...
        'Style','text', ...
        'Units','normalized', ...
	'Position',btnPos, ...
        'Horiz','left', ...
        'Foreground','black', ...
        'String','  XCorr Base.',...
	'Enable','on');

	btnPos=[left+2.*btnWid./6 yPos-btnHtEdit./2 btnWid./6 1.*btnHtEdit./2];
	callbackStr = 'fMRIMenu(''setXCorrBase'')';
    
	hXCorrBase = uicontrol( ...
        'Style','edit', ...
        'Units','normalized', ...
	'Position',btnPos, ...
        'Horiz','center', ...
        'Background','white', ...
        'Foreground','black', ...
        'String','4',...
	'Value',4,...
        'callback',callbackStr,...
	'Enable','on');

	%===================================
    	% XCorrMinLag
    	%===================================
	btnNumber=13;     
	yPos=menutop-(btnNumber-1)*(btnHt+spacing);
    	btnPos=[left+btnWid./2 yPos-btnHtEdit./2 2.*btnWid./6 btnHtEdit./2];
	hXCorrMinLagText = uicontrol( ...
        'Style','text', ...
        'Units','normalized', ...
	'Position',btnPos, ...
        'Horiz','left', ...
        'Foreground','black', ...
        'String','  XCorr Min. Lag.',...
	'Enable','on');

	btnPos=[left+5.*btnWid./6 yPos-btnHtEdit./2 btnWid./6 1.*btnHtEdit./2];
	callbackStr = 'fMRIMenu(''setXCorrMinLag'')';
    
	hXCorrMinLag = uicontrol( ...
        'Style','edit', ...
        'Units','normalized', ...
	'Position',btnPos, ...
        'Horiz','center', ...
        'Background','white', ...
        'Foreground','black', ...
        'String','-3',...
	'Value',-3,...
        'callback',callbackStr,...
	'Enable','on');

	%===================================
    	% XCorrMaxLag
    	%===================================
	btnNumber=13;     
	yPos=menutop-(btnNumber-1)*(btnHt+spacing);
    	btnPos=[left+btnWid./2 yPos-btnHtEdit 2.*btnWid./6 btnHtEdit./2];
	hXCorrMaxLagText = uicontrol( ...
        'Style','text', ...
        'Units','normalized', ...
	'Position',btnPos, ...
        'Horiz','left', ...
        'Foreground','black', ...
        'String','  XCorr Max. Lag.',...
	'Enable','on');

	btnPos=[left+5.*btnWid./6 yPos-btnHtEdit btnWid./6 1.*btnHtEdit./2];
	callbackStr = 'fMRIMenu(''setXCorrMaxLag'')';
    
	hXCorrMaxLag = uicontrol( ...
        'Style','edit', ...
        'Units','normalized', ...
	'Position',btnPos, ...
        'Horiz','center', ...
        'Background','white', ...
        'Foreground','black', ...
        'String','3',...
	'Value',3,...
        'callback',callbackStr,...
	'Enable','on');

	%===================================
    	% XCorrMin1
    	%===================================
	btnNumber=14;     
	yPos=menutop-(btnNumber-1)*(btnHt+spacing);
    	btnPos=[left yPos-btnHtEdit./2 2.*btnWid./6 btnHtEdit./2];
    
	hXCorrMin1Text = uicontrol( ...
        'Style','text', ...
        'Units','normalized', ...
	'Position',btnPos, ...
        'Horiz','left', ...
        'Foreground','black', ...
        'String','  XCorr Min. of Value ',...
	'Enable','on');

	btnPos=[left+2.*btnWid./6 yPos-btnHtEdit./2 btnWid./6 btnHtEdit./2];
	callbackStr = 'fMRIMenu(''setXCorrMin1'')';
    
	hXCorrMin1 = uicontrol( ...
        'Style','edit', ...
        'Units','normalized', ...
	'Position',btnPos, ...
        'Horiz','center', ...
        'Background','white', ...
        'Foreground','black', ...
        'String','0',...
	'Value',0,...
        'callback',callbackStr,...
	'Enable','on');

	%===================================
    	% XCorrMax1
    	%===================================
	yPos=menutop-(btnNumber-1)*(btnHt+spacing);
    	btnPos=[left yPos-btnHtEdit 2.*btnWid./6 btnHtEdit./2];
    
	hXCorrMax1Text = uicontrol( ...
        'Style','text', ...
        'Units','normalized', ...
	'Position',btnPos, ...
        'Horiz','left', ...
        'Foreground','black', ...
        'String','  XCorr Max. of Value',...
	'Enable','on');

	btnPos=[left+2.*btnWid./6 yPos-btnHtEdit btnWid./6 btnHtEdit./2];
	callbackStr = 'fMRIMenu(''setXCorrMax1'')';
    
	hXCorrMax1 = uicontrol( ...
        'Style','edit', ...
        'Units','normalized', ...
	'Position',btnPos, ...
        'Horiz','center', ...
        'Background','white', ...
        'Foreground','black', ...
        'String','100',...
	'Value',100,...
        'callback',callbackStr,...
	'Enable','on');
	
	%===================================
    	% XCorrMin2
    	%===================================
	yPos=menutop-(btnNumber-1)*(btnHt+spacing);
    	btnPos=[left+btnWid./2 yPos-btnHtEdit./2 2.*btnWid./6 btnHtEdit./2];
    
	hXCorrMin2Text = uicontrol( ...
        'Style','text', ...
        'Units','normalized', ...
	'Position',btnPos, ...
        'Horiz','left', ...
        'Foreground','black', ...
        'String','  XCorr Min. of Index',...
	'Enable','on');

	btnPos=[left+btnWid./2+2.*btnWid./6 yPos-btnHtEdit./2 btnWid./6 1.*btnHtEdit./2];
	callbackStr = 'fMRIMenu(''setXCorrMin2'')';
    
	hXCorrMin2 = uicontrol( ...
        'Style','edit', ...
        'Units','normalized', ...
	'Position',btnPos, ...
        'Horiz','center', ...
        'Background','white', ...
        'Foreground','black', ...
        'String','0',...
	'Value',0,...
        'callback',callbackStr,...
	'Enable','on');

	%===================================
    	% XCorrMax
    	%===================================
	yPos=menutop-(btnNumber-1)*(btnHt+spacing);
    	btnPos=[left+btnWid./2 yPos-btnHtEdit 2.*btnWid./6 btnHtEdit./2];
    
	hXCorrMax2Text = uicontrol( ...
        'Style','text', ...
        'Units','normalized', ...
	'Position',btnPos, ...
        'Horiz','left', ...
        'Foreground','black', ...
        'String','  XCorr Max. of Index',...
	'Enable','on');

	btnPos=[left+btnWid./2+2.*btnWid./6 yPos-btnHtEdit btnWid./6 1.*btnHtEdit./2];
	callbackStr = 'fMRIMenu(''setXCorrMax2'')';
    
	hXCorrMax2 = uicontrol( ...
        'Style','edit', ...
        'Units','normalized', ...
	'Position',btnPos, ...
        'Horiz','center', ...
        'Background','white', ...
        'Foreground','black', ...
        'String','100',...
	'Value',100,...
        'callback',callbackStr,...
	'Enable','on');

	%=====================
	%Calculate Mutual Information
	%=====================
	btnNumber = 15;
	yPos = menutop-(btnNumber-1)*(btnHt+spacing);
	btnPos = [left yPos-btnHt-delta btnWid/4 btnHt];
	callbackStr = 'fMRIMenu(''CalcMutInfo'')';
	hCalcMutInfo = uicontrol(...
        'Style','pushbutton',...
	'Units','Normalized',...
	'Position',btnPos,...
	'String','Mutual Info',...
	'Callback',callbackStr,...
	'Enable','off');
	
	%=====================
	%Plot Mutual Information CS Value
	%=====================
	yPos = menutop-(btnNumber-1)*(btnHt+spacing);
	btnPos = [left+btnWid/4 yPos-btnHt./2-delta btnWid/4 btnHt./2];
	callbackStr = 'fMRIMenu(''PlotMutInfoCSVal'')';
	hPlotMutInfoCSVal= uicontrol(...
        	 'Style','pushbutton',...
		 'Units','Normalized',...
		 'Position',btnPos,...
		 'String','Plot CS.',...
		 'Callback',callbackStr,...
		 'Enable','off');
		 
	%=====================
	%Plot Mutual Information IS Value
	%=====================
	yPos = menutop-(btnNumber-1)*(btnHt+spacing);
	btnPos = [left+btnWid/4 yPos-btnHt-delta btnWid/4 btnHt./2];
	callbackStr = 'fMRIMenu(''PlotMutInfoISVal'')';
	hPlotMutInfoISVal= uicontrol(...
        	 'Style','pushbutton',...
		 'Units','Normalized',...
		 'Position',btnPos,...
		 'String','Plot IS.',...
		 'Callback',callbackStr,...
		 'Enable','off');
	
	%=====================
	%Plot Mutual Information CS Lag
	%=====================
	yPos = menutop-(btnNumber-1)*(btnHt+spacing);
	btnPos = [left+btnWid/2 yPos-btnHt./2-delta btnWid/4 btnHt./2];
	callbackStr = 'fMRIMenu(''PlotMutInfoCSLag'')';
	hPlotMutInfoCSLag= uicontrol(...
        	 'Style','pushbutton',...
		 'Units','Normalized',...
		 'Position',btnPos,...
		 'String','Plot CS Lag',...
		 'Callback',callbackStr,...
		 'Enable','off');
	
	%=====================
	%Plot Mutual Information IS Lag
	%=====================
	yPos = menutop-(btnNumber-1)*(btnHt+spacing);
	btnPos = [left+btnWid/2 yPos-btnHt-delta btnWid/4 btnHt./2];
	callbackStr = 'fMRIMenu(''PlotMutInfoISLag'')';
	hPlotMutInfoISLag= uicontrol(...
        	 'Style','pushbutton',...
		 'Units','Normalized',...
		 'Position',btnPos,...
		 'String','Plot IS Lag',...
		 'Callback',callbackStr,...
		 'Enable','off');
		  
	%=====================
	%Plot  Mutual Information Single Slice 
	%=====================
	yPos = menutop-(btnNumber-1)*(btnHt+spacing);
	btnPos = [left+3.*btnWid/4 yPos-btnHt-delta btnWid/4 btnHt];
	callbackStr = 'fMRIMenu(''PlotMutInfoSlice'')';
	hPlotMutInfoSlice = uicontrol(...
         	'Style','popupmenu', ...
		 'Units','Normalized',...
		 'Position',btnPos,...
		 'String','Plot Slice.',...
		 'Callback',callbackStr,...
		  'Value',1,...
		 'Enable','off');

	%=====================
	%  Mut. Info Set Actual
	%=====================
	yPos = menutop-(btnNumber-1)*(btnHt+spacing);
	btnPos = [left+3.*btnWid/4 yPos-btnHt-delta btnWid/4 btnHt./2];
	callbackStr = 'fMRIMenu(''SetMutInfoActual'')';
	hSetMutInfoActual= uicontrol(...
        	 'Style','pushbutton',...
		 'Units','Normalized',...
		 'Position',btnPos,...
		 'String','Not Actual',...
		 'Callback',callbackStr,...
		 'Value',1,...
		 'Enable','off');
		 
	 %===================================
    	% Mutual Information Baseline
    	%===================================
	btnNumber=16;     
	yPos=menutop-(btnNumber-1)*(btnHt+spacing);
    	btnPos=[left yPos-btnHtEdit./2 2.*btnWid./6 btnHtEdit./2];
	hMutInfoBaseText = uicontrol( ...
        'Style','text', ...
        'Units','normalized', ...
	'Position',btnPos, ...
        'Horiz','left', ...
        'Foreground','black', ...
        'String','  Mut. Info. Baseline',...
	'Enable','on');

	btnPos=[left+2.*btnWid./6 yPos-btnHtEdit./2 btnWid./6 1.*btnHtEdit./2];
	callbackStr = 'fMRIMenu(''setMutInfoBase'')';
	hMutInfoBase = uicontrol( ...
        'Style','edit', ...
        'Units','normalized', ...
	'Position',btnPos, ...
        'Horiz','center', ...
        'Background','white', ...
        'Foreground','black', ...
        'String','4',...
	'Value',4,...
        'callback',callbackStr,...
	'Enable','on');
	
	%===================================
    	%  Mutual Information Min Lag
    	%===================================
	yPos=menutop-(btnNumber-1)*(btnHt+spacing);
    	btnPos=[left+btnWid./2 yPos-btnHtEdit./2 2.*btnWid./6 btnHtEdit./2];
    
	hMutInfoMinLagText = uicontrol( ...
        'Style','text', ...
        'Units','normalized', ...
	'Position',btnPos, ...
        'Horiz','left', ...
        'Foreground','black', ...
        'String','  Mut. Info Min. Lag',...
	'Enable','on');

	btnPos=[left+5.*btnWid./6 yPos-btnHtEdit./2 btnWid./6 1.*btnHtEdit./2];
	callbackStr = 'fMRIMenu(''setMutInfoMinLag'')';
    
	hMutInfoMinLag = uicontrol( ...
        'Style','edit', ...
        'Units','normalized', ...
	'Position',btnPos, ...
        'Horiz','center', ...
        'Background','white', ...
        'Foreground','black', ...
        'String','0',...
	'Value',0,...
        'callback',callbackStr,...
	'Enable','on');

	%===================================
    	% Mutual Information Max Lag
    	%===================================
	yPos=menutop-(btnNumber-1)*(btnHt+spacing);
    	btnPos=[left+btnWid./2 yPos-btnHtEdit 2.*btnWid./6 btnHtEdit./2];
    
	hMutInfoMaxLagText = uicontrol( ...
        'Style','text', ...
        'Units','normalized', ...
	'Position',btnPos, ...
        'Horiz','left', ...
        'Foreground','black', ...
        'String','  Mut. Info Max. Lag',...
	'Enable','on');

	btnPos=[left+5.*btnWid./6 yPos-btnHtEdit btnWid./6 1.*btnHtEdit./2];
	callbackStr = 'fMRIMenu(''setMutInfoMaxLag'')';
    
	hMutInfoMaxLag = uicontrol( ...
        'Style','edit', ...
        'Units','normalized', ...
	'Position',btnPos, ...
        'Horiz','center', ...
        'Background','white', ...
        'Foreground','black', ...
        'String','3',...
	'Value',3,...
        'callback',callbackStr,...
	'Enable','on');

	%===================================
    	% Mutual Information Minimum CS
    	%===================================
	btnNumber=17;     
	yPos=menutop-(btnNumber-1)*(btnHt+spacing);
    	btnPos=[left yPos-btnHtEdit./2 btnWid./3 btnHtEdit./2];
	hMutInfoMinCSText = uicontrol( ...
        'Style','text', ...
        'Units','normalized', ...
	'Position',btnPos, ...
        'Horiz','left', ...
        'Foreground','black', ...
        'String','Cauchy-Schwartz  Min.',...
	'Enable','on');

	btnPos=[left+btnWid./3 yPos-btnHtEdit./2 btnWid./6 1.*btnHtEdit./2];
	callbackStr = 'fMRIMenu(''setMutInfoMinCS'')';
	hMutInfoMinCS = uicontrol( ...
        'Style','edit', ...
        'Units','normalized', ...
	'Position',btnPos, ...
        'Horiz','center', ...
        'Background','white', ...
        'Foreground','black', ...
        'String','0',...
	'Value',0,...
        'callback',callbackStr,...
	'Enable','on');

	%===================================
    	% Mutual Information Maximum CS
    	%===================================
	yPos=menutop-(btnNumber-1)*(btnHt+spacing);
    	btnPos=[left yPos-btnHtEdit btnWid./3 btnHtEdit./2];
	hMutInfoMaxCSText = uicontrol( ...
        'Style','text', ...
        'Units','normalized', ...
	'Position',btnPos, ...
        'Horiz','left', ...
        'Foreground','black', ...
        'String','Cauchy-Schwartz Max.',...
	'Enable','on');

	btnPos=[left+btnWid./3 yPos-btnHtEdit btnWid./6 1.*btnHtEdit./2];
	callbackStr = 'fMRIMenu(''setMutInfoMaxCS'')';
    
	hMutInfoMaxCS = uicontrol( ...
        'Style','edit', ...
        'Units','normalized', ...
	'Position',btnPos, ...
        'Horiz','center', ...
        'Background','white', ...
        'Foreground','black', ...
        'String','100',...
	'Value',100,...
        'callback',callbackStr,...
	'Enable','on');
	
	%===================================
    	% Mutual Information Minimum IS
    	%===================================
	yPos=menutop-(btnNumber-1)*(btnHt+spacing);
    	btnPos=[left+btnWid./2 yPos-btnHtEdit./2 btnWid./3 btnHtEdit./2];
	hMutInfoMinISText = uicontrol( ...
        'Style','text', ...
        'Units','normalized', ...
	'Position',btnPos, ...
        'Horiz','left', ...
        'Foreground','black', ...
        'String','Integrated Square Min.',...
	'Enable','on');

	btnPos=[left+5.*btnWid./6 yPos-btnHtEdit./2 btnWid./6 1.*btnHtEdit./2];
	callbackStr = 'fMRIMenu(''setMutInfoMinIS'')';
	hMutInfoMinIS = uicontrol( ...
        'Style','edit', ...
        'Units','normalized', ...
	'Position',btnPos, ...
        'Horiz','center', ...
        'Background','white', ...
        'Foreground','black', ...
        'String','0',...
	'Value',0,...
        'callback',callbackStr,...
	'Enable','on');

	%===================================
    	% Mutual Information Maximum IS
    	%===================================
	yPos=menutop-(btnNumber-1)*(btnHt+spacing);
    	btnPos=[left+btnWid./2 yPos-btnHtEdit btnWid./3 btnHtEdit./2];
	hMutInfoMaxISText = uicontrol( ...
        'Style','text', ...
        'Units','normalized', ...
	'Position',btnPos, ...
        'Horiz','left', ...
        'Foreground','black', ...
        'String','Integrated Square Max.',...
	'Enable','on');

	btnPos=[left+5.*btnWid./6 yPos-btnHtEdit btnWid./6 1.*btnHtEdit./2];
	callbackStr = 'fMRIMenu(''setMutInfoMaxIS'')';
    
	hMutInfoMaxIS = uicontrol( ...
        'Style','edit', ...
        'Units','normalized', ...
	'Position',btnPos, ...
        'Horiz','center', ...
        'Background','white', ...
        'Foreground','black', ...
        'String','100',...
	'Value',100,...
        'callback',callbackStr,...
	'Enable','on');	
	
	
	%===================================
    % Power Mask Slider
    %===================================
	btnNumber=18;     
 	yPos=menutop-(btnNumber-1)*(btnHt+spacing);
    btnPos=[left yPos-btnHtEdit./2 btnWid./2 btnHtEdit./2];
	callbackStr = 'fMRIMenu(''PowerMaskSlider'')';
	hPowerMaskSlider=uicontrol( ...
        'Style','slider', ...
        'Units','normalized', ...
        'Position',btnPos, ...
        'String','Power Mask', ...
		'HorizontalAlignment','center',...
		'Min',0,...
		'Max',10,...
		'Value',0,...
		'Userdata',[], ...
        'Callback',callbackStr,...
		'Enable','off');
	
	%===================================
    %  Power Mask Edit
    %===================================
	yPos=menutop-(btnNumber-1)*(btnHt+spacing);
    btnPos=[left yPos-btnHtEdit btnWid./3 btnHtEdit./2];
	hPowerMaskText = uicontrol( ...
        'Style','text', ...
        'Units','normalized', ...
		'Position',btnPos, ...
        'Horiz','left', ...
        'Foreground','black', ...
        'String','Power Mask',...
		'Enable','on');

	btnPos=[left+2.*btnWid./6 yPos-btnHtEdit btnWid./6 btnHtEdit./2];
	callbackStr = 'fMRIMenu(''PowerMask'')';
    
	hPowerMask = uicontrol( ...
        'Style','edit', ...
        'Units','normalized', ...
		'Position',btnPos, ...
        'Horiz','center', ...
        'Background','white', ...
        'Foreground','black', ...
        'String','0',...
		'Value',0,...
        'callback',callbackStr,...
		'Enable','on');	
	
	%=====================
	%Plot  Ind. t-Test Single Slice Fix Amplitude
	%=====================
	btnNumber=19;    
	yPos = menutop-(btnNumber-1)*(btnHt+spacing);
	btnPos = [left yPos-btnHt-delta btnWid/4 btnHt./2];
	callbackStr = 'fMRIMenu(''PlotSliceFixAmp'')';
	hPlotSliceFixAmp = uicontrol(...
         'Style','radiobutton', ...
		 'Units','Normalized',...
		 'Position',btnPos,...
		 'String','Fix Amp.',...
		 'Value',0,...
		 'Enable','on');
		
	%=====================
	%Plot  Ind. t-Test Single Slice Subtract Mean
	%=====================
	yPos = menutop-(btnNumber-1)*(btnHt+spacing);
	btnPos = [left yPos-btnHt./2-delta btnWid/4 btnHt./2];
 	callbackStr = 'fMRIMenu(''PlotSliceSubMean'')';
	hPlotSliceSubMean = uicontrol(...
         'Style','radiobutton', ...
		 'Units','Normalized',...
		 'Position',btnPos,...
		 'String','Sub Mean',...
		 'Value',0,...
		 'Enable','on');
		 
	%=====================
	%Plot  Shot Order
	%=====================
	yPos = menutop-(btnNumber-1)*(btnHt+spacing);
	btnPos = [left+btnWid/4 yPos-btnHt./2-delta btnWid/4 btnHt./2];
 	callbackStr = 'fMRIMenu(''PlotShotOrder'')';
	hPlotShotOrder = uicontrol(...
         'Style','radiobutton', ...
		 'Units','Normalized',...
		 'Position',btnPos,...
		 'String','Shot Order',...
		 'Value',0,...
		 'Enable','on');

	
	%=====================
	%Callculate Center of Gravity
	%=====================
	yPos = menutop-(btnNumber-1)*(btnHt+spacing);
	btnPos = [left+btnWid./2 yPos-btnHt-delta btnWid/4 btnHt];
 	callbackStr = 'fMRIMenu(''CalcCoG'')';
	hCalcCoG = uicontrol(...
         'Style','push', ...
		 'Units','Normalized',...
		 'Position',btnPos,...
		 'String','Center of G.',...
		 'Value',0,...
		 'Callback',callbackStr,...
		 'Enable','on');
		 
	%=====================
	%Clear All
	%=====================
	yPos = menutop-(btnNumber-1)*(btnHt+spacing);
	btnPos = [left+3*btnWid/4 yPos-btnHt-delta btnWid/4 btnHt];
 	callbackStr = 'fMRIMenu(''ClearAll'')';
	hClearAll = uicontrol(...
         'Style','push', ...
		 'Units','Normalized',...
		 'Position',btnPos,...
		 'String','Clear All',...
		 'Value',0,...
		 'Callback',callbackStr,...
		 'Enable','on');
		 
	%=======================================================
	%===========UIMENUES====================================
	%=======================================================

	%=======================================================
	%===========TOPMENU FILE================================
	hFileMenu=uimenu('Label','File','ForegroundColor',[0 0 1]);
	
		%=======================================================
		hReadMenu=uimenu(hFileMenu,'Label','Read','ForegroundColor',[0 0 1]);
			hReadFuncMenu=uimenu(hReadMenu,'Label','Functional','ForegroundColor',[0 0 1]);
				hReadFuncTTestMenu=uimenu(hReadFuncMenu,'Label','t-Test','ForegroundColor',[0 0 1]);
					callbackStr = 'fMRIMenu(''ReadIndT'')';
					hReadIndT=uimenu(hReadFuncTTestMenu,'Label','Independent','Callback',callbackStr);
					callbackStr = 'fMRIMenu(''ReadDepT'')';
					hReadDepT=uimenu(hReadFuncTTestMenu,'Label','Dependent','Callback',callbackStr);
				
					callbackStr = 'fMRIMenu(''ReadXCorr'')';
				hReadFuncXCorrMenu=uimenu(hReadFuncMenu,'Label','Cross-Correlation','ForegroundColor',[0 0 1],'Callback',callbackStr);
				
				hReadFuncMutInfoMenu=uimenu(hReadFuncMenu,'Label','Mutual Information.','ForegroundColor',[0 0 1]);
					callbackStr = 'fMRIMenu(''ReadMutInfoCS'')';
					hReadMutInfoCS=uimenu(hReadFuncMutInfoMenu,'Label','Cauchy-Schwartz','Callback',callbackStr);
					callbackStr = 'fMRIMenu(''ReadMutInfoIS'')';
					hReadMutInfoIS=uimenu(hReadFuncMutInfoMenu,'Label','Integrated Square','Callback',callbackStr);
			
				callbackStr = 'fMRIMenu(''ReadPowerFuncMat'')';	
				hReadPowerFuncMatMenu=uimenu(hReadFuncMenu,'Label','Power Matrix','ForegroundColor',[0 0 1],'Callback',callbackStr);
		%=======================================================
		hSaveMenu=uimenu(hFileMenu,'Label','Save','ForegroundColor',[0 0 1]);
			hSaveFuncMenu=uimenu(hSaveMenu,'Label','Functional','ForegroundColor',[0 0 1]);
				hSaveFuncTTestMenu=uimenu(hSaveFuncMenu,'Label','t-Test','ForegroundColor',[0 0 1]);
					callbackStr = 'fMRIMenu(''SaveIndT'')';
					hSaveIndT=uimenu(hSaveFuncTTestMenu,'Label','Independent','Callback',callbackStr);
					callbackStr = 'fMRIMenu(''SaveDepT'')';
					hSaveDepT=uimenu(hSaveFuncTTestMenu,'Label','Dependent','Callback',callbackStr);
				
					callbackStr = 'fMRIMenu(''SaveXCorr'')';
				hSaveFuncXCorrMenu=uimenu(hSaveFuncMenu,'Label','Cross-Correlation','ForegroundColor',[0 0 1],'Callback',callbackStr);
	
				hSaveFuncMutInfoMenu=uimenu(hSaveFuncMenu,'Label','Mutual Information.','ForegroundColor',[0 0 1]);
					callbackStr = 'fMRIMenu(''SaveMutInfoCS'')';
					hSaveMutInfoCS=uimenu(hSaveFuncMutInfoMenu,'Label','Cauchy-Schwartz','Callback',callbackStr);
					callbackStr = 'fMRIMenu(''SaveMutInfoIS'')';
					hSaveMutInfoIS=uimenu(hSaveFuncMutInfoMenu,'Label','Integrated Square','Callback',callbackStr);
				
				callbackStr = 'fMRIMenu(''SaveActualData'')';	
				hSaveActualDataMenu=uimenu(hSaveFuncMenu,'Label','Actual Data','ForegroundColor',[0 0 1],'Callback',callbackStr);
				
				callbackStr = 'fMRIMenu(''SavePowerFuncMat'')';	
				hSavePowerFuncMatMenu=uimenu(hSaveFuncMenu,'Label','Power Matrix','ForegroundColor',[0 0 1],'Callback',callbackStr);
				
		%=======================================================
		callbackStr = 'fMRIMenu(''ReformatSubject'')';
		hRefSubj=uimenu(hFileMenu,'Label','Reformat Subject','Callback',callbackStr,'Separator','on');
		hWriteBatch=uimenu(hFileMenu,'Label','Write Batch','Callback',callbackStr);
			callbackStr = 'fMRIMenu(''WriteBatchAll'')';
			hWriteBatchAll=uimenu(hWriteBatch,'Label','All','Callback',callbackStr);
			callbackStr = 'fMRIMenu(''WriteBatchSub'')';
			hWriteBatchSub=uimenu(hWriteBatch,'Label','Subject','Callback',callbackStr);
			
	%=======================================================
	hCalcMenu=uimenu('Label','Calculate','ForegroundColor',[0 0 1]);
		hAvgStatMenu=uimenu(hCalcMenu,'Label','Average Stats','ForegroundColor',[0 0 1]);
			hAvgTTestMenu=uimenu(hAvgStatMenu,'Label','t-Test','ForegroundColor',[0 0 1]);
				hAvgIndTMenu=uimenu(hAvgTTestMenu,'Label','Ind. t-Test','ForegroundColor',[0 0 1]);
					callbackStr = 'fMRIMenu(''AvgIndTFunc'')';
					hAvgIndTMaxValMenu=uimenu(hAvgIndTMenu,'Label','Function','Callback',callbackStr);
					callbackStr = 'fMRIMenu(''AvgIndTMaxVal'')';
					hAvgIndTMaxValMenu=uimenu(hAvgIndTMenu,'Label','Max. Value','Callback',callbackStr);
					callbackStr = 'fMRIMenu(''AvgIndTMaxInd'')';
					hAvgIndTMaxValMenu=uimenu(hAvgIndTMenu,'Label','Max. Index','Callback',callbackStr);
				hAvgDepTMenu=uimenu(hAvgTTestMenu,'Label','Dep. t-Test','ForegroundColor',[0 0 1]);
					callbackStr = 'fMRIMenu(''AvgDepTFunc'')';
					hAvgDepTMaxValMenu=uimenu(hAvgDepTMenu,'Label','Function','Callback',callbackStr);
					callbackStr = 'fMRIMenu(''AvgDepTMaxVal'')';
					hAvgDepTMaxValMenu=uimenu(hAvgDepTMenu,'Label','Max. Value','Callback',callbackStr);
					callbackStr = 'fMRIMenu(''AvgDepTMaxInd'')';
					hAvgDepTMaxValMenu=uimenu(hAvgDepTMenu,'Label','Max. Index','Callback',callbackStr);
			hAvgXCorrMenu=uimenu(hAvgStatMenu,'Label','Cross-Correlation','ForegroundColor',[0 0 1]);
				callbackStr = 'fMRIMenu(''AvgXCorrFunc'')';
				hAvgXCorrFuncMenu=uimenu(hAvgXCorrMenu,'Label','Function','Callback',callbackStr);
				callbackStr = 'fMRIMenu(''AvgXCorrMaxVal'')';
				hAvgXCorrMaxValMenu=uimenu(hAvgXCorrMenu,'Label','Max. Value','Callback',callbackStr);
				callbackStr = 'fMRIMenu(''AvgXCorrMaxInd'')';
				hAvgXCorrMaxValMenu=uimenu(hAvgXCorrMenu,'Label','Max. Index','Callback',callbackStr);
			hAvgMutInfoMenu=uimenu(hAvgStatMenu,'Label','Mutual Information.','ForegroundColor',[0 0 1]);
				callbackStr = 'fMRIMenu(''AvgMutInfoCS'')';
				hAvgMutInfoCS=uimenu(hAvgMutInfoMenu,'Label','Cauchy-Schwartz','Callback',callbackStr);
				callbackStr = 'fMRIMenu(''AvgMutInfoIS'')';
				hAvgMutInfoIS=uimenu(hAvgMutInfoMenu,'Label','Integrated Square','Callback',callbackStr);
			callbackStr = 'fMRIMenu(''AvgPowerFunc'')';
			hAvgPowerFuncMenu=uimenu(hAvgStatMenu,'Label','Power Function','ForegroundColor',[0 0 1],'Callback',callbackStr);
		
	%=======================================================
	%=======================================================
		hSubStatMenu=uimenu(hCalcMenu,'Label','Subtract Stats','ForegroundColor',[0 0 1]);
			hSubTTestMenu=uimenu(hSubStatMenu,'Label','t-Test','ForegroundColor',[0 0 1]);
				callbackStr = 'fMRIMenu(''SubIndT'')';
				hSubIndTMenu=uimenu(hSubTTestMenu,'Label','Ind. t-Test','Callback',callbackStr);
				callbackStr = 'fMRIMenu(''SubDepT'')';
				hSubDepTMenu=uimenu(hSubTTestMenu,'Label','Dep. t-Test','Callback',callbackStr);
			hSubXCorrMenu=uimenu(hSubStatMenu,'Label','Cross-Correlation','ForegroundColor',[0 0 1]);
				callbackStr = 'fMRIMenu(''SubXCorrFunc'')';
				hSubXCorrFuncMenu=uimenu(hSubXCorrMenu,'Label','Function','Callback',callbackStr);
				callbackStr = 'fMRIMenu(''SubXCorrMaxVal'')';
				hSubXCorrMaxValMenu=uimenu(hSubXCorrMenu,'Label','Max. Value','Callback',callbackStr);
				callbackStr = 'fMRIMenu(''SubXCorrMaxInd'')';
				hSubXCorrMaxValMenu=uimenu(hSubXCorrMenu,'Label','Max. Index','Callback',callbackStr);
			hSubMutInfoMenu=uimenu(hSubStatMenu,'Label','Mutual Information.','ForegroundColor',[0 0 1]);
				callbackStr = 'fMRIMenu(''SubMutInfoCS'')';
				hSubMutInfoCS=uimenu(hSubMutInfoMenu,'Label','Cauchy-Schwartz','Callback',callbackStr);
				callbackStr = 'fMRIMenu(''SubMutInfoIS'')';
				hSubMutInfoIS=uimenu(hSubMutInfoMenu,'Label','Integrated Square','Callback',callbackStr);
		%======================================================
		callbackStr = 'fMRIMenu(''SubRaw'')';
		hSubRawMenu=uimenu(hCalcMenu,'Label','Subtract Raw','ForegroundColor',[0 0 1],'Callback',callbackStr,'Separator','on');
		%=======================================================
		callbackStr = 'fMRIMenu(''AvgStruc'')';
		hAvgStrucMenu=uimenu(hCalcMenu,'Label','Average Structural','ForegroundColor',[0 0 1],'Callback',callbackStr);
		%=======================================================
		callbackStr = 'fMRIMenu(''ExpMeanFunAsStruc'')';
		hExpMeanFunAsStrucMenu=uimenu(hCalcMenu,'Label','Export Mean Func as Struc','ForegroundColor',[0 0 1],'Callback',callbackStr);
		%=======================================================
		callbackStr = 'fMRIMenu(''EditStruc'')';
		hEditStrucMenu=uimenu(hCalcMenu,'Label','Edit Structural','ForegroundColor',[0 0 1],'Callback',callbackStr,'Separator','on');
		%=======================================================
		callbackStr = 'fMRIMenu(''CalcAnaSym'')';
		hCalcAnaSymMenu=uimenu(hCalcMenu,'Label','Stats','ForegroundColor',[0 0 1],'Callback',callbackStr);
		callbackStr = 'fMRIMenu(''CalcAnaSymBatch'')';
		hCalcAnaSymBatchMenu=uimenu(hCalcMenu,'Label','Batch Stats','ForegroundColor',[0 0 1],'Callback',callbackStr);
		%=======================================================
		callbackStr = 'fMRIMenu(''CompareAna'')';
		hCompareAnaMenu=uimenu(hCalcMenu,'Label','Compare','ForegroundColor',[0 0 1],'Callback',callbackStr,'Separator','on');
		%=======================================================
	
	hStrucMat=uicontrol('Visible','off');
	hFuncMat=uicontrol('Visible','off');
	hIndTMat=uicontrol('Visible','off');
	hIndTMat1=uicontrol('Visible','off');
	hIndTMat2=uicontrol('Visible','off');
	hDepTMat=uicontrol('Visible','off');
	hDepTMat1=uicontrol('Visible','off');
	hDepTMat2=uicontrol('Visible','off');
	hXCorrMat=uicontrol('Visible','off');
	hXCorrMat1=uicontrol('Visible','off');
	hXCorrMat2=uicontrol('Visible','off');
	hXCorrIndVec1=uicontrol('Visible','off');
	hXCorrIndVec2=uicontrol('Visible','off');
	hMutInfoMatCS=uicontrol('Visible','off');
	hMutInfoMatCS1=uicontrol('Visible','off');
	hMutInfoMatCS2=uicontrol('Visible','off');
	hMutInfoMatIS=uicontrol('Visible','off');
	hMutInfoMatIS1=uicontrol('Visible','off');
	hMutInfoMatIS2=uicontrol('Visible','off');
	hIndTIndVec1=uicontrol('Visible','off');
	hIndTIndVec2=uicontrol('Visible','off');
	hDepTIndVec1=uicontrol('Visible','off');
	hDepTIndVec2=uicontrol('Visible','off');
	hMutInfoIndVec1=uicontrol('Visible','off');
	hMutInfoIndVec2=uicontrol('Visible','off');
	hMaskMat1=uicontrol('Visible','off');
	hSizeStrucMat=uicontrol('Visible','off');
	hSizeFuncMat=uicontrol('Visible','off');
	hActualAnaMat=uicontrol('Visible','off','Value',0);
	hEditMatFilePath=uicontrol('Visible','off');
	hAnaStatMat=uicontrol('Visible','off');
	hActualAnaFilePath=uicontrol('Visible','off','Value',0);
	hCompareAna=uicontrol('Visible','off','Value',0);

	NonUse=0;
	
	hList = ...
	[hStrucMat hReadStruc hReformStruc hSaveStruc hFuncMat ...									%1
	hReadFunc hReformFunc hSaveFunc hCalcIndT21 hCalcDepT21 ...									%6
	hCalcXCorr hCalcMutInfo hIndTMat1 hDepTMat1 hXCorrMat1  ...									%11
	hXCorrMat2 hIndTIndVec1 hIndTIndVec2 hDepTIndVec1 hDepTIndVec2 ...							%16
	hIndTPosMinText hIndTPosMin  hIndTPosMaxText hIndTPosMax NonUse ...							%21
	hDepTPosMinText hDepTPosMin hDepTPosMaxText hDepTPosMax NonUse ...							%26
	hPlotIndTPosVal hPlotDepTPosVal hPlotIndTNegVal hPlotDepTNegVal NonUse ...					%31
	hIndTBaseText hIndTBase hDepTBaseText hDepTBase NonUse ...									%36
	hXCorrMin1Text hXCorrMin1 hXCorrMax1Text hXCorrMax1 hXCorrMat ...							%41
	hPlotXCorrVal hXCorrBaseText hXCorrBase hPlotXCorrLag hXCorrIndVec1 ...						%46
	hXCorrMin2Text hXCorrMin2 hXCorrMax2Text hXCorrMax2 hXCorrIndVec2 ...						%51
	hPlotStruc hPlotFuncShot hPlotFuncSlice NonUse NonUse ...									%56
	hPlotIndTSlice hPlotDepTSlice hPlotXCorrSlice NonUse NonUse...								%61
	hPlotMutInfoCSVal hPlotMutInfoISVal hPlotMutInfoSlice hMutInfoBaseText hMutInfoBase  ...	%66
	hMutInfoMinCSText hMutInfoMinCS hMutInfoMaxCSText hMutInfoMaxCS hPlotMutInfoCSLag ...		%71
	hMutInfoMinISText hMutInfoMinIS hMutInfoMaxISText hMutInfoMaxIS hPlotMutInfoISLag ...		%76
	hMutInfoMatCS1 hMutInfoMatIS1 hMutInfoIndVec1 hMutInfoIndVec2 NonUse ...					%81
	hNShotPerCycleText hNShotPerCycle hSamplingText hSampling NonUse ...						%86
	hXCorrMaxLagText hXCorrMaxLag hTRText hTR NonUse ...										%91	
	hMaskMat1 hPlotSliceFixAmp hPlotSliceSubMean hPlotShotOrder NonUse ...						%96	
	hIndTNegMinText hIndTNegMin  hIndTNegMaxText hIndTNegMax NonUse ...							%101
	hDepTNegMinText hDepTNegMin hDepTNegMaxText hDepTNegMax NonUse ...							%106;	
	hCalcIndT12 hCalcDepT12 hXCorrMinLagText hXCorrMinLag NonUse ...							%111
	hCalcAll hBatchCalcAll hSaveAll hBatchSamplingText hBatchSampling ...						%116;		
	hPowerMaskSlider hPowerMaskText hPowerMask NonUse NonUse ...								%121
	hIndTMinLagText hIndTMinLag  hIndTMaxLagText hIndTMaxLag NonUse ...							%126;	
	hPlotIndTPosLag hPlotIndTNegLag hIndTMat hIndTMat2 NonUse ...								%131;
	hSizeStrucMat hSizeFuncMat NonUse NonUse NonUse ...											%136;	
	hDepTMinLagText hDepTMinLag  hDepTMaxLagText hDepTMaxLag NonUse ...							%141;
	hPlotDepTPosLag hPlotDepTNegLag hDepTMat hDepTMat2 NonUse ...								%146;	
	hMutInfoMinLagText hMutInfoMinLag hMutInfoMaxLagText hMutInfoMaxLag NonUse ....				%151;		
	hMutInfoMatCS hMutInfoMatCS2 hMutInfoMatIS hMutInfoMatIS2 NonUse ...						%156;	
	hEditStrucMenu hSetIndTActual hSetDepTActual hSetXCorrActual hSetMutInfoActual ...			%161;	
	hActualAnaMat hEditMatFilePath hAnaStatMat hActualAnaFilePath hCompareAna];					%166;	
	
	set(hfMRIMenu,'UserData',hList);
	
elseif strcmp(action,'ClearAll')

	close(hfMRIMenu)
	clear all
	fMRIMenu
	
elseif strcmp(action,'ReadPowerFuncMat')

	hList=get(hfMRIMenu,'UserData');
	hMatListNo=[hMatListNo,121];	%PowerMaskSlider
	FileExt='pfm';					%PowerFuncMat
	DefDataFilePath=SetDefPath(1,['*',FileExt,'*'])
	DialogTitle=['Read ',FileExt,' data from file:'];
	[DataMat,FilePath,SizeDataMat,NDim,Version]=ReadNDimData([],'float32',DefDataFilePath,DialogTitle);
	set(hList(121),'Userdata',DataMat,'Enable','on');
	
elseif strcmp(action,'ReadIndT') | ...
	strcmp(action,'ReadDepT') | ...
	strcmp(action,'ReadXCorr') | ...
	strcmp(action,'ReadMutInfoCS') | ...
	strcmp(action,'ReadMutInfoIS'),
	
	hList=get(hfMRIMenu,'UserData');
	Tmp=100;
	if strcmp(action,'ReadIndT')
		hMatListNo=[133 13 134];
		FileExt=char('itf');				%Ind. t-test function
		FileExt=char(FileExt,'itv');		%Ind. t-test maximum value
		FileExt=char(FileExt,'itl');		%Ind. t-test lag of maximum value
		hCalcListNo=9;
		hMinListNo=[104 127];
		hMaxListNo=[24 129];
		hPlotListNo=[31 131];
		hPlotSliceListNo=61;
		fMRIMenu('SetIndTActual')
	elseif strcmp(action,'ReadDepT')
		hMatListNo=[148 14 149];
		FileExt=char('dtf');				%Dep. t-test function
		FileExt=char(FileExt,'dtv');		%Dep. t-test maximum value
		FileExt=char(FileExt,'dtl');		%Dep. t-test lag of maximum value
		hCalcListNo=10;
		hMinListNo=[109 142];
		hMaxListNo=[29 144];
		hPlotListNo=[32 146];
		hPlotSliceListNo=62;
		fMRIMenu('SetDepTActual')
	elseif strcmp(action,'ReadXCorr')
		hMatListNo=[45 15 16];
		FileExt=char('xcf');			%X-corr function
		FileExt=char(FileExt,'xcv');		%X-corr  maximum value
		FileExt=char(FileExt,'xcl');		%X-corr  lag of maximum value
		hCalcListNo=11;
		hMinListNo=[42 52];
		hMaxListNo=[44 54];
		hPlotListNo=[46 49];
		hPlotSliceListNo=63;
		fMRIMenu('SetXCorrActual')
	elseif strcmp(action,'ReadMutInfoCS')
		hMatListNo=[156 81 157];
		FileExt=char('cmf');		%CS mutual info function
		FileExt=char(FileExt,'cmv');	%CS mutual info  maximum value
		FileExt=char(FileExt,'cml');	%CS mutual info  lag of maximum value
		hCalcListNo=12;
		hMinListNo=[72 152];
		hMaxListNo=[74 154];
		hPlotListNo=[66 75];
		hPlotSliceListNo=68;
		fMRIMenu('SetMutInfoActual')	
	elseif strcmp(action,'ReadMutInfoIS')
		hMatListNo=[158 82 159];
		FileExt=char('imf');		%IS mutual info function
		FileExt=char(FileExt,'imv');	%IS mutual info  maximum value
		FileExt=char(FileExt,'iml');	%IS mutual info  lag of maximum value
		hMinListNo=[77 152];
		hMaxListNo=[79 154];
		hPlotListNo=[67 80];
		hPlotSliceListNo=68;
		fMRIMenu('SetMutInfoActual')
	end
	hMatListNo=[hMatListNo,121];	%PowerMaskSlider
	FileExt=char(FileExt,'pfm');		%PowerFuncMat
	for i=1:4
		FileExtTmp=FileExt(i,:);
		DefDataFilePath=SetDefPath(1,['*',FileExtTmp,'*'])
		DialogTitle=['Read ',FileExtTmp,' data from file:'];
		[DataMat,FilePath,SizeDataMat,NDim,Version]=ReadNDimData([],'float32',DefDataFilePath,DialogTitle);
		if ~isempty(DataMat)
			[File,Path]=SepFilePath(FilePath);
			SetDefPath(2,Path);
		end
		set(hList(hMatListNo(i)),'Userdata',DataMat);
		if i==1	
			set(hList(hPlotSliceListNo),'Enable','on');
		elseif i==2 | i==3
			MinVal=min(min(min(DataMat)));
			set(hList(hMinListNo(i-1)),'Value',MinVal,'String',sprintf('%g',round(MinVal.*Tmp)./Tmp));
			MaxVal=max(max(max(DataMat)));
			set(hList(hMaxListNo(i-1)),'Value',MaxVal,'String',sprintf('%g',round(MaxVal.*Tmp)./Tmp));
			set(hList(hPlotListNo(i-1)),'Enable','on');
		elseif i==4
			set(hList(121),'Enable','on');	%PowerMaskSlider
		end
	end
	

elseif strcmp(action,'SetIndTActual') | ...
	strcmp(action,'SetDepTActual') | ...
	strcmp(action,'SetXCorrActual') | ...
	strcmp(action,'SetMutInfoActual');

	hList=get(hfMRIMenu,'UserData');
	if strcmp(action,'SetIndTActual')
		hSetActualListNo=162;
		hFunMatListNo=13;
	elseif strcmp(action,'SetDepTActual')
		hSetActualListNo=163;
		hFunMatListNo=14;
	elseif strcmp(action,'SetXCorrActual')
		hSetActualListNo=164;
		hFunMatListNo=15;
	elseif strcmp(action,'SetMutInfoActual')
		hSetActualListNo=165;
		hFunMatListNo=16;
	end
	for i=162:165
		if i==hSetActualListNo
			set(hList(i),'String','Actual','Value',1,'Enable','on');
			set(hList(166),'Value',hFunMatListNo);
			AnaMat=get(hList(hFunMatListNo),'Userdata');
			set(hList(166),'Userdata',AnaMat); %Actual AnaMat
		else
			set(hList(i),'String','Not Actual','Value',0);
		end
	end
		
elseif strcmp(action,'SaveIndT') | ...
	strcmp(action,'SaveDepT') | ...
	strcmp(action,'SaveXCorr') | ...
	strcmp(action,'SaveMutInfoCS') | ...
	strcmp(action,'SaveMutInfoIS') | ...
	strcmp(action,'SavePowerFuncMat') | ...
	strcmp(action,'NoCallSaveIndT') | ...
	strcmp(action,'NoCallSaveDepT') | ...
	strcmp(action,'NoCallSaveXCorr') | ...
	strcmp(action,'NoCallSaveMutInfoCS') | ...
	strcmp(action,'NoCallSaveMutInfoIS') | ...
	strcmp(action,'NoCallSavePowerFuncMat'),
	
	hList=get(hfMRIMenu,'UserData');
	NExt=3;
	if strcmp(action,'SaveIndT') |  strcmp(action,'NoCallSaveIndT')
		hMatListNo=[133 13 134];
		FileExt=char('itf');				%Ind. t-test function
		FileExt=char(FileExt,'itv');		%Ind. t-test maximum value
		FileExt=char(FileExt,'itl');		%Ind. t-test lag of maximum value
	elseif strcmp(action,'SaveDepT') | strcmp(action,'NoCallSaveDepT')
		hMatListNo=[148 14 149];
		FileExt=char('dtf');			%Dep. t-test function
		FileExt=char(FileExt,'dtv');		%Dep. t-test maximum value
		FileExt=char(FileExt,'dtl');		%Dep. t-test lag of maximum value
	elseif strcmp(action,'SaveXCorr') | strcmp(action,'NoCallSaveXCorr')
		hMatListNo=[45 15 16];
		FileExt=char('xcf');			%X-corr function
		FileExt=char(FileExt,'xcv');	%X-corr  maximum value
		FileExt=char(FileExt,'xcl');		%X-corr  lag of maximum value
	elseif strcmp(action,'SaveMutInfoCS') | strcmp(action,'NoCallSaveMutInfoCS')
		hMatListNo=[156 81 157];
		FileExt=char('cmf');			%CS mutual info function
		FileExt=char(FileExt,'cmv');	%CS mutual info  maximum value
		FileExt=char(FileExt,'cml');		%CS mutual info  lag of maximum value
	elseif strcmp(action,'SaveMutInfoIS') | strcmp(action,'NoCallSaveMutInfoIS')
		hMatListNo=[158 82 159];
		FileExt=char('imf');		%IS mutual info function
		FileExt=char(FileExt,'imv');	%IS mutual info  maximum value
		FileExt=char(FileExt,'iml');	%IS mutual info  lag of maximum value
	elseif strcmp(action,'SavePowerFuncMat') | strcmp(action,'NoCallSavePowerFuncMat')
		FileExt=char('pfm');		%PowerFuncMat
		hMatListNo=121;
		NExt=1;
	end
	for i=1:NExt
		FileExtTmp=FileExt(i,:);
		DataMat=get(hList(hMatListNo(i)),'Userdata');
		if isempty(DataMat); return; end
		FilePath=get(hList(6),'Userdata');	%ReadFuncMat
		if isempty(FilePath); return; end
		[File,Path]=SepFilePath(FilePath);
		if strcmp(action(1:6),'NoCall')
			Tmp=findstr(Path,'Orig');
			PathTmp=[Path(1:Tmp-1),'Calc',Path(Tmp+4:length(Path))];
% 			FilePath=[Path,File(1:length(File)-3),FileExtTmp];
			FilePath=[PathTmp,File(1:length(File)-3),FileExtTmp]
			SaveNDimData(DataMat,FilePath,'float32');
		else
			InitFile=[File(1:length(File)-3),FileExtTmp];
			SaveNDimData(DataMat,[],'float32',InitFile,['Save ',FileExtTmp,' data to file:'])
		end
	end
	
elseif strcmp(action,'AvgXCorrFunc')

	hList=get(hfMRIMenu,'UserData');
	Tmp=100;
	CorrFac=.6;
	NShotPerCycle=get(hList(87),'Value');
	XCorrBase=get(hList(48),'Value');
	XCorrMinLag=get(hList(114),'Value');
	XCorrMaxLag=get(hList(92),'Value');
	TR=get(hList(94),'Value');
	TRs=TR./1000;
	AvgExt='xcf';
	FilterSpec=['*',AvgExt,'*'];
	DialogTitle=['Choose ',AvgExt,' file to average:'];
	[NFiles,FileMat,NonUse,BatchFilePath]=ReadFileNames([],FilterSpec,DialogTitle);
	if NFiles==0; return; end
	set(hList(6),'Userdata',BatchFilePath);
	fMRIMenu('SetfMRIMenuFigName');
	[File,Path,FilePath]=GetFileNameOfMat(FileMat,1);
	[AvgMat,FilePath,SizeDataMat,NDim,Version]=ReadNDimData(FilePath,'float32');
	[XSizeFunc,YSizeFunc,NSlice,NXCorrInd]=size(AvgMat);
	for FileInd=2:NFiles
		[File,Path,FilePath]=GetFileNameOfMat(FileMat,FileInd);
		[DataMat,FilePath,SizeDataMat,NDim,Version]=ReadNDimData(FilePath,'float32');
		AvgMat=AvgMat+DataMat;
	end
	AvgMat=AvgMat./NFiles;
	Message=char(zeros(5,100));
	hProgressMsgbox=msgbox(Message,'Progress Info:','help'); 
	hChildProgressMsgbox=get(hProgressMsgbox,'Children');
	set(hChildProgressMsgbox(length(hChildProgressMsgbox)),'Visible','off');
	MinInd=NXCorrInd-(NXCorrInd-1)./2+XCorrMinLag;
	MaxInd=NXCorrInd-(NXCorrInd-1)./2+XCorrMaxLag;
	for SliceInd=1:NSlice
		fprintf('Slice %g of %g ...\n',SliceInd,NSlice);
		Message=char('Calculate Max. of');
		Message=char(Message,'Cross-Correlation !');
		Message=char(Message,['Min. Index: ',int2str(MinInd)]);
		Message=char(Message,['Max. Index: ',int2str(MaxInd)]);
		Message=char(Message,['Slice ' int2str(SliceInd) ' of ' int2str(NSlice) ' ...']);
		set(hChildProgressMsgbox(2),'String',Message);
		pause(.001);
		for i=1:XSizeFunc
			for j=1:YSizeFunc
				[FunMat1(i,j,SliceInd),FunMat2(i,j,SliceInd)]=max(AvgMat(i,j,SliceInd,MinInd:MaxInd));
			end
		end
	end
	close(hProgressMsgbox);
	FunMat2=(FunMat2-ones(size(FunMat2)).*((NXCorrInd-1)./2+1)).*TRs;
	MaxVal1=max(max(max(FunMat1)));
	MinVal1=CorrFac.*MaxVal1;
	set(hList(42),'Value',MinVal1,'String',sprintf('%g',round(MinVal1*Tmp)/Tmp)); 
	set(hList(44),'Value',MaxVal1,'String',sprintf('%g',round(MaxVal1*Tmp)/Tmp)); 
	set(hList(45),'Userdata',AvgMat); 
	set(hList(15),'Userdata',FunMat1); 
	MinVal2=min(min(min(FunMat2)));
	MaxVal2=max(max(max(FunMat2)));
	set(hList(52),'Value',MinVal2,'String',sprintf('%g',round(MinVal2*Tmp)/Tmp)); 
	set(hList(54),'Value',MaxVal2,'String',sprintf('%g',round(MaxVal2*Tmp)/Tmp)); 
	set(hList(16),'Userdata',FunMat2); 
	set(hList(46),'Enable','on'); 		%hXCorrPlot1
	set(hList(49),'Enable','on'); 		%hXCorrPlot2
	set(hList(63),'Enable','on'); 		%hPlotSlice
	
elseif strcmp(action,'AvgIndTFunc') | ...
	strcmp(action,'AvgDepTFunc');
	
	hList=get(hfMRIMenu,'UserData');
	if strcmp(action(4:length(action)),'IndTFunc') 
		Ext='itf';
	elseif strcmp(action(4:length(action)),'DepTFunc') 
		Ext='dtf';
	end
	FilterSpec=['*',Ext,'*'];
	if strcmp(action(1:3),'Avg')
		DialogTitle=['Choose ',Ext,' file to average:'];
	elseif strcmp(action(1:3),'Sub')
		DialogTitle=['Choose two ',Ext,' files to subtract (File 1- File 2):'];
	end
	[NFiles,FileMat,NonUse,BatchFilePath]=ReadFileNames([],FilterSpec,DialogTitle);
	if NFiles==0; return; end
	if strcmp(action(1:3),'Sub') & NFiles~=2;
		error('You have to choose two files.')
		return;
	end
	%Get Maximum Matrix Size of Ana Files
	SizeMat=zeros(NFiles,4);
	InterpStatusVec=zeros(NFiles,1);
	for FileInd=1:NFiles
		[File,Path,FilePath]=GetFileNameOfMat(FileMat,FileInd);
		[NonUse,FilePath,SizeDataMat]=ReadNDimData(FilePath,'float32',[],[],1);
		SizeMat(FileInd,:)=SizeDataMat';
	end
	NSlice=SizeMat(1,3);
	if any(SizeMat(:,3)~=NSlice)
		error('Number of slices does not match.')
	end
	NLag=SizeMat(1,4);
	if any(SizeMat(:,4)~=NLag)
		error('Number of lags does not match.')
	end
	if any(SizeMat(:,1)~=SizeMat(1,1)) |  any(SizeMat(:,2)~=SizeMat(1,2))
		MaxXSize=max(SizeMat(:,1));
		MaxYSize=max(SizeMat(:,2));
		InterpX=find(SizeMat(:,1)~=MaxXSize);
		InterpStatusVec(InterpX)=ones(length(InterpX),1);
		InterpY=find(SizeMat(:,2)~=MaxYSize);
		InterpStatusVec(InterpY)=ones(length(InterpY),1);
		InterpDataMat=zeros(MaxXSize,MaxYSize,NSlice,NLag);
		InterpAvgMat=zeros(MaxXSize,MaxYSize,NSlice,NLag);
	end	
	[File,Path,FilePath]=GetFileNameOfMat(FileMat,1);
	[AvgMat,FilePath,SizeDataMat,NDim,Version]=ReadNDimData(FilePath,'float32');
	if InterpStatusVec(1)
		for LagInd=1:NLag
			for SliceInd=1:NSlice
				InterpAvgMat(:,:,SliceInd,LagInd)=squeeze(interp2(AvgMat(:,:,SliceInd,LagInd),linspace(1,SizeMat(1,1),MaxXSize),linspace(1,SizeMat(1,2),MaxYSize)','cubic'));
			end
		end
	else
		InterpAvgMat=AvgMat;
	end
	if strcmp(action(1:3),'Avg') 
		for FileInd=2:NFiles
			[File,Path,FilePath]=GetFileNameOfMat(FileMat,FileInd);
			[DataMat,FilePath,SizeDataMat,NDim,Version]=ReadNDimData(FilePath,'float32');
			if InterpStatusVec(FileInd)
				for LagInd=1:NLag
					for SliceInd=1:NSlice
						InterpDataMat(:,:,SliceInd,LagInd)=squeeze(interp2(DataMat(:,:,SliceInd,LagInd),linspace(1,SizeMat(FileInd,1),MaxXSize),linspace(1,SizeMat(FileInd,2),MaxYSize)','cubic'));
					end
				end
			else
				InterpDataMat=DataMat;	
			end
			InterpAvgMat=InterpAvgMat+InterpDataMat;	
		end
		InterpAvgMat=InterpAvgMat./NFiles;
	elseif strcmp(action(1:3),'Sub') 
		[File,Path,FilePath]=GetFileNameOfMat(FileMat,2);
		[DataMat,FilePath,SizeDataMat,NDim,Version]=ReadNDimData(FilePath,'float32');
		if InterpStatusVec(2)
			for LagInd=1:NLag
				for SliceInd=1:NSlice
					InterpDataMat(:,:,SliceInd,LagInd)=squeeze(interp2(DataMat(:,:,SliceInd,LagInd),linspace(1,SizeMat(2,1),MaxXSize),linspace(1,SizeMat(2,2),MaxYSize)','cubic'));
				end
			end
		else
			InterpDataMat=DataMat;
		end
		InterpAvgMat=InterpAvgMat-InterpDataMat;
	end
	[FilePath,Version]=SaveNDimData(InterpAvgMat,[],'float32',['01.hl.',Ext],'Save actual data to file:');

elseif strcmp(action,'AvgIndTMaxVal') | ...
	strcmp(action,'AvgIndTMaxInd') | ...
	strcmp(action,'AvgDepTMaxVal') | ...
	strcmp(action,'AvgDepTMaxInd') | ...
	strcmp(action,'AvgXCorrMaxVal') | ...
	strcmp(action,'AvgXCorrMaxInd') | ...
	strcmp(action,'AvgMutInfoCS') | ...
	strcmp(action,'AvgMutInfoIS') | ...
	strcmp(action,'AvgPowerFunc') | ...
	 strcmp(action,'SubIndT') | ...
	strcmp(action,'SubDepT') | ...
	strcmp(action,'SubXCorrMaxVal') | ...
	strcmp(action,'SubXCorrMaxInd') | ...
	strcmp(action,'SubMutInfoCS') | ...
	strcmp(action,'SubMutInfoIS'),

	hList=get(hfMRIMenu,'UserData');
	hMinListNo=[];
	hPlotNegListNo=[];
	Tmp=100;
	if strcmp(action(4:length(action)),'IndTMaxVal') 
		hMatListNo=13;
		hMinListNo=104;
		hMaxListNo=24;
		hPlotPosListNo=31;
		hPlotNegListNo=33;
		hLagListNo=37;
		hPlotSliceListNo=61;
		Ext='itv';
	elseif strcmp(action(4:length(action)),'IndTMaxInd') 
		hMatListNo=13;
		hMinListNo=104;
		hMaxListNo=24;
		hPlotPosListNo=31;
		hPlotNegListNo=33;
		hLagListNo=37;
		hPlotSliceListNo=61;
		Ext='itl';
	elseif strcmp(action(4:length(action)),'DepTMaxVal')
		hMatListNo=14;
		hMinListNo=109;
		hMaxListNo=29;
		hPlotPosListNo=32;
		hPlotNegListNo=34;
		hLagListNo=39;
		hPlotSlice=62;
		Ext='dtv';
	elseif strcmp(action(4:length(action)),'DepTMaxInd')
		hMatListNo=14;
		hMinListNo=109;
		hMaxListNo=29;
		hPlotPosListNo=32;
		hPlotNegListNo=34;
		hLagListNo=39;
		hPlotSlice=62;
		Ext='dtl';
	elseif strcmp(action(4:length(action)),'XCorrMaxVal')
		hMatListNo=15;
		hMaxListNo=42;
		hPlotPosListNo=46;
		hLagListNo=48;
		hPlotSliceListNo=63;
		Ext='xcv';
	elseif strcmp(action(4:length(action)),'XCorrMaxInd')
		hMatListNo=16;
		hMaxListNo=54;
		hPlotPosListNo=49;
		hLagListNo=48;
		hPlotSliceListNo=63;
		Ext='xci';
	elseif strcmp(action(4:length(action)),'MutInfoCS')
		hMatListNo=81;
		hMaxListNo=74;
		hPlotPosListNo=66;
		hPlotNegListNo=[];
		hPlotSliceListNo=68;
		Ext='mic';
	elseif strcmp(action(4:length(action)),'MutInfoIS')
		hMatListNo=82;
		hMaxListNo=79;
		hPlotPosListNo=67;
		hPlotNegListNo=[];
		hPlotSliceListNo=68;
		Ext='mii';
	elseif strcmp(action(4:length(action)),'PowerFunc')
		hMatListNo=121;
		hMaxListNo=[];
		hPlotPosListNo=[];
		hPlotNegListNo=[];
		hPlotSliceListNo=[];
		Ext='pfm';
	end
	FilterSpec=['*',Ext,'*'];
	if strcmp(action(1:3),'Avg')
		DialogTitle=['Choose ',Ext,' file to average:'];
	elseif strcmp(action(1:3),'Sub')
		DialogTitle=['Choose two ',Ext,' files to subtract (File 1- File 2):'];
	end
	[NFiles,FileMat,NonUse,BatchFilePath]=ReadFileNames([],FilterSpec,DialogTitle);
	if NFiles==0; return; end
	if strcmp(action(1:3),'Sub') & NFiles~=2;
		error('You have to choose two files.')
		return;
	end
	%Get Maximum Matrix Size of Ana Files
	SizeMat=zeros(NFiles,3);
	InterpStatusVec=zeros(NFiles,1);
	for FileInd=1:NFiles
		[File,Path,FilePath]=GetFileNameOfMat(FileMat,FileInd);
		[NonUse,FilePath,SizeDataMat]=ReadNDimData(FilePath,'float32',[],[],1);
		SizeMat(FileInd,:)=SizeDataMat';
	end
	NSlice=SizeMat(1,3);
	
	if any(SizeMat(:,3)~=NSlice)
		error('Number of slices does not match.')
	end
	if any(SizeMat(:,1)~=SizeMat(1,1)) |  any(SizeMat(:,2)~=SizeMat(1,2))
		MaxXSize=max(SizeMat(:,1));
		MaxYSize=max(SizeMat(:,2));
		InterpX=find(SizeMat(:,1)~=MaxXSize);
		InterpStatusVec(InterpX)=ones(length(InterpX),1);
		InterpY=find(SizeMat(:,2)~=MaxYSize);
		InterpStatusVec(InterpY)=ones(length(InterpY),1);
		InterpDataMat=zeros(MaxXSize,MaxYSize,NSlice);
		InterpAvgMat=zeros(MaxXSize,MaxYSize,NSlice);
	end	

	set(hList(6),'Userdata',BatchFilePath);
	fMRIMenu('SetfMRIMenuFigName');
	[File,Path,FilePath]=GetFileNameOfMat(FileMat,1);
	[AvgMat,FilePath,SizeDataMat,NDim,Version]=ReadNDimData(FilePath,'float32');
	if InterpStatusVec(1)
		for SliceInd=1:NSlice
			InterpAvgMat(:,:,SliceInd)=squeeze(interp2(AvgMat(:,:,SliceInd),linspace(1,SizeMat(1,1),MaxXSize),linspace(1,SizeMat(1,2),MaxYSize)','cubic'));
		end
	else
		InterpAvgMat=AvgMat;
	end
	if strcmp(action(1:3),'Avg') 
		for FileInd=2:NFiles
			[File,Path,FilePath]=GetFileNameOfMat(FileMat,FileInd);
			[DataMat,FilePath,SizeDataMat,NDim,Version]=ReadNDimData(FilePath,'float32');
			if InterpStatusVec(FileInd)
				for SliceInd=1:NSlice
					InterpDataMat(:,:,SliceInd)=squeeze(interp2(DataMat(:,:,SliceInd),linspace(1,SizeMat(FileInd,1),MaxXSize),linspace(1,SizeMat(FileInd,2),MaxYSize)','cubic'));
				end
			else
				InterpDataMat=DataMat;	
			end
			InterpAvgMat=InterpAvgMat+InterpDataMat;	
		end
		InterpAvgMat=InterpAvgMat./NFiles;
	elseif strcmp(action(1:3),'Sub') 
		[File,Path,FilePath]=GetFileNameOfMat(FileMat,2);
		[DataMat,FilePath,SizeDataMat,NDim,Version]=ReadNDimData(FilePath,'float32');
		if InterpStatusVec(2)
			for SliceInd=1:NSlice
				InterpDataMat(:,:,SliceInd)=squeeze(interp2(DataMat(:,:,SliceInd),linspace(1,SizeMat(2,1),MaxXSize),linspace(1,SizeMat(2,2),MaxYSize)','cubic'));
			end
		else
			InterpDataMat=DataMat;
		end
		InterpAvgMat=InterpAvgMat-InterpDataMat;
	end
	if ~isempty(hMinListNo)
		MinVal=min(min(min(InterpAvgMat)));
		set(hList(hMinListNo),'Value',MinVal,'String',sprintf('%g',round(MinVal*Tmp)/Tmp)); 
	end
	if ~isempty(hMaxListNo)
		MaxVal=max(max(max(InterpAvgMat)));
		set(hList(hMaxListNo),'Value',MaxVal,'String',sprintf('%g',round(MaxVal*Tmp)/Tmp)); 
	end
	set(hList(hMatListNo),'Userdata',InterpAvgMat);  %AvgMat
	set(hList(166),'Userdata',InterpAvgMat); 		 %Actual AnaMat
	if ~isempty(hPlotPosListNo)
		set(hList(hPlotPosListNo),'Enable','on'); 
	end
	if ~isempty(hPlotNegListNo)
		set(hList(hPlotNegListNo),'Enable','on'); 
	end
	[FilePath,Version]=SaveNDimData(InterpAvgMat,[],'float32',['01.hl.',Ext],'Save actual data to file:');

elseif strcmp(action,'SaveActualData')

	hList=get(hfMRIMenu,'UserData');
	ActualData=get(hList(166),'Userdata'); 	%Actual AnaMat
	if ~isempty(ActualData)
		FileExt='*';
		DefDataFilePath=SetDefPath(1,FileExt);
		[FilePath,Version]=SaveNDimData(ActualData,[],'float32',DefDataFilePath,'Save actual data to file:');
		if ~isempty(FilePath)
			[File,Path]=SepFilePath(FilePath);
			SetDefPath(2,Path);
		end
	end
	
elseif strcmp(action,'SubRaw') | ...
	strcmp(action,'OrderRawByInd1') | ...
	strcmp(action,'OrderRawByInd2'),

	hList=get(hfMRIMenu,'UserData');
	FileExt='*.fun*';
	DefDataFilePath=SetDefPath(1,FileExt);
	[NFiles,FileMat,VersionString,BatchFilePath]=ReadFileNames([],DefDataFilePath,'Choose two files to subtract (first minus second):');
	if NFiles>2 | NFiles<1; 
		Message=char('Sorry,');
		Message=char(Message,'you have to choose two files !');
		hBatchMsgbox=msgbox(Message,'Info:','help'); 
		return; 
	end
	[DefFile,DefPath]=SepFilePath(BatchFilePath);
	SetDefPath(2,DefPath);
	set(hList(117),'Userdata',FileMat);
	set(hList(117),'Value',1);
	fMRIMenu('NoCallReadFunc')
	FuncMat1=get(hList(5),'Userdata');
	set(hList(117),'Value',2);
	fMRIMenu('NoCallReadFunc')
	FuncMat2=get(hList(5),'Userdata');
	if strcmp(action,'SubRaw')
		FuncMat=FuncMat1-FuncMat2;
	elseif strcmp(action,'OrderRawByInd1') | strcmp(action,'OrderRawByInd2')
		SizeFuncMat=get(hList(137),'Userdata'); %hSizeFuncMat
		NShot=SizeFuncMat(4);
		SubMat1=FuncMat1(:,:,:,1);
		SubMat2=FuncMat2(:,:,:,1);
		for i=1:NShot
			FuncMat1(:,:,:,i)=FuncMat1(:,:,:,i)-SubMat1;
			FuncMat2(:,:,:,i)=FuncMat2(:,:,:,i)-SubMat2;
		end
		FuncMat1=FuncMat1-min(min(min(min(FuncMat1))));
		FuncMat2=FuncMat2-min(min(min(min(FuncMat2))));
		BaseVal=get(hList(37),'Value');
		NShotPerCycle=get(hList(87),'Value');
		[IndVec1,IndVec2,Num,LastShot]=CalcInd12Vec(SizeFuncMat(4),NShotPerCycle,BaseVal)
		FuncMat=zeros(size(FuncMat1));
		if strcmp(action,'OrderRawByInd1') 
			FuncMat(:,:,:,IndVec1)=FuncMat1(:,:,:,IndVec1);
			FuncMat(:,:,:,IndVec2)=FuncMat2(:,:,:,IndVec1);
		elseif strcmp(action,'OrderRawByInd2') 
			FuncMat(:,:,:,IndVec1)=FuncMat1(:,:,:,IndVec2);
			FuncMat(:,:,:,IndVec2)=FuncMat2(:,:,:,IndVec2);
		end
	end
	set(hList(5),'Userdata',FuncMat);
	
	
elseif strcmp(action,'WriteBatchAll') | strcmp(action,'WriteBatchSub')

	hList=get(hfMRIMenu,'UserData');
	if strcmp(action,'WriteBatchAll')
		ReadPrompt = {'Enter full path all data:'};
		if strcmp(computer,'MAC2')	
			ReadDef = {'00'};
		elseif  strcmp(computer,'SOL2')	
			ReadDef = {'.../'};
		end
 		ReadDlgTitle = 'All data path:';
    		Path=inputdlg(ReadPrompt,ReadDlgTitle,1,ReadDef);
	elseif strcmp(action,'WriteBatchSub')	
		ReadPrompt = {'Enter full path of subject data:'};
		if strcmp(computer,'MAC2')	
			ReadDef = {'Movie:00'};
		elseif  strcmp(computer,'SOL2')	
			ReadDef = {'.../'};
		end
 		ReadDlgTitle = 'All data path:';
    		Path=inputdlg(ReadPrompt,ReadDlgTitle,1,ReadDef);
	end
	if isempty(Path); return; end
	Path1=char(Path);
	if ~strcmp(Path1(length(Path1)),FileSep);
		Path1=[Path1,FileSep];
	end
	F1=dir(Path1);
	NFile1=size(F1,1);
	FileInd0=0;
	for FileInd1=1:NFile1
		F2 = (F1(FileInd1,1).name(:))';
		IsDirStatus = (F1(FileInd1,1).isdir(:))';
		if IsDirStatus
			Path2=[Path1,F2];
			F2=dir(Path2);
			if ~strcmp(Path2(length(Path2)),FileSep)
				Path2=[Path2,FileSep];
			end
			NFile2=size(F2,1);
			for FileInd2=1:NFile2
				F3 = (F2(FileInd2,1).name(:))';
				IsDirStatus = (F2(FileInd2,1).isdir(:))';
				if IsDirStatus
					Path3=[Path2,F3];
					F3=dir(Path3);
					if ~strcmp(Path3(length(Path3)),FileSep)
						Path3=[Path3,FileSep];
					end
					NFile3=size(F3,1);
					for FileInd3=1:NFile3
						F4=(F3(FileInd3,1).name(:))';
						if strcmp(F4(length(F4)-2:length(F4)),'fun')
							FileInd0=FileInd0+1;
							if FileInd0==1
								BatchFilePath='AllBatch.fun'
								fprintf(1,'Write file names to file:\n\n')
								fprintf(1,BatchFilePath)
								BatchFid=fopen(BatchFilePath,'w');
							else
								fprintf(BatchFid,[Path3,F4,'\n']);
							end
						end
					end
				end
			end
		end
	end
	if FileInd0>0; fclose(BatchFid); end
	
elseif strcmp(action,'ReformatSubject')

	hList=get(hfMRIMenu,'UserData');
	ReadPrompt = {'Enter full path of subject data'};
	if strcmp(computer,'MAC2')	
		ReadDef = {'Paul:fMRIDataKN:'};
	elseif  strcmp(computer,'SOL2')	
		ReadDef = {'.../R003'};
	end
 	ReadDlgTitle = 'Subjects Path';
    SubjPath=inputdlg(ReadPrompt,ReadDlgTitle,1,ReadDef);
	if isempty(SubjPath); return; end
	SubjPath=char(SubjPath);
	if ~strcmp(SubjPath(length(SubjPath)),FileSep)
		SubjPath=[SubjPath,FileSep];
	end
	S=dir(SubjPath);
	NFileFold=size(S,1)
	for FileFoldInd=1:NFileFold
		F = (S(FileFoldInd,1).name(:))';
		FilePathOld=['"' SubjPath,F '"'];
		FilePathOldDisp=[SubjPath,F];
 		NewFile=[F(5:length(F)-8)]
		fprintf(FilePathOldDisp); fprintf('  =>  '); fprintf([SubjPath,NewFile]); fprintf('\n');
		NewFile=['"' NewFile '"'];
 		RenameResult = applescript('arename', 'itemName', FilePathOld, 'newName', NewFile)
	end
	return
	WritePrompt = {'Enter full path to save data:'};
	if strcmp(computer,'MAC2')	
		WriteDef = {'Paul:fMRIDataKN:01'};
	elseif  strcmp(computer,'SOL2')	
		WriteDef = {'.../R003'};
	end
 	WriteDlgTitle = 'Save Path';
    WritePath=inputdlg(WritePrompt,WriteDlgTitle,1,WriteDef);
	if isempty(WritePath); return; end
	WritePath=char(WritePath);
	if ~strcmp(WritePath(length(WritePath)),FileSep)
		WritePath=[WritePath,FileSep];
	end
	if ~exist(WritePath)
		WritePath=pwd;
	end
	for FileFoldInd=1:NFileFold
		F = (S(FileFoldInd,1).name(:))';
		IsDirStatus = (S(FileFoldInd,1).isdir(:))';
		if IsDirStatus
			DefPath=[SubjPath,F];
			T=dir(DefPath);
			NFile=size(T,1);
			if NFile==7 | NFile==8
				[Mat,StrucFilePath,SizeStrucMat]=ReadStruc(DefPath,1,[WritePath,F,'.str']);
			elseif NFile>=504
				[Mat,FuncFilePath,SizeFuncMat]=ReadEPI(DefPath,1,[WritePath,F,'.fun']);
			end
		end
	end
	
elseif strcmp(action,'ReadStruc') | strcmp(action,'NoCallReadStruc')

	hList=get(hfMRIMenu,'UserData');	
	if strcmp(action,'NoCallReadStruc')
		FilePath=get(hList(2),'Userdata');
	else
		FilePath=[];
	end
	FileExt='*.str*';
	DefDataFilePath=SetDefPath(1,FileExt);
	[Mat,FilePath,SizeDataMat,NDim,Version]=ReadNDimData(FilePath,'int16',DefDataFilePath,'Choose Structural File:');
	if isempty(Mat); return; end
	[DefFile,DefPath]=SepFilePath(FilePath);
	SetDefPath(2,DefPath);
	NSlice=SizeDataMat(3);
	set(hList(1),'Userdata',Mat);  			%hStrucMat
	set(hList(2),'Userdata',FilePath);  			%hReadStrucMat
	set(hList(136),'Userdata',SizeDataMat);  	%hSizeStrucMat
	LabelStr=' Slice: 1';
	for Ind=2:NSlice; 
		LabelStr=[LabelStr '| Slice: ' ,int2str(Ind)];
	end
	set(hList(56),'String',LabelStr,'Enable','on');
	fMRIMenu('SetfMRIMenuFigNameStruc')	

elseif strcmp(action,'PlotStruc')

	hList=get(hfMRIMenu,'UserData');
	StrucFilePath=get(hList(2),'Userdata');  	%hReadStrucMat
	[StrucFile,StrucPath]=SepFilePath(StrucFilePath);
	Slice=get(hList(56),'Value');
	SliceLabel=get(hList(56),'String');
	NSlice=size(SliceLabel,1);
	FigSize=[0 .5 .4 .5];
	StrucMat=get(hList(1),'Userdata');  	%hStrucMat
	[XSizeStruc,YSizeStruc,NSlice]=size(StrucMat);
	
	hFig=figure('Units','normal','Position',FigSize, 'Name',['File: ',StrucFile,';  Slice: ',int2str(Slice)],'Color',[.99 .99 .99], 'NumberTitle','off');
	hAxes=axes('Units','normal','Position',[0 0 1 1]);
	RGBAnatImg=zeros(XSizeStruc,YSizeStruc,3);
	Tmp=squeeze(StrucMat(:,:,Slice));
	Tmp=Tmp./max(max(Tmp));
	RGBAnatImg(:,:,1)=Tmp;
	RGBAnatImg(:,:,2)=Tmp;
	RGBAnatImg(:,:,3)=Tmp;
	image(RGBAnatImg)
	axis off
	figure(hfMRIMenu)

elseif strcmp(action,'CalcAnaSymBatch')

	hList=get(hfMRIMenu,'UserData');
	FileExt='*sem.str*';
	DefDataFilePath=SetDefPath(1,FileExt);
	[NEditFiles,EditFileMat]=ReadFileNames([],DefDataFilePath,'Choose EditMat file(s):');
	if NEditFiles==0; return; end
	DefDataFilePath=SetDefPath(1);
	[NAnaFiles,AnaFileMat]=ReadFileNames([],DefDataFilePath,'Choose analyzed data file(s):');
	if NAnaFiles==0; return; end
	PowerFuncFileMat=PutFileExt2Mat(AnaFileMat,'pfm',3);
	StatFile='.stat';
	[StatFile,StatPath,StatFilePath]=WriteFilePath(StatFile,'Write Stats to file:');
	StatFid=fopen(StatFilePath,'w');
	if StatFid==-1; error(['Can not open file: ',StatFilePath,' for writing.']); end
	PowerMaskVal=.5;
	MinSigAnaVal=get(hList(22),'Value');
	set(hList(168),'Value',[]); %hFig
	for EditFileInd=1:2
		for AnaFileInd=1:NAnaFiles
			[AnaFile,AnaPath,AnaFilePath]=GetFileNameOfMat(AnaFileMat,AnaFileInd);
			set(hList(169),'Userdata',AnaFilePath); 
			[ActualMat,AnaFilePath,SizeAnaMat,AnaNDim]=ReadNDimData(AnaFilePath,'float32');
			if AnaNDim==4
				SpecLag=1
				ActualMat=ActualMat(:,:,:,SpecLag);
			end
			set(hList(166),'Userdata',ActualMat);
			
			[EditFile,EditPath,EditFilePath]=GetFileNameOfMat(EditFileMat,(EditFileInd-1).*NAnaFiles+AnaFileInd);			
			set(hList(167),'Userdata',EditFilePath); 
			EditMat=ReadNDimData(EditFilePath,'int16');
			set(hList(161),'Userdata',EditMat);
			
			[PowerFuncFile,PowerFuncPath,PowerFuncFilePath]=GetFileNameOfMat(PowerFuncFileMat,AnaFileInd);
			PowerFuncMat=ReadNDimData(PowerFuncFilePath,'float32');
			set(hList(121),'Userdata',PowerFuncMat,'Value',PowerMaskVal);	
			
			fMRIMenu('CalcAnaSymNoCall')

			AnaStatMat=get(hList(168),'Userdata');
			[NSliceAna,NAnaStatVal]=size(AnaStatMat);
			for SliceInd=1:NSliceAna
				fprintf(StatFid,[AnaFile,'\t']);
				fprintf(StatFid,[EditFile,'\t']);
				fprintf(StatFid,[sprintf('%g',PowerMaskVal),'\t']);
				fprintf(StatFid,[sprintf('%g',MinSigAnaVal),'\t']);
				fprintf(StatFid,[sprintf('%g',SliceInd),'\t']);
				fprintf(StatFid,[sprintf('%g\t',AnaStatMat(SliceInd,:)),'\n']);
			end
		end
	end
	fclose(StatFid);
	
elseif strcmp(action,'CalcAnaSym') | strcmp(action,'CalcAnaSymNoCall')

	hList=get(hfMRIMenu,'UserData');
	EditMat=get(hList(161),'Userdata');
	if isempty(EditMat)
		fMRIMenu('ReadEditMat')
		EditMat=get(hList(161),'Userdata'); 
		if isempty(EditMat); return; end
	end
	EditFilePath=get(hList(167),'Userdata'); 
	[EditFile,EditPath]=SepFilePath(EditFilePath);
	[XSizeEdit,YSizeEdit,NSliceEdit]=size(EditMat);
	AnaMat=get(hList(166),'Userdata');
	if isempty(AnaMat); 
		Message=char('Sorry,');
		Message=char(Message,'no analyzed functional data available.');
		Message=char(Message,'');
		Message=char(Message,'Please import analyzed or calculate functional data.');
		Message=char(Message,'');
		hMsgbox=msgbox(Message,'Info:','help'); 
		return; 
	end
	AnaFilePath=get(hList(169),'Userdata'); 
	[AnaFile,AnaPath]=SepFilePath(AnaFilePath);
	[XSizeAna,YSizeAna,NSliceAna]=size(AnaMat);

	MinSigAnaVal=get(hList(22),'Value');
	
	SigAnaMat=AnaMat.*(AnaMat>MinSigAnaVal);
 	PowerLim=get(hList(121),'Value');
	if PowerLim>0
		PowerFuncMat=get(hList(121),'Userdata');	%PowerMaskSlider
	end
	InterpStatus=0;
	if XSizeEdit~=XSizeAna | YSizeEdit~=YSizeAna
		InterpStatus=1;
		Interp2Str='cubic';
	end
	hFig=get(hList(168),'Value');
	if isempty(hFig)
		hFig=figure('Units','normal','Position',[0 0 1 1],'Color',[0 0 0], 'NumberTitle','off');
		hAxes1=axes('Units','normal','Position',[0 0 .6 .6],'Color',[0 0 0]);
		hAxes2=axes('Units','normal','Position',[0 .4 .6 .6],'Color',[0 0 0]);
	else
		figure(hFig);
		hFigChild=get(hFig,'Children');
		hAxes1=hFigChild(1);
		hAxes2=hFigChild(2);
	end
	FigNameStr=['Ana. File: ',AnaFile,'; Edit File: ',EditFile,'; Slice: '];
	RGBImg=zeros(XSizeEdit,YSizeEdit,3);
	AnaStatMat=zeros(NSliceAna,5);
	for SliceInd=1:NSliceAna
		SliceEditMat=squeeze(EditMat(:,:,SliceInd));
		AnaStatMat(SliceInd,1)=sum(sum(SliceEditMat));			%Abs. # of Pixels in area
		if InterpStatus
			SliceAnaMat=squeeze(interp2(AnaMat(:,:,SliceInd),linspace(1,XSizeAna,XSizeEdit),linspace(1,YSizeAna,YSizeEdit)',Interp2Str));
			SliceSigAnaMat=squeeze(interp2(SigAnaMat(:,:,SliceInd),linspace(1,XSizeAna,XSizeEdit),linspace(1,YSizeAna,YSizeEdit)',Interp2Str));
			if PowerLim>0
				SlicePowerFuncMat=squeeze(interp2(PowerFuncMat(:,:,SliceInd),linspace(1,XSizeAna,XSizeEdit),linspace(1,YSizeAna,YSizeEdit)',Interp2Str));
			end
		else
			SliceAnaMat=squeeze(AnaMat(:,:,SliceInd));
			SliceSigAnaMat=squeeze(SigAnaMat(:,:,SliceInd));
			if PowerLim>0
				SlicePowerFuncMat=squeeze(PowerFuncMat(:,:,SliceInd));
			end
		end
		if PowerLim>0
			SlicePowerFuncMat=SlicePowerFuncMat>PowerLim;
			SliceSigAnaMat=SliceSigAnaMat.*SlicePowerFuncMat;
			SliceAnaMat=SliceAnaMat.*SlicePowerFuncMat;
		end
		SliceSigAnaMatTmp=SliceSigAnaMat.*SliceEditMat;
		SliceSigAnaMatTmp=SliceSigAnaMatTmp.*(SliceSigAnaMatTmp>0);
		AnaStatMat(SliceInd,2)=sum(sum(SliceSigAnaMatTmp));		%Sum of t in area > MinSig
		AnaStatMat(SliceInd,3)=sum(sum((SliceSigAnaMatTmp>0)));	%Sum of t=1 in area > MinSig
		
		MaxMaxSliceAnaMatTmp=max(max(SliceSigAnaMatTmp));
		SliceSigAnaMatTmp=SliceSigAnaMatTmp./MaxMaxSliceAnaMatTmp;
		RGBImg(:,:,1)=SliceSigAnaMatTmp;
		RGBImg(:,:,2)=RGBImg(:,:,1);
		RGBImg(:,:,3)=RGBImg(:,:,1);
		axes(hAxes2)
		image(RGBImg)
		axis('off')

		MaxMaxSliceAnaMat=max(max(SliceAnaMat));
		SliceAnaMatTmp=SliceAnaMat./MaxMaxSliceAnaMat;
		SliceAnaMatTmp=SliceAnaMatTmp.*(SliceAnaMatTmp>0);
		RGBImg(:,:,1)=SliceAnaMatTmp;
		RGBImg(:,:,2)=RGBImg(:,:,1);
		RGBImg(:,:,3)=RGBImg(:,:,1);
		axes(hAxes1)
		image(RGBImg)
		axis('off')
		
		set(hFig,'Name',[FigNameStr,int2str(SliceInd)])
		pause(.1)
		if AnaStatMat(SliceInd,1)>0
			AnaStatMat(SliceInd,4)=AnaStatMat(SliceInd,2)./AnaStatMat(SliceInd,1);	%Rel. Sum of t in area > MinSig
			AnaStatMat(SliceInd,5)=AnaStatMat(SliceInd,3)./AnaStatMat(SliceInd,1);	%Rel. Sum of t=1 in area > MinSig
		end
	end
	disp(AnaStatMat)
	if strcmp(action,'CalcAnaSym')
		Save2Jmp(AnaStatMat)
	else
		set(hList(168),'Userdata',AnaStatMat,'Value',hFig)
	end

elseif strcmp(action,'CompareAna')

	hList=get(hfMRIMenu,'UserData');

	DefDataFilePath1=SetDefPath(1,'*');
	[NAnaFiles1,AnaFileMat1,NonUse,BatchFilePath]=ReadFileNames([],DefDataFilePath1,'Choose first analyzed data file(s):');
	BatchFilePath=BatchFilePath
	if NAnaFiles1==0; return; end
	[BatchFile,BatchPath]=SepFilePath(BatchFilePath);
	SetDefPath(2,BatchPath);
	
	DefDataFilePath2=SetDefPath(1,'*');
	[NAnaFiles2,AnaFileMat2,NonUse,BatchFilePath]=ReadFileNames([],DefDataFilePath2,'Choose second analyzed data file(s):');
	if NAnaFiles2==0; return; end
	[BatchFile,BatchPath]=SepFilePath(BatchFilePath);
	SetDefPath(2,BatchPath);
	NAnaFiles=min([NAnaFiles1,NAnaFiles2]);

	DefDataFilePath3=SetDefPath(1,'*');
	[NAnaFiles3,AnaFileMat3,NonUse,BatchFilePath]=ReadFileNames([],DefDataFilePath3,'Choose third analyzed data file(s):');
	if NAnaFiles3>0
		NAnaFiles=min([NAnaFiles1,NAnaFiles2,NAnaFiles3]);
		[BatchFile,BatchPath]=SepFilePath(BatchFilePath);
		SetDefPath(2,BatchPath);
	end

	DefDataFilePath4=SetDefPath(1,'*');
	[NAnaFiles4,AnaFileMat4,NonUse,BatchFilePath]=ReadFileNames([],DefDataFilePath4,'Choose fourth analyzed data file(s):');
	if NAnaFiles4>0
		NAnaFiles=min([NAnaFiles1,NAnaFiles2,NAnaFiles3,NAnaFiles4]);
		[BatchFile,BatchPath]=SepFilePath(BatchFilePath);
		SetDefPath(2,BatchPath);
	end
	
	PowerFuncFileMat1=PutFileExt2Mat(AnaFileMat1,'pfm',3);
	PowerFuncFileMat2=PutFileExt2Mat(AnaFileMat2,'pfm',3);
	if NAnaFiles3>0
		PowerFuncFileMat3=PutFileExt2Mat(AnaFileMat3,'pfm',3);
	end
	if NAnaFiles4>0
		PowerFuncFileMat4=PutFileExt2Mat(AnaFileMat4,'pfm',3);
	end
	PowerMaskVal=.5;
	MinSigAnaVal=get(hList(22),'Value');

	MinSigAnaVal=get(hList(22),'Value');
	PowerLim=get(hList(121),'Value');
	PowerLim=0.5;
	Interp2Str='cubic';
	if NAnaFiles3>0
		hFig=figure('Units','normal','Position',[0 0 1 1],'Color',[0 0 0], 'NumberTitle','off');
		hAxes1=axes('Units','normal','Position',[0 .5 .5 .5],'Color',[0 0 0]);
		hAxes2=axes('Units','normal','Position',[0 0 .5 .5],'Color',[0 0 0]);
		hAxes3=axes('Units','normal','Position',[.5 .5 .5 .5],'Color',[0 0 0]);
		hAxes4=axes('Units','normal','Position',[.5 0 .5 .5],'Color',[0 0 0]);
	else
		hFig=figure('Units','normal','Position',[0 0 .5 1],'Color',[0 0 0], 'NumberTitle','off');
		hAxes1=axes('Units','normal','Position',[0 .5 1 .5],'Color',[0 0 0]);
		hAxes2=axes('Units','normal','Position',[0 0 1 .5],'Color',[0 0 0]);
	end
	
	for AnaFileInd=1:NAnaFiles

		SpecLag=1
		[AnaFile1,AnaPath1,AnaFilePath1]=GetFileNameOfMat(AnaFileMat1,AnaFileInd)
		[AnaMat1,AnaFilePath1,AnaSizeDataMat1,AnaNDim1]=ReadNDimData(AnaFilePath1,'float32');
		if AnaNDim1==4
			AnaMat1=AnaMat1(:,:,:,SpecLag);
		end
		[XSizeAna1,YSizeAna1,NSliceAna1]=size(AnaMat1);
		
		[AnaFile2,AnaPath2,AnaFilePath2]=GetFileNameOfMat(AnaFileMat2,AnaFileInd)
		[AnaMat2,AnaFilePath2,AnaSizeDataMat2,AnaNDim2]=ReadNDimData(AnaFilePath2,'float32');
		if AnaNDim2==4
			AnaMat2=AnaMat2(:,:,:,SpecLag);
		end
		[XSizeAna2,YSizeAna2,NSliceAna2]=size(AnaMat2);
		NSliceAna=min([NSliceAna1,NSliceAna2]);
		if NAnaFiles3>0
			[AnaFile3,AnaPath3,AnaFilePath3]=GetFileNameOfMat(AnaFileMat3,AnaFileInd)
			[AnaMat3,AnaFilePath3,AnaSizeDataMat3,AnaNDim3]=ReadNDimData(AnaFilePath3,'float32');
			if AnaNDim3==4
				AnaMat3=AnaMat3(:,:,:,SpecLag);
			end
			[XSizeAna3,YSizeAna3,NSliceAna3]=size(AnaMat3);
			NSliceAna=min([NSliceAna1,NSliceAna2,NSliceAna3]);
		end
		if NAnaFiles4>0
			[AnaFile4,AnaPath4,AnaFilePath4]=GetFileNameOfMat(AnaFileMat4,AnaFileInd)
			[AnaMat4,AnaFilePath4,AnaSizeDataMat4,AnaNDim4]=ReadNDimData(AnaFilePath4,'float32');
			if AnaNDim4==4
				AnaMat4=AnaMat4(:,:,:,SpecLag);
			end
			[XSizeAna4,YSizeAna4,NSliceAna4]=size(AnaMat4);
			NSliceAna=min([NSliceAna1,NSliceAna2,NSliceAna3,NSliceAna4]);
		end
		if PowerLim>0
			[PowerFuncFile1,PowerFuncPath1,PowerFuncFilePath1]=GetFileNameOfMat(PowerFuncFileMat1,AnaFileInd)
			PowerFuncMat1=ReadNDimData(PowerFuncFilePath1,'float32');
			[PowerFuncFile2,PowerFuncPath2,PowerFuncFilePath2]=GetFileNameOfMat(PowerFuncFileMat2,AnaFileInd)
			PowerFuncMat2=ReadNDimData(PowerFuncFilePath2,'float32');
			if NAnaFiles3>0
				[PowerFuncFile3,PowerFuncPath3,PowerFuncFilePath3]=GetFileNameOfMat(PowerFuncFileMat3,AnaFileInd)
				PowerFuncMat3=ReadNDimData(PowerFuncFilePath3,'float32');
			end
			if NAnaFiles4>0
				[PowerFuncFile4,PowerFuncPath4,PowerFuncFilePath4]=GetFileNameOfMat(PowerFuncFileMat4,AnaFileInd)
				PowerFuncMat4=ReadNDimData(PowerFuncFilePath4,'float32');
			end
		end
% 		MinSlice=1;
% 		MaxSlice=NSliceAna;
		MinSlice=2;
		MaxSlice=6;
		PlotSubStatus=1;
		for SliceInd=MinSlice:MaxSlice	
			
			SliceAnaMat1=squeeze(AnaMat1(:,:,SliceInd));
			[XSizeAna1,YSizeAna1]=size(SliceAnaMat1);
			SliceAnaMat1=squeeze(interp2(SliceAnaMat1,linspace(1,XSizeAna1,256),linspace(1,YSizeAna1,256)',Interp2Str));
			if PowerLim>0
				SlicePowerFuncMat=squeeze(PowerFuncMat1(:,:,SliceInd));
				[XSize,YSize]=size(SlicePowerFuncMat);
				SlicePowerFuncMat=squeeze(interp2(SlicePowerFuncMat,linspace(1,XSize,256),linspace(1,YSize,256)',Interp2Str));
				SlicePowerFuncMat=SlicePowerFuncMat>PowerLim;
				SliceAnaMat1=SliceAnaMat1.*SlicePowerFuncMat;
			end
		
			SliceAnaMat2=squeeze(AnaMat2(:,:,SliceInd));
			[XSizeAna2,YSizeAna2]=size(SliceAnaMat2);
			SliceAnaMat2=squeeze(interp2(SliceAnaMat2,linspace(1,XSizeAna2,256),linspace(1,YSizeAna2,256)',Interp2Str));
			if PowerLim>0
				SlicePowerFuncMat=squeeze(PowerFuncMat2(:,:,SliceInd));
				[XSize,YSize]=size(SlicePowerFuncMat);
				SlicePowerFuncMat=squeeze(interp2(SlicePowerFuncMat,linspace(1,XSize,256),linspace(1,YSize,256)',Interp2Str));
				SlicePowerFuncMat=SlicePowerFuncMat>PowerLim;
				SliceAnaMat2=SliceAnaMat2.*SlicePowerFuncMat;
			end
			FigNameStr=['Upper: ',AnaFile1,';  Lower: ',AnaFile2,';  Slice: '];
			if NAnaFiles3>0
				FigNameStr=['Upper Left: ',AnaFile1,';  Lower Left: ',AnaFile2,';  Upper Right: ',AnaFile3,';  Slice: '];
				SliceAnaMat3=squeeze(AnaMat3(:,:,SliceInd));
				[XSizeAna3,YSizeAna3]=size(SliceAnaMat3);
				SliceAnaMat3=squeeze(interp2(SliceAnaMat3,linspace(1,XSizeAna3,256),linspace(1,YSizeAna3,256)',Interp2Str));
				if PowerLim>0
					SlicePowerFuncMat=squeeze(PowerFuncMat3(:,:,SliceInd));
					[XSize,YSize]=size(SlicePowerFuncMat);
					SlicePowerFuncMat=squeeze(interp2(SlicePowerFuncMat,linspace(1,XSize,256),linspace(1,YSize,256)',Interp2Str));
					SlicePowerFuncMat=SlicePowerFuncMat>PowerLim;
					SliceAnaMat3=SliceAnaMat3.*SlicePowerFuncMat;
				end
			end
		
			if NAnaFiles4>0
				FigNameStr=['Upper Left: ',AnaFile1,';  Lower Left: ',AnaFile2,';  Upper Right: ',AnaFile3,';  Lower Right: ',AnaFile4,';  Slice: '];
				SliceAnaMat4=squeeze(AnaMat4(:,:,SliceInd));
				[XSizeAna4,YSizeAna4]=size(SliceAnaMat4);
				SliceAnaMat4=squeeze(interp2(SliceAnaMat4,linspace(1,XSizeAna4,256),linspace(1,YSizeAna4,256)',Interp2Str));
				if PowerLim>0
					SlicePowerFuncMat=squeeze(PowerFuncMat4(:,:,SliceInd));
					[XSize,YSize]=size(SlicePowerFuncMat);
					SlicePowerFuncMat=squeeze(interp2(SlicePowerFuncMat,linspace(1,XSize,256),linspace(1,YSize,256)',Interp2Str));
					SlicePowerFuncMat=SlicePowerFuncMat>PowerLim;
					SliceAnaMat4=SliceAnaMat4.*SlicePowerFuncMat;
				end
			end
			if PlotSubStatus
				FigNameStr=['Upper Left: ',AnaFile1,';  Lower Left: ',AnaFile2,';  Upper Right: ',AnaFile3,';  Lower Right: Lower Left - Upper Left;  Slice: '];
% 				SliceAnaMat4=SliceAnaMat2-SliceAnaMat1;
			end
			
			MaxMaxSliceAnaMat=max(max(SliceAnaMat1));
			SliceAnaMatTmp=SliceAnaMat1./MaxMaxSliceAnaMat;
			SliceAnaMatTmp=SliceAnaMatTmp.*(SliceAnaMatTmp>0);
			if PlotSubStatus
				SliceAnaMatTmp1=SliceAnaMatTmp;
			end
			[XSizeAna,YSizeAna]=size(SliceAnaMatTmp);
			RGBImg=zeros(XSizeAna,YSizeAna,3);
			RGBImg(:,:,1)=SliceAnaMatTmp;
			RGBImg(:,:,2)=RGBImg(:,:,1);
			RGBImg(:,:,3)=RGBImg(:,:,1);
			axes(hAxes1)
			image(RGBImg)
			axis('off')
			
			MaxMaxSliceAnaMat=max(max(SliceAnaMat2));
			SliceAnaMatTmp=SliceAnaMat2./MaxMaxSliceAnaMat;
			SliceAnaMatTmp=SliceAnaMatTmp.*(SliceAnaMatTmp>0);
			if PlotSubStatus
				SliceAnaMatTmp2=SliceAnaMatTmp;
			end
			[XSizeAna,YSizeAna]=size(SliceAnaMatTmp);
			RGBImg=zeros(XSizeAna,YSizeAna,3);
			RGBImg(:,:,1)=SliceAnaMatTmp;
			RGBImg(:,:,2)=RGBImg(:,:,1);
			RGBImg(:,:,3)=RGBImg(:,:,1);
			axes(hAxes2)
			image(RGBImg)
			axis('off')
				
			if NAnaFiles3>0
				MaxMaxSliceAnaMat=max(max(SliceAnaMat3));
				SliceAnaMatTmp=SliceAnaMat3./MaxMaxSliceAnaMat;
				SliceAnaMatTmp=SliceAnaMatTmp.*(SliceAnaMatTmp>0);
				[XSizeAna,YSizeAna]=size(SliceAnaMatTmp);
				RGBImg=zeros(XSizeAna,YSizeAna,3);
				RGBImg(:,:,1)=SliceAnaMatTmp;
				RGBImg(:,:,2)=RGBImg(:,:,1);
				RGBImg(:,:,3)=RGBImg(:,:,1);
				axes(hAxes3)
				image(RGBImg)
				axis('off')
			end
		
			if NAnaFiles4>0 | PlotSubStatus
				if PlotSubStatus
					SliceAnaMat4=SliceAnaMatTmp2-SliceAnaMatTmp1;
				end
				MaxMaxSliceAnaMat=max(max(SliceAnaMat4));
				SliceAnaMatTmp=SliceAnaMat4./MaxMaxSliceAnaMat;
				SliceAnaMatTmp=SliceAnaMatTmp.*(SliceAnaMatTmp>0);
				[XSizeAna,YSizeAna]=size(SliceAnaMatTmp);
				RGBImg=zeros(XSizeAna,YSizeAna,3);
				RGBImg(:,:,1)=SliceAnaMatTmp;
				RGBImg(:,:,2)=RGBImg(:,:,1);
				RGBImg(:,:,3)=RGBImg(:,:,1);
				axes(hAxes4)
				image(RGBImg)
				axis('off')
			end
			set(hFig,'Name',[FigNameStr,int2str(SliceInd)])
			pause(.1)
		end
	end

elseif strcmp(action,'ReadEditMat')

	hList=get(hfMRIMenu,'UserData');
	EditMatFilePath=get(hList(167),'Userdata'); 
	DefDataFilePath=[];
	if isempty(EditMatFilePath)
		StrucFilePath=get(hList(2),'Userdata');  	%hReadStrucMat
		if ~isempty(StrucFilePath)
			[StrucFile,StrucPath]=SepFilePath(StrucFilePath);
		else
			StrucPath=[];
		end
		FileExt=[StrucPath,'*sem.str*'];
		DefDataFilePath=SetDefPath(1,FileExt);
	end
	[EditMat,EditMatFilePath,SizeEditMat,NDim,Version]=ReadNDimData([],'int16',DefDataFilePath,'Read Structural Edit Matrix:');
	set(hList(161),'Userdata',EditMat);
	if ~isempty(EditMatFilePath)
		[EditMatFile,EditMatPath]=SepFilePath(EditMatFilePath);
		SetDefPath(2,EditMatPath);
		set(hList(167),'Userdata',EditMatPath); 
	end
	
elseif strcmp(action,'AvgStruc')

	hList=get(hfMRIMenu,'UserData');
	
	[NFiles,FileMat]=ReadFileNames([],'*str*','Choose structural files to average:');
	if NFiles<2; return; end
	[File,Path,FilePath]=GetFileNameOfMat(FileMat,1);
	[AvgMat,FilePath,SizeDataMat,NDim,Version]=ReadNDimData(FilePath,'int16');
	[XSize,YSize,NSlice,NShot]=size(AvgMat);
	for FileInd=2:NFiles
		[File,Path,FilePath]=GetFileNameOfMat(FileMat,FileInd);
		[Mat,FilePath,SizeDataMat,NDim,Version]=ReadNDimData(FilePath,'int16');
		AvgMat=AvgMat+Mat;
	end
	AvgMat=AvgMat./NFiles;
	set(hList(1),'Userdata',AvgMat);  %FuncMat
	
elseif strcmp(action,'ExpMeanFunAsStruc')

	hList=get(hfMRIMenu,'UserData');
	FunMat=get(hList(5),'Userdata');
	[XSizeFun,YSizeFun,NSlice,NDyn]=size(FunMat);
	MeanFun=squeeze(mean(FunMat,4));
	XSizeStruc=256
	YSizeStruc=256
	if XSizeFun~=XSizeStruc | YSizeFun~=YSizeStruc
		StrucMat=zeros(XSizeStruc,YSizeStruc,NSlice);
		Interp2Str='cubic';
		for SliceInd=1:NSlice
			StrucMat(:,:,SliceInd)=interp2(MeanFun(:,:,SliceInd),linspace(1,XSizeFun,XSizeStruc),linspace(1,YSizeFun,YSizeStruc)',Interp2Str);
		end
	else
		StrucMat=MeanFun;
	end
	AbsMinStrucMat=min(min(min(StrucMat)));
	StrucMat=StrucMat-AbsMinStrucMat;	
	StrucMat=StrucMat./max(max(max(StrucMat)));
	StrucMat=StrucMat.*(2^16./2-1);
	[File,Path,FilePath]=WriteFilePath('*.str','Choose structural file name:');
	SaveNDimData(StrucMat,FilePath,'int16');

elseif strcmp(action,'EditStruc')

	hList=get(hfMRIMenu,'UserData');
	StrucMat=get(hList(1),'Userdata');  	%hStrucMat
	if isempty(StrucMat)
		fMRIMenu('ReadStruc')
		StrucMat=get(hList(1),'Userdata');  	%hStrucMat
		if isempty(StrucMat); return; end
	end
	[XSizeStruc,YSizeStruc,NSlice]=size(StrucMat);
	StrucFilePath=get(hList(2),'Userdata');  	%hReadStrucMat
	[StrucFile,StrucPath]=SepFilePath(StrucFilePath);
	Slice=get(hList(56),'Value');
	SliceLabel=get(hList(56),'String');
	NSlice=size(SliceLabel,1);
	EditMat=zeros(size(StrucMat));
	FigSize=[0 0 .8 1];
	FigNameStr=['File: ',StrucFile,';  Slice: '];
	hFig=figure('Units','normal','Position',FigSize,'Color',[.99 .99 .99], 'NumberTitle','off');
	hAxes=axes('Units','normal','Position',[0 0 1 1]);
	
	for SliceInd=1:NSlice
		set(hFig,'Name',[FigNameStr,int2str(SliceInd)])
		RGBAnatImg=zeros(XSizeStruc,YSizeStruc,3);
		Tmp=squeeze(StrucMat(:,:,SliceInd));
		Tmp=Tmp./max(max(Tmp));
		RGBAnatImg(:,:,1)=Tmp;
		RGBAnatImg(:,:,2)=Tmp;
		RGBAnatImg(:,:,3)=Tmp;
		image(RGBAnatImg)
		axis off
		xVec=[];
		yVec=[];
		
		Button=0;
		Index=0;
		while Button~=3
			[x,y,Button]=ginput(1);
			if ~isempty(x)
				x=round(x);
				y=round(y);
				if Index==0
					xVec=[];
					yVec=[];
				end
				if Button==2
					Index=max([0 Index-1]);
					if Index>0
						xVec=xVec(1:Index);
						yVec=yVec(1:Index);
					else
						xVec=[];
						yVec=[];
					end
				elseif Button==1
					Index=Index+1;
					xVec(Index)=x;
					yVec(Index)=y;
				end
			else
				Button=3;
				if Index==0
					Index=2;
				end
			end
			if Button~=3
				RGBAnatImg(y,x,2)=1;
				image(RGBAnatImg)
				hVertLine=line('XData',xVec,'YData',yVec,'Color','y');
				pause(.01)
			end
		end
		MinX=min(yVec); 		%x-line == y image
		MaxX=max(yVec); 	%x-line == y image
		NX=MaxX-MinX+1;
		MinY=min(xVec); 		%x-line == y image
		MaxY=max(xVec); 	%x-line == y image
		NY=MaxY-MinY+1;
		XPolyMat=zeros(NX,NY);
		YPolyMat=zeros(NX,NY);
		XPolyVec=[MinX:MaxX]';
		YPolyVec=[MinY:MaxY];
		for i=1:NX
			XPolyMat(i,:)=YPolyVec;
		end
		for i=1:NY
			YPolyMat(:,i)=XPolyVec;
		end
		InPolyMatPart=inpolygon(XPolyMat,YPolyMat,xVec,yVec);
		TmpTmp=zeros(size(Tmp));
		TmpTmp(MinX:MaxX,MinY:MaxY)=Tmp(MinX:MaxX,MinY:MaxY).*InPolyMatPart;
		RGBAnatImg(:,:,1)=TmpTmp;
		RGBAnatImg(:,:,2)=TmpTmp;
		RGBAnatImg(:,:,3)=TmpTmp;
		image(RGBAnatImg)
		pause(1)
		EditMat(MinX:MaxX,MinY:MaxY,SliceInd)=InPolyMatPart;
	end
	close(hFig)
	set(hList(161),'Userdata',EditMat);
	SaveNDimData(EditMat,[],'int16',[StrucFile,'.sem.str'],'Save EditMat to file:');
	
elseif strcmp(action,'AvgFunc')

	hList=get(hfMRIMenu,'UserData');
	[NFiles,FileMat]=ReadFileNames([],'*fun*','Choose file to average:');
	[File,Path,FilePath]=GetFileNameOfMat(FileMat,1);
	[AvgFuncMat,FilePath,SizeDataMat,NDim,Version]=ReadNDimData(FilePath,'int16');
	[XSizeStruc,YSizeStruc,NSlice,NShot]=size(AvgFuncMat);
	for FileInd=2:NFiles
		[File,Path,FilePath]=GetFileNameOfMat(FileMat,FileInd);
		[FuncMat,FilePath,SizeDataMat,NDim,Version]=ReadNDimData(FilePath,'int16');
		AvgFuncMat=AvgFuncMat+FuncMat;
	end
	AvgFuncMat=AvgFuncMat./NFiles;
	set(hList(5),'Userdata',FuncMat);  %FuncMat
	fMRIMenu('SaveFunc')

elseif strcmp(action,'CalcAll')

	hList=get(hfMRIMenu,'UserData');	
	fMRIMenu('CalcIndT21')
	fMRIMenu('CalcDepT21')
	fMRIMenu('CalcXCorr')
	fMRIMenu('CalcMutInfo')

elseif strcmp(action,'SaveAll')

	hList=get(hfMRIMenu,'UserData');
	fMRIMenu('NoCallSaveIndT')
	fMRIMenu('NoCallSaveDepT')
	fMRIMenu('NoCallSaveXCorr')
	fMRIMenu('NoCallSaveMutInfoCS')
 	fMRIMenu('NoCallSaveMutInfoIS')
	fMRIMenu('NoCallSavePowerFuncMat')

elseif strcmp(action,'BatchCalcAll')

	hList=get(hfMRIMenu,'UserData');
	[NFiles,FileMat]=ReadFileNames([],'*fun*','Choose .fun file(s) or batch file::');
	set(hList(117),'Userdata',FileMat);
	Message=char(zeros(5,100));
	hBatchMsgbox=msgbox(Message,'Batch Info:','help'); 
	set(hBatchMsgbox,'Units','Normal','Position',[.425 .625 .15 .1])
	hChildBatchMsgbox=get(hBatchMsgbox,'Children');
	set(hChildBatchMsgbox(length(hChildBatchMsgbox)),'Visible','off');
	MinInd=NXCorrInd-(NXCorrInd-1)./2+XCorrMinLag;
	MaxInd=NXCorrInd-(NXCorrInd-1)./2+XCorrMaxLag;
		
	for FileInd=1:NFiles
		[File,Path,FilePath]=GetFileNameOfMat(FileMat,FileInd);
		fprintf(1,'File %g of %g ...      ',FileInd,NFiles);
		fprintf(1,File);
		fprintf(1,'\n');
		Message=char('');
		Message=char(Message,'');
		Message=char(Message,['File ',int2str(FileInd),' of ',int2str(NFiles),' ... ']);
		Message=char(Message,'');
		Message=char(Message,['File:  ',File]);
		set(hChildBatchMsgbox(2),'String',Message);
		pause(.1);
		set(hList(117),'Value',FileInd);
		fMRIMenu('NoCallReadFunc')
		fMRIMenu('CalcIndT21')
 		fMRIMenu('CalcDepT21')
%  		fMRIMenu('CalcXCorr')
%  		fMRIMenu('CalcMutInfo')
		fMRIMenu('PowerFuncMat')
		fMRIMenu('SaveAll')
	end
	
elseif strcmp(action,'ReadFunc') | ...
	strcmp(action,'NoCallReadFunc') | ...
	strcmp(action,'ReadFuncStruc')

	hList=get(hfMRIMenu,'UserData');		
	if strcmp(action,'NoCallReadFunc')
		FileMat=get(hList(117),'Userdata');
		FileInd=get(hList(117),'Value');
		[File,Path,FilePath]=GetFileNameOfMat(FileMat,FileInd);
	else
		FilePath=[];
	end
	FileExt='*.fun*';
	DefDataFilePath=SetDefPath(1,FileExt);
	[FuncMat,FilePath,SizeDataMat,NDim,Version]=ReadNDimData(FilePath,'int16',DefDataFilePath,'Choose Functional File:');
	if isempty(FuncMat); return; end
	set(hList(121),'Userdata',[],'Enable','on');	%PowerFuncMat
	set(hList(137),'Userdata',SizeDataMat);
	set(hList(121),'Value',0);
	set(hList(123),'Value',0,'String','0');
	[DefFile,DefPath]=SepFilePath(FilePath);
	SetDefPath(2,DefPath);
	[XSizeStruc,YSizeStruc,NSlice,NShot]=size(FuncMat);
	set(hList(5),'Userdata',FuncMat);  %FuncMat
	set(hList(6),'Userdata',FilePath);  	%ReadFuncMat	
	set(hList(9),'Enable','on'); 		%hCalcIndT21
	set(hList(10),'Enable','on'); 		%hCalcDepT21
	set(hList(111),'Enable','on'); 		%hCalcIndT12
	set(hList(112),'Enable','on'); 		%hCalcDepT12
	set(hList(11),'Enable','on'); 		%hCalcXCorr
	set(hList(12),'Enable','on'); 		%hCalcMutInfo
	set(hList(89),'Enable','on'); 		%hSampling
	set(hList(31),'Enable','off'); 		%hPlotIndTPosVal
	set(hList(32),'Enable','off'); 		%hPlotDepTPosVal
	set(hList(33),'Enable','off'); 		%hPlotIndTNegVal
	set(hList(34),'Enable','off'); 		%hPlotDepTNegVal
	set(hList(131),'Enable','off'); 	%hPlotIndTPosLag
	set(hList(132),'Enable','off'); 	%hPlotIndTNegLag
	set(hList(146),'Enable','off'); 	%hPlotDepTPosLag
	set(hList(147),'Enable','off'); 	%hPlotDepTNegLag
	
	LabelStr=' Shot: 1';
	for Ind=2:NShot; 
		LabelStr=[LabelStr '| Shot: ' ,int2str(Ind)];
	end
	set(hList(57),'String',LabelStr,'Enable','on');
	LabelStr=' Slice: 1';
	for Ind=2:NSlice; 
		LabelStr=[LabelStr '| Slice: ' ,int2str(Ind)];
	end
	set(hList(58),'String',LabelStr,'Enable','on');
	set(hList(61),'String',LabelStr);
	set(hList(62),'String',LabelStr);
	set(hList(63),'String',LabelStr);
	set(hList(68),'String',LabelStr);
	if strcmp(action,'ReadFuncStruc')
		[FuncFile,FuncPath]=SepFilePath(FilePath);
		StrucFile=[FuncFile(1:2),'.str'];
		StrucFilePath=[FuncPath,StrucFile];
		if exist(StrucFilePath)
			set(hList(2),'Userdata',StrucFilePath);
			fMRIMenu('NoCallReadStruc')
		else
			StrucFilePathTmp=StrucFilePath;
			StrucFile=[FuncFile(1:length(FuncFile)-3),'str'];
			StrucFilePath=[FuncPath,StrucFile]
			if exist(StrucFilePath)
				set(hList(2),'Userdata',StrucFilePath);
				fMRIMenu('NoCallReadStruc')
			else
				Message=char('Sorry,');
				Message=char(Message,'the structural files:');
				Message=char(Message,StrucFilePathTmp);
				Message=char(Message,'and');
				Message=char(Message,StrucFilePath);
				Message=char(Message,'do not exist.');
				Message=char(Message,'');
				Message=char(Message,'Please choose a');
				Message=char(Message,'matching structural file.');
				Message=char(Message,'');
				hMsgbox=msgbox(Message,'Info:','help'); 
				hChildMsgbox=get(hMsgbox,'Children');
				set(hChildMsgbox(length(hChildMsgbox)),'Visible','off');
				pause(2)
				fMRIMenu('ReadStruc')
				close(hMsgbox);
			end
		end
	else
		fMRIMenu('SetfMRIMenuFigNameFunc')	
	end
	
elseif strcmp(action,'UpDownSampleFuncMat') |  strcmp(action,'UpDownSampleFuncMatBatch')

	hList=get(hfMRIMenu,'UserData');
	if strcmp(action,'UpDownSampleFuncMat')
		hListNo=89;
	elseif strcmp(action,'UpDownSampleFuncMatBatch')
		hListNo=120;
	end
	SampOld=get(hList(hListNo),'Userdata');  
	SampNew=get(hList(hListNo),'Value');  
	FuncMat=get(hList(5),'Userdata');  	%hFuncMat
	[XSizeFunc,YSizeFunc,NSlice,NShot]=size(FuncMat);
	FuncMatNew=zeros(XSizeFunc,YSizeFunc,NSlice,NShot.*SampNew);
	x=linspace(1,NShot,NShot.*SampOld);
	x1=linspace(1,NShot,NShot.*SampNew);
	c=NSlice.*YSizeFunc;
	Message=char(zeros(7,100));
	hProgressMsgbox=msgbox(Message,'Progress Info:','help'); 
	hChildProgressMsgbox=get(hProgressMsgbox,'Children');
	set(hChildProgressMsgbox(length(hChildProgressMsgbox)),'Visible','off');
	for i=1:NSlice
		a=(i-1).*YSizeFunc;
		for j=1:YSizeFunc
			b=a+j;
			Message=char('');
			Message=char(Message,'Temporal');
			Message=char(Message,'Cubic Interpolation');
			Message=char(Message,'of Functional Data:');
			Message=char(Message,'');
			Message=char(Message,['Step ' int2str(b) ' of ' int2str(c) ' ...']);
			set(hChildProgressMsgbox(2),'String',Message);
			pause(.001);
			for k=1:XSizeFunc
				y=squeeze(FuncMat(k,j,i,:));
				FuncMatNew(k,j,i,:)=interp1(x,y,x1,'cubic');
			end
		end
	end
	close(hProgressMsgbox)
	size(FuncMatNew)
	set(hList(5),'Userdata',FuncMatNew);  	%hFuncMat
	
elseif strcmp(action,'PlotFuncShot') | ...
	strcmp(action,'PlotFuncSlice') | ...
	strcmp(action,'PlotFuncSingle'),

	hList=get(hfMRIMenu,'UserData');
	FilePath=get(hList(6),'Userdata');		%ReadFuncMat
	[File,Path]=SepFilePath(FilePath);
	Shot=get(hList(57),'Value');
	FuncMat=get(hList(5),'Userdata');  	%hFuncMat
	[XSizeStruc,YSizeStruc,NSlice,NShot]=size(FuncMat);
	if strcmp(action,'PlotFuncShot')
		NSubPlotCol=2;
		NSubPlotRow=4;
		hFig=figure('Units','normal','Position',[0 0 .4 1], 'Name',['File: ',File,';  Shot: ',int2str(Shot)],'Color',[0 0 0], 'NumberTitle','off');
	elseif strcmp(action,'PlotFuncSlice')
		Slice=get(hList(58),'Value');
		NSubPlotCol=8;
		NSubPlotRow=9;
		hFig=figure('Units','normal','Position',[0 0 1 1], 'Name',['File: ',File,';  Slice: ',int2str(Slice)],'Color',[0 0 0], 'NumberTitle','off');
	elseif  strcmp(action,'PlotFuncSingle')
		Slice=get(hList(58),'Value');
		NSubPlotCol=2;
		NSubPlotRow=4;
		hFig=figure('Units','normal','Position',[0 .5 .5 .5], 'Name',['File: ',File,';  Shot: ',int2str(Shot),';  Slice: ',int2str(Slice)],'Color',[0 0 0], 'NumberTitle','off');
	end
	hAxes=axes('Units','normal','Position',[0 0 1 1]);
	axis off
	RGBAnatImg=zeros(XSizeStruc,YSizeStruc,3);
	
	if strcmp(action,'PlotFuncShot')
		Tmp=squeeze(FuncMat(:,:,:,Shot));
		NSubPlotCol=4;
		NSubPlotRow=2;
		RowInd=1;
		ColInd=1;
		MinVec=squeeze(min(min(Tmp)));
		MaxVec=squeeze(max(max(Tmp)));
		MeanVec=squeeze(mean(mean(Tmp)));
		MedVec=squeeze(median(median(Tmp)));
		StdVec=squeeze(std(std(Tmp)));
		clc; fprintf('\n')
		fprintf('Stats of Shot # %g:\n\n',Shot);
		Tmp=Tmp./max(max(max(Tmp)));
		for SliceInd=1:NSlice
			RowInd=RowInd+1;
			if RowInd>NSubPlotRow
				ColInd=ColInd+1;
				RowInd=1;
			end
			ColPos=1-ColInd.*NSubPlotCol^-1;
			RowPos=(RowInd-1).*NSubPlotRow^-1;
			hAxes=axes('Units','normal','Position',[RowPos ColPos  NSubPlotRow^-1 NSubPlotCol^-1 ]);
			fprintf('Slice # %g ; Min.: %g; Max.: %g; Mean: %g; Median: %g; Std.: %g \n',SliceInd,MinVec(SliceInd),MaxVec(SliceInd),MeanVec(SliceInd),MedVec(SliceInd),StdVec(SliceInd))
			TmpTmp=squeeze(Tmp(:,:,SliceInd));
			RGBAnatImg(:,:,1)=TmpTmp;
			RGBAnatImg(:,:,2)=TmpTmp;
			RGBAnatImg(:,:,3)=TmpTmp;
			image(RGBAnatImg)
			axis off
			title(['Shot # ',int2str(Shot),';  Slice # ', int2str(SliceInd)])
		end
	elseif strcmp(action,'PlotFuncSlice')
		Tmp=squeeze(FuncMat(:,:,Slice,:));
		Tmp=Tmp./max(max(max(Tmp)));
		RowInd=0;
		ColInd=1;
		for ShotInd=1:NShot
			RowInd=RowInd+1;
			if RowInd>NSubPlotRow
				ColInd=ColInd+1;
				RowInd=1;
			end
			ColPos=1-ColInd.*NSubPlotCol^-1;
			RowPos=(RowInd-1).*NSubPlotRow^-1;
			hAxes=axes('Units','normal','Position',[RowPos ColPos  NSubPlotRow^-1 NSubPlotCol^-1 ]);
			TmpTmp=squeeze(Tmp(:,:,ShotInd));
			RGBAnatImg(:,:,1)=TmpTmp;
			RGBAnatImg(:,:,2)=TmpTmp;
			RGBAnatImg(:,:,3)=TmpTmp;
			image(RGBAnatImg)
			axis off
		end
	elseif  strcmp(action,'PlotFuncSingle')
		Tmp=squeeze(FuncMat(:,:,Slice,Shot));
		Tmp=Tmp./max(max(Tmp));
		RGBAnatImg(:,:,1)=Tmp;
		RGBAnatImg(:,:,2)=Tmp;
		RGBAnatImg(:,:,3)=Tmp;
		image(RGBAnatImg)
		axis off
	end
elseif strcmp(action,'SetfMRIMenuFigName') | ...
	strcmp(action,'SetfMRIMenuFigNameStruc') | ...
	strcmp(action,'SetfMRIMenuFigNameFunc'),

	hList=get(hfMRIMenu,'UserData');
	StrucFilePath=get(hList(2),'Userdata');
	[StrucFile,StrucPath]=SepFilePath(StrucFilePath);
	FuncFilePath=get(hList(6),'Userdata');
	[FuncFile,FuncPath]=SepFilePath(FuncFilePath);
	FigName=['fMRI Menu;  Structural:  ', StrucFile,'; Functional:  ',FuncFile];
	set(hfMRIMenu,'Name',FigName);
	if ~strcmp(action,'SetfMRIMenuFigNameStruc') 
		set(hList(31),'Enable','off');  	%hPlotIndTPosVal
		set(hList(33),'Enable','off');  	%hPlotIndTNegVal
		set(hList(61),'Enable','off');  	%hPlotIndTSlice
		set(hList(32),'Enable','off');  	%hPlotDepTPosVal
		set(hList(34),'Enable','off');  	%hPlotDepTNegVal
		set(hList(62),'Enable','off');  	%hPlotDepTSlice
		set(hList(46),'Enable','off');  	%hPlotXCorrVal
		set(hList(49),'Enable','off');  	%hPlotXCorrLag
		set(hList(63),'Enable','off');  	%hPlotXCorrSlice
		set(hList(66),'Enable','off');  	%hPlotMutInfoCSVal
		set(hList(67),'Enable','off');  	%hPlotMutInfoISVal
		set(hList(68),'Enable','off');  	%hPlotMutInfoSlice
	end
	
elseif strcmp(action,'ReformSaveStruc')

	fMRIMenu('ReformStruc');
	fMRIMenu('SaveStruc');

elseif strcmp(action,'ReformSaveFunc')

	fMRIMenu('ReformFunc');
	fMRIMenu('SaveFunc');
		
elseif strcmp(action,'ReformStruc')

	hList=get(hfMRIMenu,'UserData');
	[StrucMat,StrucFilePath,SizeStrucMat]=ReadStruc([],0);
	set(hList(1),'Userdata',StrucMat);  	%hStrucMat
	set(hList(2),'Userdata',StrucFilePath);  	%ReadStrucMat
	set(hList(136),'Userdata',SizeStrucMat);%hSizeStrucMat
	fMRIMenu('SetfMRIMenuFigNameStruc')
	
elseif strcmp(action,'ReformFunc')

	hList=get(hfMRIMenu,'UserData');
	[FuncMat,FilePath,SizeFuncMat]=ReadEPI([],0);
	set(hList(5),'Userdata',FuncMat);  		%hFuncMat
	set(hList(6),'Userdata',FilePath);  	%hReadFuncMat
	set(hList(137),'Userdata',SizeFuncMat);%hSizeFuncMat
	set(hList(9),'Enable','on'); 			%hCalcIndT21
	set(hList(10),'Enable','on'); 			%hCalcDepT21
	set(hList(111),'Enable','on'); 			%hCalcIndT12
	set(hList(112),'Enable','on'); 			%hCalcDepT12
	fMRIMenu('SetfMRIMenuFigNameFunc')	
	
elseif strcmp(action,'SaveStruc') | ...
	strcmp(action,'SaveFunc')

	hList=get(hfMRIMenu,'UserData');
	if strcmp(action,'SaveStruc')
		MatListNo=1;
		FileListNo=2;
		InitFile=['*.str'];
	elseif strcmp(action,'SaveFunc')
		MatListNo=5;
		FileListNo=6;
		InitFile=['*.fun'];
	end
	Mat=get(hList(MatListNo),'Userdata');
	[FilePath,Version]=SaveNDimData(Mat,[],'int16',InitFile);
	set(hList(FileListNo),'Userdata',FilePath);
	if strcmp(action,'SaveStruc')
		fMRIMenu('SetfMRIMenuFigNameStruc')	
	elseif strcmp(action,'SaveFunc')
		fMRIMenu('SetfMRIMenuFigNameFunc')	
	end
	
elseif strcmp(action,'CalcIndT12') |  ...
	strcmp(action,'CalcDepT12') | ...
	strcmp(action,'CalcIndT21') |  ...
	strcmp(action,'CalcDepT21'),

	hList=get(hfMRIMenu,'UserData');
	Tmp=100;
	FuncMat=get(hList(5),'Userdata');
	if strcmp(action,'CalcIndT21') | strcmp(action,'CalcIndT12') 
		hMat0ListNo=133;
		hMat1ListNo=13;
		hMat2ListNo=134;
		hIndVec1ListNo=17;
		hIndVec2ListNo=18;
		hMinListNo=104;
		hMaxListNo=24;
		hPlotPosValListNo=31;
		hPlotNegValListNo=33;
		hPlotPosLagListNo=131;
		hPlotNegLagListNo=132;
		hBaseListNo=37;
		hMinLagListNo=127;
		hMaxLagListNo=129;
		hPlotSlice=61;
		fMRIMenu('SetIndTActual')
	elseif strcmp(action,'CalcDepT21') | strcmp(action,'CalcDepT12')
		hMat0ListNo=148;
		hMat1ListNo=14;
		hMat2ListNo=149;
		hIndVec1ListNo=19;
		hIndVec2ListNo=20;
		hMinListNo=109;
		hMaxListNo=29;
		hPlotPosValListNo=32;
		hPlotNegValListNo=34;
		hPlotPosLagListNo=146;
		hPlotNegLagListNo=147;
		hBaseListNo=39;
		hMinLagListNo=142;
		hMaxLagListNo=144;
		hPlotSlice=62;
		fMRIMenu('SetDepTActual')
	end
	BaseVal=get(hList(hBaseListNo),'Value');
	MinTLagVal=get(hList(hMinLagListNo),'Value');
	MaxTLagVal=get(hList(hMaxLagListNo),'Value');
	NShotPerCycle=get(hList(87),'Value');
	ShotOrderPlotStatus=get(hList(99),'Value');
	size(FuncMat)
	[FunMat1,FunMat2,IndVec1,IndVec2,FunMat0]=fMriTStat(FuncMat,action,BaseVal,NShotPerCycle,MinTLagVal,MaxTLagVal,ShotOrderPlotStatus);
	MinVal=min(min(min(FunMat1)));
	MaxVal=max(max(max(FunMat1)));
	set(hList(hMinListNo),'Value',MinVal,'String',sprintf('%g',round(MinVal*Tmp)/Tmp)); 
	set(hList(hMaxListNo),'Value',MaxVal,'String',sprintf('%g',round(MaxVal*Tmp)/Tmp)); 
	set(hList(hMat0ListNo),'Userdata',FunMat0); 
	set(hList(hMat1ListNo),'Userdata',FunMat1); 
	set(hList(hMat2ListNo),'Userdata',FunMat2); 
	set(hList(hIndVec1ListNo),'Userdata',IndVec1); 
	set(hList(hIndVec2ListNo),'Userdata',IndVec2); 
	set(hList(hPlotPosValListNo),'Enable','on'); 
	set(hList(hPlotNegValListNo),'Enable','on'); 
	if isempty(FunMat2)
		EnableStr='off';
	else
		EnableStr='on';
	end
	set(hList(hPlotPosLagListNo),'Enable',EnableStr); 
	set(hList(hPlotNegLagListNo),'Enable',EnableStr); 
	set(hList(hPlotSlice),'Enable','on'); 
	figure(hfMRIMenu);
	
elseif strcmp(action,'CalcXCorr')	

	hList=get(hfMRIMenu,'UserData');
	Tmp=100;
	CorrFac=.6;
	FuncMat=get(hList(5),'Userdata');
	NShotPerCycle=get(hList(87),'Value');
	XCorrBase=get(hList(48),'Value');
	XCorrMinLag=get(hList(114),'Value');
	XCorrMaxLag=get(hList(92),'Value');
	TR=get(hList(94),'Value');
	TRs=TR./1000;
	[FunMat1,FunMat2,XCorrMat,IndVec1,IndVec2]=fMriXCorrStat(FuncMat,XCorrBase,NShotPerCycle,XCorrMinLag,XCorrMaxLag);
	FunMat2=FunMat2.*TRs;
	MaxVal1=max(max(max(FunMat1)));
	MinVal1=CorrFac.*MaxVal1;
	set(hList(42),'Value',MinVal1,'String',sprintf('%g',round(MinVal1*Tmp)/Tmp)); 
	set(hList(44),'Value',MaxVal1,'String',sprintf('%g',round(MaxVal1*Tmp)/Tmp)); 
	set(hList(45),'Userdata',XCorrMat); 
	set(hList(15),'Userdata',FunMat1); 
	MinVal2=min(min(min(FunMat2)));
	MaxVal2=max(max(max(FunMat2)));
	set(hList(52),'Value',MinVal2,'String',sprintf('%g',round(MinVal2*Tmp)/Tmp)); 
	set(hList(54),'Value',MaxVal2,'String',sprintf('%g',round(MaxVal2*Tmp)/Tmp)); 
	set(hList(16),'Userdata',FunMat2); 
	set(hList(46),'Enable','on'); 		%hXCorrPlot1
	set(hList(49),'Enable','on'); 		%hXCorrPlot2
	set(hList(63),'Enable','on'); 		%hPlotSlice
	set(hList(50),'Userdata',IndVec1); %hXCorrIndVec1
	set(hList(55),'Userdata',IndVec2); %hXCorrIndVec2
	fMRIMenu('SetXCorrActual')
	
elseif strcmp(action,'CalcMutInfo')	

	hList=get(hfMRIMenu,'UserData');
	Tmp=100;
	NShotPerCycle=get(hList(87),'Value');	
	FuncMat=get(hList(5),'Userdata');
	Base=get(hList(70),'Value');
	MinLag=get(hList(152),'Value');
	MaxLag=get(hList(154),'Value');
	MinFac=0.5;
	tic
	[CS1,IS1,CS2,IS2,CS0,IS0,IndVec1,IndVec2]=MutualInfo(FuncMat,Base,NShotPerCycle,MinLag,MaxLag);
	toc
	MaxCS1=max(max(max(CS1)));
	set(hList(72),'Value',MinFac.*MaxCS1,'String',sprintf('%g',round(MinFac.*MaxCS1*Tmp)/Tmp)); 
	set(hList(74),'Value',MaxCS1,'String',sprintf('%g',round(MaxCS1*Tmp)/Tmp)); 
	MaxIS1=max(max(max(IS1)));
	set(hList(77),'Value',MinFac.*MaxIS1,'String',sprintf('%g',round(MinFac.*MaxIS1*Tmp)/Tmp)); 
	set(hList(79),'Value',MaxIS1,'String',sprintf('%g',round(MaxIS1*Tmp)/Tmp)); 
	set(hList(156),'Userdata',CS0); 	%hMutInfoMatCS
	set(hList(158),'Userdata',IS0); 	%hMutInfoMatIS
	set(hList(81),'Userdata',CS1); 		%hMutInfoMatCS1
	set(hList(82),'Userdata',IS1); 		%hMutInfoMatIS1
	set(hList(157),'Userdata',CS2); 	%hMutInfoMatCS2
	set(hList(159),'Userdata',IS2); 	%hMutInfoMatIS2
	set(hList(83),'Userdata',IndVec1); 	%hMutInfoIndVec1
	set(hList(84),'Userdata',IndVec2); 	%hMutInfoIndVec2
	set(hList(66),'Enable','on'); 		%hPlotMutInfoCSVal
	set(hList(67),'Enable','on'); 		%hPlotMutInfoISVal
	set(hList(75),'Enable','on'); 		%hPlotMutInfoCSLag
	set(hList(80),'Enable','on'); 		%hPlotMutInfoISLag
	set(hList(68),'Enable','on'); 		%hPlotMutInfoSlice
	fMRIMenu('SetMutInfoActual')
	
elseif strcmp(action,'setNShotPerCycle')

	hList=get(hfMRIMenu,'UserData');
	Val=get(hList(87),'Value');
	Str=get(hList(87),'String');
	[Val,Str]=String2Value(Str,Val,1,[],1,1);
	set(hList(87),'Value',Val,'String',Str);  

elseif strcmp(action,'setSampling') | strcmp(action,'setBatchSampling')

	hList=get(hfMRIMenu,'UserData');
	if strcmp(action,'setSampling')
		hListNo=89;
	elseif strcmp(action,'setBatchSampling')
		hListNo=120;
	end
	ValOld=get(hList(hListNo),'Value');
	Str=get(hList(hListNo),'String');
	[ValNew,StrNew]=String2Value(Str,ValOld,1,[],1,1);
	if ValNew~=ValOld
		set(hList(hListNo),'Value',ValNew,'String',Str,'Userdata',ValOld);  
		TROld=get(hList(94),'Value');  
		TRNew=TROld.*(ValOld./ValNew);
		set(hList(94),'Value',TRNew,'String',sprintf('%g',TRNew));  
		NShotPerCycleOld=get(hList(87),'Value');  
		NShotPerCycleNew=NShotPerCycleOld./(ValOld./ValNew);
		set(hList(87),'Value',NShotPerCycleNew,'String',sprintf('%g',NShotPerCycleNew));  
		if strcmp(action,'setSampling')
			fMRIMenu('UpDownSampleFuncMat')
		elseif strcmp(action,'setBatchSampling')
			[NFiles,FileMat]=ReadFileNames([],'*fun*','Choose .fun file(s) or batch file:');
			if NFiles==0; return; end
			SaveFileMat=PutFileExt2Mat(FileMat,['s',StrNew,'.'],3);
			SaveFileMat=PutFileExt2Mat(SaveFileMat,'fun');
			set(hList(117),'Userdata',FileMat);
			Message=char(zeros(5,100));
			hBatchMsgbox=msgbox(Message,'Batch Info:','help'); 
			set(hBatchMsgbox,'Units','Normal','Position',[.425 .625 .15 .1])
			hChildBatchMsgbox=get(hBatchMsgbox,'Children');
			set(hChildBatchMsgbox(length(hChildBatchMsgbox)),'Visible','off');	
			for FileInd=1:NFiles
				[File,Path,FilePath]=GetFileNameOfMat(FileMat,FileInd);
				fprintf(1,'File %g of %g ...      ',FileInd,NFiles);
				fprintf(1,File);
				fprintf(1,'\n');
				Message=char('');
				Message=char(Message,'');
				Message=char(Message,['File ',int2str(FileInd),' of ',int2str(NFiles),' ... ']);
				Message=char(Message,'');
				Message=char(Message,['File:  ',File])
				set(hChildBatchMsgbox(2),'String',Message);
				pause(.1);
				set(hList(117),'Value',FileInd);
				fMRIMenu('NoCallReadFunc')
				fMRIMenu('UpDownSampleFuncMatBatch')
				Mat=get(hList(5),'Userdata');
				[SaveFile,SavePath,SaveFilePath]=GetFileNameOfMat(SaveFileMat,FileInd);
				[FilePath,Version]=SaveNDimData(Mat,SaveFilePath,'int16');
			end
		end
	end

elseif strcmp(action,'setXCorrMaxLag') | strcmp(action,'setXCorrMinLag')

	hList=get(hfMRIMenu,'UserData');
	XCorrMinLag=get(hList(114),'Value');
	XCorrMinLagStr=get(hList(114),'String');
	XCorrMaxLag=get(hList(92),'Value');
	XCorrMaxLagStr=get(hList(92),'String');
	if strcmp(action,'setXCorrMaxLag')
		[XCorrMaxLag,XCorrMaxLagStr]=String2Value(XCorrMaxLagStr,XCorrMaxLag,XCorrMinLag,[],1,1);
		set(hList(92),'Value',XCorrMaxLag,'String',XCorrMaxLagStr);  
	elseif strcmp(action,'setXCorrMinLag')
		[XCorrMinLag,XCorrMinLagStr]=String2Value(XCorrMinLagStr,XCorrMinLag,[],XCorrMaxLag,1,1);
		set(hList(114),'Value',XCorrMinLag,'String',XCorrMinLagStr);  
	end
	Tmp=100;
	CorrFac=.6;
	NShotPerCycle=get(hList(87),'Value');
	XCorrBase=get(hList(48),'Value');
	TR=get(hList(94),'Value');
	TRs=TR./1000;
	XCorrMat=get(hList(45),'Userdata'); 
	[XSizeFunc,YSizeFunc,NSlice,NXCorrInd]=size(XCorrMat);
	Message=char(zeros(5,100));
	hProgressMsgbox=msgbox(Message,'Progress Info:','help'); 
	hChildProgressMsgbox=get(hProgressMsgbox,'Children');
	set(hChildProgressMsgbox(length(hChildProgressMsgbox)),'Visible','off');
	MinInd=NXCorrInd-(NXCorrInd-1)./2+XCorrMinLag;
	MaxInd=NXCorrInd-(NXCorrInd-1)./2+XCorrMaxLag;
	FunMat1=zeros(XSizeFunc,YSizeFunc,NSlice);
	FunMat2=FunMat1;
	for SliceInd=1:NSlice
		fprintf('Slice %g of %g ...\n',SliceInd,NSlice);
		Message=char('Calculate Max. of');
		Message=char(Message,'Cross-Correlation !');
		Message=char(Message,['Min. Index: ',int2str(MinInd)]);
		Message=char(Message,['Max. Index: ',int2str(MaxInd)]);
		Message=char(Message,['Slice ' int2str(SliceInd) ' of ' int2str(NSlice) ' ...']);
		set(hChildProgressMsgbox(2),'String',Message);
		pause(.001);
		for i=1:XSizeFunc
			for j=1:YSizeFunc
				[FunMat1(i,j,SliceInd),FunMat2(i,j,SliceInd)]=max(XCorrMat(i,j,SliceInd,MinInd:MaxInd));
			end
		end
	end
	close(hProgressMsgbox);
	FunMat2=FunMat2.*TRs;
	MaxVal1=max(max(max(FunMat1)));
	MinVal1=CorrFac.*MaxVal1;
	set(hList(42),'Value',MinVal1,'String',sprintf('%g',round(MinVal1*Tmp)/Tmp)); 
	set(hList(44),'Value',MaxVal1,'String',sprintf('%g',round(MaxVal1*Tmp)/Tmp)); 
	set(hList(15),'Userdata',FunMat1); 
	MinVal2=min(min(min(FunMat2)));
	MaxVal2=max(max(max(FunMat2)));
	set(hList(52),'Value',MinVal2,'String',sprintf('%g',round(MinVal2*Tmp)/Tmp)); 
	set(hList(54),'Value',MaxVal2,'String',sprintf('%g',round(MaxVal2*Tmp)/Tmp)); 
	set(hList(16),'Userdata',FunMat2); 
	set(hList(46),'Enable','on'); 		%hXCorrPlot1
	set(hList(49),'Enable','on'); 		%hXCorrPlot2
	set(hList(63),'Enable','on'); 		%hPlotSlice
	
elseif strcmp(action,'setIndTBase') | ...
	strcmp(action,'setIndTMinLag') | ...
	strcmp(action,'setIndTMaxLag') | ...
	strcmp(action,'setDepTBase') | ...
	strcmp(action,'setDepTMinLag') | ...
	strcmp(action,'setDepTMaxLag') | ...
	strcmp(action,'setXCorrBase') | ...
	strcmp(action,'setMutInfoBase') | ...
	strcmp(action,'setMutInfoMinLag') | ...
	strcmp(action,'setMutInfoMaxLag'),
	
	hList=get(hfMRIMenu,'UserData');
	if strcmp(action,'setIndTBase')
		hListNo=37;
	elseif strcmp(action,'setIndTMinLag')	
		hListNo=127;
	elseif strcmp(action,'setIndTMaxLag')	
		hListNo=129;
	elseif strcmp(action,'setDepTBase')
		hListNo=39;
	elseif strcmp(action,'setDepTMinLag')	
		hListNo=142;
	elseif strcmp(action,'setDepTMaxLag')	
		hListNo=144;
	elseif strcmp(action,'setXCorrBase')
		hListNo=48;
	elseif strcmp(action,'setMutInfoBase')
		hListNo=70;
	elseif strcmp(action,'setMutInfoMinLag')
		hListNo=152;
	elseif strcmp(action,'setMutInfoMaxLag')
		hListNo=154;
	end
	LagVal=get(hList(hListNo),'Value');
	LagValStr=get(hList(hListNo),'String');
	[LagVal,LagValStr]=String2Value(LagValStr,LagVal,0,[],1,1);
	set(hList(hListNo),'Value',LagVal,'String',LagValStr);  

elseif strcmp(action,'setIndTPosMin') | ...
	strcmp(action,'setIndTPosMax') | ...
	strcmp(action,'setDepTPosMin') | ...
	strcmp(action,'setDepTPosMax') | ...
	strcmp(action,'setIndTNegMin') | ...
	strcmp(action,'setIndTNegMax') | ...
	strcmp(action,'setDepTNegMin') | ...
	strcmp(action,'setDepTNegMax'),
	 
	hList=get(hfMRIMenu,'UserData');
	
	IndTPosMinVal=get(hList(22),'Value');
	IndTPosMinStr=get(hList(22),'String');
	IndTPosMaxVal=get(hList(24),'Value');
	IndTPosMaxStr=get(hList(24),'String');
	DepTPosMinVal=get(hList(27),'Value');
	DepTPosMinStr=get(hList(27),'String');
	DepTPosMaxVal=get(hList(29),'Value');
	DepTPosMaxStr=get(hList(29),'String');
	IndTNegMinVal=get(hList(102),'Value');
	IndTNegMinStr=get(hList(102),'String');
	IndTNegMaxVal=get(hList(104),'Value');
	IndTNegMaxStr=get(hList(104),'String');
	DepTNegMinVal=get(hList(107),'Value');
	DepTNegMinStr=get(hList(107),'String');
	DepTNegMaxVal=get(hList(109),'Value');
	DepTNegMaxStr=get(hList(109),'String');
	Tmp=100;
	if strcmp(action,'setIndTPosMin') 
		[MinVal,MinStr]=String2Value(IndTPosMinStr,IndTPosMinVal,[],IndTPosMaxVal);
		set(hList(22),'Value',MinVal,'String',sprintf('%g',round(MinVal*Tmp)/Tmp));  
	elseif strcmp(action,'setDepTPosMin') 
		[MinVal,MinStr]=String2Value(DepTPosMinStr,IndTPosMinVal,[],IndTPosMaxVal);
		set(hList(27),'Value',MinVal,'String',sprintf('%g',round(MinVal*Tmp)/Tmp));  
	elseif strcmp(action,'setIndTPosMax') 
		[MaxVal,MaxStr]=String2Value(IndTPosMaxStr,IndTPosMaxVal,IndTPosMinVal,[]);
		set(hList(24),'Value',MaxVal,'String',sprintf('%g',round(MaxVal*Tmp)/Tmp));  
	elseif strcmp(action,'setDepTPosMax') 
		[MaxVal,MaxStr]=String2Value(DepTPosMaxStr,DepTPosMaxVal,DepTPosMinVal,[]);
		set(hList(29),'Value',MaxVal,'String',sprintf('%g',round(MaxVal*Tmp)/Tmp));  
	elseif strcmp(action,'setIndTNegMin') 
		[MinVal,MinStr]=String2Value(IndTNegMinStr,IndTNegMinVal,IndTNegMaxVal);
		set(hList(102),'Value',MinVal,'String',sprintf('%g',round(MinVal*Tmp)/Tmp));  
	elseif strcmp(action,'setDepTNegMin') 
		[MinVal,MinStr]=String2Value(DepTNegMinStr,IndTNegMinVal,IndTNegMaxVal);
		set(hList(107),'Value',MinVal,'String',sprintf('%g',round(MinVal*Tmp)/Tmp));  
	elseif strcmp(action,'setIndTNegMax') 
		[MaxVal,MaxStr]=String2Value(IndTNegMaxStr,IndTNegMaxVal,[],IndTNegMinVal);
		set(hList(104),'Value',MaxVal,'String',sprintf('%g',round(MaxVal*Tmp)/Tmp));  
	elseif strcmp(action,'setDepTNegMax') 
		[MaxVal,MaxStr]=String2Value(DepTNegMaxStr,DepTNegMaxVal,[],DepTNegMinVal);
		set(hList(109),'Value',MaxVal,'String',sprintf('%g',round(MaxVal*Tmp)/Tmp));  
	end

elseif strcmp(action,'setXCorrMin1') | ...
	strcmp(action,'setXCorrMin2') | ...
	strcmp(action,'setXCorrMax1') | ...
	strcmp(action,'setXCorrMax2') | ...
	strcmp(action,'setMutInfoMinCS') | ...
	strcmp(action,'setMutInfoMinIS') | ...
	strcmp(action,'setMutInfoMaxCS') | ...
	strcmp(action,'setMutInfoMaxIS'),

	hList=get(hfMRIMenu,'UserData');
	if strcmp(action,'setXCorrMin1') | strcmp(action,'setXCorrMax1')
		hMinListNo=42; 
		hMaxListNo=44; 
	elseif strcmp(action,'setXCorrMin2') | strcmp(action,'setXCorrMax2')
		hMinListNo=52; 
		hMaxListNo=54; 
	elseif strcmp(action,'setMutInfoMinCS') | strcmp(action,'setMutInfoMaxCS')
		hMinListNo=72; 
		hMaxListNo=74; 
	elseif strcmp(action,'setMutInfoMinIS') | strcmp(action,'setMutInfoMaxIS')
		hMinListNo=77; 
		hMaxListNo=79; 
	end
	MinVal=get(hList(hMinListNo),'Value');
	MinStr=get(hList(hMinListNo),'String');
	MaxVal=get(hList(hMaxListNo),'Value');
	MaxStr=get(hList(hMaxListNo),'String');
	Tmp=1000;
	if strcmp(action,'setXCorrMin1') | ...
		strcmp(action,'setXCorrMin2') | ...
		strcmp(action,'setMutInfoMinCS')  | ...
		strcmp(action,'setMutInfoMinIS'),
			[MinVal,MinStr]=String2Value(MinStr,MinVal,[],MaxVal);
			set(hList(hMinListNo),'Value',MinVal,'String',sprintf('%g',round(MinVal*Tmp)/Tmp));  
	elseif strcmp(action,'setXCorrMax1') | ...
		strcmp(action,'setXCorrMax2') | ...
		strcmp(action,'setMutInfoMaxCS')  | ...
		strcmp(action,'setMutInfoMaxIS'),
			[MaxVal,MaxStr]=String2Value(MaxStr,MaxVal,MinVal,[]);
			set(hList(hMaxListNo),'Value',MaxVal,'String',sprintf('%g',round(MaxVal*Tmp)/Tmp));  
	end

elseif strcmp(action,'PlotIndTSlice') | ...
	strcmp(action,'PlotDepTSlice') | ...
	strcmp(action,'PlotXCorrSlice') | ...
	strcmp(action,'PlotMutInfoSlice'),

	hList=get(hfMRIMenu,'UserData');
	StrucMat=get(hList(1),'Userdata');
	FuncMat=get(hList(5),'Userdata');
	SizeStrucMat=get(hList(136),'Userdata')
	SizeFuncMat=get(hList(137),'Userdata')
	XSizeStruc=SizeStrucMat(1);
	YSizeStruc=SizeStrucMat(2);
	NSlice=SizeStrucMat(3);
	XSizeFunc=SizeFuncMat(1);
	YSizeFunc=SizeFuncMat(2);
	NSlice=SizeFuncMat(3);
	NShot=SizeFuncMat(4);
	NShotPerCycle=get(hList(87),'Value');
	FixAmpStatus=get(hList(97),'Value');
% 	SubMeanStatus=get(hList(98),'Value');
	SubMeanStatus=1
	FilePath=get(hList(6),'Userdata');	%ReadFuncMat
	[File,Path]=SepFilePath(FilePath);
	FileStr=['File: ',File];
	FigPosVec1=[0 .5 .4 .5];
	FigPosVec2=[0 0 .33 .4];
	FigPosVec3=[.33 0 .33 .4];
	FigPosVec4=[.66 0 .33 .4];
	FigPosVec5=[.425 .5 .575 .5];
	if strcmp(action,'PlotIndTSlice')
		SliceInd=get(hList(61),'Value');		%hPlotIndTSlice
		FunMat=get(hList(13),'Userdata');
		IndVec1=get(hList(17),'Userdata')
		IndVec2=get(hList(18),'Userdata')
		MinVal=get(hList(22),'Value');
		MaxVal=get(hList(24),'Value');
		LagVal=get(hList(37),'Value');
		FigString1=[FileStr,';   Ind. t-Test;   Slice: ',int2str(SliceInd),';   Lag:  ',int2str(LagVal)];
	elseif strcmp(action,'PlotDepTSlice')
		SliceInd=get(hList(62),'Value');		%hPlotDepTSlice
		FunMat=get(hList(14),'Userdata');
		IndVec1=get(hList(19),'Userdata');
		IndVec2=get(hList(20),'Userdata');
		MinVal=get(hList(27),'Value');
		MaxVal=get(hList(29),'Value');
		LagVal=get(hList(39),'Value');
		FigPosVec1=[0 .5 .4 .5];
		FigString1=[FileStr,';   Dep. t-Test;   Slice: ',int2str(SliceInd),';   Lag:  ',int2str(LagVal)];
	elseif strcmp(action,'PlotXCorrSlice')
		SliceInd=get(hList(63),'Value');		%hPlotXCorrSlice
		FunMat=get(hList(15),'Userdata');
		IndVec1=get(hList(50),'Userdata');
		IndVec2=get(hList(55),'Userdata');
		MinVal=get(hList(42),'Value');
		MaxVal=get(hList(44),'Value');
		LagVal=get(hList(48),'Value');
		FigString1=[FileStr,';   X-Corr. Function;   Slice: ',int2str(SliceInd),';   Base:  ',int2str(LagVal)];
	elseif strcmp(action,'PlotMutInfoSlice')
		SliceInd=get(hList(68),'Value');		%hPlotMutInfoSlice
		FunMat=get(hList(81),'Userdata');
		IndVec1=get(hList(83),'Userdata');
		IndVec2=get(hList(84),'Userdata');
		MinVal=get(hList(72),'Value');
		MaxVal=get(hList(74),'Value');
		LagVal=get(hList(70),'Value');
		FigString1=[FileStr,';   Cauchy-Schwartz;   Slice: ',int2str(SliceInd),';   Lag:  ',int2str(LagVal)];
	end
	FigString2=[FigString1,';   Mean Func. I'];
	FigString3=[FigString1,';   Mean Func. II'];
	FigString4=[FigString1,';   Mean Func. II - I'];
	FigString5=[FigString1,';   Time Course'];
	if strcmp(action,'PlotIndTSlice') | ...
		strcmp(action,'PlotDepTSlice') | ...
		strcmp(action,'PlotMutInfoSlice'),
		
		MinShot=min(min(IndVec1),min(IndVec2));
		MaxShot=max(max(IndVec1),max(IndVec2));
		PlotIndMat=ones(2,NShot,3);
		PlotIndMat(:,IndVec2,3)=zeros(2,length(IndVec2),1);
		PlotIndMat(:,IndVec2,1:2)=1.*ones(2,length(IndVec2),2);
	else
		MinShot=LagVal+1;
		MaxShot=NShot;
	end
	PlotIndVec=[1:NShot];
	FunMat=squeeze(FunMat(:,:,SliceInd));
	FuncMat=squeeze(FuncMat(:,:,SliceInd,:));
	MaxFuncMat=max(max(max(FuncMat)));
	FuncMat=FuncMat./MaxFuncMat;
	FuncImg1=squeeze(mean(FuncMat(:,:,IndVec1),3));	
	FuncImg2=squeeze(mean(FuncMat(:,:,IndVec2),3));	
	FuncImg3=FuncImg2-FuncImg1;
	FuncImg3=FuncImg3+abs(min(min(FuncImg3)));
	FuncImg3=FuncImg3/max(max(FuncImg3));
   	hFig1=figure('Units','normal','Position',FigPosVec1, 'Name',FigString1,'Color',[0 0 0], 'NumberTitle','off');
	hAxes1=axes('Position',[0 0 1 1],'Visible','off');
	hFig2=figure('Units','normal','Position',FigPosVec2, 'Name',FigString2,'Color',[0 0 0], 'NumberTitle','off');
	hAxes2=axes('Position',[0 0 1 1],'Visible','off');
	hFig3=figure('Units','normal','Position',FigPosVec3, 'Name',FigString3,'Color',[0 0 0], 'NumberTitle','off');
	hAxes3=axes('Position',[0 0 1 1],'Visible','off');
	hFig4=figure('Units','normal','Position',FigPosVec4, 'Name',FigString4,'Color',[0 0 0], 'NumberTitle','off');
	hAxes4=axes('Position',[0 0 1 1],'Visible','off');
	hFig5=figure('Units','normal','Position',FigPosVec5, 'Name',FigString5, 'NumberTitle','off');

	RGBAnatImg=zeros(XSizeFunc,YSizeFunc,3);
	RGBFuncImg1=zeros(XSizeFunc,YSizeFunc,3);
	RGBFuncImg2=RGBFuncImg1;
	RGBFuncImg3=RGBFuncImg1;
	RGBFuncImg1(:,:,1)=FuncImg1;
	RGBFuncImg1(:,:,2)=FuncImg1;
	RGBFuncImg1(:,:,3)=FuncImg1;
	figure(hFig2)
	image(RGBFuncImg1)
	axis off
	RGBFuncImg2(:,:,1)=FuncImg2;
	RGBFuncImg2(:,:,2)=FuncImg2;
	RGBFuncImg2(:,:,3)=FuncImg2;
	figure(hFig3)
	image(RGBFuncImg2)
	axis off
	RGBFuncImg3(:,:,1)=FuncImg3;
	RGBFuncImg3(:,:,2)=FuncImg3;
	RGBFuncImg3(:,:,3)=FuncImg3;
	figure(hFig4)
	image(RGBFuncImg3)
	axis off
	pause(.001)
	fprintf('\n\n')
	ColorMat=jet;
	colormap(ColorMat);	
	[NColor]=size(ColorMat,1);
	ColorVec=linspace(MinVal,MaxVal,NColor);
  	AnatImg=squeeze(StrucMat(:,:,SliceInd));
	if XSizeStruc~=XSizeFunc | YSizeStruc~=YSizeFunc
		AnatImg= interp2(AnatImg(:,:),linspace(1,XSizeStruc,XSizeFunc),linspace(1,YSizeStruc,YSizeFunc)');
	end
	AnatImg=AnatImg./max(max(AnatImg));
	[iVec,jVec]=find(FunMat>MinVal);
	RGBAnatImg(:,:,1)=AnatImg;
	RGBAnatImg(:,:,2)=AnatImg;
	RGBAnatImg(:,:,3)=AnatImg;
	for i=1:length(iVec)
		[NonUse,MinInd]=min(abs(ColorVec-FunMat(iVec(i),jVec(i))));
		RGBAnatImg(iVec(i),jVec(i),:)=ColorMat(MinInd,:);
	end
	figure(hFig1);
	image(RGBAnatImg)
	axis off
	hTextLeft1=text('Units','normal','Position',[.9 .1],'Color','w','String','R','FontSize',20,'FontWeight','bold','Horiz','right');
	hTextRight1=text('Units','normal','Position',[.1 .1],'Color','w','String','L','FontSize',20,'FontWeight','bold','Horiz','left');
	pause(.001)
	again=1;
	OldFuncVec1=[];
	First=1;
	while again
		[XInd,YInd]=ginput(1);
		XInd=round(XInd);
		YInd=round(YInd);
		figure(hFig3);

 		TimeVec=squeeze(FuncMat(YInd,XInd,:));
		TimeVec=TimeVec.*MaxFuncMat;
		if SubMeanStatus
			TimeVec=TimeVec-mean(TimeVec);
		end
		figure(hFig5)
		TmpFigString5=[FigString5,';  x:  ',int2str(XInd),';  y:  ',int2str(YInd),';  Max. Change:  ',sprintf('%g',(max(TimeVec)./min(TimeVec)).*100), ' %'];
		set(hFig5,'Name',TmpFigString5)
		plot(PlotIndVec,TimeVec,'k')
		if ~strcmp(action,'PlotXCorrSlice')
			hold on
			plot(IndVec1,TimeVec(IndVec1),'b*')
			plot(IndVec2,TimeVec(IndVec2),'ro')
		end
  		hold off
		xlabel('Shot #')
		ylabel('Amplitude []')
		title(TmpFigString5,'FontSize',12,'FontWeight','bold')
		if First | ~FixAmpStatus
			MinAmp=min(TimeVec(MinShot:MaxShot));
			MaxAmp=max(TimeVec(MinShot:MaxShot));
			First=0;
		end
 		axis([MinShot MaxShot MinAmp MaxAmp])
% 		XTick=[MinShot:NShotPerCycle:MaxShot];
% 		set(gca,'XTick',XTick,'YTickLabel',[0,int2str(XTick)],'FontSize',16);
		xlabel('Shot #','FontSize',20);
		pause(.001)
		if ~isempty(OldFuncVec1)
			RGBFuncImg1(OldYInd,OldXInd,:)=OldFuncVec1;
			RGBFuncImg2(OldYInd,OldXInd,:)=OldFuncVec2;
			RGBFuncImg3(OldYInd,OldXInd,:)=OldFuncVec3;
		end
		OldFuncVec1=RGBFuncImg1(YInd,XInd,:);
		OldFuncVec2=RGBFuncImg2(YInd,XInd,:);
		OldFuncVec3=RGBFuncImg3(YInd,XInd,:);
		Val1=OldFuncVec1(1).*MaxFuncMat;
		Val2=OldFuncVec2(1).*MaxFuncMat;
		Val3=Val2-Val1;
		Val4=Val2/Val1.*100;
		fprintf(1,'File: ');
		fprintf(1,File);
		fprintf(1,'; Slice: %g; x: %g; y: %g; t-Value: %g; Mean I: %g; Mean II: %g; Mean II - I: %g (%g) \n',SliceInd,XInd,YInd,FunMat(YInd,XInd),Val1,Val2,Val3,Val4);
		RGBFuncImg1(YInd,XInd,:)=[1 0 0];
		RGBFuncImg2(YInd,XInd,:)=[1 0 0];
		RGBFuncImg3(YInd,XInd,:)=[1 0 0];
		figure(hFig2)
		image(RGBFuncImg1)
		axis off
		figure(hFig3)
		image(RGBFuncImg2)
		axis off
		figure(hFig4)
		image(RGBFuncImg3)
		axis off
		OldXInd=XInd;
		OldYInd=YInd;
		pause(0.001)
		figure(hFig1);
	end
	
elseif strcmp(action,'PowerFuncMat')

	hList=get(hfMRIMenu,'UserData');
	Message='Calculate functional Power Matrix';
	hProgressMsgbox=msgbox(Message,'Progress Info:','help'); 
	hChildProgressMsgbox=get(hProgressMsgbox,'Children');
	set(hChildProgressMsgbox(length(hChildProgressMsgbox)),'Visible','off');
	PowerFuncMat=get(hList(5),'Userdata');
	PowerFuncMat=PowerFuncMat(:,:,:,1).^2;
	MeanPowerFuncMat=mean(mean(mean(PowerFuncMat)));
	PowerFuncMat=PowerFuncMat./MeanPowerFuncMat;
	set(hList(121),'Userdata',PowerFuncMat,'Enable','on');		%PowerMaskSlider
	pause(1)
	close(hProgressMsgbox)
	
elseif strcmp(action,'PowerMask') | strcmp(action,'PowerMaskSlider'),
	
	hList=get(hfMRIMenu,'UserData');
	if strcmp(action,'PowerMask')
		PowerLim=get(hList(123),'Value');
		PowerLimStr=get(hList(123),'String');
		[PowerLimTmp]=String2Value(PowerLimStr);
		if PowerLimTmp<0; 
			PowerLim=0;
		elseif PowerLimTmp>10
			PowerLim=10;
		else
			PowerLim=PowerLimTmp;
		end
	elseif strcmp(action,'PowerMaskSlider')
		PowerLim=get(hList(121),'Value');
	end
	set(hList(121),'Value',PowerLim);
	set(hList(123),'Value',PowerLim,'String',sprintf('%g',PowerLim));
	if PowerLim>0;
		PowerFuncMat=get(hList(121),'Userdata');
		if isempty(PowerFuncMat)
			fMRIMenu('PowerFuncMat')
		end
	end
	
elseif strcmp(action,'CalcCoG'),

	hList=get(hfMRIMenu,'UserData');
	global XYZMat
	FilePath=get(hList(6),'Userdata')	%ReadFunc
	TR=get(hList(94),'Value');
	NShotPerCycle=get(hList(87),'Value')
	if isempty(FilePath)
		ReadPrompt = {'Enter full path of subject data'};
		if strcmp(computer,'MAC2')	
			ReadDef = {'Movie:00639'};
		elseif  strcmp(computer,'SOL2')	
			ReadDef = {'.../R003'};
		end
 		ReadDlgTitle = 'Subjects Path';
    		SubjPath=inputdlg(ReadPrompt,ReadDlgTitle,1,ReadDef);
		if isempty(SubjPath); return; end
		SubjPath=char(SubjPath);
		if ~strcmp(SubjPath(length(SubjPath)),FileSep)
			SubjPath=[SubjPath,FileSep];
		end	
		S=dir(SubjPath)
		NFiles=size(S,1);
		NFunFiles=0;
		for FileInd=1:NFiles
			F = (S(FileInd,1).name(:))'
			if strcmp(F(length(F)-3:length(F)),'.fun')
				NFunFiles=NFunFiles+1;
				if NFunFiles==1
					FileMat=char([SubjPath,F]);
				else
					FileMat=char(FileMat,[SubjPath,F]);
				end
			end
		end
		if NFunFiles==0; return; end
		set(hList(117),'Userdata',FileMat);
		ActStatus=0;
	else
		[File,SubjPath]=SepFilePath(FilePath);
		NFunFiles=1;
		ActStatus=1;
	end
	for FunFileInd=1:NFunFiles
		if ~ActStatus
			[File,Path,FilePath]=GetFileNameOfMat(FileMat,FunFileInd)
			set(hList(117),'Value',FunFileInd);
			fMRIMenu('NoCallReadFunc')
		end
		FileStr=['File: ',File];
		FuncMat=get(hList(5),'Userdata');  	%hFuncMat
		if FunFileInd==1
			SizeFuncMat=size(FuncMat);
			NShot=SizeFuncMat(4);
			FoV=180;
			SliceTh=6.5;
			NSlices=7;
			NBase=4;
			XFac=SizeFuncMat(1)./FoV	;	%Pix/mm
			YFac=SizeFuncMat(2)./FoV;		%Pix/mm
			ZFac=1./SliceTh;				%Pix/mm
			XCoG=zeros(NShot,1); YCoG=XCoG; ZCoG=XCoG;
			Message=char(zeros(7,100));
			hProgressMsgbox=msgbox(Message,'Progress Info:','help'); 
			hChildProgressMsgbox=get(hProgressMsgbox,'Children');
			set(hChildProgressMsgbox(length(hChildProgressMsgbox)),'Visible','off');
			ShotVec=[1:NShot];
			Message=char('Calculate');
			Message=char(Message,'Center of Gravity: ');
			Message=char(Message,' ');
		end
		Message=char(Message,FileStr);
		Message=char(Message,' ');
		Message=char(Message,['File ',int2str(FunFileInd),' of ',int2str(NFunFiles),'.']);
		for ShotInd=1:NShot
			String=['Shot ',int2str(ShotInd),' of ',int2str(NShot),'.'];
			MessageTmp=char(Message,String);
			set(hChildProgressMsgbox(2),'String',MessageTmp);
			pause(.001);
			ShotMat=squeeze(FuncMat(:,:,:,ShotInd));
			ShotMat=ShotMat./mean(mean(mean(ShotMat)));
% 			if ShotInd==30
% 				ShotMat(1:127,:,:)=ShotMat(2:128,:,:);
% 			end
			XShotMat=ShotMat;
			YShotMat=ShotMat;
			ZShotMat=ShotMat;
			for i=1:SizeFuncMat(1);
				XShotMat(i,:,:)=XShotMat(i,:,:).*i./XFac;
			end
			for i=1:SizeFuncMat(2);
				YShotMat(:,i,:)=YShotMat(:,i,:).*i./YFac;
			end
			for i=1:SizeFuncMat(3);
				ZShotMat(:,:,i)=ZShotMat(:,:,i).*i./ZFac;
			end
			XCoG(ShotInd)=mean(mean(mean(XShotMat)));
			YCoG(ShotInd)=mean(mean(mean(YShotMat)));
			ZCoG(ShotInd)=mean(mean(mean(ZShotMat)));
		end
		XYZCoG=sqrt(XCoG.^2+YCoG.^2+ZCoG.^2);
		DiffXCoG=XCoG-mean(XCoG);
		DiffYCoG=YCoG-mean(YCoG);
		DiffZCoG=ZCoG-mean(ZCoG);
		DiffXYZCoG=XYZCoG-mean(XYZCoG);
		XYZMat=zeros(NShot,4);
		XYZMat(:,1)=DiffXCoG;
		XYZMat(:,2)=DiffYCoG;
		XYZMat(:,3)=DiffZCoG;
		XYZMat(:,4)=DiffXYZCoG;
		
		FuncMat=zeros(4,1,1,NShot);
		FuncMat(:,1,1,:)=XYZMat';

		MinLag=0
		MaxLag=3
		ShotOrderPlotStatus=get(hList(99),'Value');
		[MiCs1,MiCs2,NonUse,NonUse,MiCsMat,LastShot]=fMriTStat(FuncMat,'CalcIndT21',NBase,NShotPerCycle,MinLag,MaxLag,ShotOrderPlotStatus);
		
		DiffXYZCoG(IndVec1)=.1.*ones(1,length(IndVec1));
		DiffXYZCoG(IndVec2)=-.1.*ones(1,length(IndVec2));
		XYZMat(:,4)=DiffXYZCoG;
		
		FrequResol=TR./(NShot-NBase)./1000;
		StimFrequ=1./(2.*NShotPerCycle.*TR./1000);
		FrequVec=linspace(0,1./(2.*TR./1000),(NShot-NBase)./2+1);
		FftXYZMat=(fft(XYZMat(NBase:NShot,:)'))';
		PfftXYZMat=abs(FftXYZMat.*conj(FftXYZMat))./(NShot-NBase);
		PfftXYZMat=PfftXYZMat(1:(NShot-NBase)./2+1,:)

% 		Save2Jmp([Path,File(1:length(File)-2),'mov'],XYZMat)
		
		
		FigPosVec=[0 0 .4 1];
		FigString=['Center of Gravity; ',FileStr];
		hFig1=figure('Units','normal','Position',FigPosVec, 'Name',FigString, 'NumberTitle','off');
		Tmp=round(MiCs1.*100)./100;
		TString=['t-Values: x = ',sprintf('%g',Tmp(1)),' ; y =  ',sprintf('%g',Tmp(2)),' ; z = ',sprintf('%g',Tmp(3)),' ; xyz =  ',sprintf('%g',Tmp(4))] ;
		subplot(3,1,1)
		plot(ShotVec,XCoG)
		hold on
		plot(ShotVec,YCoG,'r')
		plot(ShotVec,ZCoG,'g')
		plot(ShotVec,XYZCoG,'k')
		AbsMin=min([min(XCoG(NBase:NShot)),min(YCoG(NBase:NShot)),min(ZCoG(NBase:NShot)),min(XYZCoG(NBase:NShot))]);
		AbsMax=max([max(XCoG(NBase:NShot)),max(YCoG(NBase:NShot)),max(ZCoG(NBase:NShot)),max(XYZCoG(NBase:NShot))]);
		axis([NBase max(ShotVec) AbsMin-5 AbsMax+5])
		xlabel('Shot #')
		ylabel('Absolute Center of Gravity [mm]')
		title('Abs. center of gravity in x (blue), y (red) and z (green) direction:')
		
		subplot(3,1,2)
		AbsMin=min([min(DiffXCoG(NBase:NShot)),min(DiffYCoG(NBase:NShot)),min(DiffZCoG(NBase:NShot)),min(DiffXYZCoG(NBase:NShot))]);
		AbsMax=max([max(DiffXCoG(NBase:NShot)),max(DiffYCoG(NBase:NShot)),max(DiffZCoG(NBase:NShot)),max(DiffXYZCoG(NBase:NShot))]);
		plot(ShotVec,DiffXCoG)
		hold on
		plot(ShotVec,DiffYCoG,'r')
		plot(ShotVec,DiffZCoG,'g')
		plot(ShotVec,DiffXYZCoG,'k')
		plot(IndVec1,AbsMax.*ones(length(IndVec1),1),'*')
		plot(IndVec2,AbsMin.*ones(length(IndVec2),1),'ro')
		hold off
		axis([NBase max(ShotVec) AbsMin AbsMax])
		xlabel('Shot #')
		ylabel('Relative Center of Gravity [mm]')
		title(TString)
		close(hProgressMsgbox)
		
		subplot(3,1,3)
		plot(FrequVec,PfftXYZMat(:,1))
		hold on
		plot(FrequVec,PfftXYZMat(:,2),'r')
		plot(FrequVec,PfftXYZMat(:,3),'g')
		plot(FrequVec,PfftXYZMat(:,4),'k')
		if StimFrequ<max(FrequVec)
			plot([StimFrequ StimFrequ],[0, max(max(PfftXYZMat))],'--k');
		end
		axis([min(FrequVec) max(FrequVec) 0 max(max(PfftXYZMat))])
		xlabel('Frequency [Hz]')
		ylabel('Power [ ]')
	end
	
elseif strcmp(action,'PlotIndTPosVal') | ...
	strcmp(action,'PlotIndTNegVal') | ...
	strcmp(action,'PlotIndTPosLag') | ...
	strcmp(action,'PlotIndTNegLag') | ...
	strcmp(action,'PlotDepTPosVal')  | ...
	strcmp(action,'PlotDepTNegVal')  | ...
	strcmp(action,'PlotDepTPosLag') | ...
	strcmp(action,'PlotDepTNegLag') | ...
	strcmp(action,'PlotXCorrVal') | ...
	strcmp(action,'PlotXCorrLag') | ...
	strcmp(action,'PlotMutInfoCSVal') | ...
	strcmp(action,'PlotMutInfoISVal') | ...
	strcmp(action,'PlotMutInfoCSLag') | ...
	strcmp(action,'PlotMutInfoISLag'),
	
	hList=get(hfMRIMenu,'UserData');
	FilePath=get(hList(6),'Userdata');	%ReadFunc
	[File,Path]=SepFilePath(FilePath);
	FileStr=['File: ',File];
	StrucMat=get(hList(1),'Userdata');
	PowerLim=get(hList(121),'Value');
	if PowerLim>0
		PowerFuncMat=get(hList(121),'Userdata');
		if isempty(PowerFuncMat)
			fMRIMenu('PowerFuncMat')
			PowerFuncMat=get(hList(121),'Userdata');
		end
	end
	if isempty(StrucMat)
		fprintf('Sorry, no structural data available...\n');
		Message=char('Sorry,');
		Message=char(Message,'no structural data available.');
		Message=char(Message,'');
		Message=char(Message,'Please choose structural');
		Message=char(Message,'data file corresponding to');
		Message=char(Message,'functional file:');
		Message=char(Message,'');
		Message=char(Message,File)
		Message=char(Message,'');
		hMsgbox=msgbox(Message,'Info:','help'); 
		fMRIMenu('ReadStruc')
		StrucMat=get(hList(1),'Userdata');
		if isempty(StrucMat); return; end
	end
	[XSizeStruc,YSizeStruc,NSlice]=size(StrucMat);
	if strcmp(action,'PlotIndTPosVal') | ...
	strcmp(action,'PlotIndTNegVal') | ...
	strcmp(action,'PlotDepTPosVal') | ...
	strcmp(action,'PlotDepTNegVal') | ...
	strcmp(action,'PlotXCorrVal') | ...
	strcmp(action,'PlotMutInfoCSVal') | ...
	strcmp(action,'PlotMutInfoISVal'),		
		MaskMat=zeros(XSizeStruc,YSizeStruc,NSlice);
	else
		MaskMat=get(hList(96),'Userdata');
	end
	if strcmp(action,'PlotIndTPosVal') | strcmp(action,'PlotIndTNegVal')
		MinTLagVal=get(hList(127),'Value')
		MaxTLagVal=get(hList(129),'Value')
		NTLagVal=MaxTLagVal-MinTLagVal+1;
		BaseVal=get(hList(37),'Value');
		BaseStr=['Base: ',int2str(BaseVal)];
		FigPosVec=[0 0 .4 1];
		if NTLagVal==1
			FigString=[FileStr,';   Ind. t-Test;   Base:  ',int2str(BaseVal),';  Lag: ',int2str(MinTLagVal)];
			CalcStr=['Ind. t-Test; Lag: ',int2str(MinTLagVal)];
		else
			FigString=[FileStr,';   Max. of Ind. t-Test;   Base:  ',int2str(BaseVal)];
			CalcStr='Max. of Ind. t-Test';
		end
		XPColorStr='t of Independent t-Test';
% 		if NTLagVal==1
% 			FunMat=get(hList(133),'Userdata');
% 			size(FunMat)
% 			FunMat=squeeze(FunMat(:,:,:,MinTLagVal+1));
% 		else
			FunMat=get(hList(13),'Userdata');
% 		end
		if strcmp(action,'PlotIndTPosVal')
			MinVal=get(hList(22),'Value');
			MaxVal=get(hList(24),'Value');
		else
			MinVal=get(hList(102),'Value');
			MaxVal=get(hList(104),'Value');
		end
	elseif strcmp(action,'PlotIndTPosLag') | strcmp(action,'PlotIndTNegLag')
		MinTLagVal=get(hList(127),'Value');
		MaxTLagVal=get(hList(129),'Value');
		NTLagVal=MaxTLagVal-MinTLagVal+1;
		BaseVal=get(hList(37),'Value');
		BaseStr=['Base: ',int2str(BaseVal)];
		FigPosVec=[.4 0 .4 1];
		if NTLagVal==1
			FigString=[FileStr,';   Lag of Ind. t-Test;   Base:  ',int2str(BaseVal),';  Lag: ',int2str(MinTLagVal)];
			CalcStr=['Lag of Ind. t-Test; Lag: ',int2str(MinTLagVal)];
		else
			FigString=[FileStr,';   Lag of Max. of Ind. t-Test;   Base:  ',int2str(BaseVal)];
			CalcStr='Lag of Max. of Ind. t-Test';
		end
		XPColorStr='t of Independent t-Test';
		FunMat=get(hList(134),'Userdata');
		MinVal=get(hList(127),'Value');
		MaxVal=get(hList(129),'Value');
	elseif strcmp(action,'PlotDepTPosVal') | strcmp(action,'PlotDepTNegVal')
		MinTLagVal=get(hList(142),'Value');
		MaxTLagVal=get(hList(144),'Value');
		NTLagVal=MaxTLagVal-MinTLagVal+1;
		BaseVal=get(hList(39),'Value');
		BaseStr=['Base: ',int2str(BaseVal)];
		FigPosVec=[0 0 .4 1];
		if NTLagVal==1
			FigString=[FileStr,';   Dep. t-Test;   Base:  ',int2str(BaseVal),';  Lag: ',int2str(MinTLagVal)];
			CalcStr=['Dep. t-Test; Lag: ',int2str(MinTLagVal)];
		else
			FigString=[FileStr,';   Max. of Dep. t-Test;   Base:  ',int2str(BaseVal)];
			CalcStr='Max. of Dep. t-Test';
		end
		XPColorStr='t of Dependent t-Test';
		if NTLagVal==1
			FunMat=get(hList(148),'Userdata');
			FunMat=squeeze(FunMat(:,:,:,MinTLagVal+1));
		else
			FunMat=get(hList(14),'Userdata');
		end
		if strcmp(action,'PlotDepTPosVal')
			MinVal=get(hList(27),'Value');
			MaxVal=get(hList(29),'Value');
		else
			MinVal=get(hList(107),'Value');
			MaxVal=get(hList(109),'Value');
		end
	elseif strcmp(action,'PlotDepTPosLag') | strcmp(action,'PlotDepTNegLag')
		MinTLagVal=get(hList(142),'Value');
		MaxTLagVal=get(hList(144),'Value');
		NTLagVal=MaxTLagVal-MinTLagVal+1;
		BaseVal=get(hList(39),'Value');
		BaseStr=['Base: ',int2str(BaseVal)];
		FigPosVec=[.4 0 .4 1];
		if NTLagVal==1
			FigString=[FileStr,';  Lag of  Dep. t-Test;   Base:  ',int2str(BaseVal),';  Lag: ',int2str(MinTLagVal)];
			CalcStr=['Lag of Dep. t-Test; Lag: ',int2str(MinTLagVal)];
		else
			FigString=[FileStr,';  Lag of Max. of Dep. t-Test;   Base:  ',int2str(BaseVal)];
			CalcStr='Lag of Max. of Dep. t-Test';
		end
		XPColorStr='t of Independent t-Test';
		FunMat=get(hList(149),'Userdata');
		MinVal=get(hList(142),'Value');
		MaxVal=get(hList(144),'Value');
	elseif strcmp(action,'PlotXCorrVal')
		CalcStr='Max. of ';
		CalcStr2='Cross-Corr. Function';
		FunMat=get(hList(15),'Userdata');
		MinVal=get(hList(42),'Value');
		MaxVal=get(hList(44),'Value');
		BaseVal=get(hList(48),'Value');
		BaseStr=['Base: ',int2str(BaseVal)];
		FigPosVec=[0 0 .4 1];
		FigString=[FileStr,';   Max. of X-Corr.;   Base:  ',int2str(BaseVal)];
		XPColorStr='Cross-Correlation Function';
	elseif strcmp(action,'PlotXCorrLag')
		CalcStr='Lag of Max. of ';
		CalcStr2='Cross-Corr. Function';
		FunMat=get(hList(16),'Userdata');
		MinVal=get(hList(52),'Value');
		MaxVal=get(hList(54),'Value');
		BaseVal=get(hList(48),'Value');
		BaseStr=['Base: ',int2str(BaseVal)];
		FigPosVec=[.4 0 .4 1];
		FigString=[FileStr,';   Lag of Max. of X-Corr .;   Base:  ',int2str(BaseVal)];
		XPColorStr='Cross-Correlation Fuction';
	elseif strcmp(action,'PlotMutInfoCSVal')
		CalcStr='Max. of Cauchy-Schwartz';
		FunMat=get(hList(81),'Userdata');
		MinVal=get(hList(72),'Value');
		MaxVal=get(hList(74),'Value');
		BaseVal=get(hList(70),'Value');
		BaseStr=['Base: ',int2str(BaseVal)];
		FigPosVec=[0 0 .4 1];
		FigString=[FileStr,';    Max. of CS Mut. Info;   Base:  ',int2str(BaseVal)];
		XPColorStr='Cauchy-Schwartz Value [ ]';
	elseif strcmp(action,'PlotMutInfoISVal')
		CalcStr='Max. of Integ. Square';
		FunMat=get(hList(82),'Userdata');
		MinVal=get(hList(77),'Value');
		MaxVal=get(hList(79),'Value');
		BaseVal=get(hList(70),'Value');
		BaseStr=['Base: ',int2str(BaseVal)];
		FigPosVec=[0 0 .4 1];
		FigString=[FileStr,';    Max. of IS Mut. Info;   Base:  ',int2str(BaseVal)];
		XPColorStr='Integ. Square Value [ ]';
	elseif strcmp(action,'PlotMutInfoCSLag')
		CalcStr='CS Mutual Info Lag:';
		FunMat=get(hList(157),'Userdata');
		MinVal=get(hList(152),'Value')
		MaxVal=get(hList(154),'Value')
		BaseVal=get(hList(70),'Value');
		BaseStr=['Base: ',int2str(BaseVal)];
		FigPosVec=[.4 0 .4 1];
		FigString=[FileStr,';   Lag of Max of CS Mut. Info;   Base:  ',int2str(BaseVal)];
		XPColorStr='Cauchy Schwartz Lag [ ]';
	elseif strcmp(action,'PlotMutInfoISLag')
		CalcStr='IS Mutual Info Lag:';
		FunMat=get(hList(159),'Userdata');
		MinVal=get(hList(152),'Value');
		MaxVal=get(hList(154),'Value');
		BaseVal=get(hList(70),'Value');
		BaseStr=['Base: ',int2str(BaseVal)];
		FigPosVec=[.4 0 .4 1];
		FigString=[FileStr,';   Lag of Max. of IS Mut. Info;   Base:  ',int2str(BaseVal)];
		XPColorStr='Integ. Square Lag [ ]';
	end
% 	global x y N M
% 	a=reshape(FunMat,64*64*7,1);
% 	figure;
% 	[N,x]=hist(a,100);
% % 	[M,y]=hist(a,100);
% 	nx=x./25;%max(x);
% 	ny=y./max(y);
% 	plot(nx,N)
% 	hold on
% 	plot(ny,M,'-r')
% 	axis([0 1 0 100])
% 	hold off
% 	return
	NSubPlotCol=4;
	NSubPlotRow=2;
	RowInd=1;
	ColInd=1;
	PrintStatus=0;
	if PrintStatus
		BackColor=[1 1 1];
   		ForeColor=[0 0 0];
	else
		BackColor=[0 0 0];
		ForeColor=[1 1 1];
	end
	hFig1=figure('Units','normal','Position',FigPosVec, 'Name',FigString,'Color',BackColor, 'NumberTitle','off');
	hAxes1=axes('Position',[0 0 1 1],'Visible','off');
	hText1=text('Units','normal','Position',[.1 .96],'Color',ForeColor,'String',FileStr,'FontSize',16,'FontWeight','bold','Horiz','left');
	hText2=text('Units','normal','Position',[.1 .93],'Color',ForeColor,'String',CalcStr,'FontSize',16,'FontWeight','bold','Horiz','left');
	if  strcmp(action,'PlotXCorrVal') | strcmp(action,'PlotXCorrLag')
		hText3=text('Units','normal','Position',[.1 .90],'Color',ForeColor,'String',CalcStr2,'FontSize',16,'FontWeight','bold','Horiz','left');
		hText4=text('Units','normal','Position',[.1 .87],'Color',ForeColor,'String',BaseStr,'FontSize',16,'FontWeight','bold','Horiz','left');
	else
		hText5=text('Units','normal','Position',[.1 .90],'Color',ForeColor,'String',BaseStr,'FontSize',16,'FontWeight','bold','Horiz','left');
	end
	hText5=text('Units','normal','Position',[.1 .87],'Color',ForeColor,'String',['Min.:  ',sprintf('%g',MinVal),';  Max.:  ',sprintf('%g',MaxVal)],'FontSize',12,'FontWeight','bold','Horiz','left');
	[XSizeFun,YSizeFun,NSlice]=size(FunMat);
	RGBAnatImg=zeros(XSizeStruc,YSizeStruc,3);
	fprintf('\n\n')
	ColorMat=jet;
	colormap(ColorMat);	
	[NColor]=size(ColorMat,1);		
	if strcmp(action,'PlotIndTNegVal') | strcmp(action,'PlotDepTNegVal')
		ColorVec=linspace(MaxVal,MinVal,NColor);
		ColorMat=flipud(ColorMat); 	
		colormap(ColorMat);	
	else
		ColorVec=linspace(MinVal,MaxVal,NColor);
	end
	
	hPColorAxes=axes('Units','normal','Position',[.1 .80 .325 .03]);
	XPColor=linspace(MinVal,MaxVal);
	pcolor(XPColor,[0 1],ones(2,1)*XPColor); 
	shading interp;
 	title(XPColorStr,'Color',ForeColor,'FontSize',12,'FontWeight','bold')
	set(gca,'YTick',[],'YTickLabel',[],'FontSize',12,'FontWeight','bold','XColor',ForeColor);
	for SliceInd=1:NSlice
		if PowerLim>0
			PowerMask=PowerFuncMat(:,:,SliceInd);
		end
		RowInd=RowInd+1;
		if RowInd>NSubPlotRow
			ColInd=ColInd+1;
			RowInd=1;
		end
		ColPos=1-ColInd.*NSubPlotCol^-1;
		RowPos=(RowInd-1).*NSubPlotRow^-1;
		hAxes=axes('Units','normal','Position',[RowPos ColPos  NSubPlotRow^-1 NSubPlotCol^-1 ]);
		
  		AnatImg=squeeze(StrucMat(:,:,SliceInd));
		AnatImg=AnatImg./max(max(AnatImg));
		RGBAnatImg(:,:,1)=AnatImg;
		RGBAnatImg(:,:,2)=AnatImg;
		RGBAnatImg(:,:,3)=AnatImg;
		if PrintStatus
			[iVec,jVec]=find(AnatImg<.005);
			TriOnes=[1 1 1];
			for i=1:length(iVec)
				RGBAnatImg(iVec(i),jVec(i),:)=TriOnes;
			end
		end
		DownSampleStatus=0;
		Interp2Str='cubic';
		 if DownSampleStatus
			 Corr= interp2(FunMat(:,:,SliceInd),linspace(1,XSizeFun,XSizeFun./2),linspace(1,YSizeFun,YSizeFun./2)',Interp2Str);
			 Corr= interp2(Corr,linspace(1,XSizeFun./2,XSizeStruc),linspace(1,YSizeFun./2,YSizeStruc)',Interp2Str);
			 if PowerLim>0
				PowerMask= interp2(PowerMask,linspace(1,XSizeFun./2,XSizeStruc),linspace(1,YSizeFun./2,YSizeStruc)',Interp2Str);
			end		
		else	 
			 if XSizeStruc~=XSizeFun | YSizeStruc~=YSizeFun
				Corr= interp2(FunMat(:,:,SliceInd),linspace(1,XSizeFun,XSizeStruc),linspace(1,YSizeFun,YSizeStruc)',Interp2Str);
				if PowerLim>0
					PowerMask= interp2(PowerMask,linspace(1,XSizeFun,XSizeStruc),linspace(1,YSizeFun,YSizeStruc)',Interp2Str);
				end
			else
  				Corr=Fun;
			end
		end
		if strcmp(action,'PlotIndTNegVal') | strcmp(action,'PlotDepTNegVal')
			[iVec,jVec]=find(Corr<MinVal);
		else
			[iVec,jVec]=find(Corr>MinVal);
		end
		if PowerLim>0
			if strcmp(action,'PlotXCorrVal') | ...
			strcmp(action,'PlotIndTPosVal') | ...
			strcmp(action,'PlotIndTNegVal') | ...
			strcmp(action,'PlotDepTPosVal') | ...
			strcmp(action,'PlotDepTNegVal') | ...
			strcmp(action,'PlotMutInfoCSVal') | ...
			strcmp(action,'PlotMutInfoISVal'),
				for i=1:length(iVec)
					if PowerMask(iVec(i),jVec(i))>PowerLim
						MaskMat(iVec(i),jVec(i),SliceInd)=1;
						[NonUse,MinInd]=min(abs(ColorVec-Corr(iVec(i),jVec(i))));
						RGBAnatImg(iVec(i),jVec(i),:)=ColorMat(MinInd,:);
					end
				end
			elseif strcmp(action,'PlotXCorrLag') | ...
			strcmp(action,'PlotIndTPosLag') | ...
			strcmp(action,'PlotIndTNegLag') | ...
			strcmp(action,'PlotDepTPosLag') | ...
			strcmp(action,'PlotDepTNegLag') | ...
			strcmp(action,'PlotMutInfoCSLag') | ...
			strcmp(action,'PlotMutInfoISLag'),
			
				for i=1:length(iVec)
					if PowerMask(iVec(i),jVec(i))>PowerLim
						if MaskMat(iVec(i),jVec(i),SliceInd)
							[NonUse,MinInd]=min(abs(ColorVec-Corr(iVec(i),jVec(i))));
							RGBAnatImg(iVec(i),jVec(i),:)=ColorMat(MinInd,:);
						end
					end
				end
			end
		else	%if PowerLim==0
			if strcmp(action,'PlotXCorrVal') | ...
				strcmp(action,'PlotIndTPosVal') | ...
				strcmp(action,'PlotIndTNegVal') | ...
				strcmp(action,'PlotDepTPosVal') | ...
				strcmp(action,'PlotDepTNegVal') | ...
				strcmp(action,'PlotMutInfoCSVal') | ...
				strcmp(action,'PlotMutInfoISVal'),
				for i=1:length(iVec)
					MaskMat(iVec(i),jVec(i),SliceInd)=1;
					[NonUse,MinInd]=min(abs(ColorVec-Corr(iVec(i),jVec(i))));
					RGBAnatImg(iVec(i),jVec(i),:)=ColorMat(MinInd,:);
				end
			elseif strcmp(action,'PlotXCorrLag') | ...
				strcmp(action,'PlotIndTPosLag') | ...
				strcmp(action,'PlotIndTNegLag') | ...
				strcmp(action,'PlotDepTPosLag') | ...
				strcmp(action,'PlotDepTNegLag') | ...
				strcmp(action,'PlotMutInfoCSLag') | ...
				strcmp(action,'PlotMutInfoISLag'),
				for i=1:length(iVec)
					if MaskMat(iVec(i),jVec(i),SliceInd)
						[NonUse,MinInd]=min(abs(ColorVec-Corr(iVec(i),jVec(i))));
						RGBAnatImg(iVec(i),jVec(i),:)=ColorMat(MinInd,:);
					end
				end
			end
		end	%if PowerLim>0
% 		subplot(NSubPlotCol,NSubPlotRow,SliceInd+1);
		image(RGBAnatImg)
		axis off
% 		title(['Slice # ', int2str(SliceInd)],'Color',[1 1 1])
		if SliceInd==1
			hTextLeft=text('Units','normal','Position',[.8 .1],'Color','w','String','R','FontSize',14,'FontWeight','bold','Horiz','right');
			hTextRight=text('Units','normal','Position',[.2 .1],'Color','w','String','L','FontSize',14,'FontWeight','bold','Horiz','left');
		end
		pause(.1)
	end
	set(hList(96),'Userdata',MaskMat);
else
  	disp(sprintf('fMRIMenu: action string ''%s'' not recognized, no action taken.',action))
end
 
