function addfixx(filename,filepath,format,width,length)
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
width = str2num(width);
length = str2num(length);
color = 'all';


file=[filepath,filename];

if ~isempty(findstr(filename,'.jpg'))
    [picmat]=imread(file,'jpg');
    readinformat = 'jpg';
else
    [picmat]=imread(file,'bmp');
    readinformat = 'bmp';
end
    
    
[picmat]=imread(file);


if strcmp(color,'red') | strcmp(color,'all')

	picmat(240-length:240+length,320-width:320+width,1)=255  ;
	picmat(240-length:240+length,320-width:320+width,2)=0;
	picmat(240-length:240+length,320-width:320+width,3)=0;
	
	picmat(240-width:240+width,320-length:320+length,1)=255;
	picmat(240-width:240+width,320-length:320+length,2)=0;
	picmat(240-width:240+width,320-length:320+length,3)=0;
    
    if strcmp(format,'jpg')
        if strcmp(readinformat,'jpg')
            targetfilename=strrep(filename,'.jpg','.rx.jpg');
            imwrite(picmat,targetfilename,'jpg','Quality',100);
        else
            targetfilename=strrep(filename,'.bmp','.rx.jpg');
            imwrite(picmat,targetfilename,'jpg','Quality',100);
        end
    else  
        if strcmp(readinformat,'jpg')
            targetfilename=strrep(filename,'.jpg','.rx.bmp');
            imwrite(picmat,targetfilename,'bmp');
        else
            targetfilename=strrep(filename,'.bmp','.rx.bmp');
            imwrite(picmat,targetfilename,'bmp');
        end
    end
    
end

if strcmp(color,'green') | strcmp(color,'all')
    
	picmat(240-length:240+length,320-width:320+width,1)=0;
	picmat(240-length:240+length,320-width:320+width,2)=255;
	picmat(240-length:240+length,320-width:320+width,3)=0;
	
	picmat(240-width:240+width,320-length:320+length,1)=0;
	picmat(240-width:240+width,320-length:320+length,2)=255;
	picmat(240-width:240+width,320-length:320+length,3)=0;
    
   if strcmp(format,'jpg')
        if strcmp(readinformat,'jpg')
            targetfilename=strrep(filename,'.jpg','.gx.jpg');
            imwrite(picmat,targetfilename,'jpg','Quality',100);
        else
            targetfilename=strrep(filename,'.bmp','.gx.jpg');
            imwrite(picmat,targetfilename,'jpg','Quality',100);
        end
    else  
        if strcmp(readinformat,'jpg')
            targetfilename=strrep(filename,'.jpg','.gx.bmp');
            imwrite(picmat,targetfilename,'bmp');
        else
            targetfilename=strrep(filename,'.bmp','.gx.bmp');
            imwrite(picmat,targetfilename,'bmp');
        end
    end
end
    
if strcmp(color,'blue') | strcmp(color,'all')
    
    picmat(240-length:240+length,320-width:320+width,1)=0;
	picmat(240-length:240+length,320-width:320+width,2)=0;
	picmat(240-length:240+length,320-width:320+width,3)=255;
	
	picmat(240-width:240+width,320-length:320+length,1)=0;
	picmat(240-width:240+width,320-length:320+length,2)=0;
	picmat(240-width:240+width,320-length:320+length,3)=255;
    
   if strcmp(format,'jpg')
        if strcmp(readinformat,'jpg')
            targetfilename=strrep(filename,'.jpg','.bx.jpg');
            imwrite(picmat,targetfilename,'jpg','Quality',100);
        else
            targetfilename=strrep(filename,'.bmp','.bx.jpg');
            imwrite(picmat,targetfilename,'jpg','Quality',100);
        end
    else  
        if strcmp(readinformat,'jpg')
            targetfilename=strrep(filename,'.jpg','.bx.bmp');
            imwrite(picmat,targetfilename,'bmp');
        else
            targetfilename=strrep(filename,'.bmp','.bx.bmp');
            imwrite(picmat,targetfilename,'bmp');
        end
    end
end
    
if strcmp(color,'black') | strcmp(color,'all')
    
    picmat(240-length:240+length,320-width:320+width,1)=0;
	picmat(240-length:240+length,320-width:320+width,2)=0;
	picmat(240-length:240+length,320-width:320+width,3)=0;
	
	picmat(240-width:240+width,320-length:320+length,1)=0;
	picmat(240-width:240+width,320-length:320+length,2)=0;
	picmat(240-width:240+width,320-length:320+length,3)=0;
    
  if strcmp(format,'jpg')
        if strcmp(readinformat,'jpg')
            targetfilename=strrep(filename,'.jpg','.x.jpg');
            imwrite(picmat,targetfilename,'jpg','Quality',100);
        else
            targetfilename=strrep(filename,'.bmp','.x.jpg');
            imwrite(picmat,targetfilename,'jpg','Quality',100);
        end
    else  
        if strcmp(readinformat,'jpg')
            targetfilename=strrep(filename,'.jpg','.x.bmp');
            imwrite(picmat,targetfilename,'bmp');
        else
            targetfilename=strrep(filename,'.bmp','.x.bmp');
            imwrite(picmat,targetfilename,'bmp');
        end
    end
    
end





return