function [filemat,mode]=batchfiletomat(filename,filepath,berichtstatus)
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      

if nargin < 3; berichtstatus = 0; end

batchfile=strcat(filepath,filename);
batchfilehandle=fopen(batchfile,'rt');
frewind(batchfilehandle);

% batchfile prfen
if batchfilehandle==-1
   batchfilefehler
   return
end

% filenamen einlesen
filemat{1}='default';
zeile=1;
j=1;
status=1;
while status==1
zeile=fgetl(batchfilehandle);
if isnumeric(zeile)
   status=0;
else 
   file=zeile;
   filemat{j}=file;
end
j=j+1;
end
fclose(batchfilehandle);

% files pruefen
size(filemat);
filematgroessevec=size(filemat);
filematgroesse=filematgroessevec(2);
for l=1:filematgroesse
   fid=fopen(filemat{l},'r');
   if fid==-1
      msgbox([' --> batchfilefehler im ',num2str(l),'. File!'],'Warnung!')
      evalstring=['edit ',filepath,filename];
      eval(evalstring);
      mode=[];
      return
   end
   fclose(fid);
end
mode = 12;
if berichtstatus == 1
    msgbox('batchfile erfolgreich geprft','Note:');
    
end
return