function choosechannelweightingfile
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
global handles channelweightmat

[chwfilename,chwfilepath]=uigetfile('*.chw','Bitte whlen Sie ein File mit Channelgewichten aus:');

if isequal(chwfilename,0)|isequal(chwfilepath,0)
        uiwait(msgbox('File not found!','Error:'));
        return
else
  try
  channelweightmat=textread([chwfilepath,chwfilename],'%n');
  if size(channelweightmat,1)~=129
      uiwait(errordlg('Unrecognized Fileformat!','Error:'));
      return
  else
      disp('Channelweights for 129 sensors found!');
  end 
  catch
      uiwait(errordlg('Unrecognized Fileformat!','Error:'));
      return
  end
   
end

set(handles.channelweightingmonitor,'String',chwfilename);
return