function chooseifile
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      

global ifilemat imode


[batifilename,batifilepath]=uigetfile('*.i*','bitte geben Sie ein Batchfile der I-files an:');
if isequal(batifilename,0)|isequal(batifilepath,0)
        uiwait(msgbox('File not found!','Error:'));
   return
else
   cd(batifilepath);
   fid = fopen([batifilepath,batifilename],'r');
   FilePath=fgetl(fid);
   disp(FilePath);
   batchfilestatus = exist(FilePath,'file');
   if batchfilestatus~=0
       ifilemat=batchfiletomat(batifilename,batifilepath,0);
       disp('Batchfile found!');
       imode = 12;
   else
       disp('i-single-file-mode initiated');
       ifilemat=cell(1);
       ifilemat{1}=[batifilepath,batifilename];
       imode = 2;
   end
end

if isempty(ifilemat);
    imode = 0;
    return;
else
    ifilemonitor=findobj('tag','ifilemonitor');
    set(ifilemonitor,'String',batifilename);
end

return
