function cmap2hexint
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      

allcolors = zeros(200,14);

%jet
jetmap =  round(jet(200)*254+1);
jetstring = [dec2hex(zeros(200,1),2),dec2hex(jetmap(:,1),2),dec2hex(jetmap(:,2),2),dec2hex(jetmap(:,3),2)];
jetnumbers = hex2dec([dec2hex(zeros(200,1),2),dec2hex(jetmap(:,1),2),dec2hex(jetmap(:,2),2),dec2hex(jetmap(:,3),2)]);
allcolors(:,1)=jetnumbers;

%autum
autumnmap =  round(autumn(200)*254+1);
autumnstring = [dec2hex(zeros(200,1),2),dec2hex(autumnmap(:,1),2),dec2hex(autumnmap(:,2),2),dec2hex(autumnmap(:,3),2)];
autumnnumbers = hex2dec([dec2hex(zeros(200,1),2),dec2hex(autumnmap(:,1),2),dec2hex(autumnmap(:,2),2),dec2hex(autumnmap(:,3),2)]);
allcolors(:,2)=autumnnumbers;

%bone
bonemap =  round(bone(200)*254+1);
bonestring = [dec2hex(zeros(200,1),2),dec2hex(bonemap(:,1),2),dec2hex(bonemap(:,2),2),dec2hex(bonemap(:,3),2)];
bonenumbers = hex2dec([dec2hex(zeros(200,1),2),dec2hex(bonemap(:,1),2),dec2hex(bonemap(:,2),2),dec2hex(bonemap(:,3),2)]);
allcolors(:,3)=bonenumbers;

%cool
coolmap =  round(cool(200)*254+1);
coolstring = [dec2hex(zeros(200,1),2),dec2hex(coolmap(:,1),2),dec2hex(coolmap(:,2),2),dec2hex(coolmap(:,3),2)];
coolnumbers = hex2dec([dec2hex(zeros(200,1),2),dec2hex(coolmap(:,1),2),dec2hex(coolmap(:,2),2),dec2hex(coolmap(:,3),2)]);
allcolors(:,4)=coolnumbers;

%copper
coppermap =  round(copper(200)*254+1);
copperstring = [dec2hex(zeros(200,1),2),dec2hex(coppermap(:,1),2),dec2hex(coppermap(:,2),2),dec2hex(coppermap(:,3),2)];
coppernumbers = hex2dec([dec2hex(zeros(200,1),2),dec2hex(coppermap(:,1),2),dec2hex(coppermap(:,2),2),dec2hex(coppermap(:,3),2)]);
allcolors(:,5)=coppernumbers;

%flag
flagmap =  round(flag(200)*254+1);
flagstring = [dec2hex(zeros(200,1),2),dec2hex(flagmap(:,1),2),dec2hex(flagmap(:,2),2),dec2hex(flagmap(:,3),2)];
flagnumbers = hex2dec([dec2hex(zeros(200,1),2),dec2hex(flagmap(:,1),2),dec2hex(flagmap(:,2),2),dec2hex(flagmap(:,3),2)]);
allcolors(:,6)=flagnumbers;

%gray
graymap =  round(gray(200)*254+1);
graystring = [dec2hex(zeros(200,1),2),dec2hex(graymap(:,1),2),dec2hex(graymap(:,2),2),dec2hex(graymap(:,3),2)];
graynumbers = hex2dec([dec2hex(zeros(200,1),2),dec2hex(graymap(:,1),2),dec2hex(graymap(:,2),2),dec2hex(graymap(:,3),2)]);
allcolors(:,7)=graynumbers;

%hot
hotmap =  round(hot(200)*254+1);
hotstring = [dec2hex(zeros(200,1),2),dec2hex(hotmap(:,1),2),dec2hex(hotmap(:,2),2),dec2hex(hotmap(:,3),2)];
hotnumbers = hex2dec([dec2hex(zeros(200,1),2),dec2hex(hotmap(:,1),2),dec2hex(hotmap(:,2),2),dec2hex(hotmap(:,3),2)]);
allcolors(:,8)=hotnumbers;

%hsv
hsvmap =  round(hsv(200)*254+1);
hsvstring = [dec2hex(zeros(200,1),2),dec2hex(hsvmap(:,1),2),dec2hex(hsvmap(:,2),2),dec2hex(hsvmap(:,3),2)];
hsvnumbers = hex2dec([dec2hex(zeros(200,1),2),dec2hex(hsvmap(:,1),2),dec2hex(hsvmap(:,2),2),dec2hex(hsvmap(:,3),2)]);
allcolors(:,9)=hsvnumbers;

%pink
pinkmap =  round(pink(200)*254+1);
pinkstring = [dec2hex(zeros(200,1),2),dec2hex(pinkmap(:,1),2),dec2hex(pinkmap(:,2),2),dec2hex(pinkmap(:,3),2)];
pinknumbers = hex2dec([dec2hex(zeros(200,1),2),dec2hex(pinkmap(:,1),2),dec2hex(pinkmap(:,2),2),dec2hex(pinkmap(:,3),2)]);
allcolors(:,10)=pinknumbers;

%prism
prismmap =  round(prism(200)*254+1);
prismstring = [dec2hex(zeros(200,1),2),dec2hex(prismmap(:,1),2),dec2hex(prismmap(:,2),2),dec2hex(prismmap(:,3),2)];
prismnumbers = hex2dec([dec2hex(zeros(200,1),2),dec2hex(prismmap(:,1),2),dec2hex(prismmap(:,2),2),dec2hex(prismmap(:,3),2)]);
allcolors(:,11)=prismnumbers;

%spring
springmap =  round(spring(200)*254+1);
springstring = [dec2hex(zeros(200,1),2),dec2hex(springmap(:,1),2),dec2hex(springmap(:,2),2),dec2hex(springmap(:,3),2)];
springnumbers = hex2dec([dec2hex(zeros(200,1),2),dec2hex(springmap(:,1),2),dec2hex(springmap(:,2),2),dec2hex(springmap(:,3),2)]);
allcolors(:,12)=springnumbers;

%summer
summermap =  round(summer(200)*254+1);
summerstring = [dec2hex(zeros(200,1),2),dec2hex(summermap(:,1),2),dec2hex(summermap(:,2),2),dec2hex(summermap(:,3),2)];
summernumbers = hex2dec([dec2hex(zeros(200,1),2),dec2hex(summermap(:,1),2),dec2hex(summermap(:,2),2),dec2hex(summermap(:,3),2)]);
allcolors(:,13)=summernumbers;

%winter
wintermap =  round(winter(200)*254+1);
winterstring = [dec2hex(zeros(200,1),2),dec2hex(wintermap(:,1),2),dec2hex(wintermap(:,2),2),dec2hex(wintermap(:,3),2)];
winternumbers = hex2dec([dec2hex(zeros(200,1),2),dec2hex(wintermap(:,1),2),dec2hex(wintermap(:,2),2),dec2hex(wintermap(:,3),2)]);
allcolors(:,14)=winternumbers


[outfilename,outfilepath]=uiputfile('*.txt','Please name output-file:');
fid = fopen([outfilepath,outfilename],'wt');

fprintf(fid,'%s','colorslice allcolors[] = {');
fprintf(fid,'\n');
for w=1:size(allcolors,2)
    fprintf(fid,num2str(allcolors(1,w)));
	for v=2:size(allcolors,1)
        fprintf(fid,[',',num2str(allcolors(v,w))]);
    end
    fprintf(fid,',\n');
end

fclose(fid);





