function coefficientmat = contrastdef(factorstruct_ia_con,instring,defaultstring)
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
if nargin<3
    defaultstring = ['']; 
end
if nargin<2
    instring = 'The current effect structure is as follows:';
end
if nargin<1
    factorstruct_ia_con= [];
end




F = figure('units','normalized','position',[0.4 0.4  0.3  0.18 ],'menubar','none','numbertitle','off','Name','Define custom contrast:','tag','contrastdeffigure','visible','off');
    
EditHandles = [];

h = uicontrol(F,'Style','Frame',...
	'tag','uigettextframe',...
    'units','normalized',...
	'Position',[0 0 1 1]);

h = uicontrol(F,'Style','Text',...
	'String',get(findobj(F,'Tag','Prompt'),'String'),...
	'FontName','times',...
	'FontWeight','Bold',...
	'FontAngle','Italic',...
	'FontSize',16,...
	'ForegroundColor','k',...
	'HorizontalAlignment','Center',...
    'tag','otherstringtext',...
    'units','normalized',...
	'Position',[0.05 0.85 0.8 0.05]);

h = uicontrol(F,'Style','Text',...
	'String',instring,...
	'HorizontalAlignment','Left',...
    'tag','instringtext',...
    'units','normalized',...
	'Position',[0.05 0.8 0.9 0.13]);

h = uicontrol(F,'Style','Edit',...
    'String',defaultstring,...
	'Tag','EditWindow','UserData',0,...
	'HorizontalAlignment','Left',...
	'ForegroundColor',[0 0 0],'BackgroundColor',[1 1 1],...
	'Max',2,...
	'Callback','set(gco,''UserData'',1)',...
    'tag','editfenster',...
    'units','normalized',...
	'Position',[0.05 0.1 0.9 0.6]);

set(h,'String',num2str(factorstruct_ia_con));

return
