clear all;
[filename,filepath]=uigetfile('*.wav','sourcefile whlen:');
cd(filepath);
file=[filepath filename];
[kritfilename,kritfilepath]=uigetfile('*.wav','referenzfile whlen:');
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
kritfile=[kritfilepath kritfilename];
[audiosignal,audiofs,audiobits]=wavread(file);
[kritaudiosignal,kritaudiofs,kritaudiobits]=wavread(kritfile);

kritaudiomonosignal=kritaudiosignal(:,1);
kritaudio.groesse=length(kritaudiomonosignal);
audiomonosignal=audiosignal(:,1);
audio.groesse=length(audiomonosignal);
diff=zeros(kritaudio.groesse,1);
sumdiff=200*ones(1,audio.groesse-kritaudio.groesse);
j=1;
while j<audio.groesse-kritaudio.groesse
    diff=audiomonosignal(j:j+kritaudio.groesse-1,1)-kritaudiomonosignal;
    sumdiff(1,j)=sum(abs(diff));
    if sumdiff(1,j)<90
        j=j+44100*5.5;
    end;
j=j+1;
end;
triggerindex=find(sumdiff<90);

anzahlsounds=size(triggerindex);
sounds=zeros(44100*6,anzahlsounds(2));

for m=1:anzahlsounds(2)
    sounds(:,m)=audiomonosignal((triggerindex(m)+2100:triggerindex(m)+2100+44100*6-1),1);
end;



%hpos
%name={'s110','s200','s201','s202','s205','s215','s216','s220','s226','s351','s352','s353','s360','s400','s401','s601','s705','s802','s815','s820'};

%hneg
%name={'s106','s115','s116','s276','s277','s278','s279','s285','s286','s287','s291','s422','s424','s600','s625','s626','s698','s709','s711','s712'};

%ns
%name={'s100','s101','s105','s132','s152','s171','s251','s252','s253','s254','s270','s311','s320','s322','s325','s358','s361','s425','s699','s700'};



%all
name={'s110','s200','s201','s202','s205','s215','s216','s220','s226','s351','s352','s353','s360','s400','s401','s601','s705','s802','s815','s820','s106','s115','s116','s276','s277','s278','s279','s285','s286','s287','s291','s422','s424','s600','s625','s626','s698','s709','s711','s712','s100','s101','s105','s132','s152','s171','s251','s252','s253','s254','s270','s311','s320','s322','s325','s358','s361','s425','s699','s700'};

for k=1:anzahlsounds(2)
a=sounds(:,k);
astereo=[a a];
savefile=strcat(name{k},'.wav');
wavwrite(astereo,audiofs,audiobits,savefile);
end
