function eegquerystart()
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      

global ifilemat appfileamt logfilemat intervallstatus...
    intervall lookfor speciallogfilestatus handles...
    baselinestatus baselineintervall baselinetotintervallstatus

%variablen 
intervallradio = findobj('tag','intervallradio');
starttimeedit = findobj('tag','starttimeedit');
endtimeedit = findobj('tag','endtimeedit');
lookforpopup = findobj('tag','lookforpopup');
normalizationpopup = findobj('tag','normalizationpopup');

if get(intervallradio,'Value')==1 & ~isempty(get(starttimeedit,'String')) & ~isempty(get(endtimeedit,'String'))
    %sampling rate = 250/1000 = 0.25
    samplingrate = 0.25;
    pointrange = 1/samplingrate;
    starttime=round(str2num(get(starttimeedit,'String'))/pointrange)*pointrange;
    endtime=round(str2num(get(endtimeedit,'String'))/pointrange)*pointrange;
    intervall = [starttime endtime];
    intervallstatus = 1;
elseif get(intervallradio,'Value')==1
    uiwait(errordlg('Bitte definieren Sie starttime und endtime des Intervalls!','Fehler:'));
    intervallstatus = 0;
    intervall = [];
    return
end

lookfor = get(lookforpopup,'Value');
if isempty(lookfor); lookfor=1; end

%modefehler
if mode==0; modefehler;return

% batchfile mode   
elseif mode==12
    
    if ~(size(appfilemat,1)==size(ifilemat,1))
        errorcell={'Fileanzahl in den Batchfiles stimmt nicht berein!';['app-batch: ',num2str(length(appfilemat)),' files <> ','i-batch: ',num2str(length(ifilemat)),' files.']}; 
        uiwait(errordlg(errorcell,'Fehler:'));
        return
    end
    
    if size(logfilemat,1)==1
        speciallogfilestatus=1;
    end
    
    %Variablen
    anzahlvp = size(appfilemat,1);
    anzahltottrials=zeros(1,anzahlvp);
    anzahldifftrials=zeros(1,anzahlvp);
    reihenfolgematcell=cell(1,anzahlvp);
    stimulinames=cell(1,anzahlvp);
    trialpercondveccell=cell(1,anzahlvp);
    repeatstatus=zeros(1,anzahlvp);
    appmatcell=cell(1,anzahlvp);
    testdata=ReadAppData(appfilemat{1},1);
    NChan=size(testdata,1);
    NPoints=size(testdata,2);
     
    %log-files einlesen
    for vpzaehler=1:anzahlvp
        if speciallogfilestatus==1
            [stimulinames{vpzaehler},reihenfolgematcell{vpzaehler},anzahltottrials(vpzaehler),anzahldifftrials(vpzaehler),repeatstatus(vpzaehler)]=readlogfile(logfilemat{1}); 
        else
            [stimulinames{vpzaehler},reihenfolgematcell{vpzaehler},anzahltottrials(vpzaehler),anzahldifftrials(vpzaehler),repeatstatus(vpzaehler)]=readlogfile(logfilemat{vpzaehler}); 
        end
    end
   
    %i-files einlesen
    for vpzaehler=1:anzahlvp
        trialpercondveccell{vpzaehler}=readascii(ifilemat{i});
    end
    
    %Trialanzahl 
    trialanzahl = max(anzahltottrials);
    answer = questdlg({'berprfen Sie bitte die Trialanzahl:';'';['            ',num2str(max(anzahltottrials))];''},'Trialanzahl:',...
                        'korrekt','ndern','korrekt');
    if strcmp(answer,'ndern')
        trialanzahlcell = inputdlg('Bitte legen Sie die erzwungen Anzahl von Trials fest:','Erzwungene Trialanzahl:');
        if isstring(trialanzahl{1})
            trialanzahl=str2num(trialanzahlcell{1});
        else
            trialanzahl=trialanzahlcell{1};
        end
    end
    
    
    %app-files einlesen
    eegdata=zeros(NChan,NPoints,anzahltottrials,anzahlvp);
    for vpzaehler=1:anzahlvp
        for j=1:trialanzahl
            if ~isempty(find(trialpercondveccell{vpzaehler}==j))
                app_pos=find(trialpercondveccell{vpzaehler}==j);
                if baselinestatus == 1
                    if baselinetotintervallstatus == 1
                        eegdata(:,:,j,vpzaehler)=CalcBaseline(ReadAppData(appfilemat{vpzaehler},app_pos),1,NPoints,1);
                    else
                        eegdata(:,:,j,vpzaehler)=CalcBaseline(ReadAppData(appfilemat{vpzaehler},app_pos),baselineintervall(1),baselineintervall(2),1);
                    end
                else
                   eegdata(:,:,j,vpzaehler)=ReadAppData(appfilemat{vpzaehler},app_pos);
                end
            end
        end
    end
    
    
    
    
    %Paramat berechen
    %----------------
    paramat=zeros(trialanzahl,anzahlvp)
        
        
    %Global Power
    if lookfor = 1           
    for vpzaehler=1:anzahlvp
        for j=1:trialanzahl
            globalpower=CalcGlobalPower(eegdata(:,:,j,vpzaehler);
	        paramat(j,vpzaehler)=sum(globalpower(intervall(1):intervall(2)))/sum(globalpower)
            
                    gpmat(i,(j+1)./2)=sum(globalpower(21:29))/sum(globalpower);
                else
                    gpmat(i,(j+1)./2)=-1;
                end
                fprintf('*');
				sternzaehler=sternzaehler+1;
				if mod(sternzaehler,50)==0
                    fprintf('\n');
				end
            end
            fprintf(['VP ',num2str(i),':\n']);
  

        
        
    end
    ok
      
% single file mode   
elseif mode==2
   filename;
  
	ok
  
end

return




%function gpquery
sternzaehler=1;
order_lpls=cell(1);
order_lpls={'2058';'7217';'1660';'5520';'1850';'7037';'5994';'2880';'2442';'5533';'2170';'2495';'7470';'2722';'1731';'7236';'4603';'7504';'2387';'7185';'7450';'2190';'4617';'5030';'1640';'8465';'7281';'7035';'2345';'2214';'5910';'7020';'2388';'7205';'2303';'7036';'5890';'2630';'5820';'2980';'2352';'5130';'1920';'2191';'5990';'1661';'5779';'7187';'4274';'7041';'4609';'7700';'2209';'2270';'4626';'5711';'2071';'7160';'5220';'2320';'7480';'2215';'2299';'5534';'1440';'7705';'2055';'2635';'2216';'2393';'5270';'2272';'8130';'2480';'2340';'2440';'7195';'7100';'8120';'2010';'4606';'7034';'2005';'7038';'2311';'1450';'1340';'2745.1';'1463';'7233';'8497';'7000';'7200';'7179';'4622';'5530';'7400';'2580';'2655';'2200';'8540';'2235';'4601';'2870';'2260';'7025';'1460';'5120';'2150';'7491';'2160';'7150';'5661';'2595';'2375';'2890';'2057';'5875';'8330';'9700';'1600';'7175';'1721';'5731';'2650';'2570';'7402';'7040';'1750';'2499';'4625';'7170';'2165';'7224';'5811';'7161';'1500';'2850';'8350';'7039';'4614';'2441';'7330';'7050';'1811';'2210';'7280';'2493';'2310';'7140';'8503';'2720';'7220';'7235';'5001';'7291';'5660';'5390';'4610';'7009';'2530';'2840';'8162';'2579';'1740';'7090';'2091';'2221';'2070';'2518';'2040';'7495';'2331';'7234';'7460';'2372';'7352';'7060';'2389';'5740';'4624';'2357';'8496';'7010';'8320';'7490';'7390';'7004';'5849';'7110';'5551';'9210';'1722';'7031';'4004';'1947';'7282';'7207';'5300';'7030';'1750';'2635';'2057';'9210';'1850';'2372';'5220';'7030';'8120';'5534';'2345';'7110';'7220';'7038';'1500';'7040';'2303';'2580';'2160';'1947';'7480';'7010';'1660';'7175';'1722';'7160';'7281';'1661';'2650';'7490';'7352';'5533';'2389';'5130';'1811';'2518';'4626';'2210';'1600';'5731';'4610';'7036';'7330';'7050';'2058';'2357';'2216';'7179';'2388';'7025';'5820';'5740';'7450';'7495';'2170';'7150';'1463';'7000';'2209';'7217';'1640';'2630';'2260';'5120';'1440';'2579';'7460';'2850';'5994';'5711';'5849';'2393';'2070';'2235';'5300';'7236';'7470';'2010';'8130';'2272';'7280';'7504';'4617';'2980';'8496';'7035';'2150';'7041';'2655';'2870';'8162';'7090';'1731';'2191';'5811';'7060';'7200';'7140';'2165';'7700';'4274';'2214';'2040';'2493';'2387';'7034';'4609';'7187';'2375';'7004';'8320';'7161';'4603';'2720';'1460';'7205';'1920';'2890';'2530';'2722';'8330';'2495';'5001';'7224';'4004';'7185';'5779';'7291';'5660';'2880';'2442';'5030';'8503';'2320';'7390';'2595';'2005';'2480';'4606';'5875';'7402';'7100';'2310';'2440';'2340';'7039';'2091';'7234';'1740';'7020';'5551';'5520';'5661';'2570';'4601';'2840';'5910';'5390';'4625';'2745.1';'5890';'2221';'8540';'8465';'2352';'2215';'4614';'7031';'2331';'1450';'2055';'2200';'1340';'7037';'1721';'9700';'2311';'2499';'4624';'7235';'2071';'7170';'4622';'2270';'7195';'7207';'8497';'5530';'2299';'7009';'8350';'7705';'5270';'7233';'7282';'2441';'7400';'7491';'5990';'2190'};

[ifilemat_at1]=batchfiletomat('bat_i_files_at1.m','J:\peter\data\Data\fastpicsdipl\batchfiles\');
[ifilemat_at0]=batchfiletomat('bat_i_files_at0.m','J:\peter\data\Data\fastpicsdipl\batchfiles\');
[appfilemat_at1]=batchfiletomat('bat_app_files_at1.m','J:\peter\data\Data\fastpicsdipl\batchfiles\');
%[appfilemat_at0]=batchfiletomat('bat_app_files_at0.m','J:\peter\data\Data\fastpicsdipl\batchfiles\');
[atfilemat_at0]=batchfiletomat('bat_at_files_at0.m','J:\peter\data\Data\fastpicsdipl\batchfiles\');

%[confilemat]=batchfiletomat('bat_con_files.m','J:\peter\data\Data\fastpicsdipl\batchfiles\');
    

%19Vp X 200 Trials
gpmat=ones(19,200); 
globalpowermat=zeros(19,200,168);
potentialmat=zeros(19,200,168);
for i=1:19 %Anzahlvp            
    TrialVec_at1=readascii(ifilemat_at1{i});
    TrialVec_at0=readascii(ifilemat_at0{i});
    
    
    if size(TrialVec_at1,2)>size(TrialVec_at1,1)
        TrialVec_at1=TrialVec_at1';
    end
    if size(TrialVec_at0,2)>size(TrialVec_at0,1)
        TrialVec_at0=TrialVec_at0';
    end
    
    
    
    
    for j=1:2:400
        if ~isempty(find(TrialVec_at1==j))
			app_pos_at1=find(TrialVec_at1==j);
            
            potential_at1=CalcBaseline(ReadAppData(appfilemat_at1{i},app_pos_at1),1,168,1);
            potential_at0=CalcBaseline(ReadAvgFile(atfilemat_at0{i}),1,168,1);
%             figure
%             surf(potential)
%             pause(2)
%             close(gcf)
%             
 			globalpower=CalcGlobalPower(potential_at1-potential_at0);
%             figure
%             plot(globalpower)
%             pause(2)
%             close(gcf)
            
%             globalpowermat(i,j,:)=globalpower;
%             potentialmat(i,j,:)=potential(84,:);
            gpmat(i,(j+1)./2)=sum(globalpower(21:29))/sum(globalpower);
        else
            gpmat(i,(j+1)./2)=-1;
        end
        fprintf('*');
		sternzaehler=sternzaehler+1;
		if mod(sternzaehler,50)==0
            fprintf('\n');
		end
    end
    fprintf(['VP ',num2str(i),':\n']);
end

% for r=1:19
% globalpowermatvp=squeeze(globalpowermat(r,:,:));
% 
% figure
% surf(globalpowermatvp)
% pause(2)
% close(gcf)
% end

% globalpowermat2d=squeeze(mean(globalpowermat,2));
% potentialmat2d=squeeze(mean(potentialmat,2));
% figure
% surf(globalpowermat2d)
% figure
% surf(potentialmat2d)

%Grenze per var
% [y,x]=ind2sub(size(gpmat),find(gpmat>0.2)); 
% 
% 
% picindices=finddiffel(x);
% length(picindices)
% 
% for u=1:length(picindices)
%     fprintf(1,[order_lpls{   (u)},'\n'])
% end


  
weightvec=zeros(1,200);
gpvec=zeros(1,200);


%Block2 umsortieren
namenslisteorder=zeros(1,100)
for i=1:100
    temp=find(strcmp(order_lpls{i*2-1},order_lpls));
    namenslisteorder(i)=temp(2);
    order_lpls{i*2-1}
    order_lpls{namenslisteorder(i)}
    %pause
end
gpvecorder=(namenslisteorder-199)./2+100
gpvecorder=[linspace(1,100,100),gpvecorder]

%Mitteln
for s=1:200
    for t=1:19
        if gpmat(t,s)~=-1
            gpvec(s)=gpvec(s)+gpmat(t,s);
            weightvec(s)=weightvec(s)+1;
        end
    end
    gpvec(s)=gpvec(s)/weightvec(s);
end

%gpvec plotten
gpvec=gpvec(gpvecorder);
gpvec1=gpvec(1:100)
gpvec2=gpvec(101:200)

%Reihenfolge in Block1 und 2 matchen und GPs vergleiche pro Trial!
figure
plot(gpvec1,'-bo')
hold on
plot(gpvec2,'-ro')
hold off

%stimulinamen
hold on
  for k=1:100
      text(k*1.02,gpvec(k),order_lpls{gpvecorder(k)*2-1});
      text(k*1.02,gpvec(k+100),order_lpls{gpvecorder(k+100)*2-1});
  end
hold off


    
            