function fig2mfile
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      

[figfilename,figfilepath]=uigetfile('*.fig','Please choose fig-file:');
figfile=[figfilepath,figfilename];
fig=openfig(figfile);

handles=get(fig,'children');
[mfilename,mfilepath]=uiputfile('*.m','Please name m-file:');
mfile=[mfilepath,mfilename];
if isempty(findstr(mfile,'.m'))
    mfile=[mfile,'.m'];
end




figposition=get(fig,'position');
figunits=get(fig,'Units');
figtag=get(fig,'tag');
if ~isempty(get(fig,'color'))
    color=get(fig,'color');
else
    color=[];
end
figname=get(fig,'Name');
fignrtitle=get(fig,'Numbertitle');
figmenubar=get(fig,'Menubar');
figresize=get(fig,'Resize');




fid=fopen(mfile,'wt');

fprintf(fid,'%s',['%figure']);
fprintf(fid,'\n');
fprintf(fid,'%s',['%---------------']);
fprintf(fid,'\n');

fprintf(fid,[figtag,'=figure(',char(39),'units',char(39),',',char(39),figunits,char(39),',',char(39),'position',char(39),',[',num2str(figposition),'],',char(39),'units',char(39),',',char(39),figunits,char(39),',...\n']);
fprintf(fid,[char(39),'color',char(39),',[',num2str(color),'],',char(39),'Name',char(39),',',char(39),figname,char(39),',',char(39),'Numbertitle',char(39)]);
fprintf(fid,[',',char(39),fignrtitle,char(39),',',char(39),'Resize',char(39),',',char(39),figresize,char(39),',',char(39),'Menubar',char(39),',',char(39),figmenubar,char(39),',',char(39),'units',char(39),',',char(39),figunits,char(39),');']);
fprintf(fid,'\n\n');


for i=1:length(handles)
    
    style=get(handles(i),'style');
    callback=get(handles(i),'Callback');
    position=get(handles(i),'position');
    tag=get(handles(i),'tag');
    value=get(handles(i),'Value');
    controlunits=get(handles(i),'units');
    controlstring=get(handles(i),'String');
    controlhalignment=get(handles(i),'HorizontalAlignment');
    if ~isempty(get(handles(i),'Backgroundcolor'))
        backgroundcolor=get(handles(i),'Backgroundcolor');
    else
        backgroundcolor=[];
    end
    
    if ~isempty(get(handles(i),'foregroundcolor'))
        foregroundcolor=get(handles(i),'foregroundcolor');
    else
        foregroundcolor=[];
    end
    
    fprintf(fid,'%s',['%',tag]);
    fprintf(fid,'\n');
    fprintf(fid,'%s','%----------------');
    fprintf(fid,'\n');
    fprintf(fid,[tag,'= uicontrol(',char(39),'units',char(39),',',char(39),controlunits,char(39),',',char(39),'style',char(39),',',char(39),style,char(39),',...\n',char(39),'position',char(39),',[',num2str(position),']']);
    if ~isempty(backgroundcolor)
        fprintf(fid,[',...\n',char(39),'backgroundcolor',char(39),',[',num2str(backgroundcolor),']']);
    end
    if ~isempty(foregroundcolor)
        fprintf(fid,[',...\n',char(39),'foregroundcolor',char(39),',[',num2str(foregroundcolor),']']);
    end
    if ~isempty(callback)
        if ~isempty(findstr(callback,char(39)))
            callback=strrep(callback,char(39),'');
        end
        fprintf(fid,[',...\n',char(39),'Callback',char(39),',',char(39),callback,char(39)]);
    end
    if ~isempty(value)
         fprintf(fid,[',...\n',char(39),'Value',char(39),',',num2str(value)]);
    end
    if ~isempty(tag)
        fprintf(fid,[',...\n',char(39),'tag',char(39),',',char(39),tag,char(39)]); 
    end
     if ~isempty(controlstring) & ~iscell(controlstring)
        fprintf(fid,[',...\n',char(39),'String',char(39),',',char(39),controlstring,char(39)]); 
    elseif iscell(controlstring)
        fprintf(fid,[',...\n',char(39),'String',char(39),',','{']);
        fprintf(fid,[char(39),controlstring{1},char(39)]); 
        for i=2:size(controlstring,1)
            fprintf(fid,[',',char(39),controlstring{i},char(39)]); 
        end
        fprintf(fid,['}']);
    end
    if ~isempty(controlhalignment)
        fprintf(fid,[',...\n',char(39),'HorizontalAlignment',char(39),',',char(39),controlhalignment,char(39)]); 
    end
    fprintf(fid,');\n\n');
    
end

fclose(fid);
close(fig);

return
            


