function out = iscoloninind(line,colpos)
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      

if ~strcmp(line(colpos),':')
    error('invalid colon position in iscoloninarg!');
end


lbracks = findstr(line,'(');
rbracks = findstr(line,')');

if isempty(lbracks) & isempty(rbracks)
    out = 0;
    return
end

if length(lbracks)~=length(rbracks)
    error('invalid bracketing in iscoloninarg!');
end

closestleftbrack = lbracks(find(abs(lbracks-colpos)==min(abs(lbracks-colpos))));
while line(closestleftbrack-1)==' '
    line(closestleftbrack-1)=[];
    closestleftbrack = lbracks(find(abs(lbracks-colpos)==min(abs(lbracks-colpos))));
end
if ~isdelimiter(line(closestleftbrack-1))
	endpos = closestleftbrack-1;
	startpos = endpos;
	while ~isdelimiter(startpos)
        startpos = startpos-1;
        if startpos<1
            startpos = 1;
            break;
        end
    end
    tmpstring = line(startpos:endpos);
    if strcmp(tmpstring,'transpose') |strcmp(tmpstring,'ctranspose')|strcmp(tmpstring,'colon') |...
            exist(tmpstring)==5 | exist(tmpstring)==2 |exist(tmpstring)==6 |strcmp(tmpstring,'ldivide') |...
            strcmp(tmpstring,'mldivide') |strcmp(tmpstring,'rdivide') |strcmp(tmpstring,'mrdivide') |...
            strcmp(tmpstring,'times') | strcmp(tmpstring,'mtimes') |  strcmp(tmpstring,'power') |...
            strcmp(tmpstring,'mpower') | strcmp(tmpstring,'mpower')
        out = 0;
        return
    else
        out = 1;
        return
    end
else
    if strcmp(line(closestleftbrack-1),'*') | strcmp(line(closestleftbrack-1),'/') | strcmp(line(closestleftbrack-1),'^') | strcmp(line(closestleftbrack-1),';')
        out = 0;
        return
    else
        while strcmp(line(closestleftbrack-1),'(') |strcmp(line(closestleftbrack-1),',')
        
end


return