function pic2html(filename,filepath)
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
if nargin<2;filepath=[];end
file=[filepath,filename];



immat=imread(file,'jpg');
picsize=size(immat);
fid=fopen(strrep(file,'.JPG','.htm'),'wt');

fprintf(fid,'<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/transitional.dtd">\n');
fprintf(fid,'<html><head><!--AFTP--><link rel="stylesheet" href="style.css" type="text/css">\n');
fprintf(fid,'<style type="text/css"></style><script type="text/javascript">\n');
fprintf(fid,'</script><meta name="author" content="Peter Peyk"><meta name="keywords" content="Gitarre Musik Konstanz klassisch Ensemble Amateur">\n');
fprintf(fid,'<title>Gitarrenensemble Konstanz</title><body></head><body><br><br>\n');
fprintf(fid,['<a href="besetzung.htm"><img src="']);
filesepvec=findstr(filename,filesep);
filenameonly=filename(filesepvec(end)+1:end);
fprintf(fid,'%s',filenameonly);
fprintf(fid,['" width="',num2str(picsize(2)),'" height="',num2str(picsize(1)),'" border="0" alt=""></a>\n']);
fprintf(fid,'</body></html>\n');

fclose(fid);

return